/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.util;

import ch.softenvironment.util.BeanReflector;
import ch.softenvironment.util.Evaluator;
import ch.softenvironment.util.StringUtils;
import ch.softenvironment.util.Tracer;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public abstract class ListUtils {
    public static List createList(Object item) {
        ArrayList<Object> list = new ArrayList<Object>(1);
        list.add(item);
        return list;
    }

    public static List sort(List items, Evaluator evaluator, String property) {
        if (items == null || items.size() == 0) {
            return items;
        }
        if (StringUtils.isNullOrEmpty(property)) {
            throw new IllegalArgumentException("property must not be null");
        }
        ArrayList list = new ArrayList(items.size());
        Iterator it = items.iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        Collections.sort(list, new ObjectPropertyComparator(evaluator, property));
        return list;
    }

    public static void eliminateDuplicates(List list, String property) throws Throwable {
        HashSet<Object> set = new HashSet<Object>();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            Object value = new BeanReflector(obj, property).getValue();
            if (set.contains(value)) {
                it.remove();
                continue;
            }
            set.add(value);
        }
    }

    public static String convertToString(List list, String method, char separator) {
        if (list == null || list.size() == 0) {
            return "";
        }
        if (StringUtils.isNullOrEmpty(method)) {
            throw new IllegalArgumentException("method must not be null");
        }
        StringBuffer contents = new StringBuffer();
        for (Object element : list) {
            BeanReflector reflector = new BeanReflector(element, method);
            try {
                contents.append(reflector.getValue());
            }
            catch (Throwable e) {
                Tracer.getInstance().developerWarning("method buggy: " + element + "#" + method + "=>" + e.getLocalizedMessage());
                contents.append(element.toString());
            }
            contents.append(separator);
        }
        return contents.toString();
    }

    public static Set createIntersection(Set set0, Set set1) {
        if (set0 == null || set1 == null) {
            throw new IllegalArgumentException("given sets must not be null");
        }
        HashSet intersection = new HashSet();
        for (Object element : set0) {
            if (!set1.contains(element)) continue;
            intersection.add(element);
        }
        return intersection;
    }

    private static class ObjectPropertyComparator
    implements Comparator {
        private Evaluator evaluator = null;
        private String property = null;
        private Collator collator = null;

        protected ObjectPropertyComparator(Evaluator evaluator, String property) {
            if (evaluator == null) {
                throw new IllegalArgumentException("evaluator must not be null");
            }
            if (property == null) {
                throw new IllegalArgumentException("property must not be null");
            }
            this.evaluator = evaluator;
            this.property = property;
            this.collator = Collator.getInstance(Locale.getDefault());
        }

        public int compare(Object o1, Object o2) {
            try {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                Object v1 = this.evaluator.evaluate(o1, this.property);
                Object v2 = this.evaluator.evaluate(o2, this.property);
                if (v1 == null) {
                    if (v2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (v2 == null) {
                    return 1;
                }
                if (v1 instanceof String && v2 instanceof String) {
                    String s1 = v1 == null ? "" : v1.toString();
                    String s2 = v1 == null ? "" : v2.toString();
                    return this.collator.compare(s1, s2);
                }
                if (v1 instanceof Long && v2 instanceof Long) {
                    return ((Long)v1).compareTo((Long)v2);
                }
                if (v1 instanceof Integer && v2 instanceof Integer) {
                    return ((Integer)v1).compareTo((Integer)v2);
                }
                if (v1 instanceof Double && v2 instanceof Double) {
                    return ((Double)v1).compareTo((Double)v2);
                }
                return v1.toString().compareTo(v2.toString());
            }
            catch (Throwable e) {
                Tracer.getInstance().runtimeWarning("sort failed: " + e.getLocalizedMessage());
                return 0;
            }
        }
    }
}

