/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.tk.quantum.GlassDragEvent;
import com.sun.javafx.tk.quantum.GlassPrismInputMethodEvent;
import com.sun.javafx.tk.quantum.GlassPrismKeyEvent;
import com.sun.javafx.tk.quantum.GlassPrismMouseEvent;
import javafx.event.EventType;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;

public class PrismEventUtils {
    private static EventType<MouseEvent> glassMouseEventType(GlassPrismMouseEvent glassPrismMouseEvent) {
        switch (glassPrismMouseEvent.type()) {
            case 221: {
                return MouseEvent.MOUSE_PRESSED;
            }
            case 222: {
                return MouseEvent.MOUSE_RELEASED;
            }
            case 227: {
                return MouseEvent.MOUSE_CLICKED;
            }
            case 225: {
                return MouseEvent.MOUSE_ENTERED;
            }
            case 226: {
                return MouseEvent.MOUSE_EXITED;
            }
            case 224: {
                return MouseEvent.MOUSE_MOVED;
            }
            case 223: {
                return MouseEvent.MOUSE_DRAGGED;
            }
            case 228: {
                throw new IllegalArgumentException("WHEEL event cannot be translated to MouseEvent, must be translated to ScrollEvent");
            }
        }
        throw new UnsupportedOperationException("unhandled MouseEvent type: " + glassPrismMouseEvent.type());
    }

    private static EventType<KeyEvent> glassKeyEventType(GlassPrismKeyEvent glassPrismKeyEvent) {
        switch (glassPrismKeyEvent.type()) {
            case 111: {
                return KeyEvent.KEY_PRESSED;
            }
            case 112: {
                return KeyEvent.KEY_RELEASED;
            }
            case 113: {
                return KeyEvent.KEY_TYPED;
            }
        }
        return null;
    }

    public static MouseEvent glassMouseEventToFX(GlassPrismMouseEvent glassPrismMouseEvent) {
        MouseButton mouseButton;
        int n = glassPrismMouseEvent.x();
        int n2 = glassPrismMouseEvent.y();
        int n3 = glassPrismMouseEvent.xAbs();
        int n4 = glassPrismMouseEvent.yAbs();
        switch (glassPrismMouseEvent.button()) {
            case 212: {
                mouseButton = MouseButton.PRIMARY;
                break;
            }
            case 213: {
                mouseButton = MouseButton.SECONDARY;
                break;
            }
            case 214: {
                mouseButton = MouseButton.MIDDLE;
                break;
            }
            default: {
                mouseButton = MouseButton.NONE;
            }
        }
        int n5 = glassPrismMouseEvent.clickCount();
        int n6 = glassPrismMouseEvent.modifiers();
        boolean bl = (n6 & 1) > 0;
        boolean bl2 = (n6 & 4) > 0;
        boolean bl3 = (n6 & 8) > 0;
        boolean bl4 = (n6 & 0x10) > 0;
        boolean bl5 = glassPrismMouseEvent.isPopupTrigger();
        boolean bl6 = (n6 & 0x20) > 0;
        boolean bl7 = (n6 & 0x80) > 0;
        boolean bl8 = (n6 & 0x40) > 0;
        boolean bl9 = glassPrismMouseEvent.isSynthesized();
        EventType<MouseEvent> eventType = PrismEventUtils.glassMouseEventType(glassPrismMouseEvent);
        return MouseEvent.impl_mouseEvent(n, n2, n3, n4, mouseButton, n5, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, eventType);
    }

    public static KeyEvent glassKeyEventToFX(GlassPrismKeyEvent glassPrismKeyEvent) {
        String string;
        int n = glassPrismKeyEvent.type();
        String string2 = string = new String(glassPrismKeyEvent.characters());
        int n2 = glassPrismKeyEvent.key();
        int n3 = glassPrismKeyEvent.modifiers();
        boolean bl = (n3 & 1) > 0;
        boolean bl2 = (n3 & 4) > 0;
        boolean bl3 = (n3 & 8) > 0;
        boolean bl4 = (n3 & 0x10) > 0;
        EventType<KeyEvent> eventType = PrismEventUtils.glassKeyEventType(glassPrismKeyEvent);
        return KeyEvent.impl_keyEvent(null, string, string2, n2, bl, bl2, bl3, bl4, eventType);
    }

    public static InputMethodEvent glassInputMethodEventToFX(GlassPrismInputMethodEvent glassPrismInputMethodEvent) {
        return InputMethodEvent.impl_inputMethodEvent(null, glassPrismInputMethodEvent.getComposed(), glassPrismInputMethodEvent.getCommitted(), glassPrismInputMethodEvent.getCursorPos(), InputMethodEvent.INPUT_METHOD_TEXT_CHANGED);
    }

    private static DragEvent glassDragEventToFX(GlassDragEvent glassDragEvent, Dragboard dragboard) {
        DragEvent dragEvent = DragEvent.impl_create(glassDragEvent.getX(), glassDragEvent.getY(), glassDragEvent.getXAbs(), glassDragEvent.getYAbs(), PrismEventUtils.convertToTransferMode(glassDragEvent.getRecommendedDropAction()), dragboard != null ? dragboard : glassDragEvent.getDragboard(), glassDragEvent);
        dragEvent.impl_setRecognizedEvent(glassDragEvent);
        return dragEvent;
    }

    public static DragEvent glassDragGestureToFX(GlassDragEvent glassDragEvent, Dragboard dragboard) {
        return PrismEventUtils.glassDragEventToFX(glassDragEvent, dragboard);
    }

    public static DragEvent glassDragSourceEventToFX(GlassDragEvent glassDragEvent, Dragboard dragboard) {
        return PrismEventUtils.glassDragEventToFX(glassDragEvent, dragboard);
    }

    public static DragEvent glassDropTargetEventToFX(GlassDragEvent glassDragEvent, Dragboard dragboard) {
        return PrismEventUtils.glassDragEventToFX(glassDragEvent, dragboard);
    }

    public static TransferMode convertToTransferMode(int n) {
        if (n == 0) {
            return null;
        }
        if (n == 1 || n == 0x40000001) {
            return TransferMode.COPY;
        }
        if (n == 2 || n == 0x40000002) {
            return TransferMode.MOVE;
        }
        if (n == 0x40000000) {
            return TransferMode.LINK;
        }
        if (n == 0x4FFFFFFF) {
            return TransferMode.COPY;
        }
        if (n == 3) {
            throw new IllegalArgumentException("PrismEventUtils.convertToTransferMode: ambiguous drop action: " + Integer.toHexString(n));
        }
        throw new IllegalArgumentException("PrismEventUtils.convertToTransferMode: bad drop action: " + Integer.toHexString(n));
    }
}

