/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.SSLConnector;
import org.zaproxy.zap.CommandLineBootstrap;
import org.zaproxy.zap.DaemonBootstrap;
import org.zaproxy.zap.GuiBootstrap;
import org.zaproxy.zap.ZapBootstrap;
import org.zaproxy.zap.eventBus.EventBus;
import org.zaproxy.zap.eventBus.SimpleEventBus;
import org.zaproxy.zap.utils.ClassLoaderUtil;

public class ZAP {
    private static ProcessType processType;
    private static final EventBus eventBus;
    private static final Logger logger;

    public static void main(String[] stringArray) throws Exception {
        CommandLine commandLine = null;
        try {
            commandLine = new CommandLine(stringArray);
        }
        catch (Exception exception) {
            System.out.println("Failed due to invalid parameters. Use '-h' for more details.");
            System.exit(1);
        }
        ZAP.initClassLoader();
        ZapBootstrap zapBootstrap = ZAP.createZapBootstrap(commandLine);
        try {
            int n = zapBootstrap.start();
            if (n != 0) {
                System.exit(n);
            }
        }
        catch (Exception exception) {
            logger.fatal((Object)exception.getMessage(), (Throwable)exception);
            System.exit(1);
        }
    }

    private static void initClassLoader() {
        try {
            File file = new File(Constant.getZapInstall(), "lang");
            if (file.exists() && file.isDirectory()) {
                ClassLoaderUtil.addFile(file.getAbsolutePath());
            } else {
                System.out.println("Warning: failed to load language files from " + file.getAbsolutePath());
            }
            File file2 = new File(Constant.getZapInstall(), "lib");
            if (file2.exists() && file2.isDirectory()) {
                File[] fileArray;
                for (File file3 : fileArray = file2.listFiles()) {
                    if (!file3.getName().toLowerCase(Locale.ENGLISH).endsWith("jar")) continue;
                    ClassLoaderUtil.addFile(file3);
                }
            } else {
                System.out.println("Warning: failed to load jar files from " + file2.getAbsolutePath());
            }
        }
        catch (IOException iOException) {
            System.out.println("Failed loading jars: " + iOException);
        }
    }

    private static ZapBootstrap createZapBootstrap(CommandLine commandLine) {
        ZapBootstrap zapBootstrap;
        if (commandLine.isGUI()) {
            processType = ProcessType.desktop;
            zapBootstrap = new GuiBootstrap(commandLine);
        } else if (commandLine.isDaemon()) {
            processType = ProcessType.daemon;
            zapBootstrap = new DaemonBootstrap(commandLine);
        } else {
            processType = ProcessType.cmdline;
            zapBootstrap = new CommandLineBootstrap(commandLine);
        }
        return zapBootstrap;
    }

    public static ProcessType getProcessType() {
        return processType;
    }

    public static EventBus getEventBus() {
        return eventBus;
    }

    static {
        eventBus = new SimpleEventBus();
        logger = Logger.getLogger(ZAP.class);
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtExceptionLogger());
        ProtocolSocketFactory protocolSocketFactory = null;
        try {
            Protocol protocol = Protocol.getProtocol((String)"https");
            protocolSocketFactory = protocol.getSocketFactory();
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
        if (protocolSocketFactory == null || !(protocolSocketFactory instanceof SSLConnector)) {
            Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new SSLConnector(), 443));
        }
    }

    private static final class UncaughtExceptionLogger
    implements Thread.UncaughtExceptionHandler {
        private static final Logger logger = Logger.getLogger(UncaughtExceptionLogger.class);
        private static boolean loggerConfigured = false;

        private UncaughtExceptionLogger() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            if (!(throwable instanceof ThreadDeath)) {
                if (loggerConfigured || UncaughtExceptionLogger.isLoggerConfigured()) {
                    logger.error((Object)("Exception in thread \"" + thread.getName() + "\""), throwable);
                } else {
                    System.err.println("Exception in thread \"" + thread.getName() + "\"");
                    throwable.printStackTrace();
                }
            }
        }

        private static boolean isLoggerConfigured() {
            if (loggerConfigured) {
                return true;
            }
            Enumeration enumeration = LogManager.getRootLogger().getAllAppenders();
            if (enumeration.hasMoreElements()) {
                loggerConfigured = true;
            } else {
                Enumeration enumeration2 = LogManager.getCurrentLoggers();
                while (enumeration2.hasMoreElements()) {
                    Logger logger = (Logger)enumeration2.nextElement();
                    if (!logger.getAllAppenders().hasMoreElements()) continue;
                    loggerConfigured = true;
                    break;
                }
            }
            return loggerConfigured;
        }
    }

    public static enum ProcessType {
        cmdline,
        daemon,
        desktop,
        zaas;

    }
}

