/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.log4j;

import javax.swing.SwingUtilities;
import org.apache.log4j.Level;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.view.ScanStatus;

public class ZapOutputWriter
extends WriterAppender {
    private static final char NEWLINE = '\n';
    private ScanStatus scanStatus = null;

    public ZapOutputWriter(ScanStatus scanStatus) {
        if (!View.isInitialised()) {
            throw new IllegalStateException("View must be initialised.");
        }
        if (scanStatus == null) {
            throw new IllegalArgumentException("The parameter scanStatus must not be null.");
        }
        this.scanStatus = scanStatus;
    }

    public void append(final LoggingEvent loggingEvent) {
        if (loggingEvent.getLevel().equals((Object)Level.ERROR)) {
            String[] stringArray;
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ZapOutputWriter.this.append(loggingEvent);
                    }
                });
                return;
            }
            this.scanStatus.incScanCount();
            String string = loggingEvent.getRenderedMessage();
            if (string != null) {
                View.getSingleton().getOutputPanel().append(string + '\n');
            }
            if ((stringArray = loggingEvent.getThrowableStrRep()) != null) {
                StringBuilder stringBuilder = new StringBuilder(stringArray.length * 75);
                for (String string2 : stringArray) {
                    stringBuilder.append(string2).append('\n');
                }
                View.getSingleton().getOutputPanel().append(stringBuilder.toString());
            }
        }
    }
}

