/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.worker;

import java.io.File;
import java.net.URL;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.WorkerTestClassProcessorFactory;
import org.gradle.api.internal.tasks.testing.worker.RemoteTestClassProcessor;
import org.gradle.api.internal.tasks.testing.worker.TestEventSerializer;
import org.gradle.api.internal.tasks.testing.worker.TestWorker;
import org.gradle.internal.operations.BuildOperationWorkerRegistry;
import org.gradle.internal.remote.ObjectConnection;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.worker.WorkerProcess;
import org.gradle.process.internal.worker.WorkerProcessBuilder;
import org.gradle.process.internal.worker.WorkerProcessFactory;
import org.gradle.util.CollectionUtils;

public class ForkingTestClassProcessor
implements TestClassProcessor {
    private final WorkerProcessFactory workerFactory;
    private final WorkerTestClassProcessorFactory processorFactory;
    private final JavaForkOptions options;
    private final Iterable<File> classPath;
    private final Action<WorkerProcessBuilder> buildConfigAction;
    private final ModuleRegistry moduleRegistry;
    private final BuildOperationWorkerRegistry.Operation owner;
    private RemoteTestClassProcessor remoteProcessor;
    private WorkerProcess workerProcess;
    private TestResultProcessor resultProcessor;
    private BuildOperationWorkerRegistry.Completion workerCompletion;

    public ForkingTestClassProcessor(WorkerProcessFactory workerFactory, WorkerTestClassProcessorFactory processorFactory, JavaForkOptions options, Iterable<File> classPath, Action<WorkerProcessBuilder> buildConfigAction, ModuleRegistry moduleRegistry, BuildOperationWorkerRegistry.Operation owner) {
        this.workerFactory = workerFactory;
        this.processorFactory = processorFactory;
        this.options = options;
        this.classPath = classPath;
        this.buildConfigAction = buildConfigAction;
        this.moduleRegistry = moduleRegistry;
        this.owner = owner;
    }

    @Override
    public void startProcessing(TestResultProcessor resultProcessor) {
        this.resultProcessor = resultProcessor;
    }

    @Override
    public void processTestClass(TestClassRunInfo testClass) {
        if (this.remoteProcessor == null) {
            this.workerCompletion = this.owner.operationStart();
            this.remoteProcessor = this.forkProcess();
        }
        this.remoteProcessor.processTestClass(testClass);
    }

    RemoteTestClassProcessor forkProcess() {
        WorkerProcessBuilder builder = this.workerFactory.create((Action)new TestWorker(this.processorFactory));
        builder.setBaseName("Gradle Test Executor");
        builder.setImplementationClasspath(this.getTestWorkerImplementationClasspath());
        builder.applicationClasspath(this.classPath);
        this.options.copyTo((JavaForkOptions)builder.getJavaCommand());
        this.buildConfigAction.execute((Object)builder);
        this.workerProcess = builder.build();
        this.workerProcess.start();
        ObjectConnection connection = this.workerProcess.getConnection();
        connection.useParameterSerializers(TestEventSerializer.create());
        connection.addIncoming(TestResultProcessor.class, (Object)this.resultProcessor);
        RemoteTestClassProcessor remoteProcessor = (RemoteTestClassProcessor)connection.addOutgoing(RemoteTestClassProcessor.class);
        connection.connect();
        remoteProcessor.startProcessing();
        return remoteProcessor;
    }

    List<URL> getTestWorkerImplementationClasspath() {
        return CollectionUtils.flattenCollections(URL.class, (Object[])new Object[]{this.moduleRegistry.getModule("gradle-version-info").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-core").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-logging").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-messaging").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-base-services").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-cli").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-native").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-testing-base").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-testing-jvm").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getModule("gradle-process-services").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getExternalModule("guava-jdk5").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getExternalModule("slf4j-api").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getExternalModule("jul-to-slf4j").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getExternalModule("native-platform").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getExternalModule("kryo").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getExternalModule("commons-lang").getImplementationClasspath().getAsURLs(), this.moduleRegistry.getExternalModule("junit").getImplementationClasspath().getAsURLs()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.remoteProcessor != null) {
            try {
                this.remoteProcessor.stop();
                this.workerProcess.waitForStop();
            }
            finally {
                this.workerCompletion.operationFinish();
            }
        }
    }
}

