/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.AbstractRoleAwareBuildCacheServiceDecorator;
import org.gradle.caching.internal.DirectoryBuildCacheService;
import org.gradle.caching.internal.RoleAwareBuildCacheService;

public class StagingBuildCacheServiceDecorator
extends AbstractRoleAwareBuildCacheServiceDecorator {
    private final boolean stageCacheEntries;
    private final TemporaryFileProvider temporaryFileProvider;

    public StagingBuildCacheServiceDecorator(TemporaryFileProvider temporaryFileProvider, boolean stageCacheEntries, RoleAwareBuildCacheService delegate) {
        super(delegate);
        this.stageCacheEntries = stageCacheEntries;
        this.temporaryFileProvider = temporaryFileProvider;
    }

    public StagingBuildCacheServiceDecorator(TemporaryFileProvider temporaryFileProvider, RoleAwareBuildCacheService delegate) {
        this(temporaryFileProvider, !(delegate instanceof DirectoryBuildCacheService), delegate);
    }

    public boolean load(BuildCacheKey key, BuildCacheEntryReader reader) throws BuildCacheException {
        if (this.stageCacheEntries) {
            return super.load(key, new StagingBuildCacheEntryReader(reader, this.temporaryFileProvider));
        }
        return super.load(key, reader);
    }

    public void store(BuildCacheKey key, BuildCacheEntryWriter writer) throws BuildCacheException {
        if (this.stageCacheEntries) {
            super.store(key, new StagingBuildCacheEntryWriter(writer, this.temporaryFileProvider));
        } else {
            super.store(key, writer);
        }
    }

    private static class StagingBuildCacheEntryWriter
    implements BuildCacheEntryWriter {
        private final BuildCacheEntryWriter writer;
        private final TemporaryFileProvider temporaryFileProvider;

        private StagingBuildCacheEntryWriter(BuildCacheEntryWriter writer, TemporaryFileProvider temporaryFileProvider) {
            this.writer = writer;
            this.temporaryFileProvider = temporaryFileProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(OutputStream output) throws IOException {
            File destination = this.temporaryFileProvider.createTemporaryFile("gradle_cache", "entry", new String[0]);
            try {
                this.writeCacheEntry(destination);
                this.unstageCacheEntry(output, destination);
            }
            finally {
                destination.delete();
            }
        }

        private void writeCacheEntry(File destination) throws IOException {
            BufferedOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new BufferedOutputStream(new FileOutputStream(destination));
                this.writer.writeTo(fileOutputStream);
            }
            catch (FileNotFoundException e) {
                try {
                    throw new BuildCacheException("Couldn't create local file for cache entry", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileOutputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unstageCacheEntry(OutputStream output, File destination) throws IOException {
            BufferedInputStream fileInputStream = null;
            try {
                fileInputStream = new BufferedInputStream(new FileInputStream(destination));
                IOUtils.copyLarge((InputStream)fileInputStream, (OutputStream)output);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
    }

    private static class StagingBuildCacheEntryReader
    implements BuildCacheEntryReader {
        private final BuildCacheEntryReader reader;
        private final TemporaryFileProvider temporaryFileProvider;

        private StagingBuildCacheEntryReader(BuildCacheEntryReader reader, TemporaryFileProvider temporaryFileProvider) {
            this.reader = reader;
            this.temporaryFileProvider = temporaryFileProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFrom(InputStream input) throws IOException {
            File destination = this.temporaryFileProvider.createTemporaryFile("gradle_cache", "entry", new String[0]);
            try {
                this.stageCacheEntry(input, destination);
                this.readCacheEntry(destination);
            }
            finally {
                destination.delete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stageCacheEntry(InputStream input, File destination) throws IOException {
            BufferedOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new BufferedOutputStream(new FileOutputStream(destination));
                IOUtils.copyLarge((InputStream)input, (OutputStream)fileOutputStream);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
        }

        private void readCacheEntry(File destination) throws IOException {
            BufferedInputStream fileInputStream = null;
            try {
                fileInputStream = new BufferedInputStream(new FileInputStream(destination));
                this.reader.readFrom(fileInputStream);
            }
            catch (FileNotFoundException e) {
                try {
                    throw new BuildCacheException("Couldn't create local file for cache entry", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileInputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
    }
}

