/**
 * @file
 * A Backbone Model for the state of a CKEditor toolbar configuration .
 */

(function (Drupal, Backbone) {

  'use strict';

  /**
   * Backbone model for the CKEditor toolbar configuration state.
   *
   * @constructor
   *
   * @augments Backbone.Model
   */
  Drupal.ckeditor.Model = Backbone.Model.extend(/** @lends Drupal.ckeditor.Model# */{

    /**
     * Default values.
     *
     * @type {object}
     */
    defaults: /** @lends Drupal.ckeditor.Model# */{

      /**
       * The CKEditor configuration that is being manipulated through the UI.
       */
      activeEditorConfig: null,

      /**
       * The textarea that contains the serialized representation of the active
       * CKEditor configuration.
       */
      $textarea: null,

      /**
       * Tracks whether the active toolbar DOM structure has been changed. When
       * true, activeEditorConfig needs to be updated, and when that is updated,
       * $textarea will also be updated.
       */
      isDirty: false,

      /**
       * The configuration for the hidden CKEditor instance that is used to
       * build the features metadata.
       */
      hiddenEditorConfig: null,

      /**
       * A hash that maps buttons to features.
       */
      buttonsToFeatures: null,

      /**
       * A hash, keyed by a feature name, that details CKEditor plugin features.
       */
      featuresMetadata: null,

      /**
       * Whether the button group names are currently visible.
       */
      groupNamesVisible: false
    },

    /**
     * @method
     */
    sync: function () {
      // Push the settings into the textarea.
      this.get('$textarea').val(JSON.stringify(this.get('activeEditorConfig')));
    }
  });

})(Drupal, Backbone);
