/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli.converter;

import java.util.Map;
import org.gradle.StartParameter;
import org.gradle.launcher.cli.converter.PropertiesToParallelismConfigurationConverter;
import org.gradle.launcher.daemon.configuration.GradleProperties;
import org.gradle.util.SingleMessageLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesToStartParameterConverter {
    private final PropertiesToParallelismConfigurationConverter propertiesToParallelismConfigurationConverter = new PropertiesToParallelismConfigurationConverter();

    public StartParameter convert(Map<String, String> properties, StartParameter startParameter) {
        String buildCacheEnabled;
        startParameter.setConfigureOnDemand(GradleProperties.isTrue(properties.get("org.gradle.configureondemand")));
        this.propertiesToParallelismConfigurationConverter.convert(properties, startParameter);
        String taskOutputCache = properties.get("org.gradle.cache.tasks");
        if (taskOutputCache != null) {
            SingleMessageLogger.nagUserOfDiscontinuedProperty((String)"org.gradle.cache.tasks", (String)"Use org.gradle.caching instead.");
            startParameter.setBuildCacheEnabled(GradleProperties.isTrue(taskOutputCache));
        }
        if ((buildCacheEnabled = properties.get("org.gradle.caching")) != null) {
            startParameter.setBuildCacheEnabled(GradleProperties.isTrue(buildCacheEnabled));
        }
        return startParameter;
    }
}

