/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitorWithResult;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MergeInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.AbstractJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ThrowExceptionInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.MarkInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineExitInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineSinkInstruction;
import org.jetbrains.kotlin.psi.KtElement;

public class TailInstructionDetector
extends InstructionVisitorWithResult<Boolean> {
    private final KtElement subroutine;

    public TailInstructionDetector(@NotNull KtElement subroutine) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/kotlin/cfg/TailInstructionDetector", "<init>"));
        }
        this.subroutine = subroutine;
    }

    @Override
    public Boolean visitInstruction(@NotNull Instruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/TailInstructionDetector", "visitInstruction"));
        }
        return false;
    }

    @Override
    public Boolean visitSubroutineExit(@NotNull SubroutineExitInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/TailInstructionDetector", "visitSubroutineExit"));
        }
        return !instruction.isError() && instruction.getSubroutine() == this.subroutine;
    }

    @Override
    public Boolean visitSubroutineSink(@NotNull SubroutineSinkInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/TailInstructionDetector", "visitSubroutineSink"));
        }
        return instruction.getSubroutine() == this.subroutine;
    }

    @Override
    public Boolean visitJump(@NotNull AbstractJumpInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/TailInstructionDetector", "visitJump"));
        }
        return true;
    }

    @Override
    public Boolean visitThrowExceptionInstruction(@NotNull ThrowExceptionInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/TailInstructionDetector", "visitThrowExceptionInstruction"));
        }
        return false;
    }

    @Override
    public Boolean visitMarkInstruction(@NotNull MarkInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/TailInstructionDetector", "visitMarkInstruction"));
        }
        return true;
    }

    @Override
    public Boolean visitMagic(@NotNull MagicInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/TailInstructionDetector", "visitMagic"));
        }
        return instruction.getSynthetic();
    }

    @Override
    public Boolean visitMerge(@NotNull MergeInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/kotlin/cfg/TailInstructionDetector", "visitMerge"));
        }
        return true;
    }
}

