/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.LanguageUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.ProperTextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.Segment;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnchor;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.AnchorElementInfoFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.AnchorTypeInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.MarkerCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SelfElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerAnchorProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileWithStubSupport;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

class AnchorElementInfo
extends SelfElementInfo {
    private volatile long myStubElementTypeAndId;

    AnchorElementInfo(@NotNull PsiElement anchor2, @NotNull PsiFile containingFile) {
        if (anchor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/AnchorElementInfo", "<init>"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/AnchorElementInfo", "<init>"));
        }
        super(containingFile.getProject(), ProperTextRange.create(anchor2.getTextRange()), AnchorTypeInfo.obtainInfo(anchor2, LanguageUtil.getRootLanguage(containingFile)), containingFile, false);
        assert (!(anchor2 instanceof PsiFile)) : "FileElementInfo must be used for file: " + anchor2;
        this.myStubElementTypeAndId = AnchorElementInfo.pack(-1, null);
    }

    AnchorElementInfo(@NotNull PsiElement anchor2, @NotNull PsiFileWithStubSupport containingFile, int stubId, @NotNull IStubElementType stubElementType) {
        if (anchor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/AnchorElementInfo", "<init>"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/AnchorElementInfo", "<init>"));
        }
        if (stubElementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stubElementType", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/AnchorElementInfo", "<init>"));
        }
        super(containingFile.getProject(), null, AnchorTypeInfo.obtainInfo(anchor2.getClass(), stubElementType, LanguageUtil.getRootLanguage(containingFile)), containingFile, false);
        this.myStubElementTypeAndId = AnchorElementInfo.pack(stubId, stubElementType);
        assert (!(anchor2 instanceof PsiFile)) : "FileElementInfo must be used for file: " + anchor2;
    }

    private static long pack(int stubId, IStubElementType stubElementType) {
        short index2;
        short s = index2 = stubElementType == null ? (short)0 : stubElementType.getIndex();
        assert (index2 >= 0) : "Unregistered token types not allowed here: " + stubElementType;
        return (long)stubId | (long)index2 << 32;
    }

    private int getStubId() {
        return (int)this.myStubElementTypeAndId;
    }

    @Override
    @Nullable
    public PsiElement restoreElement() {
        long typeAndId = this.myStubElementTypeAndId;
        int stubId = (int)typeAndId;
        if (stubId != -1) {
            PsiFile file2 = this.restoreFile();
            if (!(file2 instanceof PsiFileWithStubSupport)) {
                return null;
            }
            short index2 = (short)(typeAndId >> 32);
            IStubElementType stubElementType = (IStubElementType)IElementType.find(index2);
            return PsiAnchor.restoreFromStubIndex((PsiFileWithStubSupport)file2, stubId, stubElementType, false);
        }
        TextRange psiRange = this.getPsiRange();
        if (psiRange == null) {
            return null;
        }
        PsiFile file3 = this.restoreFile();
        if (file3 == null) {
            return null;
        }
        PsiElement anchor2 = AnchorElementInfo.findElementInside(file3, psiRange.getStartOffset(), psiRange.getEndOffset(), this.myType);
        if (anchor2 == null) {
            return null;
        }
        TextRange range = anchor2.getTextRange();
        if (range == null || range.getStartOffset() != psiRange.getStartOffset() || range.getEndOffset() != psiRange.getEndOffset()) {
            return null;
        }
        return AnchorElementInfo.restoreFromAnchor(anchor2);
    }

    @Nullable
    static PsiElement restoreFromAnchor(PsiElement anchor2) {
        for (SmartPointerAnchorProvider provider : SmartPointerAnchorProvider.EP_NAME.getExtensions()) {
            PsiElement element = provider.restoreElement(anchor2);
            if (element == null) continue;
            return element;
        }
        return anchor2;
    }

    @Override
    public boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/AnchorElementInfo", "pointsToTheSameElementAs"));
        }
        if (other instanceof AnchorElementInfo) {
            if (!this.getVirtualFile().equals(other.getVirtualFile())) {
                return false;
            }
            long packed1 = this.myStubElementTypeAndId;
            long packed2 = ((AnchorElementInfo)other).myStubElementTypeAndId;
            if (packed1 != -1L && packed2 != -1L) {
                return packed1 == packed2;
            }
            if (packed1 != -1L || packed2 != -1L) {
                return this.areRestoredElementsEqual(other);
            }
        }
        return super.pointsToTheSameElementAs(other);
    }

    @Override
    public void fastenBelt() {
        if (this.getStubId() != -1) {
            this.switchToTree();
        }
        super.fastenBelt();
    }

    private void switchToTree() {
        PsiElement element = this.restoreElement();
        if (element != null) {
            PsiElement anchor2 = AnchorElementInfoFactory.getAnchor(element);
            if (anchor2 == null) {
                anchor2 = element;
            }
            this.myType = AnchorTypeInfo.obtainInfo(anchor2, this.myType.getFileLanguage());
            this.setRange(anchor2.getTextRange());
            MarkerCache cache2 = this.myManager.getMarkerCache(this.getVirtualFile());
            if (cache2 != null) {
                cache2.rangeChanged();
            }
            this.myStubElementTypeAndId = AnchorElementInfo.pack(-1, null);
        }
    }

    @Override
    public Segment getRange() {
        if (this.getStubId() != -1) {
            this.switchToTree();
        }
        return super.getRange();
    }

    @Override
    @Nullable
    public TextRange getPsiRange() {
        if (this.getStubId() != -1) {
            this.switchToTree();
        }
        return super.getPsiRange();
    }

    @Override
    public String toString() {
        return super.toString() + ",stubId=" + this.getStubId();
    }
}

