/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.GenericsUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCall;
import org.jetbrains.kotlin.com.intellij.psi.PsiCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiDiamondType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameIdentifierOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiReturnStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameterListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceIncorporationPhase;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSessionContainer;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceVariablesOrder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InitialInferenceState;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.CheckedExceptionCompatibilityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.PsiMethodReferenceCompatibilityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTypesUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypesDistinctProver;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class InferenceSession {
    private static final Logger LOG = Logger.getInstance("#" + InferenceSession.class.getName());
    private static final Key<PsiType> LOWER_BOUND = Key.create("LowBound");
    private static final Key<PsiType> UPPER_BOUND = Key.create("UpperBound");
    private static final Key<Boolean> ERASED = Key.create("UNCHECKED_CONVERSION");
    private static final Function<Pair<PsiType, PsiType>, PsiType> UPPER_BOUND_FUNCTION = new Function<Pair<PsiType, PsiType>, PsiType>(){

        @Override
        public PsiType fun(Pair<PsiType, PsiType> pair) {
            if (!this.isValidGlb((PsiType)pair.first, (PsiType)pair.second)) {
                return null;
            }
            if (!this.isValidGlb((PsiType)pair.second, (PsiType)pair.first)) {
                return null;
            }
            return GenericsUtil.getGreatestLowerBound((PsiType)pair.first, (PsiType)pair.second);
        }

        private boolean isValidGlb(PsiType first, PsiType second) {
            PsiClass conjunct;
            if (second instanceof PsiArrayType && TypesDistinctProver.proveArrayTypeDistinct((PsiArrayType)second, first)) {
                return false;
            }
            return !(second instanceof PsiCapturedWildcardType) || first.isAssignableFrom(second) || (conjunct = PsiUtil.resolveClassInType(first)) == null || conjunct.isInterface();
        }
    };
    private final Set<InferenceVariable> myInferenceVariables = new LinkedHashSet<InferenceVariable>();
    private final List<ConstraintFormula> myConstraints = new ArrayList<ConstraintFormula>();
    private final Set<ConstraintFormula> myConstraintsCopy = new HashSet<ConstraintFormula>();
    private InferenceSessionContainer myInferenceSessionContainer = new InferenceSessionContainer();
    private PsiSubstitutor mySiteSubstitutor;
    private final PsiManager myManager;
    private int myConstraintIdx;
    private List<String> myErrorMessages;
    private boolean myErased;
    public final InferenceIncorporationPhase myIncorporationPhase = new InferenceIncorporationPhase(this);
    private final PsiElement myContext;
    private ParameterTypeInferencePolicy myPolicy;
    private PsiSubstitutor myInferenceSubstitution = PsiSubstitutor.EMPTY;
    private PsiSubstitutor myRestoreNameSubstitution = PsiSubstitutor.EMPTY;

    public InferenceSession(InitialInferenceState initialState) {
        this.myContext = initialState.getContext();
        this.myManager = this.myContext.getManager();
        this.myInferenceSubstitution = initialState.getInferenceSubstitutor();
        this.myInferenceVariables.addAll(initialState.getInferenceVariables());
        this.mySiteSubstitutor = initialState.getSiteSubstitutor();
        for (Pair<InferenceVariable[], PsiClassType> capture : initialState.getCaptures()) {
            this.myIncorporationPhase.addCapture((InferenceVariable[])capture.first, (PsiClassType)capture.second);
        }
        this.myInferenceSessionContainer = initialState.getInferenceSessionContainer();
        this.myErased = initialState.isErased();
        this.myPolicy = DefaultParameterTypeInferencePolicy.INSTANCE;
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiType[] leftTypes, PsiType[] rightTypes, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myContext = context;
        this.initBounds(typeParams);
        LOG.assertTrue(leftTypes.length == rightTypes.length);
        for (int i = 0; i < leftTypes.length; ++i) {
            PsiType rightType = this.mySiteSubstitutor.substitute(rightTypes[i]);
            if (rightType == null || leftTypes[i] == null) continue;
            this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(leftTypes[i]), this.substituteWithInferenceVariables(rightType)));
        }
        this.myPolicy = DefaultParameterTypeInferencePolicy.INSTANCE;
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context) {
        this(typeParams, siteSubstitutor, manager, context, DefaultParameterTypeInferencePolicy.INSTANCE);
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context, ParameterTypeInferencePolicy policy2) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myContext = context;
        this.myPolicy = policy2;
        this.initBounds(typeParams);
    }

    public static PsiType getUpperBound(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "getUpperBound"));
        }
        return psiClass.getUserData(UPPER_BOUND);
    }

    public static PsiType getLowerBound(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "getLowerBound"));
        }
        return psiClass.getUserData(LOWER_BOUND);
    }

    public void initExpressionConstraints(PsiParameter[] parameters2, PsiExpression[] args, PsiElement parent2, PsiMethod method) {
        MethodCandidateInfo.CurrentCandidateProperties currentProperties = InferenceSession.getCurrentProperties(parent2);
        this.initExpressionConstraints(parameters2, args, parent2, method, currentProperties != null && currentProperties.isVarargs());
    }

    public void initExpressionConstraints(PsiParameter[] parameters2, PsiExpression[] args, PsiElement parent2, PsiMethod method, boolean varargs) {
        MethodCandidateInfo.CurrentCandidateProperties currentProperties = InferenceSession.getCurrentProperties(parent2);
        if (method == null && currentProperties != null) {
            method = currentProperties.getMethod();
        }
        if (method != null) {
            this.initThrowsConstraints(method);
        }
        if (parameters2.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (!varargs && i >= parameters2.length || args[i] == null || !InferenceSession.isPertinentToApplicability(args[i], method)) continue;
                PsiType parameterType = InferenceSession.getParameterType(parameters2, i, this.mySiteSubstitutor, varargs);
                this.addConstraint(new ExpressionCompatibilityConstraint(args[i], this.substituteWithInferenceVariables(parameterType)));
            }
        }
    }

    public void initThrowsConstraints(PsiMethod method) {
        for (PsiClassType thrownType : method.getThrowsList().getReferencedTypes()) {
            InferenceVariable variable = this.getInferenceVariable(this.substituteWithInferenceVariables(thrownType));
            if (variable == null) continue;
            variable.setThrownBound();
        }
    }

    private static MethodCandidateInfo.CurrentCandidateProperties getCurrentProperties(PsiElement parent2) {
        if (parent2 instanceof PsiCall) {
            return MethodCandidateInfo.getCurrentMethod(((PsiCall)parent2).getArgumentList());
        }
        return null;
    }

    public static boolean isPertinentToApplicability(PsiExpression expr, PsiMethod method) {
        return InferenceSession.isPertinentToApplicability(expr, method, null);
    }

    private static boolean isPertinentToApplicability(PsiExpression expr, PsiMethod method, PsiType expectedReturnType) {
        if ((expr instanceof PsiLambdaExpression && ((PsiLambdaExpression)expr).hasFormalParameterTypes() || expr instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)expr).isExact()) && method != null) {
            PsiElement parent2 = PsiUtil.skipParenthesizedExprUp(expr.getParent());
            PsiType paramType = null;
            if (parent2 instanceof PsiExpressionList) {
                PsiElement gParent = parent2.getParent();
                PsiTypeParameterListOwner owner = InferenceSession.getTypeParameterOwner(method, gParent);
                if (owner != null) {
                    PsiParameter[] parameters2;
                    int idx = LambdaUtil.getLambdaIdx((PsiExpressionList)parent2, expr);
                    if (idx > (parameters2 = method.getParameterList().getParameters()).length - 1) {
                        PsiType lastParamType = parameters2[parameters2.length - 1].getType();
                        paramType = parameters2[parameters2.length - 1].isVarArgs() ? ((PsiEllipsisType)lastParamType).getComponentType() : lastParamType;
                    } else {
                        paramType = parameters2[idx].getType();
                    }
                    if (InferenceSession.isTypeParameterType(owner, paramType)) {
                        return false;
                    }
                }
            } else if (expectedReturnType != null && parent2 instanceof PsiLambdaExpression) {
                if (InferenceSession.isTypeParameterType(method, expectedReturnType)) {
                    return false;
                }
                paramType = expectedReturnType;
            }
            if (expr instanceof PsiLambdaExpression) {
                for (PsiExpression expression : LambdaUtil.getReturnExpressions((PsiLambdaExpression)expr)) {
                    if (InferenceSession.isPertinentToApplicability(expression, method, LambdaUtil.getFunctionalInterfaceReturnType(paramType))) continue;
                    return false;
                }
                return true;
            }
        }
        if (expr instanceof PsiLambdaExpression) {
            return ((PsiLambdaExpression)expr).hasFormalParameterTypes();
        }
        if (expr instanceof PsiMethodReferenceExpression) {
            return ((PsiMethodReferenceExpression)expr).isExact();
        }
        if (expr instanceof PsiParenthesizedExpression) {
            return InferenceSession.isPertinentToApplicability(((PsiParenthesizedExpression)expr).getExpression(), method);
        }
        if (expr instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)expr).getThenExpression();
            if (!InferenceSession.isPertinentToApplicability(thenExpression, method)) {
                return false;
            }
            PsiExpression elseExpression = ((PsiConditionalExpression)expr).getElseExpression();
            if (!InferenceSession.isPertinentToApplicability(elseExpression, method)) {
                return false;
            }
        }
        return true;
    }

    private static PsiTypeParameterListOwner getTypeParameterOwner(@NotNull PsiMethod method, PsiElement gParent) {
        PsiClass containingClass;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "getTypeParameterOwner"));
        }
        PsiNameIdentifierOwner owner = null;
        if (method.getTypeParameters().length > 0 && gParent instanceof PsiCallExpression && ((PsiCallExpression)gParent).getTypeArgumentList().getTypeParameterElements().length == 0) {
            owner = method;
        } else if (method.isConstructor() && gParent instanceof PsiNewExpression && (containingClass = method.getContainingClass()) != null && containingClass.hasTypeParameters() && PsiDiamondType.hasDiamond((PsiNewExpression)gParent)) {
            owner = containingClass;
        }
        return owner;
    }

    private static boolean isTypeParameterType(PsiTypeParameterListOwner method, PsiType paramType) {
        PsiClass psiClass = PsiUtil.resolveClassInType(paramType);
        return psiClass instanceof PsiTypeParameter && ((PsiTypeParameter)psiClass).getOwner() == method;
    }

    private static PsiType getParameterType(PsiParameter[] parameters2, int i, @Nullable PsiSubstitutor substitutor2, boolean varargs) {
        if (substitutor2 == null) {
            return null;
        }
        return substitutor2.substitute(PsiTypesUtil.getParameterType(parameters2, i, varargs));
    }

    @NotNull
    public PsiSubstitutor infer() {
        PsiSubstitutor psiSubstitutor = this.infer(null, null, null);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor;
    }

    public PsiSubstitutor collectAdditionalAndInfer(@NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] args, @NotNull MethodCandidateInfo.CurrentCandidateProperties properties2, @NotNull PsiSubstitutor psiSubstitutor) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "collectAdditionalAndInfer"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "collectAdditionalAndInfer"));
        }
        if (properties2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "collectAdditionalAndInfer"));
        }
        if (psiSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiSubstitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "collectAdditionalAndInfer"));
        }
        return this.performGuardedInference(parameters2, args, this.myContext, properties2, psiSubstitutor);
    }

    @NotNull
    public PsiSubstitutor infer(@Nullable PsiParameter[] parameters2, @Nullable PsiExpression[] args, @Nullable PsiElement parent2) {
        PsiSubstitutor psiSubstitutor = this.infer(parameters2, args, parent2, InferenceSession.getCurrentProperties(parent2));
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor infer(@Nullable PsiParameter[] parameters2, @Nullable PsiExpression[] args, @Nullable PsiElement parent2, @Nullable MethodCandidateInfo.CurrentCandidateProperties properties2) {
        PsiSubstitutor psiSubstitutor = this.performGuardedInference(parameters2, args, parent2, properties2, PsiSubstitutor.EMPTY);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private PsiSubstitutor performGuardedInference(@Nullable PsiParameter[] parameters2, @Nullable PsiExpression[] args, @Nullable PsiElement parent2, @Nullable MethodCandidateInfo.CurrentCandidateProperties properties2, @NotNull PsiSubstitutor initialSubstitutor) {
        if (initialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialSubstitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "performGuardedInference"));
        }
        this.doInfer(parameters2, args, parent2, properties2, initialSubstitutor);
        PsiSubstitutor psiSubstitutor = this.prepareSubstitution();
        PsiSubstitutor psiSubstitutor2 = psiSubstitutor;
        if (psiSubstitutor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "performGuardedInference"));
        }
        return psiSubstitutor2;
        finally {
            for (ConstraintFormula formula : this.myConstraintsCopy) {
                if (!(formula instanceof InputOutputConstraintFormula)) continue;
                LambdaUtil.getFunctionalTypeMap().remove(((InputOutputConstraintFormula)formula).getExpression());
            }
            if (properties2 != null && this.myErrorMessages != null) {
                properties2.getInfo().setInferenceError(StringUtil.join(this.myErrorMessages, "\n"));
            }
        }
    }

    private void doInfer(@Nullable PsiParameter[] parameters2, @Nullable PsiExpression[] args, @Nullable PsiElement parent2, @Nullable MethodCandidateInfo.CurrentCandidateProperties properties2, @NotNull PsiSubstitutor initialSubstitutor) {
        PsiSubstitutor substitutor2;
        if (initialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialSubstitutor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "doInfer"));
        }
        if (!this.repeatInferencePhases()) {
            return;
        }
        if (properties2 != null && !properties2.isApplicabilityCheck()) {
            PsiType returnType;
            PsiMethod method = properties2.getMethod();
            if (parent2 instanceof PsiCallExpression && PsiPolyExpressionUtil.isMethodCallPolyExpression((PsiExpression)parent2, method) && !PsiType.VOID.equals(returnType = method.getReturnType()) && returnType != null) {
                Ref<String> errorMessage2 = new Ref<String>();
                PsiType targetType = InferenceSession.getTargetTypeFromParent(parent2, errorMessage2, false);
                if (targetType == null && errorMessage2.get() != null) {
                    this.registerIncompatibleErrorMessage(errorMessage2.get());
                    return;
                }
                if (targetType != null && !PsiType.VOID.equals(targetType)) {
                    this.registerReturnTypeConstraints(PsiUtil.isRawSubstitutor(method, this.mySiteSubstitutor) ? returnType : this.mySiteSubstitutor.substitute(returnType), targetType);
                }
            }
            if (!this.repeatInferencePhases()) {
                return;
            }
            if (parameters2 != null && args != null && !this.isOverloadCheck()) {
                LinkedHashSet<ConstraintFormula> additionalConstraints = new LinkedHashSet<ConstraintFormula>();
                HashSet<ConstraintFormula> ignoredConstraints = new HashSet<ConstraintFormula>();
                if (parameters2.length > 0) {
                    this.collectAdditionalConstraints(parameters2, args, properties2.getMethod(), this.mySiteSubstitutor, additionalConstraints, ignoredConstraints, properties2.isVarargs(), initialSubstitutor);
                }
                if (!additionalConstraints.isEmpty() && !this.proceedWithAdditionalConstraints(additionalConstraints, ignoredConstraints)) {
                    return;
                }
            }
        }
        if ((substitutor2 = this.resolveBounds(this.myInferenceVariables, initialSubstitutor)) != null) {
            if (this.myContext != null) {
                this.myContext.putUserData(ERASED, this.myErased);
            }
            Map<PsiTypeParameter, PsiType> map2 = substitutor2.getSubstitutionMap();
            for (PsiTypeParameter parameter : map2.keySet()) {
                PsiTypeParameter param;
                PsiType mapping2 = map2.get(parameter);
                if (parameter instanceof InferenceVariable) {
                    ((InferenceVariable)parameter).setInstantiation(mapping2);
                    if (((InferenceVariable)parameter).getCallContext() != this.myContext) continue;
                    param = ((InferenceVariable)parameter).getParameter();
                } else {
                    param = parameter;
                }
                this.mySiteSubstitutor = this.mySiteSubstitutor.put(param, mapping2);
            }
        }
    }

    private boolean isOverloadCheck() {
        if (this.myContext != null) {
            for (Object o : MethodCandidateInfo.ourOverloadGuard.currentStack()) {
                if (!(o instanceof PsiExpressionList)) continue;
                PsiExpressionList element = (PsiExpressionList)o;
                for (PsiExpression expression : element.getExpressions()) {
                    if (expression != this.myContext) continue;
                    return true;
                }
            }
            return false;
        }
        return MethodCandidateInfo.isOverloadCheck();
    }

    private void collectAdditionalConstraints(PsiParameter[] parameters2, PsiExpression[] args, PsiMethod parentMethod, PsiSubstitutor siteSubstitutor, Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints, boolean varargs, PsiSubstitutor initialSubstitutor) {
        for (int i = 0; i < args.length; ++i) {
            PsiExpression arg = PsiUtil.skipParenthesizedExprDown(args[i]);
            if (arg == null) continue;
            PsiSubstitutor nestedSubstitutor = this.myInferenceSessionContainer.findNestedSubstitutor(arg, this.myInferenceSubstitution);
            PsiType parameterType = nestedSubstitutor.substitute(InferenceSession.getParameterType(parameters2, i, siteSubstitutor, varargs));
            if (!InferenceSession.isPertinentToApplicability(arg, parentMethod)) {
                if (arg instanceof PsiLambdaExpression) {
                    for (Object expr : MethodCandidateInfo.ourOverloadGuard.currentStack()) {
                        if (PsiTreeUtil.getParentOfType((PsiElement)expr, PsiLambdaExpression.class) != arg) continue;
                        return;
                    }
                    for (Object expr : LambdaUtil.ourParameterGuard.currentStack()) {
                        if (!(expr instanceof PsiParameter) || ((PsiParameter)expr).getDeclarationScope() != arg) continue;
                        ignoredConstraints.add(new ExpressionCompatibilityConstraint(arg, parameterType));
                        return;
                    }
                }
                additionalConstraints.add(new ExpressionCompatibilityConstraint(arg, parameterType));
            }
            additionalConstraints.add(new CheckedExceptionCompatibilityConstraint(arg, parameterType));
            if (arg instanceof PsiCall) {
                PsiMethod calledMethod = InferenceSession.getCalledMethod((PsiCall)((Object)arg));
                if (calledMethod == null || !PsiPolyExpressionUtil.isMethodCallPolyExpression(arg, calledMethod)) continue;
                this.collectAdditionalConstraints(additionalConstraints, ignoredConstraints, (PsiCall)((Object)arg), initialSubstitutor);
                continue;
            }
            if (!(arg instanceof PsiLambdaExpression) || !InferenceSession.isPertinentToApplicability(arg, parentMethod)) continue;
            this.collectLambdaReturnExpression(additionalConstraints, ignoredConstraints, (PsiLambdaExpression)arg, parameterType, !this.isProperType(initialSubstitutor.substitute(parameterType)), initialSubstitutor);
        }
    }

    public static PsiMethod getCalledMethod(PsiCall arg) {
        PsiExpressionList argumentList2 = arg.getArgumentList();
        if (argumentList2 == null) {
            return null;
        }
        MethodCandidateInfo.CurrentCandidateProperties properties2 = MethodCandidateInfo.getCurrentMethod(argumentList2);
        if (properties2 != null) {
            return properties2.getMethod();
        }
        JavaResolveResult resolveResult = InferenceSession.getResolveResult(arg);
        if (resolveResult instanceof MethodCandidateInfo) {
            return (PsiMethod)resolveResult.getElement();
        }
        return null;
    }

    private void collectLambdaReturnExpression(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints, PsiLambdaExpression lambdaExpression, PsiType parameterType, boolean addConstraint2, PsiSubstitutor initialSubstitutor) {
        PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType(parameterType);
        if (interfaceReturnType != null) {
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions(lambdaExpression);
            for (PsiExpression returnExpression : returnExpressions) {
                this.processReturnExpression(additionalConstraints, ignoredConstraints, returnExpression, interfaceReturnType, addConstraint2, initialSubstitutor);
            }
        }
    }

    private void processReturnExpression(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints, PsiExpression returnExpression, PsiType functionalType, boolean addConstraint2, PsiSubstitutor initialSubstitutor) {
        if (returnExpression instanceof PsiCallExpression) {
            if (addConstraint2) {
                PsiMethod calledMethod = InferenceSession.getCalledMethod((PsiCallExpression)returnExpression);
                if (calledMethod != null && PsiPolyExpressionUtil.isMethodCallPolyExpression(returnExpression, calledMethod)) {
                    this.collectAdditionalConstraints(additionalConstraints, ignoredConstraints, (PsiCallExpression)returnExpression, initialSubstitutor);
                }
            } else {
                this.getInferenceSessionContainer().registerNestedSession(this, functionalType, returnExpression);
            }
        } else if (returnExpression instanceof PsiParenthesizedExpression) {
            this.processReturnExpression(additionalConstraints, ignoredConstraints, ((PsiParenthesizedExpression)returnExpression).getExpression(), functionalType, addConstraint2, initialSubstitutor);
        } else if (returnExpression instanceof PsiConditionalExpression) {
            this.processReturnExpression(additionalConstraints, ignoredConstraints, ((PsiConditionalExpression)returnExpression).getThenExpression(), functionalType, addConstraint2, initialSubstitutor);
            this.processReturnExpression(additionalConstraints, ignoredConstraints, ((PsiConditionalExpression)returnExpression).getElseExpression(), functionalType, addConstraint2, initialSubstitutor);
        } else if (returnExpression instanceof PsiLambdaExpression) {
            this.collectLambdaReturnExpression(additionalConstraints, ignoredConstraints, (PsiLambdaExpression)returnExpression, functionalType, this.myErased, initialSubstitutor);
        }
    }

    private void collectAdditionalConstraints(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints, PsiCall callExpression, PsiSubstitutor initialSubstitutor) {
        PsiExpressionList argumentList2 = callExpression.getArgumentList();
        if (argumentList2 != null) {
            PsiMethod method;
            JavaResolveResult result2;
            MethodCandidateInfo.CurrentCandidateProperties properties2 = MethodCandidateInfo.getCurrentMethod(argumentList2);
            JavaResolveResult javaResolveResult = result2 = properties2 != null ? null : InferenceSession.getResolveResult(callExpression);
            PsiMethod psiMethod = properties2 != null ? properties2.getMethod() : (method = result2 instanceof MethodCandidateInfo ? ((MethodCandidateInfo)result2).getElement() : null);
            if (method != null) {
                PsiExpression[] newArgs = argumentList2.getExpressions();
                PsiParameter[] newParams = method.getParameterList().getParameters();
                if (newParams.length > 0) {
                    this.collectAdditionalConstraints(newParams, newArgs, method, InferenceSession.chooseSiteSubstitutor(properties2, result2, method), additionalConstraints, ignoredConstraints, InferenceSession.chooseVarargsMode(properties2, result2), initialSubstitutor);
                }
            }
        }
    }

    public static JavaResolveResult getResolveResult(final PsiCall callExpression) {
        if (callExpression instanceof PsiNewExpression && PsiDiamondType.hasDiamond((PsiNewExpression)callExpression)) {
            PsiUtilCore.ensureValid(callExpression);
            return CachedValuesManager.getCachedValue(callExpression, new CachedValueProvider<JavaResolveResult>(){

                @Override
                @Nullable
                public CachedValueProvider.Result<JavaResolveResult> compute() {
                    PsiElement psiClass;
                    PsiJavaCodeReferenceElement classReference = ((PsiNewExpression)callExpression).getClassOrAnonymousClassReference();
                    JavaResolveResult constructor = JavaResolveResult.EMPTY;
                    JavaResolveResult resolveResult = null;
                    if (classReference != null && (psiClass = (resolveResult = classReference.advancedResolve(false)).getElement()) != null) {
                        JavaPsiFacade facade = JavaPsiFacade.getInstance(callExpression.getProject());
                        PsiExpressionList argumentList2 = callExpression.getArgumentList();
                        if (argumentList2 != null) {
                            constructor = facade.getResolveHelper().resolveConstructor(facade.getElementFactory().createType((PsiClass)psiClass).rawType(), argumentList2, callExpression);
                        }
                    }
                    return new CachedValueProvider.Result<JavaResolveResult>(constructor.getElement() == null && resolveResult != null ? resolveResult : constructor, PsiModificationTracker.MODIFICATION_COUNT);
                }
            });
        }
        return callExpression.resolveMethodGenerics();
    }

    public static PsiSubstitutor chooseSiteSubstitutor(MethodCandidateInfo.CurrentCandidateProperties candidateProperties, JavaResolveResult resolveResult, PsiMethod method) {
        return resolveResult instanceof MethodCandidateInfo && method != null && !method.isConstructor() ? ((MethodCandidateInfo)resolveResult).getSiteSubstitutor() : (candidateProperties != null ? candidateProperties.getSubstitutor() : PsiSubstitutor.EMPTY);
    }

    public static boolean chooseVarargsMode(MethodCandidateInfo.CurrentCandidateProperties candidateProperties, JavaResolveResult resolveResult) {
        return resolveResult instanceof MethodCandidateInfo && ((MethodCandidateInfo)resolveResult).isVarargs() || candidateProperties != null && candidateProperties.isVarargs();
    }

    public PsiSubstitutor getInstantiations(Collection<InferenceVariable> variables) {
        PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : variables) {
            PsiType equalsBound = this.getEqualsBound(variable, substitutor2);
            if (equalsBound == null || PsiType.NULL.equals(equalsBound)) continue;
            substitutor2 = substitutor2.put(variable.getParameter(), equalsBound);
        }
        return substitutor2;
    }

    PsiSubstitutor prepareSubstitution() {
        boolean foundErrorMessage = false;
        Iterator<List<InferenceVariable>> iterator2 = InferenceVariablesOrder.resolveOrderIterator(this.myInferenceVariables, this);
        while (iterator2.hasNext()) {
            List<InferenceVariable> variables = iterator2.next();
            for (InferenceVariable inferenceVariable : variables) {
                PsiTypeParameter typeParameter = inferenceVariable.getParameter();
                PsiType instantiation = inferenceVariable.getInstantiation();
                if (instantiation != PsiType.NULL) continue;
                if (!foundErrorMessage) {
                    foundErrorMessage = this.checkBoundsConsistency(this.mySiteSubstitutor, inferenceVariable) == PsiType.NULL;
                }
                this.mySiteSubstitutor = this.mySiteSubstitutor.put(typeParameter, JavaPsiFacade.getInstance(typeParameter.getProject()).getElementFactory().createType(typeParameter));
            }
        }
        return this.mySiteSubstitutor;
    }

    public InitialInferenceState createInitialState(InferenceSessionContainer container2, Collection<InferenceVariable> variables, PsiSubstitutor topInferenceSubstitutor) {
        return new InitialInferenceState(variables, topInferenceSubstitutor, this.myContext, this.myInferenceSubstitution, this.mySiteSubstitutor, this.myIncorporationPhase.getCaptures(), this.myErased, container2);
    }

    public void initBounds(PsiTypeParameter ... typeParameters2) {
        this.initBounds(this.myContext, typeParameters2);
    }

    public InferenceVariable[] initBounds(PsiElement context, PsiTypeParameter ... typeParameters2) {
        return this.initBounds(context, this.mySiteSubstitutor, typeParameters2);
    }

    public InferenceVariable[] initBounds(PsiElement context, PsiSubstitutor siteSubstitutor, PsiTypeParameter ... typeParameters2) {
        ArrayList<InferenceVariable> result2 = new ArrayList<InferenceVariable>(typeParameters2.length);
        for (PsiTypeParameter parameter : typeParameters2) {
            String name2 = parameter.getName();
            if (this.myContext != null) {
                name2 = name2 + Math.abs(this.myContext.hashCode());
            }
            InferenceVariable variable = new InferenceVariable(context, parameter, name2);
            result2.add(variable);
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(parameter.getProject());
            this.myInferenceSubstitution = this.myInferenceSubstitution.put(parameter, elementFactory.createType(variable));
            this.myRestoreNameSubstitution = this.myRestoreNameSubstitution.put(variable, elementFactory.createType(parameter));
            this.myInferenceVariables.add(variable);
        }
        for (InferenceVariable variable : result2) {
            PsiClassType[] extendsListTypes;
            PsiTypeParameter parameter = variable.getParameter();
            boolean added = false;
            for (PsiType classType : extendsListTypes = parameter.getExtendsListTypes()) {
                if (this.isProperType(classType = this.substituteWithInferenceVariables(siteSubstitutor.substitute(classType)))) {
                    added = true;
                }
                variable.addBound(classType, InferenceBound.UPPER, null);
            }
            if (added) continue;
            variable.addBound(PsiType.getJavaLangObject(parameter.getManager(), parameter.getResolveScope()), InferenceBound.UPPER, null);
        }
        return result2.toArray(new InferenceVariable[result2.size()]);
    }

    public void registerReturnTypeConstraints(PsiType returnType, PsiType targetType) {
        returnType = this.substituteWithInferenceVariables(returnType);
        if (this.myErased) {
            PsiSubstitutor substitutor2;
            InferenceVariable inferenceVariable = this.getInferenceVariable(returnType);
            if (inferenceVariable != null && (returnType = (substitutor2 = this.resolveSubset(Collections.singletonList(inferenceVariable), this.mySiteSubstitutor)).substitute(inferenceVariable)) == null) {
                return;
            }
            this.addConstraint(new TypeCompatibilityConstraint(targetType, TypeConversionUtil.erasure(returnType)));
        } else if (FunctionalInterfaceParameterizationUtil.isWildcardParameterized(returnType)) {
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(returnType);
            PsiClass psiClass = resolveResult.getElement();
            if (psiClass != null) {
                LOG.assertTrue(returnType instanceof PsiClassType);
                PsiClassType substitutedCapture = (PsiClassType)PsiUtil.captureToplevelWildcards(returnType, this.myContext);
                PsiTypeParameter[] typeParameters2 = psiClass.getTypeParameters();
                PsiType[] parameters2 = substitutedCapture.getParameters();
                InferenceVariable[] copy = this.initFreshVariablesForCapturedBounds(typeParameters2, parameters2);
                PsiType[] newParameters = new PsiType[parameters2.length];
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(this.myManager.getProject());
                int idx = 0;
                for (int i = 0; i < parameters2.length; ++i) {
                    newParameters[i] = parameters2[i];
                    if (!(parameters2[i] instanceof PsiCapturedWildcardType)) continue;
                    newParameters[i] = elementFactory.createType(copy[idx++]);
                }
                substitutedCapture = elementFactory.createType(psiClass, newParameters);
                this.myIncorporationPhase.addCapture(copy, (PsiClassType)returnType);
                this.addConstraint(new TypeCompatibilityConstraint(targetType, substitutedCapture));
            }
        } else {
            InferenceVariable inferenceVariable = this.shouldResolveAndInstantiate(returnType, targetType);
            if (inferenceVariable != null) {
                PsiSubstitutor substitutor3 = this.resolveSubset(Collections.singletonList(inferenceVariable), this.mySiteSubstitutor);
                PsiType substitutedReturnType = substitutor3.substitute(inferenceVariable);
                if (substitutedReturnType != null) {
                    this.addConstraint(new TypeCompatibilityConstraint(targetType, PsiUtil.captureToplevelWildcards(substitutedReturnType, this.myContext)));
                }
            } else {
                this.addConstraint(new TypeCompatibilityConstraint(targetType, returnType));
            }
        }
    }

    private InferenceVariable[] initFreshVariablesForCapturedBounds(PsiTypeParameter[] typeParameters2, PsiType[] parameters2) {
        if (Registry.is("javac.fresh.variables.for.captured.wildcards.only")) {
            ArrayList<PsiTypeParameter> capturedParams = new ArrayList<PsiTypeParameter>();
            PsiSubstitutor restParamSubstitution = PsiSubstitutor.EMPTY;
            for (int i = 0; i < parameters2.length; ++i) {
                PsiType parameter = parameters2[i];
                if (parameter instanceof PsiCapturedWildcardType) {
                    capturedParams.add(typeParameters2[i]);
                    continue;
                }
                restParamSubstitution = restParamSubstitution.put(typeParameters2[i], parameter);
            }
            return this.initBounds(null, restParamSubstitution, capturedParams.toArray(new PsiTypeParameter[0]));
        }
        return this.initBounds((PsiElement)null, typeParameters2);
    }

    private InferenceVariable shouldResolveAndInstantiate(PsiType returnType, PsiType targetType) {
        InferenceVariable inferenceVariable = this.getInferenceVariable(returnType);
        if (inferenceVariable != null) {
            if (targetType instanceof PsiPrimitiveType && InferenceSession.hasPrimitiveWrapperBound(inferenceVariable)) {
                return inferenceVariable;
            }
            if (targetType instanceof PsiClassType && (InferenceSession.hasUncheckedBounds(inferenceVariable, (PsiClassType)targetType) || InferenceSession.hasWildcardParameterization(inferenceVariable, (PsiClassType)targetType))) {
                return inferenceVariable;
            }
        }
        return null;
    }

    private static boolean hasPrimitiveWrapperBound(InferenceVariable inferenceVariable) {
        InferenceBound[] boundTypes;
        for (InferenceBound inferenceBound : boundTypes = new InferenceBound[]{InferenceBound.UPPER, InferenceBound.LOWER, InferenceBound.EQ}) {
            List<PsiType> bounds = inferenceVariable.getBounds(inferenceBound);
            for (PsiType bound : bounds) {
                if (PsiPrimitiveType.getUnboxedType(bound) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasUncheckedBounds(InferenceVariable inferenceVariable, PsiClassType targetType) {
        if (!targetType.isRaw()) {
            InferenceBound[] boundTypes;
            for (InferenceBound inferenceBound : boundTypes = new InferenceBound[]{InferenceBound.EQ, InferenceBound.LOWER}) {
                List<PsiType> bounds = inferenceVariable.getBounds(inferenceBound);
                for (PsiType bound : bounds) {
                    if (!TypeCompatibilityConstraint.isUncheckedConversion(targetType, bound)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean hasWildcardParameterization(InferenceVariable inferenceVariable, PsiClassType targetType) {
        if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(targetType)) {
            Processor<Pair<PsiType, PsiType>> differentParameterizationProcessor;
            List<PsiType> bounds = inferenceVariable.getBounds(InferenceBound.LOWER);
            if (InferenceSession.findParameterizationOfTheSameGenericClass(bounds, differentParameterizationProcessor = new Processor<Pair<PsiType, PsiType>>(){

                @Override
                public boolean process(Pair<PsiType, PsiType> pair) {
                    return pair.first == null || pair.second == null || !TypesDistinctProver.provablyDistinct((PsiType)pair.first, (PsiType)pair.second);
                }
            }) != null) {
                return true;
            }
            List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
            ArrayList<PsiType> boundsToCheck = new ArrayList<PsiType>(bounds);
            boundsToCheck.addAll(eqBounds);
            for (PsiType lowBound : boundsToCheck) {
                if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(lowBound)) continue;
                return true;
            }
        }
        return false;
    }

    public static PsiType getTargetType(PsiElement context) {
        return InferenceSession.getTargetTypeFromParent(context, new Ref<String>(), true);
    }

    private static PsiType getTargetTypeFromParent(PsiElement context, Ref<String> errorMessage2, boolean inferParent) {
        PsiType targetType = PsiTypesUtil.getExpectedTypeByParent(context);
        if (targetType != null) {
            return targetType;
        }
        PsiElement parent2 = PsiUtil.skipParenthesizedExprUp(context.getParent());
        if (parent2 instanceof PsiExpressionList) {
            PsiExpressionList argumentList2;
            PsiElement gParent = parent2.getParent();
            if (gParent instanceof PsiAnonymousClass) {
                gParent = gParent.getParent();
            }
            if (gParent instanceof PsiCall && (argumentList2 = ((PsiCall)gParent).getArgumentList()) != null) {
                MethodCandidateInfo.CurrentCandidateProperties properties2 = MethodCandidateInfo.getCurrentMethod(argumentList2);
                if (properties2 != null && properties2.isApplicabilityCheck()) {
                    return InferenceSession.getTypeByMethod(context, argumentList2, properties2.getMethod(), properties2.isVarargs(), properties2.getSubstitutor());
                }
                JavaResolveResult result2 = ((PsiCall)gParent).resolveMethodGenerics();
                PsiElement element = result2.getElement();
                if (element == null) {
                    errorMessage2.set("Overload resolution failed");
                    return null;
                }
                if (element instanceof PsiMethod && (inferParent || !((PsiMethod)element).hasTypeParameters())) {
                    boolean varargs = result2 instanceof MethodCandidateInfo && ((MethodCandidateInfo)result2).isVarargs();
                    return InferenceSession.getTypeByMethod(context, argumentList2, result2.getElement(), varargs, result2.getSubstitutor());
                }
            }
        } else {
            if (parent2 instanceof PsiConditionalExpression) {
                return InferenceSession.getTargetTypeFromParent(parent2, errorMessage2, inferParent);
            }
            if (parent2 instanceof PsiLambdaExpression) {
                return InferenceSession.getTargetTypeFromParentLambda((PsiLambdaExpression)parent2, errorMessage2, inferParent);
            }
            if (parent2 instanceof PsiReturnStatement) {
                return InferenceSession.getTargetTypeFromParentLambda(PsiTreeUtil.getParentOfType(parent2, PsiLambdaExpression.class, true, PsiMethod.class), errorMessage2, inferParent);
            }
        }
        return null;
    }

    private static PsiType getTargetTypeFromParentLambda(PsiLambdaExpression lambdaExpression, Ref<String> errorMessage2, boolean inferParent) {
        if (lambdaExpression != null) {
            PsiType typeTypeByParentCall = InferenceSession.getTargetTypeFromParent(lambdaExpression, errorMessage2, inferParent);
            if (typeTypeByParentCall != null) {
                return LambdaUtil.getFunctionalInterfaceReturnType(FunctionalInterfaceParameterizationUtil.getGroundTargetType(typeTypeByParentCall, lambdaExpression));
            }
            PsiType cachedLambdaType = LambdaUtil.getFunctionalTypeMap().get(lambdaExpression);
            if (cachedLambdaType != null) {
                return LambdaUtil.getFunctionalInterfaceReturnType(FunctionalInterfaceParameterizationUtil.getGroundTargetType(cachedLambdaType, lambdaExpression));
            }
            return inferParent || !(PsiUtil.skipParenthesizedExprUp(lambdaExpression.getParent()) instanceof PsiExpressionList) ? LambdaUtil.getFunctionalInterfaceReturnType(lambdaExpression.getFunctionalInterfaceType()) : null;
        }
        return null;
    }

    private static PsiType getTypeByMethod(PsiElement context, PsiExpressionList argumentList2, PsiElement parentMethod, boolean varargs, PsiSubstitutor substitutor2) {
        if (parentMethod instanceof PsiMethod) {
            PsiParameter[] parameters2 = ((PsiMethod)parentMethod).getParameterList().getParameters();
            if (parameters2.length == 0) {
                return null;
            }
            PsiExpression[] args = argumentList2.getExpressions();
            if (!((PsiMethod)parentMethod).isVarArgs() && parameters2.length != args.length) {
                return null;
            }
            PsiElement arg = context;
            while (arg.getParent() instanceof PsiParenthesizedExpression) {
                arg = arg.getParent();
            }
            int i = ArrayUtilRt.find(args, arg);
            if (i < 0) {
                return null;
            }
            PsiType parameterType = InferenceSession.getParameterType(parameters2, i, substitutor2, varargs);
            boolean isRaw = substitutor2 != null && PsiUtil.isRawSubstitutor((PsiMethod)parentMethod, substitutor2);
            return isRaw ? TypeConversionUtil.erasure(parameterType) : parameterType;
        }
        return null;
    }

    public InferenceVariable getInferenceVariable(PsiType psiType) {
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(psiType);
        return psiClass instanceof InferenceVariable ? this.getInferenceVariable((PsiTypeParameter)psiClass) : null;
    }

    public boolean isProperType(@Nullable PsiType type2) {
        return this.collectDependencies(type2, null);
    }

    public boolean collectDependencies(@Nullable PsiType type2, @Nullable Set<InferenceVariable> dependencies) {
        return InferenceSession.collectDependencies(type2, dependencies, new Function<PsiClassType, InferenceVariable>(){

            @Override
            public InferenceVariable fun(PsiClassType classType) {
                return InferenceSession.this.getInferenceVariable(classType);
            }
        });
    }

    public static boolean collectDependencies(@Nullable PsiType type2, final @Nullable Set<InferenceVariable> dependencies, final Function<PsiClassType, InferenceVariable> fun) {
        if (type2 == null) {
            return true;
        }
        Boolean isProper2 = type2.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            @Nullable
            public Boolean visitType(PsiType type2) {
                return true;
            }

            @Override
            @Nullable
            public Boolean visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
                return true;
            }

            @Override
            @Nullable
            public Boolean visitArrayType(PsiArrayType arrayType) {
                return arrayType.getComponentType().accept(this);
            }

            @Override
            @Nullable
            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                if (bound == null) {
                    return true;
                }
                return bound.accept(this);
            }

            @Override
            @Nullable
            public Boolean visitClassType(PsiClassType classType) {
                InferenceVariable inferenceVariable = (InferenceVariable)fun.fun(classType);
                if (inferenceVariable != null) {
                    if (dependencies != null) {
                        dependencies.add(inferenceVariable);
                        return true;
                    }
                    return false;
                }
                for (PsiType psiType : classType.getParameters()) {
                    if (psiType.accept(this).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        });
        return dependencies != null ? !dependencies.isEmpty() : isProper2;
    }

    public boolean repeatInferencePhases() {
        do {
            if (!this.reduceConstraints()) {
                return false;
            }
            if (this.myIncorporationPhase.incorporate()) continue;
            return false;
        } while (!this.myIncorporationPhase.isFullyIncorporated() || this.myConstraintIdx < this.myConstraints.size());
        return true;
    }

    private boolean reduceConstraints() {
        ArrayList<ConstraintFormula> newConstraints = new ArrayList<ConstraintFormula>();
        for (int i = this.myConstraintIdx; i < this.myConstraints.size(); ++i) {
            ConstraintFormula constraint = this.myConstraints.get(i);
            if (constraint.reduce(this, newConstraints)) continue;
            return false;
        }
        this.myConstraintIdx = this.myConstraints.size();
        for (ConstraintFormula constraint : newConstraints) {
            this.addConstraint(constraint);
        }
        return true;
    }

    private boolean isThrowable(List<PsiType> upperBounds2) {
        boolean commonThrowable = false;
        for (PsiType upperBound : upperBounds2) {
            if (upperBound.equalsToText("java.lang.Object") || !this.isProperType(upperBound)) continue;
            if (upperBound.equalsToText("java.lang.Exception") || upperBound.equalsToText("java.lang.Throwable")) {
                commonThrowable = true;
                continue;
            }
            return false;
        }
        return commonThrowable;
    }

    private PsiType substituteNonProperBound(PsiType bound, PsiSubstitutor substitutor2) {
        LinkedHashSet<InferenceVariable> dependencies = new LinkedHashSet<InferenceVariable>();
        if (!this.collectDependencies(bound, dependencies)) {
            return bound;
        }
        for (InferenceVariable dependency : dependencies) {
            PsiType instantiation = dependency.getInstantiation();
            if (instantiation == PsiType.NULL) continue;
            substitutor2 = substitutor2.put(dependency, instantiation);
        }
        return substitutor2.substitute(bound);
    }

    private boolean hasBoundProblems(List<InferenceVariable> typeParams, PsiSubstitutor substitutor2) {
        for (InferenceVariable typeParameter : typeParams) {
            List<PsiType> extendsTypes;
            PsiType[] bounds;
            PsiClass aClass2;
            PsiType type2;
            if (typeParameter.getInstantiation() != PsiType.NULL || (type2 = substitutor2.substitute(typeParameter)) instanceof PsiClassType && (aClass2 = ((PsiClassType)type2).resolve()) instanceof PsiTypeParameter && TypeConversionUtil.isFreshVariable((PsiTypeParameter)aClass2) || GenericsUtil.findTypeParameterBoundError(typeParameter, bounds = (extendsTypes = typeParameter.getBounds(InferenceBound.UPPER)).toArray(new PsiType[extendsTypes.size()]), substitutor2, this.myContext, true) == null) continue;
            return true;
        }
        return false;
    }

    private PsiSubstitutor resolveBounds(Collection<InferenceVariable> inferenceVariables, PsiSubstitutor substitutor2) {
        ArrayList<InferenceVariable> allVars = new ArrayList<InferenceVariable>(inferenceVariables);
        while (!allVars.isEmpty()) {
            List<InferenceVariable> vars = InferenceVariablesOrder.resolveOrder(allVars, this);
            List<InferenceVariable> unresolved = new ArrayList<InferenceVariable>();
            for (InferenceVariable var : vars) {
                PsiType eqBound = this.getEqualsBound(var, substitutor2);
                if (eqBound != PsiType.NULL) continue;
                unresolved.add(var);
            }
            if (!this.myIncorporationPhase.hasCaptureConstraints(unresolved)) {
                PsiSubstitutor firstSubstitutor = this.resolveSubset(vars, substitutor2);
                if (this.hasBoundProblems(vars, firstSubstitutor)) {
                    firstSubstitutor = null;
                    unresolved = vars;
                }
                if (firstSubstitutor != null) {
                    substitutor2 = firstSubstitutor;
                    allVars.removeAll(vars);
                    continue;
                }
            }
            if (!this.initFreshVariables(substitutor2, unresolved)) {
                return null;
            }
            this.myIncorporationPhase.forgetCaptures(vars);
            if (this.repeatInferencePhases()) continue;
            return null;
        }
        return substitutor2;
    }

    private boolean initFreshVariables(PsiSubstitutor substitutor2, List<InferenceVariable> vars) {
        int i;
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(this.getManager().getProject());
        PsiSubstitutor ySubstitutor = PsiSubstitutor.EMPTY;
        PsiTypeParameter[] yVars = new PsiTypeParameter[vars.size()];
        for (i = 0; i < vars.size(); ++i) {
            InferenceVariable var = vars.get(i);
            PsiTypeParameter parameter = var.getParameter();
            yVars[i] = elementFactory.createTypeParameterFromText(parameter.getName(), parameter);
            ySubstitutor = ySubstitutor.put(var, elementFactory.createType(yVars[i]));
        }
        for (i = 0; i < yVars.length; ++i) {
            PsiTypeParameter parameter = yVars[i];
            InferenceVariable var = vars.get(i);
            PsiType lub = this.getLowerBound(var, substitutor2);
            if (lub != PsiType.NULL) {
                for (PsiClassType upperBoundType : parameter.getExtendsListTypes()) {
                    if (TypeConversionUtil.isAssignable(upperBoundType, lub)) continue;
                    return false;
                }
                parameter.putUserData(LOWER_BOUND, lub);
            }
            parameter.putUserData(UPPER_BOUND, this.composeBound(var, InferenceBound.UPPER, UPPER_BOUND_FUNCTION, ySubstitutor.putAll(substitutor2), true));
            TypeConversionUtil.markAsFreshVariable(parameter, this.myContext);
            if (var.addBound(elementFactory.createType(parameter), InferenceBound.EQ, this.myIncorporationPhase)) continue;
            return false;
        }
        return true;
    }

    private PsiSubstitutor resolveSubsetOrdered(Set<InferenceVariable> varsToResolve, PsiSubstitutor siteSubstitutor) {
        PsiSubstitutor substitutor2 = siteSubstitutor;
        Iterator<List<InferenceVariable>> varsIterator = InferenceVariablesOrder.resolveOrderIterator(varsToResolve, this);
        while (varsIterator.hasNext()) {
            List<InferenceVariable> vars = varsIterator.next();
            PsiSubstitutor resolveSubset = this.resolveSubset(vars, substitutor2);
            substitutor2 = substitutor2.putAll(resolveSubset);
        }
        return substitutor2;
    }

    @NotNull
    private PsiSubstitutor resolveSubset(Collection<InferenceVariable> vars, PsiSubstitutor substitutor2) {
        for (InferenceVariable var : vars) {
            PsiType instantiation = var.getInstantiation();
            PsiType type2 = instantiation == PsiType.NULL ? this.checkBoundsConsistency(substitutor2, var) : instantiation;
            if (type2 == PsiType.NULL) continue;
            substitutor2 = substitutor2.put(var, type2);
        }
        PsiSubstitutor psiSubstitutor = substitutor2;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "resolveSubset"));
        }
        return psiSubstitutor;
    }

    private PsiType checkBoundsConsistency(PsiSubstitutor substitutor2, InferenceVariable var) {
        PsiType type2;
        PsiType eqBound = this.getEqualsBound(var, substitutor2);
        if (eqBound != PsiType.NULL && eqBound instanceof PsiPrimitiveType) {
            return PsiType.NULL;
        }
        PsiType lowerBound = this.getLowerBound(var, substitutor2);
        PsiType upperBound = this.getUpperBound(var, substitutor2);
        if (eqBound != PsiType.NULL && (this.myErased || eqBound != null)) {
            if (lowerBound != PsiType.NULL && !TypeConversionUtil.isAssignable(eqBound, lowerBound)) {
                String incompatibleBoundsMessage = this.incompatibleBoundsMessage(var, substitutor2, InferenceBound.EQ, "equality constraints", InferenceBound.LOWER, "lower bounds");
                this.registerIncompatibleErrorMessage(incompatibleBoundsMessage);
                return PsiType.NULL;
            }
            type2 = eqBound;
            if (!TypeConversionUtil.isAssignable(eqBound, lowerBound, false)) {
                this.setErased();
            }
        } else {
            type2 = lowerBound;
        }
        if (type2 == PsiType.NULL) {
            String conflictingConjunctsMessage;
            if (var.isThrownBound() && this.isThrowable(var.getBounds(InferenceBound.UPPER))) {
                type2 = PsiType.getJavaLangRuntimeException(this.myManager, GlobalSearchScope.allScope(this.myManager.getProject()));
            } else if (this.myErased) {
                type2 = null;
            } else {
                PsiType psiType = type2 = var.getBounds(InferenceBound.UPPER).size() == 1 ? (PsiType)this.myPolicy.getInferredTypeWithNoConstraint((PsiManager)this.myManager, (PsiType)upperBound).first : upperBound;
            }
            if (type2 instanceof PsiIntersectionType && (conflictingConjunctsMessage = ((PsiIntersectionType)type2).getConflictingConjunctsMessage()) != null) {
                this.registerIncompatibleErrorMessage("Type parameter " + var.getParameter().getName() + " has incompatible upper bounds: " + conflictingConjunctsMessage);
                return PsiType.NULL;
            }
        } else {
            for (PsiType upperType : var.getBounds(InferenceBound.UPPER)) {
                if (!this.isProperType(upperType)) continue;
                String incompatibleBoundsMessage = null;
                if (type2 != lowerBound && !TypeConversionUtil.isAssignable(upperType, type2)) {
                    incompatibleBoundsMessage = this.incompatibleBoundsMessage(var, substitutor2, InferenceBound.EQ, "equality constraints", InferenceBound.UPPER, "upper bounds");
                } else if (type2 == lowerBound && !TypeConversionUtil.isAssignable(upperType, lowerBound)) {
                    incompatibleBoundsMessage = this.incompatibleBoundsMessage(var, substitutor2, InferenceBound.LOWER, "lower bounds", InferenceBound.UPPER, "upper bounds");
                }
                if (incompatibleBoundsMessage == null) continue;
                this.registerIncompatibleErrorMessage(incompatibleBoundsMessage);
                return PsiType.NULL;
            }
        }
        return type2;
    }

    public String getPresentableText(PsiType psiType) {
        PsiType substituted = this.myRestoreNameSubstitution.substitute(psiType);
        return substituted != null ? substituted.getPresentableText() : null;
    }

    public void registerIncompatibleErrorMessage(Collection<InferenceVariable> variables, String incompatibleTypesMessage) {
        variables = new ArrayList<InferenceVariable>(variables);
        Collections.sort((ArrayList)variables, new Comparator<InferenceVariable>(){

            @Override
            public int compare(InferenceVariable v1, InferenceVariable v2) {
                return Comparing.compare(v1.getName(), v2.getName());
            }
        });
        String variablesEnumeration = StringUtil.join(variables, new Function<InferenceVariable, String>(){

            @Override
            public String fun(InferenceVariable variable) {
                return variable.getParameter().getName();
            }
        }, ", ");
        this.registerIncompatibleErrorMessage("no instance(s) of type variable(s) " + variablesEnumeration + " exist so that " + incompatibleTypesMessage);
    }

    public void registerIncompatibleErrorMessage(@NotNull String incompatibleBoundsMessage) {
        if (incompatibleBoundsMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "incompatibleBoundsMessage", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "registerIncompatibleErrorMessage"));
        }
        if (this.myErrorMessages == null) {
            this.myErrorMessages = new ArrayList<String>();
        }
        if (!this.myErrorMessages.contains(incompatibleBoundsMessage)) {
            this.myErrorMessages.add(incompatibleBoundsMessage);
        }
    }

    private String incompatibleBoundsMessage(InferenceVariable var, final PsiSubstitutor substitutor2, InferenceBound lowBound, String lowBoundName, InferenceBound upperBound, String upperBoundName) {
        Function<PsiType, String> typePresentation = new Function<PsiType, String>(){

            @Override
            public String fun(PsiType type2) {
                PsiType substituted = InferenceSession.this.substituteNonProperBound(type2, substitutor2);
                return InferenceSession.this.getPresentableText(substituted != null ? substituted : type2);
            }
        };
        return "inference variable " + var.getParameter().getName() + " has incompatible bounds:\n " + lowBoundName + ": " + StringUtil.join(var.getBounds(lowBound), typePresentation, ", ") + "\n" + upperBoundName + ": " + StringUtil.join(var.getBounds(upperBound), typePresentation, ", ");
    }

    private PsiType getLowerBound(InferenceVariable var, PsiSubstitutor substitutor2) {
        return this.composeBound(var, InferenceBound.LOWER, new Function<Pair<PsiType, PsiType>, PsiType>(){

            @Override
            public PsiType fun(Pair<PsiType, PsiType> pair) {
                return GenericsUtil.getLeastUpperBound((PsiType)pair.first, (PsiType)pair.second, InferenceSession.this.myManager);
            }
        }, substitutor2);
    }

    private PsiType getUpperBound(InferenceVariable var, PsiSubstitutor substitutor2) {
        return this.composeBound(var, InferenceBound.UPPER, UPPER_BOUND_FUNCTION, substitutor2);
    }

    public PsiType getEqualsBound(InferenceVariable var, PsiSubstitutor substitutor2) {
        return this.composeBound(var, InferenceBound.EQ, new Function<Pair<PsiType, PsiType>, PsiType>(){

            @Override
            public PsiType fun(Pair<PsiType, PsiType> pair) {
                return !Comparing.equal(pair.first, pair.second) ? null : (PsiType)pair.first;
            }
        }, substitutor2);
    }

    private PsiType composeBound(InferenceVariable variable, InferenceBound boundType, Function<Pair<PsiType, PsiType>, PsiType> fun, PsiSubstitutor substitutor2) {
        return this.composeBound(variable, boundType, fun, substitutor2, false);
    }

    private PsiType composeBound(InferenceVariable variable, InferenceBound boundType, Function<Pair<PsiType, PsiType>, PsiType> fun, PsiSubstitutor substitutor2, boolean includeNonProperBounds) {
        List<PsiType> lowerBounds = variable.getBounds(boundType);
        PsiType lub = PsiType.NULL;
        for (PsiType lowerBound : lowerBounds) {
            lowerBound = this.substituteNonProperBound(lowerBound, substitutor2);
            if (!includeNonProperBounds && !this.isProperType(lowerBound)) continue;
            if (lub == PsiType.NULL) {
                lub = lowerBound;
                continue;
            }
            Pair<PsiPrimitiveType, PsiType> pair = Pair.create(lub, lowerBound);
            if ((lub = fun.fun(pair)) != null) continue;
            return PsiType.NULL;
        }
        return lub;
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public GlobalSearchScope getScope() {
        if (this.myContext != null) {
            return this.myContext.getResolveScope();
        }
        return GlobalSearchScope.allScope(this.myManager.getProject());
    }

    public Collection<InferenceVariable> getInferenceVariables() {
        return this.myInferenceVariables;
    }

    public void addConstraint(ConstraintFormula constraint) {
        if (this.myConstraintsCopy.add(constraint)) {
            this.myConstraints.add(constraint);
        }
    }

    private boolean proceedWithAdditionalConstraints(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints) {
        PsiSubstitutor siteSubstitutor = PsiSubstitutor.EMPTY;
        while (!additionalConstraints.isEmpty()) {
            Set<ConstraintFormula> subset = this.buildSubset(additionalConstraints, ignoredConstraints);
            LinkedHashSet<InferenceVariable> varsToResolve = new LinkedHashSet<InferenceVariable>();
            for (ConstraintFormula formula : subset) {
                if (!(formula instanceof InputOutputConstraintFormula)) continue;
                this.collectVarsToResolve(varsToResolve, (InputOutputConstraintFormula)formula);
            }
            PsiSubstitutor substitutor2 = this.resolveSubsetOrdered(varsToResolve, siteSubstitutor);
            for (ConstraintFormula formula : subset) {
                if (this.processOneConstraint(formula, additionalConstraints, substitutor2, ignoredConstraints)) continue;
                return false;
            }
        }
        return true;
    }

    private void collectVarsToResolve(Set<InferenceVariable> varsToResolve, InputOutputConstraintFormula formula) {
        Set<InferenceVariable> inputVariables = formula.getInputVariables(this);
        if (inputVariables != null) {
            for (InferenceVariable inputVariable : inputVariables) {
                varsToResolve.addAll(inputVariable.getDependencies(this));
            }
            varsToResolve.addAll(inputVariables);
        }
    }

    private boolean processOneConstraint(ConstraintFormula formula, Set<ConstraintFormula> additionalConstraints, PsiSubstitutor substitutor2, Set<ConstraintFormula> ignoredConstraints) {
        PsiExpression expression;
        if (this.myContext instanceof PsiCall) {
            PsiExpressionList argumentList2 = ((PsiCall)this.myContext).getArgumentList();
            LOG.assertTrue(argumentList2 != null);
            MethodCandidateInfo.updateSubstitutor(argumentList2, substitutor2);
        }
        formula.apply(substitutor2, true);
        this.addConstraint(formula);
        if (!this.repeatInferencePhases()) {
            return false;
        }
        if (formula instanceof ExpressionCompatibilityConstraint && (expression = ((ExpressionCompatibilityConstraint)formula).getExpression()) instanceof PsiLambdaExpression) {
            PsiType parameterType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(((ExpressionCompatibilityConstraint)formula).getT(), (PsiLambdaExpression)expression);
            this.collectLambdaReturnExpression(additionalConstraints, ignoredConstraints, (PsiLambdaExpression)expression, parameterType, !this.isProperType(parameterType), substitutor2);
        }
        return true;
    }

    private Set<ConstraintFormula> buildSubset(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints) {
        Set<InferenceVariable> outputVariables = this.getOutputVariables(additionalConstraints);
        Set<InferenceVariable> ignoredOutputVariables = this.getOutputVariables(ignoredConstraints);
        LinkedHashSet<ConstraintFormula> subset = new LinkedHashSet<ConstraintFormula>();
        LinkedHashSet<ConstraintFormula> noInputVariables = new LinkedHashSet<ConstraintFormula>();
        for (ConstraintFormula constraint : additionalConstraints) {
            if (constraint instanceof InputOutputConstraintFormula) {
                Set<InferenceVariable> inputVariables = ((InputOutputConstraintFormula)constraint).getInputVariables(this);
                if (inputVariables != null) {
                    boolean dependsOnOutput = false;
                    for (InferenceVariable inputVariable : inputVariables) {
                        if (dependsOnOutput) break;
                        Set<InferenceVariable> dependencies = inputVariable.getDependencies(this);
                        dependencies.add(inputVariable);
                        if (!this.hasCapture(inputVariable)) {
                            if (this.dependsOnOutput(ignoredOutputVariables, dependencies)) {
                                dependsOnOutput = true;
                                ignoredConstraints.add(constraint);
                                break;
                            }
                            dependsOnOutput = this.dependsOnOutput(outputVariables, dependencies);
                        }
                        dependencies.retainAll(outputVariables);
                        if (dependencies.isEmpty()) continue;
                        dependsOnOutput = true;
                        break;
                    }
                    if (dependsOnOutput) continue;
                    subset.add(constraint);
                    if (!inputVariables.isEmpty()) continue;
                    noInputVariables.add(constraint);
                    continue;
                }
                subset.add(constraint);
                noInputVariables.add(constraint);
                continue;
            }
            subset.add(constraint);
        }
        if (subset.isEmpty()) {
            additionalConstraints.removeAll(ignoredConstraints);
            if (!additionalConstraints.isEmpty()) {
                subset.add(additionalConstraints.iterator().next());
            }
        }
        if (!noInputVariables.isEmpty()) {
            subset = noInputVariables;
        }
        additionalConstraints.removeAll(subset);
        return subset;
    }

    private boolean dependsOnOutput(Set<InferenceVariable> outputVariables, Set<InferenceVariable> dependencies) {
        for (InferenceVariable outputVariable : outputVariables) {
            if (!ContainerUtil.intersects(outputVariable.getDependencies(this), dependencies)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private Set<InferenceVariable> getOutputVariables(Set<ConstraintFormula> constraintFormulas) {
        HashSet<InferenceVariable> outputVariables = new HashSet<InferenceVariable>();
        for (ConstraintFormula constraint : constraintFormulas) {
            Set<InferenceVariable> inputVariables;
            Set<InferenceVariable> outputVars;
            if (!(constraint instanceof InputOutputConstraintFormula) || (outputVars = ((InputOutputConstraintFormula)constraint).getOutputVariables(inputVariables = ((InputOutputConstraintFormula)constraint).getInputVariables(this), this)) == null) continue;
            outputVariables.addAll(outputVars);
        }
        HashSet<InferenceVariable> hashSet = outputVariables;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "getOutputVariables"));
        }
        return hashSet;
    }

    public PsiSubstitutor collectApplicabilityConstraints(PsiMethodReferenceExpression reference, MethodCandidateInfo candidateInfo, PsiType functionalInterfaceType) {
        block10: {
            PsiType normalizedPType;
            PsiSubstitutor receiverSubstitutor;
            PsiSubstitutor psiSubstitutor;
            boolean isStatic;
            PsiParameter[] parameters2;
            PsiClass containingClass;
            PsiClass methodContainingClass;
            PsiMethod method;
            boolean varargs;
            MethodSignature signature2;
            block9: {
                PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
                PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
                LOG.assertTrue(interfaceMethod != null, this.myContext);
                PsiSubstitutor functionalInterfaceSubstitutor = LambdaUtil.getSubstitutor(interfaceMethod, resolveResult);
                signature2 = interfaceMethod.getSignature(functionalInterfaceSubstitutor);
                varargs = candidateInfo.isVarargs();
                method = candidateInfo.getElement();
                methodContainingClass = method.getContainingClass();
                PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(reference);
                containingClass = qualifierResolveResult.getContainingClass();
                if (containingClass == null) {
                    return this.resolveSubset(this.myInferenceVariables, this.mySiteSubstitutor);
                }
                PsiParameter[] functionalMethodParameters = interfaceMethod.getParameterList().getParameters();
                parameters2 = method.getParameterList().getParameters();
                isStatic = method.hasModifierProperty("static");
                psiSubstitutor = qualifierResolveResult.getSubstitutor();
                if ((parameters2.length != functionalMethodParameters.length || varargs) && (!isStatic || !varargs)) break block9;
                if (method.isConstructor() && PsiUtil.isRawSubstitutor(containingClass, psiSubstitutor)) {
                    this.initBounds(containingClass.getTypeParameters());
                    psiSubstitutor = PsiSubstitutor.EMPTY;
                }
                if (methodContainingClass != null) {
                    LOG.assertTrue((psiSubstitutor = TypeConversionUtil.getClassSubstitutor(methodContainingClass, containingClass, psiSubstitutor)) != null, "derived: " + containingClass + "; super: " + methodContainingClass);
                }
                for (int i = 0; i < functionalMethodParameters.length; ++i) {
                    PsiType pType = signature2.getParameterTypes()[i];
                    this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, i, psiSubstitutor, varargs)), PsiUtil.captureToplevelWildcards(pType, reference)));
                }
                break block10;
            }
            if (!PsiMethodReferenceUtil.isResolvedBySecondSearch(reference, signature2, varargs, isStatic, parameters2.length)) break block10;
            PsiType pType = signature2.getParameterTypes()[0];
            if (PsiUtil.isRawSubstitutor(containingClass, psiSubstitutor) && (receiverSubstitutor = PsiMethodReferenceCompatibilityConstraint.getParameterizedTypeSubstitutor(containingClass, normalizedPType = PsiUtil.captureToplevelWildcards(pType, this.myContext))) != null) {
                if (!method.hasTypeParameters() && (signature2.getParameterTypes().length == 1 || PsiUtil.isRawSubstitutor(containingClass, receiverSubstitutor))) {
                    return receiverSubstitutor;
                }
                this.mySiteSubstitutor = this.mySiteSubstitutor.putAll(receiverSubstitutor);
                if (methodContainingClass != null) {
                    PsiSubstitutor superSubstitutor = TypeConversionUtil.getClassSubstitutor(methodContainingClass, containingClass, receiverSubstitutor);
                    LOG.assertTrue(superSubstitutor != null, "mContainingClass: " + methodContainingClass.getName() + "; containingClass: " + containingClass.getName());
                    this.mySiteSubstitutor = this.mySiteSubstitutor.putAll(superSubstitutor);
                }
                psiSubstitutor = receiverSubstitutor;
            }
            PsiClassType qType = JavaPsiFacade.getElementFactory(method.getProject()).createType(containingClass, psiSubstitutor);
            this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(qType), pType));
            if (methodContainingClass != null) {
                LOG.assertTrue((psiSubstitutor = TypeConversionUtil.getClassSubstitutor(methodContainingClass, containingClass, psiSubstitutor)) != null, "derived: " + containingClass + "; super: " + methodContainingClass);
            }
            for (int i = 0; i < signature2.getParameterTypes().length - 1; ++i) {
                PsiType interfaceParamType = signature2.getParameterTypes()[i + 1];
                this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, i, psiSubstitutor, varargs)), PsiUtil.captureToplevelWildcards(interfaceParamType, reference)));
            }
        }
        return null;
    }

    public void setErased() {
        this.myErased = true;
    }

    public InferenceVariable getInferenceVariable(PsiTypeParameter parameter) {
        return parameter instanceof InferenceVariable && this.myInferenceVariables.contains(parameter) ? (InferenceVariable)parameter : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMoreSpecific(PsiMethod m1, PsiMethod m2, final PsiSubstitutor siteSubstitutor1, PsiExpression[] args, PsiElement context, boolean varargs) {
        PsiTypeParameter[] typeParameters2 = m1.getTypeParameters();
        try {
            for (PsiTypeParameter parameter : typeParameters2) {
                PsiClassType[] types = parameter.getExtendsListTypes();
                if (types.length <= 0) continue;
                List<PsiType> conjuncts = ContainerUtil.map(types, new Function<PsiClassType, PsiType>(){

                    @Override
                    public PsiType fun(PsiClassType type2) {
                        return siteSubstitutor1.substitute(type2);
                    }
                });
                PsiType upperBound = PsiIntersectionType.createIntersection(false, conjuncts.toArray(new PsiType[conjuncts.size()]));
                LambdaUtil.getFunctionalTypeMap().put(parameter, upperBound);
            }
            boolean bl = InferenceSession.isMoreSpecificInternal(m1, m2, siteSubstitutor1, args, context, varargs);
            return bl;
        }
        finally {
            for (PsiTypeParameter parameter : typeParameters2) {
                LambdaUtil.getFunctionalTypeMap().remove(parameter);
            }
        }
    }

    private static boolean isMoreSpecificInternal(PsiMethod m1, PsiMethod m2, PsiSubstitutor siteSubstitutor1, PsiExpression[] args, PsiElement context, boolean varargs) {
        ArrayList<PsiTypeParameter> params = new ArrayList<PsiTypeParameter>();
        for (PsiTypeParameter param : PsiUtil.typeParametersIterable(m2)) {
            params.add(param);
        }
        siteSubstitutor1 = InferenceSession.getSiteSubstitutor(siteSubstitutor1, params);
        InferenceSession session = new InferenceSession(params.toArray(new PsiTypeParameter[params.size()]), siteSubstitutor1, m2.getManager(), context);
        PsiParameter[] parameters1 = m1.getParameterList().getParameters();
        PsiParameter[] parameters2 = m2.getParameterList().getParameters();
        if (!varargs) {
            LOG.assertTrue(parameters1.length == parameters2.length);
        }
        int paramsLength = !varargs ? parameters1.length : Math.max(parameters1.length, parameters2.length) - 1;
        for (int i = 0; i < paramsLength; ++i) {
            PsiType sType = InferenceSession.getParameterType(parameters1, i, siteSubstitutor1, false);
            PsiType tType = session.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, i, siteSubstitutor1, varargs));
            if (sType instanceof PsiClassType && tType instanceof PsiClassType && LambdaUtil.isFunctionalType(sType) && LambdaUtil.isFunctionalType(tType) && !InferenceSession.relates(sType, tType)) {
                if (InferenceSession.isFunctionalTypeMoreSpecific(sType, tType, session, args[i])) continue;
                return false;
            }
            if (session.isProperType(tType) && !TypeConversionUtil.isAssignable(tType, sType)) {
                return false;
            }
            session.addConstraint(new StrictSubtypingConstraint(tType, sType));
        }
        if (varargs) {
            PsiType sType = InferenceSession.getParameterType(parameters1, paramsLength, siteSubstitutor1, true);
            PsiType tType = session.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, paramsLength, siteSubstitutor1, true));
            session.addConstraint(new StrictSubtypingConstraint(tType, sType));
        }
        return session.repeatInferencePhases();
    }

    private static PsiSubstitutor getSiteSubstitutor(PsiSubstitutor siteSubstitutor1, List<PsiTypeParameter> params) {
        PsiSubstitutor subst = PsiSubstitutor.EMPTY;
        for (PsiTypeParameter param : params) {
            subst = subst.put(param, siteSubstitutor1.substitute(param));
        }
        return subst;
    }

    public static boolean isFunctionalTypeMoreSpecificOnExpression(PsiType sType, PsiType tType, PsiExpression arg) {
        return InferenceSession.isFunctionalTypeMoreSpecific(sType, tType, null, arg);
    }

    private static boolean isFunctionalTypeMoreSpecific(PsiType sType, PsiType tType, @Nullable InferenceSession session, PsiExpression ... args) {
        PsiType capturedSType = sType;
        PsiClassType.ClassResolveResult sResult = PsiUtil.resolveGenericsClassInType(capturedSType);
        PsiMethod sInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(sResult);
        LOG.assertTrue(sInterfaceMethod != null);
        PsiSubstitutor sSubstitutor = LambdaUtil.getSubstitutor(sInterfaceMethod, sResult);
        PsiClassType.ClassResolveResult tResult = PsiUtil.resolveGenericsClassInType(tType);
        PsiMethod tInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(tResult);
        LOG.assertTrue(tInterfaceMethod != null);
        PsiSubstitutor tSubstitutor = LambdaUtil.getSubstitutor(tInterfaceMethod, tResult);
        for (PsiExpression arg : args) {
            if (InferenceSession.argConstraints(arg, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor)) continue;
            return false;
        }
        return true;
    }

    protected static boolean argConstraints(PsiExpression arg, @Nullable InferenceSession session, PsiMethod sInterfaceMethod, PsiSubstitutor sSubstitutor, PsiMethod tInterfaceMethod, PsiSubstitutor tSubstitutor) {
        if (arg instanceof PsiLambdaExpression && ((PsiLambdaExpression)arg).hasFormalParameterTypes()) {
            PsiType sReturnType = sSubstitutor.substitute(sInterfaceMethod.getReturnType());
            PsiType tReturnType = tSubstitutor.substitute(tInterfaceMethod.getReturnType());
            if (PsiType.VOID.equals(tReturnType)) {
                return true;
            }
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)arg);
            if (sReturnType instanceof PsiClassType && tReturnType instanceof PsiClassType && LambdaUtil.isFunctionalType(sReturnType) && LambdaUtil.isFunctionalType(tReturnType) && !TypeConversionUtil.isAssignable(TypeConversionUtil.erasure(sReturnType), TypeConversionUtil.erasure(tReturnType)) && !TypeConversionUtil.isAssignable(TypeConversionUtil.erasure(tReturnType), TypeConversionUtil.erasure(sReturnType))) {
                if (!InferenceSession.isFunctionalTypeMoreSpecific(sReturnType, tReturnType, session, returnExpressions.toArray(new PsiExpression[returnExpressions.size()]))) {
                    return false;
                }
            } else {
                boolean tPrimitive;
                boolean sPrimitive = sReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals(sReturnType);
                boolean bl = tPrimitive = tReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals(tReturnType);
                if (sPrimitive ^ tPrimitive) {
                    for (PsiExpression returnExpression : returnExpressions) {
                        if (!PsiPolyExpressionUtil.isPolyExpression(returnExpression)) {
                            PsiType returnExpressionType = returnExpression.getType();
                            if (!(sPrimitive ? !(returnExpressionType instanceof PsiPrimitiveType) : !(returnExpressionType instanceof PsiClassType))) continue;
                            return false;
                        }
                        if (!sPrimitive) continue;
                        return false;
                    }
                    return true;
                }
                if (session != null) {
                    session.addConstraint(new StrictSubtypingConstraint(tReturnType, sReturnType));
                    return true;
                }
                return sReturnType != null && tReturnType != null && TypeConversionUtil.isAssignable(tReturnType, sReturnType);
            }
        }
        if (arg instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)arg).isExact()) {
            boolean tPrimitive;
            PsiParameter[] tParameters;
            PsiParameter[] sParameters = sInterfaceMethod.getParameterList().getParameters();
            LOG.assertTrue(sParameters.length == (tParameters = tInterfaceMethod.getParameterList().getParameters()).length, "s: " + sInterfaceMethod.getParameterList().getText() + "; t: " + tInterfaceMethod.getParameterList().getText());
            for (int i = 0; i < tParameters.length; ++i) {
                PsiType tSubstituted = tSubstitutor.substitute(tParameters[i].getType());
                PsiType sSubstituted = sSubstitutor.substitute(sParameters[i].getType());
                if (session != null) {
                    session.addConstraint(new TypeEqualityConstraint(tSubstituted, sSubstituted));
                    continue;
                }
                if (Comparing.equal(tSubstituted, sSubstituted)) continue;
                return false;
            }
            PsiType sReturnType = sSubstitutor.substitute(sInterfaceMethod.getReturnType());
            PsiType tReturnType = tSubstitutor.substitute(tInterfaceMethod.getReturnType());
            if (PsiType.VOID.equals(tReturnType)) {
                return true;
            }
            boolean sPrimitive = sReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals(sReturnType);
            boolean bl = tPrimitive = tReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals(tReturnType);
            if (sPrimitive ^ tPrimitive) {
                PsiMember member = ((PsiMethodReferenceExpression)arg).getPotentiallyApplicableMember();
                LOG.assertTrue(member != null, arg);
                if (member instanceof PsiMethod) {
                    PsiType methodReturnType = ((PsiMethod)member).getReturnType();
                    if (sPrimitive && methodReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals(methodReturnType) || tPrimitive && methodReturnType instanceof PsiClassType) {
                        return true;
                    }
                }
                return false;
            }
            if (session != null) {
                session.addConstraint(new StrictSubtypingConstraint(tReturnType, sReturnType));
                return true;
            }
            return sReturnType != null && tReturnType != null && TypeConversionUtil.isAssignable(tReturnType, sReturnType);
        }
        if (arg instanceof PsiParenthesizedExpression) {
            return InferenceSession.argConstraints(((PsiParenthesizedExpression)arg).getExpression(), session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor);
        }
        if (arg instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)arg).getThenExpression();
            PsiExpression elseExpression = ((PsiConditionalExpression)arg).getElseExpression();
            return InferenceSession.argConstraints(thenExpression, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor) && InferenceSession.argConstraints(elseExpression, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor);
        }
        return false;
    }

    private static boolean relates(PsiType sType, PsiType tType) {
        PsiType sTypeErasure;
        PsiType erasedType = TypeConversionUtil.erasure(tType);
        LOG.assertTrue(erasedType != null);
        if (sType instanceof PsiIntersectionType) {
            boolean superRelation = true;
            boolean subRelation = false;
            for (PsiType sConjunct : ((PsiIntersectionType)sType).getConjuncts()) {
                PsiType sConjunctErasure = TypeConversionUtil.erasure(sConjunct);
                if (sConjunctErasure == null) continue;
                superRelation &= TypeConversionUtil.isAssignable(sConjunctErasure, erasedType);
                subRelation |= TypeConversionUtil.isAssignable(erasedType, sConjunctErasure);
            }
            return superRelation || subRelation;
        }
        if (sType instanceof PsiClassType && (sTypeErasure = TypeConversionUtil.erasure(sType)) != null) {
            return TypeConversionUtil.isAssignable(sTypeErasure, erasedType) || TypeConversionUtil.isAssignable(erasedType, sTypeErasure);
        }
        return false;
    }

    public void collectCaptureDependencies(InferenceVariable inferenceVariable, Set<InferenceVariable> dependencies) {
        this.myIncorporationPhase.collectCaptureDependencies(inferenceVariable, dependencies);
    }

    public boolean hasCapture(InferenceVariable inferenceVariable) {
        return this.myIncorporationPhase.hasCaptureConstraints(Collections.singletonList(inferenceVariable));
    }

    public static boolean wasUncheckedConversionPerformed(PsiElement call2) {
        Boolean erased = call2.getUserData(ERASED);
        return erased != null && erased != false;
    }

    public PsiElement getContext() {
        return this.myContext;
    }

    public void propagateVariables(Collection<InferenceVariable> variables, PsiSubstitutor restoreNamesSubstitution) {
        this.myInferenceVariables.addAll(variables);
        this.myRestoreNameSubstitution = this.myRestoreNameSubstitution.putAll(restoreNamesSubstitution);
    }

    public PsiType substituteWithInferenceVariables(PsiType type2) {
        return this.myInferenceSubstitution.substitute(type2);
    }

    public PsiSubstitutor getInferenceSubstitution() {
        return this.myInferenceSubstitution;
    }

    public PsiSubstitutor getRestoreNameSubstitution() {
        return this.myRestoreNameSubstitution;
    }

    public InferenceSessionContainer getInferenceSessionContainer() {
        return this.myInferenceSessionContainer;
    }

    public PsiType startWithFreshVars(PsiType type2) {
        PsiSubstitutor s = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : this.myInferenceVariables) {
            s = s.put(variable, JavaPsiFacade.getElementFactory(variable.getProject()).createType(variable.getParameter()));
        }
        return s.substitute(type2);
    }

    public static PsiClass findParameterizationOfTheSameGenericClass(List<PsiType> upperBounds2, Processor<Pair<PsiType, PsiType>> processor) {
        for (int i = 0; i < upperBounds2.size(); ++i) {
            PsiType sBound = upperBounds2.get(i);
            PsiClass sClass = PsiUtil.resolveClassInClassTypeOnly(sBound);
            if (sClass == null) continue;
            LinkedHashSet<PsiClass> superClasses2 = InheritanceUtil.getSuperClasses(sClass);
            superClasses2.add(sClass);
            for (int j = i + 1; j < upperBounds2.size(); ++j) {
                PsiType tBound = upperBounds2.get(j);
                PsiClass tClass = PsiUtil.resolveClassInClassTypeOnly(tBound);
                if (tClass == null) continue;
                LinkedHashSet<PsiClass> tSupers = InheritanceUtil.getSuperClasses(tClass);
                tSupers.add(tClass);
                tSupers.retainAll(superClasses2);
                for (PsiClass gClass : tSupers) {
                    PsiSubstitutor sSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(gClass, (PsiClassType)sBound);
                    PsiSubstitutor tSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(gClass, (PsiClassType)tBound);
                    for (PsiTypeParameter typeParameter : gClass.getTypeParameters()) {
                        PsiType tType;
                        PsiType sType = sSubstitutor.substitute(typeParameter);
                        Pair<PsiType, PsiType> typePair = Pair.create(sType, tType = tSubstitutor.substitute(typeParameter));
                        if (processor.process(typePair)) continue;
                        return gClass;
                    }
                }
            }
        }
        return null;
    }

    public List<String> getIncompatibleErrorMessages() {
        return this.myErrorMessages;
    }

    public boolean isErased() {
        return this.myErased;
    }
}

