/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.containers.OpenTHashSet;
import org.jetbrains.kotlin.gnu.trove.TObjectHashingStrategy;

public class Interner<T> {
    private final OpenTHashSet<T> mySet;

    public Interner() {
        this.mySet = new OpenTHashSet();
    }

    public Interner(@NotNull TObjectHashingStrategy<T> strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/kotlin/com/intellij/util/containers/Interner", "<init>"));
        }
        this.mySet = new OpenTHashSet<T>(strategy);
    }

    @NotNull
    public T intern(@NotNull T name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/util/containers/Interner", "intern"));
        }
        T interned = this.mySet.get(name2);
        if (interned != null) {
            T t = interned;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/Interner", "intern"));
            }
            return t;
        }
        boolean added = this.mySet.add(name2);
        assert (added);
        T t = name2;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/Interner", "intern"));
        }
        return t;
    }

    public void clear() {
        this.mySet.clear();
    }

    @NotNull
    public Set<T> getValues() {
        OpenTHashSet<T> openTHashSet = this.mySet;
        if (openTHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/Interner", "getValues"));
        }
        return openTHashSet;
    }
}

