/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.health.memory;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Locale;
import org.gradle.api.Nullable;

public class MemoryAmount {
    private static final long KILO_FACTOR = 1024L;
    private static final long MEGA_FACTOR = 0x100000L;
    private static final long GIGA_FACTOR = 0x40000000L;
    private static final long TERA_FACTOR = 0x10000000000L;
    private final long bytes;
    private final String notation;

    public static MemoryAmount of(long bytes) {
        return new MemoryAmount(bytes, String.valueOf(bytes));
    }

    public static MemoryAmount ofKiloBytes(long kiloBytes) {
        long bytes = kiloBytes * 1024L;
        return new MemoryAmount(bytes, bytes + "k");
    }

    public static MemoryAmount ofMegaBytes(long megaBytes) {
        long bytes = megaBytes * 0x100000L;
        return new MemoryAmount(bytes, bytes + "m");
    }

    public static MemoryAmount ofGigaBytes(long gigaBytes) {
        long bytes = gigaBytes * 0x40000000L;
        return new MemoryAmount(bytes, bytes + "g");
    }

    public static MemoryAmount ofTeraBytes(long teraBytes) {
        long bytes = teraBytes * 0x10000000000L;
        return new MemoryAmount(bytes, bytes + "t");
    }

    public static MemoryAmount of(String notation) {
        return new MemoryAmount(MemoryAmount.parseNotation(notation), notation);
    }

    public static long parseNotation(@Nullable String notation) {
        if (notation == null) {
            return -1L;
        }
        String normalized = notation.toLowerCase(Locale.US).trim();
        if (normalized.isEmpty()) {
            return -1L;
        }
        try {
            if (normalized.endsWith("k")) {
                return MemoryAmount.parseWithFactor(normalized, 1024L);
            }
            if (normalized.endsWith("m")) {
                return MemoryAmount.parseWithFactor(normalized, 0x100000L);
            }
            if (normalized.endsWith("g")) {
                return MemoryAmount.parseWithFactor(normalized, 0x40000000L);
            }
            if (normalized.endsWith("t")) {
                return MemoryAmount.parseWithFactor(normalized, 0x10000000000L);
            }
            return Long.parseLong(normalized);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Cannot parse memory amount notation: " + notation, ex);
        }
    }

    private static long parseWithFactor(String notation, long factor) {
        return Long.parseLong(notation.substring(0, notation.length() - 1)) * factor;
    }

    private MemoryAmount(long bytes, String notation) {
        Preconditions.checkArgument((bytes > 0L ? 1 : 0) != 0, (Object)"bytes must be positive");
        this.bytes = bytes;
        this.notation = notation;
    }

    public long getBytes() {
        return this.bytes;
    }

    public String toString() {
        return this.notation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryAmount that = (MemoryAmount)o;
        return this.bytes == that.bytes;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.bytes});
    }
}

