/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.cacheops;

import java.util.HashMap;
import java.util.Map;
import org.gradle.cache.internal.cacheops.CacheOperationStack;

public class CacheAccessOperationsStack {
    private final Map<Thread, CacheOperationStack> perThreadStacks = new HashMap<Thread, CacheOperationStack>();

    public void pushCacheAction() {
        this.getStackForCurrentThread().pushCacheAction();
    }

    public void popCacheAction() {
        CacheOperationStack stack = this.getStackForCurrentThread();
        stack.popCacheAction();
        if (stack.isEmpty()) {
            this.perThreadStacks.remove(Thread.currentThread());
        }
    }

    public boolean isInCacheAction() {
        CacheOperationStack stack = this.perThreadStacks.get(Thread.currentThread());
        return stack != null && stack.isInCacheAction();
    }

    public void pushLongRunningOperation() {
        this.getStackForCurrentThread().pushLongRunningOperation();
    }

    public void popLongRunningOperation() {
        CacheOperationStack stack = this.getStackForCurrentThread();
        stack.popLongRunningOperation();
        if (stack.isEmpty()) {
            this.perThreadStacks.remove(Thread.currentThread());
        }
    }

    private CacheOperationStack getStackForCurrentThread() {
        CacheOperationStack stack = this.perThreadStacks.get(Thread.currentThread());
        if (stack == null) {
            stack = new CacheOperationStack();
            this.perThreadStacks.put(Thread.currentThread(), stack);
        }
        return stack;
    }
}

