/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal;

import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.RoleAwareBuildCacheService;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.util.GFileUtils;

public class DispatchingBuildCacheService
implements RoleAwareBuildCacheService {
    private final RoleAwareBuildCacheService local;
    private final boolean pushToLocal;
    private final RoleAwareBuildCacheService remote;
    private final boolean pushToRemote;
    private final TemporaryFileProvider temporaryFileProvider;
    private final String role;

    DispatchingBuildCacheService(RoleAwareBuildCacheService local, boolean pushToLocal, RoleAwareBuildCacheService remote, boolean pushToRemote, TemporaryFileProvider temporaryFileProvider) {
        this.local = local;
        this.pushToLocal = pushToLocal;
        this.remote = remote;
        this.pushToRemote = pushToRemote;
        this.temporaryFileProvider = temporaryFileProvider;
        this.role = local.getRole() + " and " + remote.getRole();
    }

    public boolean load(BuildCacheKey key, BuildCacheEntryReader reader) throws BuildCacheException {
        return this.local.load(key, reader) || this.remote.load(key, reader);
    }

    public void store(BuildCacheKey key, BuildCacheEntryWriter writer) throws BuildCacheException {
        if (this.pushToLocal && this.pushToRemote) {
            this.pushToLocalAndRemote(key, writer);
        } else if (this.pushToLocal) {
            this.local.store(key, writer);
        } else if (this.pushToRemote) {
            this.remote.store(key, writer);
        }
    }

    private void pushToLocalAndRemote(BuildCacheKey key, BuildCacheEntryWriter writer) {
        File destination = this.temporaryFileProvider.createTemporaryFile("gradle_cache", "entry", new String[0]);
        try {
            this.writeCacheEntryLocally(writer, destination);
            CopyBuildCacheEntryWriter copier = new CopyBuildCacheEntryWriter(destination);
            this.local.store(key, copier);
            this.remote.store(key, copier);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        finally {
            GFileUtils.deleteQuietly(destination);
        }
    }

    private void writeCacheEntryLocally(BuildCacheEntryWriter writer, File destination) throws IOException {
        BufferedOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new BufferedOutputStream(new FileOutputStream(destination));
            writer.writeTo(fileOutputStream);
        }
        catch (FileNotFoundException e) {
            try {
                throw new BuildCacheException("Couldn't create local file for cache entry", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
    }

    public String getRole() {
        return this.role;
    }

    public String getDescription() {
        return "dispatching build cache";
    }

    public void close() throws IOException {
        CompositeStoppable.stoppable((Object[])new Object[]{this.local, this.remote}).stop();
    }

    private class CopyBuildCacheEntryWriter
    implements BuildCacheEntryWriter {
        private final File source;

        private CopyBuildCacheEntryWriter(File source) {
            this.source = source;
        }

        public void writeTo(OutputStream output) throws IOException {
            Files.copy((File)this.source, (OutputStream)output);
        }
    }
}

