/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.script.lang.kotlin.accessors;

import groovy.json.JsonOutput;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.script.lang.kotlin.accessors.ProjectSchemaKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016R\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/gradle/script/lang/kotlin/accessors/GenerateProjectSchema;", "Lorg/gradle/api/DefaultTask;", "()V", "destinationFile", "Ljava/io/File;", "getDestinationFile", "()Ljava/io/File;", "setDestinationFile", "(Ljava/io/File;)V", "generateProjectSchema", "", "getDescription", "", "getGroup", "gradle-script-kotlin_main"})
public class GenerateProjectSchema
extends DefaultTask {
    @Nullable
    private File destinationFile;

    @NotNull
    public String getGroup() {
        return "Build Setup";
    }

    @NotNull
    public String getDescription() {
        return "Generates Kotlin code for accessing and configuring the currently available project extensions and conventions.";
    }

    @OutputFile
    @Nullable
    public final File getDestinationFile() {
        return this.destinationFile;
    }

    public final void setDestinationFile(@Nullable File file) {
        this.destinationFile = file;
    }

    @TaskAction
    public final void generateProjectSchema() {
        File file = this.destinationFile;
        if (file == null) {
            Intrinsics.throwNpe();
        }
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        String string = JsonOutput.prettyPrint((String)ProjectSchemaKt.toJson(ProjectSchemaKt.multiProjectSchemaFor(project)));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"prettyPrint(toJson(multi\u2026ojectSchemaFor(project)))");
        FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
    }
}

