/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.component.Artifact;
import org.gradle.api.internal.artifacts.DependencyGraphNodeResult;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCollectingVisitor;
import org.gradle.api.internal.artifacts.ivyservice.CacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedFileDependencyResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactsResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedFileDependencyResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResultsLoader;
import org.gradle.api.internal.artifacts.result.DefaultResolvedArtifactResult;
import org.gradle.api.internal.artifacts.transform.ArtifactTransforms;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.Factory;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraphWithEdgeValues;
import org.gradle.util.CollectionUtils;

public class DefaultLenientConfiguration
implements LenientConfiguration,
VisitedArtifactSet {
    private final CacheLockingManager cacheLockingManager;
    private final ConfigurationInternal configuration;
    private final Set<UnresolvedDependency> unresolvedDependencies;
    private final VisitedArtifactsResults artifactResults;
    private final VisitedFileDependencyResults fileDependencyResults;
    private final TransientConfigurationResultsLoader transientConfigurationResultsFactory;
    private final ArtifactTransforms artifactTransforms;
    private SelectedArtifactResults artifactsForThisConfiguration;
    private SelectedFileDependencyResults filesForThisConfiguration;

    public DefaultLenientConfiguration(ConfigurationInternal configuration, CacheLockingManager cacheLockingManager, Set<UnresolvedDependency> unresolvedDependencies, VisitedArtifactsResults artifactResults, VisitedFileDependencyResults fileDependencyResults, TransientConfigurationResultsLoader transientConfigurationResultsLoader, ArtifactTransforms artifactTransforms) {
        this.configuration = configuration;
        this.cacheLockingManager = cacheLockingManager;
        this.unresolvedDependencies = unresolvedDependencies;
        this.artifactResults = artifactResults;
        this.fileDependencyResults = fileDependencyResults;
        this.transientConfigurationResultsFactory = transientConfigurationResultsLoader;
        this.artifactTransforms = artifactTransforms;
    }

    private SelectedArtifactResults getSelectedArtifacts() {
        if (this.artifactsForThisConfiguration == null) {
            this.artifactsForThisConfiguration = this.artifactResults.select((Spec<? super ComponentIdentifier>)Specs.satisfyAll(), this.artifactTransforms.variantSelector((AttributeContainerInternal)ImmutableAttributes.EMPTY));
        }
        return this.artifactsForThisConfiguration;
    }

    private SelectedFileDependencyResults getSelectedFiles() {
        if (this.filesForThisConfiguration == null) {
            this.filesForThisConfiguration = this.fileDependencyResults.select((Spec<? super ComponentIdentifier>)Specs.satisfyAll(), this.artifactTransforms.variantSelector((AttributeContainerInternal)ImmutableAttributes.EMPTY));
        }
        return this.filesForThisConfiguration;
    }

    public SelectedArtifactSet select() {
        return this.select((Spec<? super Dependency>)Specs.satisfyAll(), (AttributeContainerInternal)ImmutableAttributes.EMPTY, (Spec<? super ComponentIdentifier>)Specs.satisfyAll());
    }

    public SelectedArtifactSet select(Spec<? super Dependency> dependencySpec) {
        return this.select(dependencySpec, (AttributeContainerInternal)ImmutableAttributes.EMPTY, (Spec<? super ComponentIdentifier>)Specs.satisfyAll());
    }

    @Override
    public SelectedArtifactSet select(final Spec<? super Dependency> dependencySpec, AttributeContainerInternal requestedAttributes, Spec<? super ComponentIdentifier> componentSpec) {
        Transformer<ResolvedArtifactSet, Collection<? extends ResolvedVariant>> selector = this.artifactTransforms.variantSelector(requestedAttributes);
        final SelectedArtifactResults artifactResults = this.artifactResults.select(componentSpec, selector);
        final SelectedFileDependencyResults fileDependencyResults = this.fileDependencyResults.select(componentSpec, selector);
        return new SelectedArtifactSet(){

            @Override
            public <T extends Collection<Object>> T collectBuildDependencies(T dest) {
                artifactResults.getArtifacts().collectBuildDependencies(dest);
                fileDependencyResults.getArtifacts().collectBuildDependencies(dest);
                return dest;
            }

            @Override
            public void visitArtifacts(ArtifactVisitor visitor) {
                DefaultLenientConfiguration.this.visitArtifacts((Spec<? super Dependency>)dependencySpec, artifactResults, fileDependencyResults, visitor);
            }

            @Override
            public <T extends Collection<? super File>> T collectFiles(T dest) throws ResolveException {
                DefaultLenientConfiguration.this.rethrowFailure();
                ResolvedFilesCollectingVisitor visitor = new ResolvedFilesCollectingVisitor(dest);
                try {
                    DefaultLenientConfiguration.this.visitArtifacts((Spec<? super Dependency>)dependencySpec, artifactResults, fileDependencyResults, visitor);
                    visitor.addArtifacts();
                }
                catch (Throwable t) {
                    visitor.failures.add(t);
                }
                if (!visitor.failures.isEmpty()) {
                    throw new ArtifactResolveException("files", DefaultLenientConfiguration.this.configuration.getPath(), DefaultLenientConfiguration.this.configuration.getDisplayName(), visitor.failures);
                }
                return dest;
            }

            @Override
            public <T extends Collection<? super ResolvedArtifactResult>> T collectArtifacts(T dest) throws ResolveException {
                DefaultLenientConfiguration.this.rethrowFailure();
                ResolvedArtifactCollectingVisitor visitor = new ResolvedArtifactCollectingVisitor(dest);
                try {
                    DefaultLenientConfiguration.this.visitArtifacts((Spec<? super Dependency>)dependencySpec, artifactResults, fileDependencyResults, visitor);
                }
                catch (Throwable t) {
                    visitor.failures.add(t);
                }
                if (!visitor.failures.isEmpty()) {
                    throw new ArtifactResolveException("artifacts", DefaultLenientConfiguration.this.configuration.getPath(), DefaultLenientConfiguration.this.configuration.getDisplayName(), visitor.failures);
                }
                return dest;
            }
        };
    }

    public boolean hasError() {
        return this.unresolvedDependencies.size() > 0;
    }

    public Set<UnresolvedDependency> getUnresolvedModuleDependencies() {
        return this.unresolvedDependencies;
    }

    public void rethrowFailure() throws ResolveException {
        if (this.hasError()) {
            ArrayList<Throwable> failures = new ArrayList<Throwable>();
            for (UnresolvedDependency unresolvedDependency : this.unresolvedDependencies) {
                failures.add(unresolvedDependency.getProblem());
            }
            throw new ResolveException(this.configuration.toString(), failures);
        }
    }

    private TransientConfigurationResults loadTransientGraphResults(SelectedArtifactResults artifactResults) {
        return this.transientConfigurationResultsFactory.create(artifactResults);
    }

    public Set<ResolvedDependency> getFirstLevelModuleDependencies(Spec<? super Dependency> dependencySpec) {
        LinkedHashSet<ResolvedDependency> matches = new LinkedHashSet<ResolvedDependency>();
        for (DependencyGraphNodeResult node : this.getFirstLevelNodes(dependencySpec)) {
            matches.add(node.getPublicView());
        }
        return matches;
    }

    private Set<DependencyGraphNodeResult> getFirstLevelNodes(Spec<? super Dependency> dependencySpec) {
        LinkedHashSet<DependencyGraphNodeResult> matches = new LinkedHashSet<DependencyGraphNodeResult>();
        TransientConfigurationResults graphResults = this.loadTransientGraphResults(this.getSelectedArtifacts());
        for (Map.Entry<ModuleDependency, DependencyGraphNodeResult> entry : graphResults.getFirstLevelDependencies().entrySet()) {
            if (!dependencySpec.isSatisfiedBy((Object)entry.getKey())) continue;
            matches.add(entry.getValue());
        }
        return matches;
    }

    public Set<ResolvedDependency> getAllModuleDependencies() {
        LinkedHashSet<ResolvedDependency> resolvedElements = new LinkedHashSet<ResolvedDependency>();
        LinkedList workQueue = new LinkedList();
        workQueue.addAll(this.loadTransientGraphResults(this.getSelectedArtifacts()).getRootNode().getPublicView().getChildren());
        while (!workQueue.isEmpty()) {
            Set children;
            ResolvedDependency item = (ResolvedDependency)workQueue.removeFirst();
            if (!resolvedElements.add(item) || (children = item.getChildren()) == null) continue;
            workQueue.addAll(children);
        }
        return resolvedElements;
    }

    public Set<File> getFiles() {
        return this.getFiles((Spec<? super Dependency>)Specs.satisfyAll());
    }

    public Set<File> getFiles(Spec<? super Dependency> dependencySpec) {
        LinkedHashSet files = Sets.newLinkedHashSet();
        FilesAndArtifactCollectingVisitor visitor = new FilesAndArtifactCollectingVisitor(files);
        this.visitArtifacts(dependencySpec, this.getSelectedArtifacts(), this.getSelectedFiles(), visitor);
        files.addAll(this.getFiles(this.filterUnresolved(visitor.artifacts)));
        return files;
    }

    public Set<ResolvedArtifact> getArtifacts() {
        return this.getArtifacts((Spec<? super Dependency>)Specs.satisfyAll());
    }

    public Set<ResolvedArtifact> getArtifacts(Spec<? super Dependency> dependencySpec) {
        ArtifactCollectingVisitor visitor = new ArtifactCollectingVisitor();
        this.visitArtifacts(dependencySpec, this.getSelectedArtifacts(), this.getSelectedFiles(), visitor);
        return this.filterUnresolved(visitor.artifacts);
    }

    private Set<ResolvedArtifact> filterUnresolved(final Set<ResolvedArtifact> artifacts) {
        return (Set)this.cacheLockingManager.useCache((Factory)new Factory<Set<ResolvedArtifact>>(){

            public Set<ResolvedArtifact> create() {
                return CollectionUtils.filter((Set)artifacts, (Spec)new IgnoreMissingExternalArtifacts());
            }
        });
    }

    private Set<File> getFiles(final Set<ResolvedArtifact> artifacts) {
        final LinkedHashSet<File> files = new LinkedHashSet<File>();
        this.cacheLockingManager.useCache(new Runnable(){

            @Override
            public void run() {
                for (ResolvedArtifact artifact : artifacts) {
                    File depFile = artifact.getFile();
                    if (depFile == null) continue;
                    files.add(depFile);
                }
            }
        });
        return files;
    }

    private void visitArtifacts(Spec<? super Dependency> dependencySpec, SelectedArtifactResults artifactResults, SelectedFileDependencyResults fileDependencyResults, ArtifactVisitor visitor) {
        if (dependencySpec == Specs.SATISFIES_ALL) {
            if (visitor.includeFiles()) {
                fileDependencyResults.getArtifacts().visit(visitor);
            }
            artifactResults.getArtifacts().visit(visitor);
            return;
        }
        if (visitor.includeFiles()) {
            for (Map.Entry<FileCollectionDependency, ResolvedArtifactSet> entry : fileDependencyResults.getFirstLevelFiles().entrySet()) {
                if (!dependencySpec.isSatisfiedBy((Object)entry.getKey())) continue;
                entry.getValue().visit(visitor);
            }
        }
        CachingDirectedGraphWalker walker = new CachingDirectedGraphWalker((DirectedGraphWithEdgeValues)new ResolvedDependencyArtifactsGraph(visitor, fileDependencyResults));
        DependencyGraphNodeResult rootNode = this.loadTransientGraphResults(artifactResults).getRootNode();
        for (DependencyGraphNodeResult node : this.getFirstLevelNodes(dependencySpec)) {
            node.getArtifactsForIncomingEdge(rootNode).visit(visitor);
            walker.add((Object[])new DependencyGraphNodeResult[]{node});
        }
        walker.findValues();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Set<ResolvedDependency> getFirstLevelModuleDependencies() {
        return this.loadTransientGraphResults(this.getSelectedArtifacts()).getRootNode().getPublicView().getChildren();
    }

    private static class IgnoreMissingExternalArtifacts
    implements Spec<ResolvedArtifact> {
        private IgnoreMissingExternalArtifacts() {
        }

        public boolean isSatisfiedBy(ResolvedArtifact element) {
            if (this.isExternalModuleArtifact(element)) {
                try {
                    element.getFile();
                }
                catch (org.gradle.internal.resolve.ArtifactResolveException e) {
                    return false;
                }
            }
            return true;
        }

        boolean isExternalModuleArtifact(ResolvedArtifact element) {
            return element.getId().getComponentIdentifier() instanceof ModuleComponentIdentifier;
        }
    }

    private static class ResolvedDependencyArtifactsGraph
    implements DirectedGraphWithEdgeValues<DependencyGraphNodeResult, ResolvedArtifact> {
        private final ArtifactVisitor artifactsVisitor;
        private final SelectedFileDependencyResults fileDependencyResults;

        ResolvedDependencyArtifactsGraph(ArtifactVisitor artifactsVisitor, SelectedFileDependencyResults fileDependencyResults) {
            this.artifactsVisitor = artifactsVisitor;
            this.fileDependencyResults = fileDependencyResults;
        }

        public void getNodeValues(DependencyGraphNodeResult node, Collection<? super ResolvedArtifact> values, Collection<? super DependencyGraphNodeResult> connectedNodes) {
            connectedNodes.addAll(node.getOutgoingEdges());
            if (this.artifactsVisitor.includeFiles()) {
                this.fileDependencyResults.getArtifacts(node.getNodeId()).visit(this.artifactsVisitor);
            }
        }

        public void getEdgeValues(DependencyGraphNodeResult from, DependencyGraphNodeResult to, Collection<ResolvedArtifact> values) {
            to.getArtifactsForIncomingEdge(from).visit(this.artifactsVisitor);
        }
    }

    private static class ArtifactResolveException
    extends ResolveException {
        private final String type;
        private final String displayName;

        public ArtifactResolveException(String type, String path, String displayName, List<Throwable> failures) {
            super(path, failures);
            this.type = type;
            this.displayName = displayName;
        }

        public String getMessage() {
            return String.format("Could not resolve all %s for %s.", this.type, this.displayName);
        }
    }

    private static class FilesAndArtifactCollectingVisitor
    extends ArtifactCollectingVisitor {
        final Collection<File> files;

        FilesAndArtifactCollectingVisitor(Collection<File> files) {
            this.files = files;
        }

        @Override
        public boolean includeFiles() {
            return true;
        }

        @Override
        public void visitFile(ComponentArtifactIdentifier artifactIdentifier, AttributeContainer variant, File file) {
            this.files.add(file);
        }
    }

    private static class ResolvedArtifactCollectingVisitor
    implements ArtifactVisitor {
        private final Collection<? super ResolvedArtifactResult> artifacts;
        private final Set<ComponentArtifactIdentifier> seenArtifacts = new HashSet<ComponentArtifactIdentifier>();
        private final List<Throwable> failures = new ArrayList<Throwable>();

        ResolvedArtifactCollectingVisitor(Collection<? super ResolvedArtifactResult> artifacts) {
            this.artifacts = artifacts;
        }

        @Override
        public void visitFailure(Throwable failure) {
            this.failures.add(failure);
        }

        @Override
        public void visitArtifact(AttributeContainer variant, ResolvedArtifact artifact) {
            try {
                if (this.seenArtifacts.add(artifact.getId())) {
                    File file = artifact.getFile();
                    this.artifacts.add(new DefaultResolvedArtifactResult(artifact.getId(), variant, Artifact.class, file));
                }
            }
            catch (Throwable t) {
                this.failures.add(t);
            }
        }

        @Override
        public boolean includeFiles() {
            return true;
        }

        @Override
        public void visitFile(ComponentArtifactIdentifier artifactIdentifier, AttributeContainer variant, File file) {
            if (this.seenArtifacts.add(artifactIdentifier)) {
                this.artifacts.add(new DefaultResolvedArtifactResult(artifactIdentifier, variant, Artifact.class, file));
            }
        }
    }

    private static class ResolvedFilesCollectingVisitor
    implements ArtifactVisitor {
        private final Collection<? super File> files;
        private final List<Throwable> failures = new ArrayList<Throwable>();
        private final Set<ResolvedArtifact> artifacts = new LinkedHashSet<ResolvedArtifact>();

        ResolvedFilesCollectingVisitor(Collection<? super File> files) {
            this.files = files;
        }

        @Override
        public void visitArtifact(AttributeContainer variant, ResolvedArtifact artifact) {
            this.artifacts.add(artifact);
        }

        @Override
        public void visitFailure(Throwable failure) {
            this.failures.add(failure);
        }

        @Override
        public boolean includeFiles() {
            return true;
        }

        @Override
        public void visitFile(ComponentArtifactIdentifier artifactIdentifier, AttributeContainer variant, File file) {
            this.files.add(file);
        }

        public void addArtifacts() {
            for (ResolvedArtifact artifact : this.artifacts) {
                try {
                    this.files.add(artifact.getFile());
                }
                catch (Throwable t) {
                    this.failures.add(t);
                }
            }
        }
    }
}

