/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.CompatibilityCheckDetails;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.CompatibilityRuleChainInternal;
import org.gradle.internal.Cast;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.text.TreeFormatter;

public class AmbiguousConfigurationSelectionException
extends IllegalArgumentException {
    private static final Function<ConfigurationMetadata, String> CONFIG_NAME = new Function<ConfigurationMetadata, String>(){

        public String apply(ConfigurationMetadata input) {
            return input.getName();
        }
    };
    private static final Joiner JOINER = Joiner.on((String)", ");
    static final Function<Attribute<?>, String> ATTRIBUTE_NAME = new Function<Attribute<?>, String>(){

        public String apply(Attribute<?> input) {
            return input.getName();
        }
    };

    public AmbiguousConfigurationSelectionException(AttributeContainer fromConfigurationAttributes, AttributesSchema consumerSchema, List<? extends ConfigurationMetadata> matches, ComponentResolveMetadata targetComponent) {
        super(AmbiguousConfigurationSelectionException.generateMessage(fromConfigurationAttributes, consumerSchema, matches, targetComponent));
    }

    private static String generateMessage(AttributeContainer fromConfigurationAttributes, AttributesSchema consumerSchema, List<? extends ConfigurationMetadata> matches, ComponentResolveMetadata targetComponent) {
        TreeSet ambiguousConfigurations = Sets.newTreeSet((Iterable)Lists.transform(matches, CONFIG_NAME));
        TreeSet requestedAttributes = Sets.newTreeSet((Iterable)Iterables.transform((Iterable)fromConfigurationAttributes.keySet(), ATTRIBUTE_NAME));
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("Cannot choose between the following configurations on ");
        formatter.append((CharSequence)targetComponent.getComponentId().getDisplayName());
        formatter.startChildren();
        for (String configuration : ambiguousConfigurations) {
            formatter.node(configuration);
        }
        formatter.endChildren();
        formatter.node("All of them match the consumer attributes");
        formatter.startChildren();
        for (String ambiguousConf : ambiguousConfigurations) {
            AmbiguousConfigurationSelectionException.formatConfiguration(formatter, fromConfigurationAttributes, consumerSchema, matches, requestedAttributes, ambiguousConf);
        }
        formatter.endChildren();
        return formatter.toString();
    }

    static void formatConfiguration(TreeFormatter formatter, AttributeContainer fromConfigurationAttributes, AttributesSchema consumerSchema, List<? extends ConfigurationMetadata> matches, Set<String> requestedAttributes, final String conf) {
        Optional match = Iterables.tryFind(matches, (Predicate)new Predicate<ConfigurationMetadata>(){

            public boolean apply(ConfigurationMetadata input) {
                return conf.equals(input.getName());
            }
        });
        if (match.isPresent()) {
            AttributeContainerInternal producerAttributes = ((ConfigurationMetadata)match.get()).getAttributes();
            Set targetAttributes = producerAttributes.keySet();
            TreeSet targetAttributeNames = Sets.newTreeSet((Iterable)Iterables.transform((Iterable)targetAttributes, ATTRIBUTE_NAME));
            Sets.SetView allAttributes = Sets.union((Set)fromConfigurationAttributes.keySet(), (Set)producerAttributes.keySet());
            Sets.SetView commonAttributes = Sets.intersection(requestedAttributes, (Set)targetAttributeNames);
            Sets.SetView consumerOnlyAttributes = Sets.difference(requestedAttributes, (Set)targetAttributeNames);
            formatter.node("Configuration '");
            formatter.append((CharSequence)conf);
            formatter.append((CharSequence)"'");
            formatter.startChildren();
            List sortedAttributes = Ordering.usingToString().sortedCopy((Iterable)allAttributes);
            AmbiguousConfigurationSelectionException.formatAttributes(formatter, fromConfigurationAttributes, consumerSchema, (AttributeContainer)producerAttributes, (Set<String>)commonAttributes, (Set<String>)consumerOnlyAttributes, sortedAttributes);
            formatter.endChildren();
        }
    }

    private static void formatAttributes(final TreeFormatter formatter, AttributeContainer fromConfigurationAttributes, AttributesSchema consumerSchema, AttributeContainer producerAttributes, Set<String> commonAttributes, Set<String> consumerOnlyAttributes, List<Attribute<?>> sortedAttributes) {
        for (Attribute<?> attribute : sortedAttributes) {
            final String attributeName = attribute.getName();
            if (commonAttributes.contains(attributeName)) {
                AttributeMatchingStrategy strategy = consumerSchema.getMatchingStrategy(attribute);
                CompatibilityRuleChainInternal compatibilityRules = (CompatibilityRuleChainInternal)Cast.uncheckedCast((Object)strategy.getCompatibilityRules());
                final Object consumerValue = fromConfigurationAttributes.getAttribute(attribute);
                final Object producerValue = producerAttributes.getAttribute(attribute);
                compatibilityRules.execute((Object)new CompatibilityCheckDetails<Object>(){

                    public Object getConsumerValue() {
                        return consumerValue;
                    }

                    public Object getProducerValue() {
                        return producerValue;
                    }

                    public void compatible() {
                        formatter.node("Required " + attributeName + " '" + consumerValue + "' and found compatible value '" + producerValue + "'.");
                    }

                    public void incompatible() {
                        formatter.node("Required " + attributeName + " '" + consumerValue + "' and found incompatible value '" + producerValue + "'.");
                    }
                });
                continue;
            }
            if (consumerOnlyAttributes.contains(attributeName)) {
                formatter.node("Required " + attributeName + " '" + fromConfigurationAttributes.getAttribute(attribute) + "' but no value provided.");
                continue;
            }
            formatter.node("Found " + attributeName + " '" + producerAttributes.getAttribute(attribute) + "' but wasn't required.");
        }
    }
}

