/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.AbstractRubyMethod;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.ProcMethod;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"UnboundMethod"}, parent="Method")
public class RubyUnboundMethod
extends AbstractRubyMethod {
    protected RubyUnboundMethod(Ruby runtime) {
        super(runtime, runtime.getUnboundMethod());
    }

    public static RubyUnboundMethod newUnboundMethod(RubyModule implementationModule, String methodName, RubyModule originModule, String originName, DynamicMethod method) {
        RubyUnboundMethod newMethod = new RubyUnboundMethod(implementationModule.getRuntime());
        newMethod.implementationModule = implementationModule;
        newMethod.methodName = methodName;
        newMethod.originModule = originModule;
        newMethod.originName = originName;
        newMethod.method = method;
        return newMethod;
    }

    public static RubyClass defineUnboundMethodClass(Ruby runtime) {
        RubyClass newClass = runtime.defineClass("UnboundMethod", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setUnboundMethod(newClass);
        newClass.setClassIndex(ClassIndex.UNBOUNDMETHOD);
        newClass.setReifiedClass(RubyUnboundMethod.class);
        newClass.defineAnnotatedMethods(AbstractRubyMethod.class);
        newClass.defineAnnotatedMethods(RubyUnboundMethod.class);
        newClass.getSingletonClass().undefineMethod("new");
        return newClass;
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public RubyBoolean op_equal(ThreadContext context, IRubyObject other) {
        if (!(other instanceof AbstractRubyMethod)) {
            return context.runtime.getFalse();
        }
        if (this.method instanceof ProcMethod) {
            return context.runtime.newBoolean(((ProcMethod)this.method).isSame(((AbstractRubyMethod)other).getMethod()));
        }
        AbstractRubyMethod otherMethod = (AbstractRubyMethod)other;
        return context.runtime.newBoolean(this.originModule == otherMethod.originModule && this.method.getRealMethod().getSerialNumber() == otherMethod.method.getRealMethod().getSerialNumber());
    }

    @JRubyMethod
    public RubyMethod bind(ThreadContext context, IRubyObject aReceiver) {
        RubyClass receiverClass = aReceiver.getMetaClass();
        receiverClass.checkValidBindTargetFrom(context, this.implementationModule);
        return RubyMethod.newMethod(this.implementationModule, this.methodName, receiverClass, this.originName, this.method, aReceiver);
    }

    @Override
    @JRubyMethod(name={"clone"})
    public RubyUnboundMethod rbClone() {
        return RubyUnboundMethod.newUnboundMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.method);
    }

    @Override
    @JRubyMethod(name={"inspect", "to_s"})
    public IRubyObject inspect() {
        StringBuilder buf = new StringBuilder("#<");
        char delimeter = '#';
        buf.append(this.getMetaClass().getRealClass().getName()).append(": ");
        if (this.implementationModule.isSingleton()) {
            buf.append(this.implementationModule.inspect().toString());
        } else {
            buf.append(this.originModule.getName());
            if (this.implementationModule != this.originModule) {
                buf.append('(').append(this.implementationModule.getName()).append(')');
            }
        }
        buf.append(delimeter).append(this.methodName).append('>');
        RubyString str = this.getRuntime().newString(buf.toString());
        str.setTaint(this.isTaint());
        return str;
    }

    @JRubyMethod
    public IRubyObject super_method(ThreadContext context) {
        return this.super_method(context, null, this.implementationModule.getSuperClass());
    }
}

