# walkdir Contributing Guidelines

- Always search for a related issue before starting a new issue.
- Always choose a concise, helpful issue name.
- Always stay on-topic. If you've got a new bug report or feature request, put it in its own issue.
- Always be polite to other people.
- Never post private information, such as torrent or tracker names, IP addresses, etc.

Issues that break the rules may be deleted and locked without warning.

## walkdir is an OPEN Open Source Project

Individuals making significant and valuable contributions are given commit-access to the project to contribute as they see fit. This project is more like an open wiki than a standard guarded open source project.

## Rules

There are a few basic ground-rules for contributors:

1. **No `--force` pushes** or modifying the Git history in any way.
1. **External API changes and significant modifications** should be subject to a **pull request** to solicit feedback from other contributors.
1. Pull requests to solicit feedback are *encouraged* for any other non-trivial contribution but left to the discretion of the contributor.
1. Use a non-`master` branch for ongoing work.
1. Contributors should attempt to adhere to the prevailing code style.
1. Run `npm test` locally before submitting your PR to catch easy-to-miss style & testing issues

## Releases

Declaring formal releases remains the prerogative of the project maintainer.

## Changes to this arrangement

*Thanks to [Rod Vagg](https://github.com/rvagg) and the [LevelUP](https://github.com/rvagg/node-levelup) project for coming up with this model of open source contribution.*
