/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram;

import com.baselet.control.HandlerElementMap;
import com.baselet.control.Main;
import com.baselet.control.SharedUtils;
import com.baselet.control.basics.Converter;
import com.baselet.control.basics.geom.Point;
import com.baselet.control.constants.Constants;
import com.baselet.control.enums.Program;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.diagram.DiagramPopupMenu;
import com.baselet.diagram.DrawPanel;
import com.baselet.diagram.FontHandler;
import com.baselet.diagram.Notifier;
import com.baselet.diagram.PaletteHandler;
import com.baselet.diagram.io.DiagramFileHandler;
import com.baselet.element.ComponentSwing;
import com.baselet.element.NewGridElement;
import com.baselet.element.interfaces.GridElement;
import com.baselet.element.old.element.Relation;
import com.baselet.gui.BaseGUI;
import com.baselet.gui.CurrentGui;
import com.baselet.gui.command.Controller;
import com.baselet.gui.listener.DiagramListener;
import com.baselet.gui.listener.GridElementListener;
import com.baselet.gui.listener.OldRelationListener;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagramHandler {
    private static final Logger log = LoggerFactory.getLogger(DiagramHandler.class);
    private boolean isChanged = false;
    private final DiagramFileHandler fileHandler;
    private FontHandler fontHandler;
    protected DrawPanel drawpanel = this.createDrawPanel();
    private final Controller controller = new Controller(this);
    protected DiagramListener listener;
    private String helptext;
    private boolean enabled = true;
    private int gridSize = 10;
    private OldRelationListener relationListener;
    private GridElementListener gridElementListener;

    public static DiagramHandler forExport(FontHandler fontHandler) {
        DiagramHandler returnHandler = new DiagramHandler(null, false);
        if (fontHandler != null) {
            returnHandler.fontHandler = fontHandler;
        }
        return returnHandler;
    }

    public DiagramHandler(File diagram) {
        this(diagram, false);
    }

    protected DiagramHandler(File diagram, boolean nolistener) {
        this.fontHandler = new FontHandler(this);
        this.fileHandler = DiagramFileHandler.createInstance(this, diagram);
        if (!nolistener) {
            this.setListener(new DiagramListener(this));
        }
        if (diagram != null) {
            this.fileHandler.doOpen();
        }
        boolean extendedPopupMenu = false;
        BaseGUI gui = CurrentGui.getInstance().getGui();
        if (gui != null) {
            gui.setValueOfZoomDisplay(this.getGridSize());
            extendedPopupMenu = gui.hasExtendedContextMenu();
        }
        this.initDiagramPopupMenu(extendedPopupMenu);
    }

    protected DrawPanel createDrawPanel() {
        return new DrawPanel(this, true);
    }

    protected void initDiagramPopupMenu(boolean extendedPopupMenu) {
        this.drawpanel.setComponentPopupMenu(new DiagramPopupMenu(extendedPopupMenu));
    }

    public void setEnabled(boolean en) {
        if (!en && this.enabled) {
            this.drawpanel.removeMouseListener(this.listener);
            this.drawpanel.removeMouseMotionListener(this.listener);
            this.enabled = false;
        } else if (en && !this.enabled) {
            this.drawpanel.addMouseListener(this.listener);
            this.drawpanel.addMouseMotionListener(this.listener);
            this.enabled = true;
        }
    }

    protected void setListener(DiagramListener listener) {
        this.listener = listener;
        this.drawpanel.addMouseListener(this.listener);
        this.drawpanel.addMouseMotionListener(this.listener);
        this.drawpanel.addMouseWheelListener(this.listener);
    }

    public DiagramListener getListener() {
        return this.listener;
    }

    public void setChanged(boolean changed) {
        if (this.isChanged != changed) {
            this.isChanged = changed;
            BaseGUI gui = CurrentGui.getInstance().getGui();
            if (gui != null) {
                gui.setDiagramChanged(this, changed);
            }
        }
    }

    public DrawPanel getDrawPanel() {
        return this.drawpanel;
    }

    public DiagramFileHandler getFileHandler() {
        return this.fileHandler;
    }

    public FontHandler getFontHandler() {
        return this.fontHandler;
    }

    public Controller getController() {
        return this.controller;
    }

    public boolean doSave() {
        try {
            this.fileHandler.doSave();
            this.reloadPalettes();
            CurrentGui.getInstance().getGui().afterSaving();
            return true;
        }
        catch (IOException e) {
            log.error("An error occured during saving: ", (Throwable)e);
            this.displayError("An error occured during saving: " + e.getMessage());
            return false;
        }
    }

    public void doSaveAs(String extension) {
        if (this.drawpanel.getGridElements().isEmpty()) {
            this.displayError("You cannot save or export an empty diagram.");
        } else {
            try {
                this.fileHandler.doSaveAs(extension);
                this.reloadPalettes();
                CurrentGui.getInstance().getGui().afterSaving();
            }
            catch (IOException e) {
                log.error("An error occured during saving: ", (Throwable)e);
                this.displayError("An error occured during saving: " + e.getMessage());
            }
        }
    }

    public void doPrint() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this.getDrawPanel());
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (PrinterException pe) {
                this.displayError("An error occured during printing.");
            }
        }
    }

    public void reload() {
        this.drawpanel.removeAll();
        this.fileHandler.doOpen();
        this.drawpanel.updatePanelAndScrollbars();
    }

    private void reloadPalettes() {
        for (DiagramHandler diagramHandler : Main.getInstance().getPalettes().values()) {
            if (!diagramHandler.getFileHandler().equals(this.getFileHandler()) || diagramHandler.equals(this)) continue;
            diagramHandler.reload();
        }
        this.getDrawPanel().getSelector().updateSelectorInformation();
    }

    public void doClose() {
        if (this.askSaveIfDirty()) {
            Main.getInstance().getDiagrams().remove(this);
            CurrentGui.getInstance().getGui().close(this);
            this.drawpanel.getSelector().deselectAll();
            DiagramHandler newhandler = CurrentDiagram.getInstance().getDiagramHandler();
            if (newhandler != null) {
                newhandler.getDrawPanel().getSelector().updateSelectorInformation();
            } else {
                Main.getInstance().setPropertyPanelToGridElement(null);
            }
        }
    }

    public String getName() {
        String name = this.fileHandler.getFileName();
        if (name.contains(".")) {
            name = name.substring(0, name.lastIndexOf("."));
        }
        return name;
    }

    public String getFullPathName() {
        return this.fileHandler.getFullPathName();
    }

    public GridElementListener getEntityListener(GridElement e) {
        if (e instanceof Relation) {
            if (this.relationListener == null) {
                this.relationListener = new OldRelationListener(this);
            }
            return this.relationListener;
        }
        if (this.gridElementListener == null) {
            this.gridElementListener = new GridElementListener(this);
        }
        return this.gridElementListener;
    }

    public boolean askSaveIfDirty() {
        if (this.isChanged) {
            int ch = JOptionPane.showOptionDialog(CurrentGui.getInstance().getGui().getMainFrame(), "Save changes?", Program.getInstance().getProgramName() + " - " + this.getName(), 1, 2, null, null, null);
            if (ch == 0) {
                this.doSave();
                return true;
            }
            return ch == 1;
        }
        return true;
    }

    public void setHelpText(String helptext) {
        this.helptext = helptext;
    }

    public String getHelpText() {
        if (this.helptext == null) {
            return Constants.getDefaultHelptext();
        }
        return this.helptext;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public float getZoomFactor() {
        return (float)this.getGridSize() / 10.0f;
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    public int realignToGrid(double val) {
        return this.realignToGrid(true, val, false);
    }

    public int realignToGrid(boolean logRealign, double val) {
        return this.realignToGrid(logRealign, val, false);
    }

    public int realignToGrid(boolean logRealign, double val, boolean roundUp) {
        return SharedUtils.realignTo((boolean)logRealign, (double)val, (boolean)roundUp, (int)this.gridSize);
    }

    public static int realignTo(int val, int toVal) {
        return SharedUtils.realignTo((boolean)false, (double)val, (boolean)false, (int)toVal);
    }

    public static void zoomEntity(int fromFactor, int toFactor, GridElement e) {
        Vector<GridElement> vec = new Vector<GridElement>();
        vec.add(e);
        DiagramHandler.zoomEntities(fromFactor, toFactor, vec);
    }

    public static void zoomEntities(int fromFactor, int toFactor, List<GridElement> selectedEntities) {
        for (GridElement entity : selectedEntities) {
            int newX = entity.getRectangle().x * toFactor / fromFactor;
            int newY = entity.getRectangle().y * toFactor / fromFactor;
            int newW = entity.getRectangle().width * toFactor / fromFactor;
            int newH = entity.getRectangle().height * toFactor / fromFactor;
            entity.setLocation(DiagramHandler.realignTo(newX, toFactor), DiagramHandler.realignTo(newY, toFactor));
            entity.setSize(DiagramHandler.realignTo(newW, toFactor), DiagramHandler.realignTo(newH, toFactor));
            if (!(entity instanceof Relation)) continue;
            for (Point point : ((Relation)entity).getLinePoints()) {
                newX = point.getX() * toFactor / fromFactor;
                newY = point.getY() * toFactor / fromFactor;
                point.setX(DiagramHandler.realignTo(newX, toFactor));
                point.setY(DiagramHandler.realignTo(newY, toFactor));
            }
        }
    }

    public void setGridAndZoom(int factor) {
        this.setGridAndZoom(factor, true);
    }

    public void setGridAndZoom(int factor, boolean manualZoom) {
        int oldGridSize = this.getGridSize();
        if (factor < 1 || factor > 20) {
            return;
        }
        if (factor == oldGridSize) {
            return;
        }
        this.setGridSize(factor);
        DiagramHandler.zoomEntities(oldGridSize, this.gridSize, this.getDrawPanel().getGridElements());
        this.getDrawPanel().zoomOrigin(oldGridSize, this.gridSize);
        if (manualZoom) {
            BaseGUI gui;
            Point mouseLocation = Converter.convert(MouseInfo.getPointerInfo().getLocation());
            Point viewportLocation = Converter.convert(this.getDrawPanel().getScrollPane().getViewport().getLocationOnScreen());
            float x = mouseLocation.x - viewportLocation.x;
            float y = mouseLocation.y - viewportLocation.y;
            x = (float)((double)x + this.getDrawPanel().getScrollPane().getViewport().getViewPosition().getX());
            y = (float)((double)y + this.getDrawPanel().getScrollPane().getViewport().getViewPosition().getY());
            float diffx = x - x * (float)this.gridSize / (float)oldGridSize;
            float diffy = y - y * (float)this.gridSize / (float)oldGridSize;
            log.debug("diffX/diffY: " + diffx + "/" + diffy);
            log.debug("Manual Zoom Delta: " + this.realignToGrid(false, diffx) + "/" + this.realignToGrid(false, diffy));
            this.getDrawPanel().moveOrigin(this.realignToGrid(false, -diffx), this.realignToGrid(false, -diffy));
            for (GridElement e : this.getDrawPanel().getGridElements()) {
                e.setLocationDifference(this.realignToGrid(false, diffx), this.realignToGrid(false, diffy));
            }
            this.getDrawPanel().updatePanelAndScrollbars();
            if (!this.drawpanel.getGridElements().isEmpty()) {
                this.setChanged(true);
            }
            if ((gui = CurrentGui.getInstance().getGui()) != null) {
                gui.setValueOfZoomDisplay(factor);
            }
            float zoomFactor = CurrentDiagram.getInstance().getDiagramHandler().getZoomFactor() * 100.0f;
            String zoomtext = CurrentDiagram.getInstance().getDiagramHandler() instanceof PaletteHandler ? "Palette zoomed to " + Integer.toString((int)zoomFactor) + "%" : "Diagram zoomed to " + Integer.toString((int)zoomFactor) + "%";
            Notifier.getInstance().showInfo(zoomtext);
        }
    }

    private void displayError(String error) {
        JOptionPane.showMessageDialog(CurrentGui.getInstance().getGui().getMainFrame(), error, "ERROR", 0);
    }

    public void setHandlerAndInitListeners(GridElement element) {
        if (HandlerElementMap.getHandlerForElement(element) != null) {
            ((Component)element.getComponent()).removeMouseListener(HandlerElementMap.getHandlerForElement(element).getEntityListener(element));
            ((Component)element.getComponent()).removeMouseMotionListener(HandlerElementMap.getHandlerForElement(element).getEntityListener(element));
        }
        HandlerElementMap.setHandlerForElement(element, this);
        ((Component)element.getComponent()).addMouseListener(HandlerElementMap.getHandlerForElement(element).getEntityListener(element));
        ((Component)element.getComponent()).addMouseMotionListener(HandlerElementMap.getHandlerForElement(element).getEntityListener(element));
        if (element instanceof NewGridElement) {
            ((ComponentSwing)element.getComponent()).setHandler(this);
        }
        element.updateModelFromText();
    }
}

