/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Choice;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

class OptionsFrame
extends Frame
implements WindowListener,
ActionListener,
ItemListener {
    static String[] names = new String[]{"Encoding", "Compression level", "JPEG image quality", "Cursor shape updates", "Use CopyRect", "Restricted colors", "Mouse buttons 2 and 3", "View only", "Scale remote cursor", "Share desktop"};
    static String[][] values = new String[][]{{"Auto", "Raw", "RRE", "CoRRE", "Hextile", "Zlib", "Tight", "ZRLE"}, {"Default", "1", "2", "3", "4", "5", "6", "7", "8", "9"}, {"JPEG off", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"}, {"Enable", "Ignore", "Disable"}, {"Yes", "No"}, {"Yes", "No"}, {"Normal", "Reversed"}, {"Yes", "No"}, {"No", "50%", "75%", "125%", "150%"}, {"Yes", "No"}};
    final int encodingIndex = 0;
    final int compressLevelIndex = 1;
    final int jpegQualityIndex = 2;
    final int cursorUpdatesIndex = 3;
    final int useCopyRectIndex = 4;
    final int eightBitColorsIndex = 5;
    final int mouseButtonIndex = 6;
    final int viewOnlyIndex = 7;
    final int scaleCursorIndex = 8;
    final int shareDesktopIndex = 9;
    Label[] labels = new Label[names.length];
    Choice[] choices = new Choice[names.length];
    Button closeButton;
    VncViewer viewer;
    int preferredEncoding;
    int compressLevel;
    int jpegQuality;
    boolean useCopyRect;
    boolean requestCursorUpdates;
    boolean ignoreCursorUpdates;
    boolean eightBitColors;
    boolean reverseMouseButtons2And3;
    boolean shareDesktop;
    boolean viewOnly;
    int scaleCursor;
    boolean autoScale;
    int scalingFactor;

    OptionsFrame(VncViewer vncViewer) {
        super("TightVNC Options");
        int n;
        this.viewer = vncViewer;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        for (n = 0; n < names.length; ++n) {
            this.labels[n] = new Label(names[n]);
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.labels[n], gridBagConstraints);
            this.add(this.labels[n]);
            this.choices[n] = new Choice();
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(this.choices[n], gridBagConstraints);
            this.add(this.choices[n]);
            this.choices[n].addItemListener(this);
            for (int i = 0; i < values[n].length; ++i) {
                this.choices[n].addItem(values[n][i]);
            }
        }
        this.closeButton = new Button("Close");
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.closeButton, gridBagConstraints);
        this.add(this.closeButton);
        this.closeButton.addActionListener(this);
        this.pack();
        this.addWindowListener(this);
        this.choices[0].select("Auto");
        this.choices[1].select("Default");
        this.choices[2].select("6");
        this.choices[3].select("Enable");
        this.choices[4].select("Yes");
        this.choices[5].select("No");
        this.choices[6].select("Normal");
        this.choices[7].select("No");
        this.choices[8].select("No");
        this.choices[9].select("Yes");
        for (n = 0; n < names.length; ++n) {
            String string = this.viewer.readParameter(names[n], false);
            if (string == null) continue;
            for (int i = 0; i < values[n].length; ++i) {
                if (!string.equalsIgnoreCase(values[n][i])) continue;
                this.choices[n].select(i);
            }
        }
        this.autoScale = false;
        this.scalingFactor = 100;
        String string = this.viewer.readParameter("Scaling Factor", false);
        if (string != null) {
            if (string.equalsIgnoreCase("Auto")) {
                this.autoScale = true;
            } else {
                if (string.charAt(string.length() - 1) == '%') {
                    string = string.substring(0, string.length() - 1);
                }
                try {
                    this.scalingFactor = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.scalingFactor = 100;
                }
                if (this.scalingFactor < 1) {
                    this.scalingFactor = 1;
                } else if (this.scalingFactor > 1000) {
                    this.scalingFactor = 1000;
                }
            }
        }
        this.setEncodings();
        this.setColorFormat();
        this.setOtherOptions();
    }

    void disableShareDesktop() {
        this.labels[9].setEnabled(false);
        this.choices[9].setEnabled(false);
    }

    void setEncodings() {
        this.useCopyRect = this.choices[4].getSelectedItem().equals("Yes");
        this.preferredEncoding = 0;
        boolean bl = false;
        if (this.choices[0].getSelectedItem().equals("RRE")) {
            this.preferredEncoding = 2;
        } else if (this.choices[0].getSelectedItem().equals("CoRRE")) {
            this.preferredEncoding = 4;
        } else if (this.choices[0].getSelectedItem().equals("Hextile")) {
            this.preferredEncoding = 5;
        } else if (this.choices[0].getSelectedItem().equals("ZRLE")) {
            this.preferredEncoding = 16;
        } else if (this.choices[0].getSelectedItem().equals("Zlib")) {
            this.preferredEncoding = 6;
            bl = true;
        } else if (this.choices[0].getSelectedItem().equals("Tight")) {
            this.preferredEncoding = 7;
            bl = true;
        } else if (this.choices[0].getSelectedItem().equals("Auto")) {
            this.preferredEncoding = -1;
        }
        try {
            this.compressLevel = Integer.parseInt(this.choices[1].getSelectedItem());
        }
        catch (NumberFormatException numberFormatException) {
            this.compressLevel = -1;
        }
        if (this.compressLevel < 1 || this.compressLevel > 9) {
            this.compressLevel = -1;
        }
        this.labels[1].setEnabled(bl);
        this.choices[1].setEnabled(bl);
        try {
            this.jpegQuality = Integer.parseInt(this.choices[2].getSelectedItem());
        }
        catch (NumberFormatException numberFormatException) {
            this.jpegQuality = -1;
        }
        if (this.jpegQuality < 0 || this.jpegQuality > 9) {
            this.jpegQuality = -1;
        }
        boolean bl2 = this.requestCursorUpdates = !this.choices[3].getSelectedItem().equals("Disable");
        if (this.requestCursorUpdates) {
            this.ignoreCursorUpdates = this.choices[3].getSelectedItem().equals("Ignore");
        }
        this.viewer.setEncodings();
    }

    void setColorFormat() {
        this.eightBitColors = this.choices[5].getSelectedItem().equals("Yes");
        boolean bl = !this.eightBitColors;
        this.labels[2].setEnabled(bl);
        this.choices[2].setEnabled(bl);
    }

    void setOtherOptions() {
        this.reverseMouseButtons2And3 = this.choices[6].getSelectedItem().equals("Reversed");
        this.viewOnly = this.choices[7].getSelectedItem().equals("Yes");
        if (this.viewer.vc != null) {
            this.viewer.vc.enableInput(!this.viewOnly);
        }
        this.shareDesktop = this.choices[9].getSelectedItem().equals("Yes");
        String string = this.choices[8].getSelectedItem();
        if (string.endsWith("%")) {
            string = string.substring(0, string.length() - 1);
        }
        try {
            this.scaleCursor = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.scaleCursor = 0;
        }
        if (this.scaleCursor < 10 || this.scaleCursor > 500) {
            this.scaleCursor = 0;
        }
        if (this.requestCursorUpdates && !this.ignoreCursorUpdates && !this.viewOnly) {
            this.labels[8].setEnabled(true);
            this.choices[8].setEnabled(true);
        } else {
            this.labels[8].setEnabled(false);
            this.choices[8].setEnabled(false);
        }
        if (this.viewer.vc != null) {
            this.viewer.vc.createSoftCursor();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.choices[0] || object == this.choices[1] || object == this.choices[2] || object == this.choices[3] || object == this.choices[4]) {
            this.setEncodings();
            if (object == this.choices[3]) {
                this.setOtherOptions();
            }
        } else if (object == this.choices[5]) {
            this.setColorFormat();
        } else if (object == this.choices[6] || object == this.choices[9] || object == this.choices[7] || object == this.choices[8]) {
            this.setOtherOptions();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.closeButton) {
            this.setVisible(false);
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }
}

