/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToggleButton;

public class ZapToggleButton
extends JToggleButton {
    private static final long serialVersionUID = 1L;
    private String defaultToolTipText;
    private String selectedToolTipText;
    private String disabledToolTipText;
    private String disabledSelectedToolTipText;
    private ToolTipTextUpdaterOnSelectionStateChange toolTipTextUpdaterOnSelectionStateChange;

    public ZapToggleButton() {
        super(null, null, false);
    }

    public ZapToggleButton(Icon icon) {
        super(null, icon, false);
    }

    public ZapToggleButton(Icon icon, boolean bl) {
        super(null, icon, bl);
    }

    public ZapToggleButton(String string) {
        super(string, null, false);
    }

    public ZapToggleButton(String string, boolean bl) {
        super(string, null, bl);
    }

    public ZapToggleButton(Action action) {
        super(action);
    }

    public ZapToggleButton(String string, Icon icon) {
        super(string, icon, false);
    }

    public ZapToggleButton(String string, Icon icon, boolean bl) {
        super(string, icon, bl);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.updateCurrentToolTipText();
    }

    private void updateCurrentToolTipText() {
        boolean bl = !this.isEnabled();
        boolean bl2 = this.isSelected();
        String string = bl && bl2 && this.disabledSelectedToolTipText != null ? this.disabledSelectedToolTipText : (bl && this.disabledToolTipText != null ? this.disabledToolTipText : (bl2 && this.selectedToolTipText != null ? this.selectedToolTipText : this.defaultToolTipText));
        super.setToolTipText(string);
    }

    @Override
    public void setToolTipText(String string) {
        this.defaultToolTipText = string;
        this.updateCurrentToolTipText();
    }

    @Override
    public String getToolTipText() {
        return super.getToolTipText();
    }

    public String getDefaultToolTipText() {
        return this.defaultToolTipText;
    }

    public void setSelectedToolTipText(String string) {
        this.selectedToolTipText = string;
        this.addRemoveToolTipTextUpdaterOnSelectionStateChangeAsNeeded();
        this.updateCurrentToolTipText();
    }

    private void addRemoveToolTipTextUpdaterOnSelectionStateChangeAsNeeded() {
        if (this.selectedToolTipText == null && this.disabledSelectedToolTipText == null) {
            if (this.toolTipTextUpdaterOnSelectionStateChange != null) {
                this.removeItemListener(this.toolTipTextUpdaterOnSelectionStateChange);
                this.toolTipTextUpdaterOnSelectionStateChange = null;
            }
        } else if (this.toolTipTextUpdaterOnSelectionStateChange == null) {
            this.toolTipTextUpdaterOnSelectionStateChange = new ToolTipTextUpdaterOnSelectionStateChange();
            this.addItemListener(this.toolTipTextUpdaterOnSelectionStateChange);
        }
    }

    public String getSelectedToolTipText() {
        return this.selectedToolTipText;
    }

    public void setDisabledToolTipText(String string) {
        this.disabledToolTipText = string;
        this.updateCurrentToolTipText();
    }

    public String getDisabledToolTipText() {
        return this.disabledToolTipText;
    }

    public void setDisabledSelectedToolTipText(String string) {
        this.disabledSelectedToolTipText = string;
        this.addRemoveToolTipTextUpdaterOnSelectionStateChangeAsNeeded();
        this.updateCurrentToolTipText();
    }

    public String getDisabledSelectedToolTipText() {
        return this.disabledSelectedToolTipText;
    }

    private class ToolTipTextUpdaterOnSelectionStateChange
    implements ItemListener {
        private ToolTipTextUpdaterOnSelectionStateChange() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (701 == itemEvent.getID()) {
                ZapToggleButton.this.updateCurrentToolTipText();
            }
        }
    }
}

