/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Action;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.remote.Address;
import org.gradle.internal.remote.ConnectionAcceptor;
import org.gradle.internal.remote.MessagingServer;
import org.gradle.internal.remote.ObjectConnection;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.JavaExecHandleFactory;
import org.gradle.process.internal.health.memory.JvmMemoryStatus;
import org.gradle.process.internal.health.memory.MemoryAmount;
import org.gradle.process.internal.health.memory.MemoryManager;
import org.gradle.process.internal.worker.DefaultWorkerLoggingProtocol;
import org.gradle.process.internal.worker.DefaultWorkerProcess;
import org.gradle.process.internal.worker.WorkerJvmMemoryInfoSerializer;
import org.gradle.process.internal.worker.WorkerLoggingSerializer;
import org.gradle.process.internal.worker.WorkerProcess;
import org.gradle.process.internal.worker.WorkerProcessBuilder;
import org.gradle.process.internal.worker.WorkerProcessContext;
import org.gradle.process.internal.worker.child.ApplicationClassesInSystemClassLoaderWorkerFactory;
import org.gradle.process.internal.worker.child.WorkerJvmMemoryInfoProtocol;
import org.gradle.process.internal.worker.child.WorkerLoggingProtocol;
import org.gradle.util.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWorkerProcessBuilder
implements WorkerProcessBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultWorkerProcessBuilder.class);
    private final MessagingServer server;
    private final IdGenerator<?> idGenerator;
    private final ApplicationClassesInSystemClassLoaderWorkerFactory workerFactory;
    private final OutputEventListener outputEventListener;
    private final JavaExecHandleBuilder javaCommand;
    private final Set<String> packages = new HashSet<String>();
    private final Set<File> applicationClasspath = new LinkedHashSet<File>();
    private final MemoryManager memoryManager;
    private Action<? super WorkerProcessContext> action;
    private LogLevel logLevel = LogLevel.LIFECYCLE;
    private String baseName = "Gradle Worker";
    private File gradleUserHomeDir;
    private int connectTimeoutSeconds;
    private List<URL> implementationClassPath;
    private boolean shouldPublishJvmMemoryInfo;

    DefaultWorkerProcessBuilder(JavaExecHandleFactory execHandleFactory, MessagingServer server, IdGenerator<?> idGenerator, ApplicationClassesInSystemClassLoaderWorkerFactory workerFactory, OutputEventListener outputEventListener, MemoryManager memoryManager) {
        this.javaCommand = execHandleFactory.newJavaExec();
        this.server = server;
        this.idGenerator = idGenerator;
        this.workerFactory = workerFactory;
        this.outputEventListener = outputEventListener;
        this.memoryManager = memoryManager;
    }

    public int getConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds;
    }

    public void setConnectTimeoutSeconds(int connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
    }

    @Override
    public WorkerProcessBuilder setBaseName(String baseName) {
        this.baseName = baseName;
        return this;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    public WorkerProcessBuilder applicationClasspath(Iterable<File> files) {
        GUtil.addToCollection(this.applicationClasspath, (Iterable[])new Iterable[]{files});
        return this;
    }

    @Override
    public Set<File> getApplicationClasspath() {
        return this.applicationClasspath;
    }

    @Override
    public WorkerProcessBuilder sharedPackages(String ... packages) {
        this.sharedPackages(Arrays.asList(packages));
        return this;
    }

    @Override
    public WorkerProcessBuilder sharedPackages(Iterable<String> packages) {
        GUtil.addToCollection(this.packages, (Iterable[])new Iterable[]{packages});
        return this;
    }

    @Override
    public Set<String> getSharedPackages() {
        return this.packages;
    }

    public WorkerProcessBuilder worker(Action<? super WorkerProcessContext> action) {
        this.action = action;
        return this;
    }

    @Override
    public Action<? super WorkerProcessContext> getWorker() {
        return this.action;
    }

    @Override
    public JavaExecHandleBuilder getJavaCommand() {
        return this.javaCommand;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public WorkerProcessBuilder setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public File getGradleUserHomeDir() {
        return this.gradleUserHomeDir;
    }

    public void setGradleUserHomeDir(File gradleUserHomeDir) {
        this.gradleUserHomeDir = gradleUserHomeDir;
    }

    @Override
    public void setImplementationClasspath(List<URL> implementationClassPath) {
        this.implementationClassPath = implementationClassPath;
    }

    public List<URL> getImplementationClassPath() {
        return this.implementationClassPath;
    }

    @Override
    public void enableJvmMemoryInfoPublishing(boolean shouldPublish) {
        this.shouldPublishJvmMemoryInfo = shouldPublish;
    }

    @Override
    public WorkerProcess build() {
        final WorkerJvmMemoryStatus memoryStatus = this.shouldPublishJvmMemoryInfo ? new WorkerJvmMemoryStatus() : null;
        final DefaultWorkerProcess workerProcess = new DefaultWorkerProcess(this.connectTimeoutSeconds, TimeUnit.SECONDS, memoryStatus);
        ConnectionAcceptor acceptor = this.server.accept((Action)new Action<ObjectConnection>(){

            public void execute(final ObjectConnection connection) {
                workerProcess.onConnect(connection, new Runnable(){

                    public void run() {
                        DefaultWorkerLoggingProtocol defaultWorkerLoggingProtocol = new DefaultWorkerLoggingProtocol(DefaultWorkerProcessBuilder.this.outputEventListener);
                        connection.useParameterSerializers(WorkerLoggingSerializer.create());
                        connection.addIncoming(WorkerLoggingProtocol.class, (Object)defaultWorkerLoggingProtocol);
                        if (DefaultWorkerProcessBuilder.this.shouldPublishJvmMemoryInfo) {
                            connection.useParameterSerializers(WorkerJvmMemoryInfoSerializer.create());
                            connection.addIncoming(WorkerJvmMemoryInfoProtocol.class, (Object)memoryStatus);
                        }
                    }
                });
            }
        });
        workerProcess.startAccepting(acceptor);
        Address localAddress = acceptor.getAddress();
        Object id = this.idGenerator.generateId();
        String displayName = this.getBaseName() + " " + id;
        LOGGER.debug("Creating {}", (Object)displayName);
        LOGGER.debug("Using application classpath {}", this.applicationClasspath);
        LOGGER.debug("Using implementation classpath {}", this.implementationClassPath);
        JavaExecHandleBuilder javaCommand = this.getJavaCommand();
        javaCommand.setDisplayName(displayName);
        this.workerFactory.prepareJavaCommand(id, displayName, this, this.implementationClassPath, localAddress, javaCommand, this.shouldPublishJvmMemoryInfo);
        javaCommand.args("'" + displayName + "'");
        ExecHandle execHandle = javaCommand.build();
        workerProcess.setExecHandle(execHandle);
        return new MemoryRequestingWorkerProcess(workerProcess, this.memoryManager, MemoryAmount.parseNotation((String)javaCommand.getMinHeapSize()));
    }

    private static class WorkerJvmMemoryStatus
    implements JvmMemoryStatus,
    WorkerJvmMemoryInfoProtocol {
        private JvmMemoryStatus snapshot = new JvmMemoryStatus(){

            public long getMaxMemory() {
                throw new IllegalStateException("JVM memory status has not been reported yet.");
            }

            public long getCommittedMemory() {
                throw new IllegalStateException("JVM memory status has not been reported yet.");
            }
        };

        public void sendJvmMemoryStatus(JvmMemoryStatus jvmMemoryStatus) {
            this.snapshot = jvmMemoryStatus;
        }

        public long getMaxMemory() {
            return this.snapshot.getMaxMemory();
        }

        public long getCommittedMemory() {
            return this.snapshot.getCommittedMemory();
        }
    }

    private static class MemoryRequestingWorkerProcess
    implements WorkerProcess {
        private final WorkerProcess delegate;
        private final MemoryManager memoryResourceManager;
        private final long memoryAmount;

        private MemoryRequestingWorkerProcess(WorkerProcess delegate, MemoryManager memoryResourceManager, long memoryAmount) {
            this.delegate = delegate;
            this.memoryResourceManager = memoryResourceManager;
            this.memoryAmount = memoryAmount;
        }

        public WorkerProcess start() {
            this.memoryResourceManager.requestFreeMemory(this.memoryAmount);
            return this.delegate.start();
        }

        public ObjectConnection getConnection() {
            return this.delegate.getConnection();
        }

        public ExecResult waitForStop() {
            return this.delegate.waitForStop();
        }

        public JvmMemoryStatus getJvmMemoryStatus() {
            return this.delegate.getJvmMemoryStatus();
        }
    }
}

