/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.internal.artifacts.DefaultResolvedArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactBackedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusion;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Factory;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.component.model.VariantMetadata;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.progress.BuildOperationDetails;
import org.gradle.internal.progress.BuildOperationExecutor;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.result.DefaultBuildableArtifactResolveResult;

public class DefaultArtifactSet
implements ArtifactSet {
    private final ComponentIdentifier componentIdentifier;
    private final ModuleVersionIdentifier moduleVersionIdentifier;
    private final ModuleSource moduleSource;
    private final ModuleExclusion exclusions;
    private final Set<? extends VariantMetadata> variants;
    private final ArtifactResolver artifactResolver;
    private final Map<ComponentArtifactIdentifier, ResolvedArtifact> allResolvedArtifacts;
    private final long id;
    private final ImmutableAttributesFactory attributesFactory;
    private final BuildOperationExecutor buildOperationExecutor;

    public DefaultArtifactSet(ComponentIdentifier componentIdentifier, ModuleVersionIdentifier ownerId, ModuleSource moduleSource, ModuleExclusion exclusions, Set<? extends VariantMetadata> variants, ArtifactResolver artifactResolver, Map<ComponentArtifactIdentifier, ResolvedArtifact> allResolvedArtifacts, long id, ImmutableAttributesFactory attributesFactory, BuildOperationExecutor buildOperationExecutor) {
        this.componentIdentifier = componentIdentifier;
        this.moduleVersionIdentifier = ownerId;
        this.moduleSource = moduleSource;
        this.exclusions = exclusions;
        this.variants = variants;
        this.artifactResolver = artifactResolver;
        this.allResolvedArtifacts = allResolvedArtifacts;
        this.id = id;
        this.attributesFactory = attributesFactory;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public ResolvedArtifactSet select(Spec<? super ComponentIdentifier> componentFilter, Transformer<ResolvedArtifactSet, Collection<? extends ResolvedVariant>> selector) {
        return this.snapshot().select(componentFilter, selector);
    }

    @Override
    public ArtifactSet snapshot() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (VariantMetadata variantMetadata : this.variants) {
            Set<? extends ComponentArtifactMetadata> artifacts = variantMetadata.getArtifacts();
            LinkedHashSet<ResolvedArtifact> resolvedArtifacts = new LinkedHashSet<ResolvedArtifact>(artifacts.size());
            AttributeContainerInternal attributes = variantMetadata.getAttributes();
            if (!attributes.contains(ArtifactAttributes.ARTIFACT_FORMAT)) {
                String format = null;
                for (ComponentArtifactMetadata componentArtifactMetadata : artifacts) {
                    String candidateFormat = componentArtifactMetadata.getName().getType();
                    if (format == null) {
                        format = candidateFormat;
                        continue;
                    }
                    if (format.equals(candidateFormat)) continue;
                    format = null;
                    break;
                }
                if (format != null) {
                    attributes = this.attributesFactory.concat(attributes.asImmutable(), ArtifactAttributes.ARTIFACT_FORMAT, format);
                }
            }
            for (ComponentArtifactMetadata componentArtifactMetadata : artifacts) {
                IvyArtifactName ivyArtifactName = componentArtifactMetadata.getName();
                if (this.exclusions.excludeArtifact(this.moduleVersionIdentifier.getModule(), ivyArtifactName)) continue;
                ResolvedArtifact resolvedArtifact = this.allResolvedArtifacts.get(componentArtifactMetadata.getId());
                if (resolvedArtifact == null) {
                    BuildOperationArtifactSource artifactSource = new BuildOperationArtifactSource(this.buildOperationExecutor, componentArtifactMetadata.getId(), new LazyArtifactSource(componentArtifactMetadata, this.moduleSource, this.artifactResolver));
                    resolvedArtifact = new DefaultResolvedArtifact(this.moduleVersionIdentifier, ivyArtifactName, componentArtifactMetadata.getId(), componentArtifactMetadata.getBuildDependencies(), artifactSource);
                    this.allResolvedArtifacts.put(componentArtifactMetadata.getId(), resolvedArtifact);
                }
                resolvedArtifacts.add(resolvedArtifact);
            }
            result.add((Object)new DefaultResolvedVariant(attributes, ArtifactBackedArtifactSet.forVariant((AttributeContainer)attributes, resolvedArtifacts)));
        }
        return new ArtifactSetSnapshot(this.id, this.componentIdentifier, (Set<ResolvedVariant>)result.build());
    }

    private static class DefaultResolvedVariant
    implements ResolvedVariant {
        private final AttributeContainerInternal attributes;
        private final ResolvedArtifactSet artifactSet;

        DefaultResolvedVariant(AttributeContainerInternal attributes, ResolvedArtifactSet artifactSet) {
            this.attributes = attributes;
            this.artifactSet = artifactSet;
        }

        @Override
        public AttributeContainerInternal getAttributes() {
            return this.attributes;
        }

        @Override
        public ResolvedArtifactSet getArtifacts() {
            return this.artifactSet;
        }
    }

    private static class BuildOperationArtifactSource
    implements Factory<File> {
        private final BuildOperationExecutor buildOperationExecutor;
        private final ComponentArtifactIdentifier artifactId;
        private final Factory<File> delegate;

        BuildOperationArtifactSource(BuildOperationExecutor buildOperationExecutor, ComponentArtifactIdentifier artifactId, Factory<File> delegate) {
            this.buildOperationExecutor = buildOperationExecutor;
            this.artifactId = artifactId;
            this.delegate = delegate;
        }

        public File create() {
            String displayName = this.artifactId.getDisplayName();
            BuildOperationDetails operationDetails = BuildOperationDetails.displayName((String)("Resolve artifact " + displayName)).operationDescriptor((Object)this.artifactId).build();
            return (File)this.buildOperationExecutor.run(operationDetails, (Transformer)new Transformer<File, BuildOperationContext>(){

                public File transform(BuildOperationContext context) {
                    return (File)BuildOperationArtifactSource.this.delegate.create();
                }
            });
        }
    }

    private static class LazyArtifactSource
    implements Factory<File> {
        private final ArtifactResolver artifactResolver;
        private final ModuleSource moduleSource;
        private final ComponentArtifactMetadata artifact;

        private LazyArtifactSource(ComponentArtifactMetadata artifact, ModuleSource moduleSource, ArtifactResolver artifactResolver) {
            this.artifact = artifact;
            this.artifactResolver = artifactResolver;
            this.moduleSource = moduleSource;
        }

        public File create() {
            DefaultBuildableArtifactResolveResult result = new DefaultBuildableArtifactResolveResult();
            this.artifactResolver.resolveArtifact(this.artifact, this.moduleSource, result);
            return (File)result.getResult();
        }
    }

    private static class ArtifactSetSnapshot
    implements ArtifactSet {
        private final long id;
        private final ComponentIdentifier componentIdentifier;
        private final Set<ResolvedVariant> variants;

        ArtifactSetSnapshot(long id, ComponentIdentifier componentIdentifier, Set<ResolvedVariant> variants) {
            this.id = id;
            this.componentIdentifier = componentIdentifier;
            this.variants = variants;
        }

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        public ArtifactSet snapshot() {
            return this;
        }

        @Override
        public ResolvedArtifactSet select(Spec<? super ComponentIdentifier> componentFilter, Transformer<ResolvedArtifactSet, Collection<? extends ResolvedVariant>> selector) {
            if (!componentFilter.isSatisfiedBy((Object)this.componentIdentifier)) {
                return ResolvedArtifactSet.EMPTY;
            }
            return (ResolvedArtifactSet)selector.transform(this.variants);
        }
    }
}

