#ifndef _EFL_CONFIG_EO_H_
#define _EFL_CONFIG_EO_H_

#ifndef _EFL_CONFIG_EO_CLASS_TYPE
#define _EFL_CONFIG_EO_CLASS_TYPE

typedef Eo Efl_Config;

#endif

#ifndef _EFL_CONFIG_EO_TYPES
#define _EFL_CONFIG_EO_TYPES


#endif
/** A generic configuration interface, that holds key-value pairs.
 *
 * @ingroup Efl_Config
 */
#define EFL_CONFIG_INTERFACE efl_config_interface_get()

EWAPI const Eo_Class *efl_config_interface_get(void);

EOAPI Eina_Bool efl_config_set(Eo *obj, const char *name, const Eina_Value *val);

EOAPI Eina_Value *efl_config_get(const Eo *obj, const char *name);

/**
 * @brief Returns a list of generic values under a given key.
 *
 * @param[in] name
 *
 * @ingroup Efl_Config
 */
EOAPI Eina_Iterator *efl_config_list_get(const Eo *obj, const char *name);


#endif
