/*
 * Decompiled with CFR 0.152.
 */
package gps.log.out;

import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Path;
import bt747.sys.interfaces.BT747Time;
import gps.log.GPSRecord;
import gps.log.out.CommonOut;
import gps.log.out.GPSFile;
import gps.log.out.WayPointStyle;
import gps.log.out.WayPointStyleSet;

public class GPSKMLFile
extends GPSFile {
    private final StringBuffer rec = new StringBuffer(1024);
    public static final String ABSOLUTE_HEIGHT = "absolute";
    public static final String RELATIVE_HEIGHT = "relativeToGround";
    public static final String CLAMPED_HEIGHT = "clampToGround";
    private boolean isWayType;
    private boolean isTrackType;
    private boolean isPathType;
    private int currentFilter;
    private String trackName;
    private int altitudeMode = 0;
    private String altitudeModeIfHeight = "absolute";
    private int fileStartTime;
    private int lastTime;
    private int posDigits;
    private int heightDigits;
    private boolean trackStarted = false;
    private boolean isLineString = false;
    private boolean isDateFolder;
    private String currentWayFolderDate = "";

    public GPSKMLFile() {
        this.numberOfPasses = 3;
        this.fileStartTime = 0;
        this.lastTime = 0;
    }

    public void initialiseFile(BT747Path object, String string, int n) {
        super.initialiseFile((BT747Path)object, string, n);
        this.currentFilter = 1;
        this.isWayType = true;
        this.isTrackType = false;
        this.isPathType = false;
        object = this.getParamObject().getStringParam("kml-track-altitude");
        if (object != null) {
            this.altitudeModeIfHeight = object;
        }
        this.posDigits = this.getParamObject().hasParam("pos-digits") ? this.getParamObject().getIntParam("pos-digits") : 6;
        if (this.getParamObject().hasParam("height-digits")) {
            this.heightDigits = this.getParamObject().getIntParam("height-digits");
            return;
        }
        this.heightDigits = 3;
    }

    public final boolean nextPass() {
        super.nextPass();
        if (this.nbrOfPassesToGo > 0) {
            --this.nbrOfPassesToGo;
            this.previousDate = 0;
            if (this.isWayType) {
                this.isWayType = false;
                this.isPathType = true;
                this.currentFilter = 0;
            } else if (this.isPathType) {
                this.isTrackType = true;
                this.isPathType = false;
                this.currentFilter = 0;
            } else if (this.isTrackType) {
                this.isTrackType = false;
                this.currentFilter = 0;
            }
            return true;
        }
        return false;
    }

    private final void addLookAt(StringBuffer stringBuffer, int n, int n2) {
        BT747Time bT747Time = JavaLibBridge.getTimeInstance();
        stringBuffer.append("<LookAt>\r\n");
        stringBuffer.append(" <gx:TimeSpan>\r\n");
        stringBuffer.append("  <begin>");
        bT747Time.setUTCTime(n);
        stringBuffer.append(CommonOut.getDateTimeISO8601(bT747Time, -1));
        stringBuffer.append("</begin>\r\n");
        stringBuffer.append("  <end>");
        bT747Time.setUTCTime(n2);
        stringBuffer.append(CommonOut.getDateTimeISO8601(bT747Time, -1));
        stringBuffer.append("</end>\r\n");
        stringBuffer.append(" </gx:TimeSpan>\r\n");
        stringBuffer.append("</LookAt>\r\n");
    }

    public final void writeFileHeader(String object) {
        WayPointStyle wayPointStyle;
        StringBuffer stringBuffer = new StringBuffer(2048);
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<kml xmlns=\"http://www.opengis.net/kml/2.2\" xmlns:gx=\"http://www.google.com/kml/ext/2.2\" xmlns:kml=\"http://www.opengis.net/kml/2.2\" xmlns:atom=\"http://www.w3.org/2005/Atom\"><Document xmlns:atom=\"http://www.w3.org/2005/Atom\" >\r\n<atom:generator uri=\"http://sf.net/projects/bt747\" version=\"2.1.3\">BT747</atom:generator>\r\n<name>" + (String)object + "</name>\r\n  <open>1</open>\r\n");
        object = CommonOut.getWayPointStyles().iterator();
        while (((WayPointStyleSet)object).hasNext()) {
            wayPointStyle = ((WayPointStyleSet)object).next();
            for (int i = 0; i < 2; ++i) {
                stringBuffer.append("  <Style id=\"Style" + wayPointStyle.getKey() + i + "\">\r\n    <IconStyle>\r\n      <Icon>\r\n        <href>" + wayPointStyle.getIconUrl() + "</href>\r\n      </Icon>\r\n    </IconStyle>\r\n    <LabelStyle>\r\n" + "      <scale>" + i + "</scale>\r\n    </LabelStyle>\r\n  </Style>\r\n");
            }
        }
        object = CommonOut.getWayPointStyles().iterator();
        while (((WayPointStyleSet)object).hasNext()) {
            wayPointStyle = ((WayPointStyleSet)object).next();
            String string = "";
            if (wayPointStyle.getKey().length() > 1) {
                string = "X";
            }
            stringBuffer.append("  <StyleMap id=\"Style" + string + wayPointStyle.getKey() + "\">\r\n    <Pair>\r\n      <key>normal</key>\r\n      <styleUrl>#Style" + wayPointStyle.getKey() + "0</styleUrl>\r\n    </Pair>\r\n    <Pair>\r\n      <key>highlight</key>\r\n" + "      <styleUrl>#Style" + wayPointStyle.getKey() + "1</styleUrl>\r\n    </Pair>\r\n  </StyleMap>\r\n");
        }
        this.writeTxt(stringBuffer.toString());
        stringBuffer.setLength(0);
    }

    protected final void writeDataHeader() {
        String string;
        if (this.isWayType) {
            string = "  <Folder>\r\n    <name>My Waypoints</name>\r\n  <open>0</open>\r\n";
            this.isDateFolder = false;
        } else {
            string = this.isTrackType ? "  <Folder>\r\n    <name>My Trackpoints</name>\r\n    <Folder>\r\n    <name>Trackpoints" + this.trackName + "</name>\r\n      <open>0</open>\r\n\r\n" : "  <Folder>\r\n  <name>My Tracks</name>\r\n  <open>0</open>\r\n    <name>Track" + this.trackName + "</name>\r\n";
        }
        this.writeTxt(string);
    }

    private final void startTrack(String string) {
        String string2 = this.goodTrackColor.length() == 6 ? this.goodTrackColor.substring(4) + this.goodTrackColor.substring(2, 4) + this.goodTrackColor.substring(0, 2) : "FFFFFF";
        string = "<Placemark><name>" + JavaLibBridge.convertHTMLtoUTF8(string) + "</name>\r\n    <Style>\r\n      <LineStyle>\r\n" + "        <color>ff" + string2 + "</color>\r\n        <width>3.0</width>\r\n      </LineStyle>\r\n    </Style>\r\n";
        this.writeTxt(string);
        this.trackStarted = true;
    }

    private final void endTrack() {
        if (this.isLineString) {
            this.writeTxt("      </coordinates>\r\n     </LineString>\r\n");
            this.isLineString = false;
        }
        if (this.trackStarted) {
            this.writeTxt("    </Placemark>\r\n");
            this.trackStarted = false;
        }
    }

    protected final void writeDataFooter() {
        String string = "";
        if (this.isDateFolder) {
            string = "   </Folder>\r\n";
            this.isDateFolder = false;
        }
        if (this.isWayType) {
            string = string + "  </Folder>\r\n\r\n";
        } else if (this.isTrackType) {
            string = string + "    </Folder>\r\n  </Folder>\r\n\r\n";
        } else {
            this.endTrack();
            string = string + "  </Folder>\r\n";
        }
        this.writeTxt(string);
    }

    public final void writeRecord(GPSRecord gPSRecord) {
        super.writeRecord(gPSRecord);
        this.rec.setLength(0);
        if (this.ptFilters[this.currentFilter].doFilter(gPSRecord)) {
            String string = "";
            if (gPSRecord.hasUtc()) {
                string = this.t.getYear() + "-" + (this.t.getMonth() < 10 ? "0" : "") + this.t.getMonth() + "-" + (this.t.getDay() < 10 ? "0" : "") + this.t.getDay();
                if (gPSRecord.getUtc() > this.lastTime) {
                    this.lastTime = gPSRecord.getUtc();
                    if (this.fileStartTime == 0) {
                        this.fileStartTime = this.lastTime;
                    }
                }
            }
            if (this.isWayType || this.isTrackType && (this.isIncludeTrkName || this.isTrkComment)) {
                if (this.isDateFolder && !string.equals(this.currentWayFolderDate)) {
                    this.rec.append("</Folder>");
                    this.isDateFolder = false;
                }
                if (!this.isDateFolder) {
                    this.rec.append("<Folder><name>");
                    this.currentWayFolderDate = string;
                    this.rec.append(string);
                    this.rec.append("</name>\r\n");
                    this.isDateFolder = true;
                }
                this.rec.append("<Placemark>\r\n");
                if (!this.isTrackType || this.isIncludeTrkName) {
                    this.rec.append("<name>");
                    if (gPSRecord.hasUtc() && this.selectedFileFields.hasUtc()) {
                        this.rec.append("TIME: " + (this.t.getHour() < 10 ? "0" : "") + this.t.getHour() + ":" + (this.t.getMinute() < 10 ? "0" : "") + this.t.getMinute() + ":" + (this.t.getSecond() < 10 ? "0" : "") + this.t.getSecond());
                    } else if (gPSRecord.hasRecCount()) {
                        this.rec.append("IDX: ");
                        this.rec.append(gPSRecord.getRecCount());
                    }
                    this.rec.append("</name>\r\n");
                }
                if (this.isTrackType) {
                    this.rec.append("<visibility>0</visibility>\r\n");
                }
                if (this.isTrackType && this.isTrkComment || this.isWayType && this.isWayComment) {
                    this.rec.append("<description>");
                    this.rec.append("<![CDATA[");
                    CommonOut.getHtml(this.rec, gPSRecord, this.selectedFileFields, this.t, this.recordNbrInLogs, this.imperial, true);
                    this.rec.append("]]>");
                    this.rec.append("</description>");
                }
                if (gPSRecord.hasUtc() && this.selectedFileFields.hasUtc()) {
                    this.rec.append("<TimeStamp><when>");
                    this.rec.append(CommonOut.getDateTimeISO8601(this.t, gPSRecord.hasMillisecond() ? gPSRecord.getMilisecond() : -1));
                    this.rec.append("</when></TimeStamp>\r\n");
                }
                if (gPSRecord.hasRcr()) {
                    this.rec.append("<styleUrl>");
                    string = CommonOut.getRCRstr(gPSRecord);
                    if (string.length() > 1 && (gPSRecord.rcr & 0xFFF0) == 0) {
                        string = "M";
                    }
                    this.rec.append("#Style");
                    this.rec.append(string);
                    this.rec.append("</styleUrl>\r\n");
                }
                if (gPSRecord.hasPosition() && this.selectedFileFields.hasPosition()) {
                    this.rec.append("<Point>\r\n");
                    this.rec.append("<coordinates>");
                    this.rec.append(JavaLibBridge.toString(gPSRecord.getLongitude(), this.posDigits));
                    this.rec.append(",");
                    this.rec.append(JavaLibBridge.toString(gPSRecord.getLatitude(), this.posDigits));
                    if (gPSRecord.hasHeight() && this.selectedFileFields.hasHeight()) {
                        this.rec.append(",");
                        this.rec.append(JavaLibBridge.toString(gPSRecord.getHeight(), this.heightDigits));
                    }
                    this.rec.append("</coordinates>");
                    this.rec.append("</Point>\r\n");
                }
                this.rec.append("</Placemark>\r\n");
                this.writeTxt(this.rec.toString());
                this.rec.setLength(0);
                return;
            }
            if (this.isPathType) {
                this.rec.setLength(0);
                if (gPSRecord.hasPosition() && this.selectedFileFields.hasPosition()) {
                    boolean bl = false;
                    if (this.needsToSplitTrack) {
                        this.endTrack();
                    }
                    if (!this.trackStarted) {
                        String string2 = "";
                        if (gPSRecord.hasUtc()) {
                            string2 = CommonOut.getDateTimeStr(gPSRecord.getUtc());
                        }
                        this.startTrack(string2);
                    }
                    if ((gPSRecord.hasHeight() && this.selectedFileFields.hasHeight()) != (this.altitudeMode == 0)) {
                        bl = true;
                    }
                    if (this.isLineString && bl) {
                        this.rec.append("</coordinates>");
                        this.rec.append("</LineString>");
                        this.isLineString = false;
                    }
                    if (!this.isLineString) {
                        this.isLineString = true;
                        this.rec.append("<LineString>\r\n    <extrude>1</extrude>\r\n    <tessellate>1</tessellate>\r\n    <altitudeMode>");
                        if (gPSRecord.hasHeight() && this.selectedFileFields.hasHeight()) {
                            this.altitudeMode = 0;
                            this.rec.append(this.altitudeModeIfHeight);
                        } else {
                            this.rec.append(CLAMPED_HEIGHT);
                            this.altitudeMode = 1;
                        }
                        this.rec.append("</altitudeMode><coordinates>\r\n");
                    }
                    this.rec.append("        ");
                    this.rec.append(JavaLibBridge.toString(gPSRecord.getLongitude(), this.posDigits));
                    this.rec.append(",");
                    this.rec.append(JavaLibBridge.toString(gPSRecord.getLatitude(), this.posDigits));
                    if (gPSRecord.hasHeight() && this.selectedFileFields.hasHeight()) {
                        this.rec.append(",");
                        this.rec.append(JavaLibBridge.toString(gPSRecord.getHeight(), this.heightDigits));
                    }
                    this.rec.append("\r\n");
                    this.writeTxt(this.rec.toString());
                    this.rec.setLength(0);
                }
            }
        }
    }

    protected int createFile(int n, String string, boolean bl) {
        this.trackName = string;
        return super.createFile(n, string, bl);
    }

    public void setTrackName(String string) {
        this.trackName = string;
    }

    public void finaliseFile() {
        if (this.isOpen()) {
            this.writeDataFooter();
            this.rec.setLength(0);
            this.rec.append("</Document>\r\n</kml>");
            this.writeTxt(this.rec.toString());
        }
        super.finaliseFile();
    }
}

