/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.facade;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputBinaryFile;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputFile;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputFileCollection;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.facade.SourceMapBuilderConsumer;
import org.jetbrains.kotlin.js.sourceMap.JsSourceGenerationVisitor;
import org.jetbrains.kotlin.js.sourceMap.SourceMap3Builder;
import org.jetbrains.kotlin.js.sourceMap.SourceMapBuilder;
import org.jetbrains.kotlin.js.util.TextOutput;
import org.jetbrains.kotlin.js.util.TextOutputImpl;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.serialization.js.JsModuleDescriptor;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/js/facade/TranslationResult;", "", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "(Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;)V", "getDiagnostics", "()Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "Fail", "Success", "kotlin-compiler"})
public abstract class TranslationResult {
    @NotNull
    private final Diagnostics diagnostics;

    @NotNull
    public final Diagnostics getDiagnostics() {
        return this.diagnostics;
    }

    protected TranslationResult(@NotNull Diagnostics diagnostics) {
        Intrinsics.checkParameterIsNotNull(diagnostics, "diagnostics");
        this.diagnostics = diagnostics;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/js/facade/TranslationResult$Fail;", "Lorg/jetbrains/kotlin/js/facade/TranslationResult;", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "(Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;)V", "kotlin-compiler"})
    public static final class Fail
    extends TranslationResult {
        public Fail(@NotNull Diagnostics diagnostics) {
            Intrinsics.checkParameterIsNotNull(diagnostics, "diagnostics");
            super(diagnostics);
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0014\u001a\u00020\fH\u0007J\u001a\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\"\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001cR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/js/facade/TranslationResult$Success;", "Lorg/jetbrains/kotlin/js/facade/TranslationResult;", "config", "Lorg/jetbrains/kotlin/js/config/JsConfig;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "program", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgram;", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "importedModules", "", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lorg/jetbrains/kotlin/js/config/JsConfig;Ljava/util/List;Lorg/jetbrains/kotlin/js/backend/ast/JsProgram;Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;Ljava/util/List;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "getProgram", "()Lorg/jetbrains/kotlin/js/backend/ast/JsProgram;", "getCode", "output", "Lorg/jetbrains/kotlin/js/util/TextOutput;", "sourceMapBuilder", "Lorg/jetbrains/kotlin/js/sourceMap/SourceMapBuilder;", "getOutputFiles", "Lorg/jetbrains/kotlin/backend/common/output/OutputFileCollection;", "outputFile", "Ljava/io/File;", "outputPrefixFile", "outputPostfixFile", "kotlin-compiler"})
    public static final class Success
    extends TranslationResult {
        private final JsConfig config;
        private final List<KtFile> files;
        @NotNull
        private final JsProgram program;
        private final List<String> importedModules;
        private final ModuleDescriptor moduleDescriptor;
        private final BindingContext bindingContext;

        @NotNull
        public final String getCode() {
            return this.getCode(new TextOutputImpl(), null);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final OutputFileCollection getOutputFiles(@NotNull File outputFile, @Nullable File outputPrefixFile, @Nullable File outputPostfixFile) {
            Object virtualFile;
            ModuleKind it;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Object object;
            Object prefix;
            Intrinsics.checkParameterIsNotNull(outputFile, "outputFile");
            TextOutputImpl output = new TextOutputImpl();
            SourceMap3Builder sourceMapBuilder = this.config.getConfiguration().getBoolean(JSConfigurationKeys.SOURCE_MAP) ? new SourceMap3Builder(outputFile, output, new SourceMapBuilderConsumer()) : null;
            String code = this.getCode(output, sourceMapBuilder);
            Object object2 = outputPrefixFile;
            if (object2 == null || (object2 = FilesKt.readText$default((File)object2, null, 1, null)) == null) {
                object2 = prefix = "";
            }
            if ((object = outputPostfixFile) == null || (object = FilesKt.readText$default((File)object, null, 1, null)) == null) {
                object = "";
            }
            Object postfix = object;
            Iterable iterable = $receiver$iv = (Iterable)this.files;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                File file2;
                KtFile ktFile = (KtFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                virtualFile = ((PsiFileImpl)((Object)it)).getOriginalFile().getVirtualFile();
                if (virtualFile == null) {
                    file2 = new File(((KtFile)((Object)it)).getName());
                } else {
                    File file3 = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                    file2 = file3;
                    Intrinsics.checkExpressionValueIsNotNull(file3, "VfsUtilCore.virtualToIoFile(virtualFile)");
                }
                File file4 = file2;
                collection.add(file4);
            }
            List sourceFiles2 = (List)destination$iv$iv;
            String string = outputFile.getName();
            Intrinsics.checkExpressionValueIsNotNull(string, "outputFile.name");
            SimpleOutputFile jsFile = new SimpleOutputFile(sourceFiles2, string, (String)prefix + code + (String)postfix);
            ArrayList<OutputFile> outputFiles = CollectionsKt.arrayListOf(jsFile);
            if (this.config.getConfiguration().getBoolean(JSConfigurationKeys.META_INFO)) {
                Map<String, byte[]> $receiver$iv2;
                Object item$iv$iv;
                String string2 = outputFile.getName();
                Intrinsics.checkExpressionValueIsNotNull(string2, "outputFile.name");
                String metaFileName = KotlinJavascriptMetadataUtils.INSTANCE.replaceSuffix(string2);
                String string3 = this.config.getModuleId();
                Intrinsics.checkExpressionValueIsNotNull(string3, "config.moduleId");
                ModuleKind moduleKind = this.config.getModuleKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleKind, "config.moduleKind");
                item$iv$iv = this.importedModules;
                it = moduleKind;
                virtualFile = this.moduleDescriptor;
                JsModuleDescriptor<Object> moduleDescription = new JsModuleDescriptor<Object>(string3, it, (List<String>)item$iv$iv, virtualFile);
                String metaFileContent = KotlinJavascriptSerializationUtil.INSTANCE.metadataAsString(this.bindingContext, moduleDescription);
                ArrayList sourceFilesForMetaFile = new ArrayList(sourceFiles2);
                SimpleOutputFile jsMetaFile = new SimpleOutputFile(sourceFilesForMetaFile, metaFileName, metaFileContent);
                outputFiles.add(jsMetaFile);
                Map<String, byte[]> map2 = $receiver$iv2 = KotlinJavascriptSerializationUtil.INSTANCE.toContentMap(this.bindingContext, this.moduleDescriptor);
                Iterator<Map.Entry<String, byte[]>> iterator2 = map2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<String, byte[]> element$iv;
                    Map.Entry<String, byte[]> it2 = element$iv = iterator2.next();
                    outputFiles.add(new SimpleOutputBinaryFile(CollectionsKt.emptyList(), this.config.getModuleId() + '/' + it2.getKey(), it2.getValue()));
                }
            }
            if (sourceMapBuilder != null) {
                sourceMapBuilder.skipLinesAtBeginning(StringUtil.getLineBreakCount((CharSequence)prefix));
                String string4 = sourceMapBuilder.getOutFile().getName();
                Intrinsics.checkExpressionValueIsNotNull(string4, "sourceMapBuilder.outFile.name");
                String string5 = sourceMapBuilder.build();
                Intrinsics.checkExpressionValueIsNotNull(string5, "sourceMapBuilder.build()");
                SimpleOutputFile sourceMapFile = new SimpleOutputFile(sourceFiles2, string4, string5);
                outputFiles.add(sourceMapFile);
            }
            return new SimpleOutputFileCollection((List<? extends OutputFile>)outputFiles);
        }

        private final String getCode(TextOutput output, SourceMapBuilder sourceMapBuilder) {
            this.program.accept(new JsSourceGenerationVisitor(output, sourceMapBuilder));
            return output.toString();
        }

        @NotNull
        public final JsProgram getProgram() {
            return this.program;
        }

        public Success(@NotNull JsConfig config, @NotNull List<? extends KtFile> files2, @NotNull JsProgram program, @NotNull Diagnostics diagnostics, @NotNull List<String> importedModules, @NotNull ModuleDescriptor moduleDescriptor, @NotNull BindingContext bindingContext) {
            Intrinsics.checkParameterIsNotNull(config, "config");
            Intrinsics.checkParameterIsNotNull(files2, "files");
            Intrinsics.checkParameterIsNotNull(program, "program");
            Intrinsics.checkParameterIsNotNull(diagnostics, "diagnostics");
            Intrinsics.checkParameterIsNotNull(importedModules, "importedModules");
            Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
            Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
            super(diagnostics);
            this.config = config;
            this.files = files2;
            this.program = program;
            this.importedModules = importedModules;
            this.moduleDescriptor = moduleDescriptor;
            this.bindingContext = bindingContext;
        }
    }
}

