/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.partitions;

import com.amazonaws.AmazonClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.partitions.PartitionMetadataProvider;
import com.amazonaws.partitions.model.Partitions;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.json.Jackson;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;

@SdkInternalApi
public class PartitionsLoader {
    public static final String PARTITIONS_RESOURCE_PATH = "com/amazonaws/partitions/endpoints.json";
    public static final String PARTITIONS_OVERRIDE_RESOURCE_PATH = "com/amazonaws/partitions/override/endpoints.json";
    private static final ObjectMapper mapper = Jackson.getObjectMapper();
    private final ClassLoader classLoader = PartitionsLoader.class.getClassLoader();

    public PartitionMetadataProvider build() {
        InputStream stream = this.classLoader.getResourceAsStream(PARTITIONS_OVERRIDE_RESOURCE_PATH);
        if (stream != null) {
            return new PartitionMetadataProvider(this.loadPartitionFromStream(stream, PARTITIONS_OVERRIDE_RESOURCE_PATH).getPartitions());
        }
        stream = this.classLoader.getResourceAsStream(PARTITIONS_RESOURCE_PATH);
        if (stream == null) {
            throw new AmazonClientException("Unable to load parition metadata from com/amazonaws/partitions/endpoints.json");
        }
        return new PartitionMetadataProvider(this.loadPartitionFromStream(stream, PARTITIONS_RESOURCE_PATH).getPartitions());
    }

    private Partitions loadPartitionFromStream(InputStream stream, String location) {
        try {
            Partitions partitions = (Partitions)mapper.readValue(stream, Partitions.class);
            return partitions;
        }
        catch (IOException e) {
            throw new AmazonClientException("Error while loading partitions file from " + location, e);
        }
        finally {
            IOUtils.closeQuietly(stream, null);
        }
    }
}

