/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.logging.console.BuildProgressArea;
import org.gradle.internal.logging.console.ConsoleLayoutCalculator;
import org.gradle.internal.logging.console.DefaultWorkInProgressFormatter;
import org.gradle.internal.logging.console.ProgressOperation;
import org.gradle.internal.logging.console.ProgressOperations;
import org.gradle.internal.logging.console.StyledLabel;
import org.gradle.internal.logging.events.BatchOutputEventListener;
import org.gradle.internal.logging.events.EndOutputEvent;
import org.gradle.internal.logging.events.MaxWorkerCountChangeEvent;
import org.gradle.internal.logging.events.OperationIdentifier;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.ProgressCompleteEvent;
import org.gradle.internal.logging.events.ProgressEvent;
import org.gradle.internal.logging.events.ProgressStartEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkInProgressRenderer
extends BatchOutputEventListener {
    private final OutputEventListener listener;
    private final ProgressOperations operations = new ProgressOperations();
    private final BuildProgressArea progressArea;
    private final DefaultWorkInProgressFormatter labelFormatter;
    private final ConsoleLayoutCalculator consoleLayoutCalculator;
    private final Deque<StyledLabel> unusedProgressLabels;
    private final Map<OperationIdentifier, AssociationLabel> operationIdToAssignedLabels = new HashMap<OperationIdentifier, AssociationLabel>();
    private final Deque<ProgressOperation> unassignedProgressOperations = new ArrayDeque<ProgressOperation>();
    private final Map<OperationIdentifier, Set<OperationIdentifier>> parentIdToChildrenIds = new HashMap<OperationIdentifier, Set<OperationIdentifier>>();

    public WorkInProgressRenderer(OutputEventListener listener, BuildProgressArea progressArea, DefaultWorkInProgressFormatter labelFormatter, ConsoleLayoutCalculator consoleLayoutCalculator) {
        this.listener = listener;
        this.progressArea = progressArea;
        this.labelFormatter = labelFormatter;
        this.consoleLayoutCalculator = consoleLayoutCalculator;
        this.unusedProgressLabels = new ArrayDeque<StyledLabel>(progressArea.getBuildProgressLabels());
    }

    @Override
    public void onOutput(OutputEvent event) {
        if (event instanceof ProgressStartEvent) {
            this.progressArea.setVisible(true);
            ProgressStartEvent startEvent = (ProgressStartEvent)event;
            ProgressOperation op = this.operations.start(startEvent.getShortDescription(), startEvent.getStatus(), startEvent.getCategory(), startEvent.getOperationId(), startEvent.getParentId());
            this.attach(op);
        } else if (event instanceof ProgressCompleteEvent) {
            ProgressCompleteEvent completeEvent = (ProgressCompleteEvent)event;
            this.detach(this.operations.complete(completeEvent.getOperationId()));
        } else if (event instanceof ProgressEvent) {
            ProgressEvent progressEvent = (ProgressEvent)event;
            this.operations.progress(progressEvent.getStatus(), progressEvent.getOperationId());
        } else if (event instanceof EndOutputEvent) {
            this.progressArea.setVisible(false);
        } else if (event instanceof MaxWorkerCountChangeEvent) {
            int newCount = this.consoleLayoutCalculator.calculateNumWorkersForConsoleDisplay(((MaxWorkerCountChangeEvent)event).getNewMaxWorkerCount());
            this.resizeTo(newCount);
        }
        this.listener.onOutput(event);
    }

    @Override
    public void onOutput(Iterable<OutputEvent> events) {
        super.onOutput(events);
        this.renderNow();
    }

    private void resizeTo(int newBuildProgressLabelCount) {
        int previousBuildProgressLabelCount = this.progressArea.getBuildProgressLabels().size();
        if (previousBuildProgressLabelCount >= newBuildProgressLabelCount) {
            return;
        }
        this.progressArea.resizeBuildProgressTo(newBuildProgressLabelCount);
        for (int i = newBuildProgressLabelCount - 1; i >= previousBuildProgressLabelCount; --i) {
            this.unusedProgressLabels.push(this.progressArea.getBuildProgressLabels().get(i));
        }
        while (!this.unusedProgressLabels.isEmpty() && !this.unassignedProgressOperations.isEmpty()) {
            this.attach(this.unassignedProgressOperations.pop());
        }
    }

    private void attach(ProgressOperation operation) {
        if (this.isChildAssociationAlreadyExists(operation.getOperationId())) {
            return;
        }
        AssociationLabel association = null;
        if (operation.getParent() != null) {
            this.addDirectChildOperationId(operation.getParent().getOperationId(), operation.getOperationId());
            association = this.operationIdToAssignedLabels.remove(operation.getParent().getOperationId());
            if (association != null) {
                this.unusedProgressLabels.push(association.label);
                association = null;
            }
        }
        if (association == null && !this.unusedProgressLabels.isEmpty()) {
            association = new AssociationLabel(operation, this.unusedProgressLabels.pop());
        }
        if (association == null) {
            this.unassignedProgressOperations.addLast(operation);
        } else {
            this.operationIdToAssignedLabels.put(operation.getOperationId(), association);
        }
    }

    private void detach(ProgressOperation operation) {
        AssociationLabel association;
        if (operation.getParent() != null) {
            this.removeDirectChildOperationId(operation.getParent().getOperationId(), operation.getOperationId());
        }
        if ((association = this.operationIdToAssignedLabels.remove(operation.getOperationId())) != null) {
            this.unusedProgressLabels.push(association.label);
            if (operation.getParent() != null) {
                this.attach(operation.getParent());
            } else if (!this.unassignedProgressOperations.isEmpty()) {
                this.attach(this.unassignedProgressOperations.pop());
            }
        } else {
            this.unassignedProgressOperations.remove(operation);
        }
    }

    private void addDirectChildOperationId(OperationIdentifier parentId, OperationIdentifier childId) {
        Set<OperationIdentifier> children = this.parentIdToChildrenIds.get(parentId);
        if (children == null) {
            children = new HashSet<OperationIdentifier>();
            this.parentIdToChildrenIds.put(parentId, children);
        }
        children.add(childId);
    }

    private void removeDirectChildOperationId(OperationIdentifier parentId, OperationIdentifier childId) {
        Set<OperationIdentifier> children = this.parentIdToChildrenIds.get(parentId);
        if (children == null) {
            throw new IllegalStateException("");
        }
        children.remove(childId);
        if (children.isEmpty()) {
            this.parentIdToChildrenIds.remove(parentId);
        }
    }

    private boolean isChildAssociationAlreadyExists(OperationIdentifier parentId) {
        Set<OperationIdentifier> children = this.parentIdToChildrenIds.get(parentId);
        return children != null && !children.isEmpty();
    }

    private void renderNow() {
        for (AssociationLabel associatedLabel : this.operationIdToAssignedLabels.values()) {
            associatedLabel.renderNow();
        }
        for (StyledLabel emptyLabel : this.unusedProgressLabels) {
            emptyLabel.setText(this.labelFormatter.format());
        }
    }

    private class AssociationLabel {
        final ProgressOperation operation;
        final StyledLabel label;

        AssociationLabel(ProgressOperation operation, StyledLabel label) {
            this.operation = operation;
            this.label = label;
        }

        void renderNow() {
            this.label.setText(WorkInProgressRenderer.this.labelFormatter.format(this.operation));
        }
    }
}

