/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.internal.component.AmbiguousConfigurationSelectionException;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.text.TreeFormatter;

public class NoMatchingConfigurationSelectionException
extends IllegalArgumentException {
    public NoMatchingConfigurationSelectionException(AttributeContainer fromConfigurationAttributes, AttributesSchema consumerSchema, ComponentResolveMetadata targetComponent, List<String> candidateConfigurations) {
        super(NoMatchingConfigurationSelectionException.generateMessage(fromConfigurationAttributes, consumerSchema, targetComponent, candidateConfigurations));
    }

    private static String generateMessage(AttributeContainer fromConfigurationAttributes, AttributesSchema consumerSchema, ComponentResolveMetadata targetComponent, List<String> configurationNames) {
        ArrayList<ConfigurationMetadata> configurations = new ArrayList<ConfigurationMetadata>(configurationNames.size());
        for (String name : configurationNames) {
            ConfigurationMetadata targetComponentConfiguration = targetComponent.getConfiguration(name);
            if (!targetComponentConfiguration.isCanBeConsumed() || targetComponentConfiguration.getAttributes().isEmpty()) continue;
            configurations.add(targetComponentConfiguration);
        }
        TreeSet requestedAttributes = Sets.newTreeSet((Iterable)Iterables.transform((Iterable)fromConfigurationAttributes.keySet(), AmbiguousConfigurationSelectionException.ATTRIBUTE_NAME));
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("Unable to find a matching configuration in " + targetComponent.getComponentId().getDisplayName());
        formatter.startChildren();
        if (configurations.isEmpty()) {
            formatter.node("None of the consumable configurations have attributes.");
        } else {
            for (String config : configurationNames) {
                AmbiguousConfigurationSelectionException.formatConfiguration(formatter, fromConfigurationAttributes, consumerSchema, configurations, requestedAttributes, config);
            }
        }
        formatter.endChildren();
        return formatter.toString();
    }
}

