/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import org.gradle.api.Action;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.file.SourceDirectorySetFactory;
import org.gradle.api.tasks.GroovySourceSet;
import org.gradle.util.ConfigureUtil;

public class DefaultGroovySourceSet
implements GroovySourceSet {
    private final SourceDirectorySet groovy;
    private final SourceDirectorySet allGroovy;

    public DefaultGroovySourceSet(String displayName, SourceDirectorySetFactory sourceDirectorySetFactory) {
        this.groovy = sourceDirectorySetFactory.create(displayName + " Groovy source");
        this.groovy.getFilter().include(new String[]{"**/*.java", "**/*.groovy"});
        this.allGroovy = sourceDirectorySetFactory.create(displayName + " Groovy source");
        this.allGroovy.source(this.groovy);
        this.allGroovy.getFilter().include(new String[]{"**/*.groovy"});
    }

    @Override
    public SourceDirectorySet getGroovy() {
        return this.groovy;
    }

    @Override
    public GroovySourceSet groovy(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getGroovy());
        return this;
    }

    @Override
    public GroovySourceSet groovy(Action<? super SourceDirectorySet> configureAction) {
        configureAction.execute((Object)this.getGroovy());
        return this;
    }

    @Override
    public SourceDirectorySet getAllGroovy() {
        return this.allGroovy;
    }
}

