/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.io.UpdatePrimitivesTask;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class DownloadOsmTask
extends AbstractDownloadTask<DataSet> {
    protected static final String PATTERN_OSM_API_URL = "https?://.*/api/0.6/(map|nodes?|ways?|relations?|\\*).*";
    protected static final String PATTERN_OVERPASS_API_URL = "https?://.*/interpreter\\?data=.*";
    protected static final String PATTERN_OVERPASS_API_XAPI_URL = "https?://.*/xapi(\\?.*\\[@meta\\]|_meta\\?).*";
    protected static final String PATTERN_EXTERNAL_OSM_FILE = "https?://.*/.*\\.osm";
    protected Bounds currentBounds;
    protected DownloadTask downloadTask;
    protected String newLayerName;
    protected boolean warnAboutEmptyArea = true;

    @Override
    public String[] getPatterns() {
        if (this.getClass() == DownloadOsmTask.class) {
            return new String[]{PATTERN_OSM_API_URL, PATTERN_OVERPASS_API_URL, PATTERN_OVERPASS_API_XAPI_URL, PATTERN_EXTERNAL_OSM_FILE};
        }
        return super.getPatterns();
    }

    @Override
    public String getTitle() {
        if (this.getClass() == DownloadOsmTask.class) {
            return I18n.tr("Download OSM", new Object[0]);
        }
        return super.getTitle();
    }

    @Override
    public Future<?> download(boolean bl, Bounds bounds, ProgressMonitor progressMonitor) {
        return this.download(new BoundingBoxDownloader(bounds), bl, bounds, progressMonitor);
    }

    public Future<?> download(OsmServerReader osmServerReader, boolean bl, Bounds bounds, ProgressMonitor progressMonitor) {
        return this.download(new DownloadTask(bl, osmServerReader, progressMonitor, this.zoomAfterDownload), bounds);
    }

    protected Future<?> download(DownloadTask downloadTask, Bounds bounds) {
        this.downloadTask = downloadTask;
        this.currentBounds = new Bounds(bounds);
        return Main.worker.submit(downloadTask);
    }

    protected String modifyUrlBeforeLoad(String string) {
        return string;
    }

    @Override
    public Future<?> loadUrl(boolean bl, String string, ProgressMonitor progressMonitor) {
        String string2 = this.modifyUrlBeforeLoad(string);
        this.downloadTask = new DownloadTask(bl, new OsmServerLocationReader(string2), progressMonitor);
        this.currentBounds = null;
        this.extractOsmFilename("https?://.*/(.*\\.osm)", string2);
        return Main.worker.submit(this.downloadTask);
    }

    protected final void extractOsmFilename(String string, String string2) {
        Matcher matcher = Pattern.compile(string).matcher(string2);
        this.newLayerName = matcher.matches() ? matcher.group(1) : null;
    }

    @Override
    public void cancel() {
        if (this.downloadTask != null) {
            this.downloadTask.cancel();
        }
    }

    @Override
    public boolean isSafeForRemotecontrolRequests() {
        return true;
    }

    @Override
    public ProjectionBounds getDownloadProjectionBounds() {
        return this.downloadTask != null ? this.downloadTask.computeBbox(this.currentBounds) : null;
    }

    @Override
    public String getConfirmationMessage(URL uRL) {
        String string;
        if (uRL != null && (string = uRL.toExternalForm()).matches(PATTERN_OSM_API_URL)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(I18n.tr("OSM Server URL:", new Object[0]) + ' ' + uRL.getHost());
            arrayList.add(I18n.tr("Command", new Object[0]) + ": " + uRL.getPath());
            if (uRL.getQuery() != null) {
                arrayList.add(I18n.tr("Request details: {0}", uRL.getQuery().replaceAll(",\\s*", ", ")));
            }
            return Utils.joinAsHtmlUnorderedList(arrayList);
        }
        return null;
    }

    protected class DownloadTask
    extends AbstractInternalTask {
        protected final OsmServerReader reader;

        public DownloadTask(boolean bl, OsmServerReader osmServerReader, ProgressMonitor progressMonitor) {
            this(bl, osmServerReader, progressMonitor, true);
        }

        public DownloadTask(boolean bl, OsmServerReader osmServerReader, ProgressMonitor progressMonitor, boolean bl2) {
            super(bl, I18n.tr("Downloading data", new Object[0]), progressMonitor, false, bl2);
            this.reader = osmServerReader;
        }

        protected DataSet parseDataSet() throws OsmTransferException {
            return this.reader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
        }

        @Override
        public void realRun() throws IOException, SAXException, OsmTransferException {
            try {
                if (DownloadOsmTask.this.isCanceled()) {
                    return;
                }
                this.dataSet = this.parseDataSet();
            }
            catch (OsmTransferException osmTransferException) {
                if (DownloadOsmTask.this.isCanceled()) {
                    Main.info(I18n.tr("Ignoring exception because download has been canceled. Exception was: {0}", osmTransferException.toString()));
                    return;
                }
                if (osmTransferException instanceof OsmTransferCanceledException) {
                    DownloadOsmTask.this.setCanceled(true);
                    return;
                }
                DownloadOsmTask.this.rememberException(osmTransferException);
                DownloadOsmTask.this.setFailed(true);
            }
        }

        @Override
        protected void finish() {
            if (DownloadOsmTask.this.isFailed() || DownloadOsmTask.this.isCanceled()) {
                return;
            }
            if (this.dataSet == null) {
                return;
            }
            if (this.dataSet.allPrimitives().isEmpty()) {
                if (DownloadOsmTask.this.warnAboutEmptyArea) {
                    DownloadOsmTask.this.rememberErrorMessage(I18n.tr("No data found in this area.", new Object[0]));
                }
                this.dataSet.addDataSource(new DataSource(DownloadOsmTask.this.currentBounds != null ? DownloadOsmTask.this.currentBounds : new Bounds(LatLon.ZERO), "OpenStreetMap server"));
            }
            DownloadOsmTask.this.rememberDownloadedData(this.dataSet);
            this.loadData(DownloadOsmTask.this.newLayerName, DownloadOsmTask.this.currentBounds);
        }

        @Override
        protected void cancel() {
            DownloadOsmTask.this.setCanceled(true);
            if (this.reader != null) {
                this.reader.cancel();
            }
        }
    }

    public static abstract class AbstractInternalTask
    extends PleaseWaitRunnable {
        protected final boolean newLayer;
        protected final boolean zoomAfterDownload;
        protected DataSet dataSet;

        public AbstractInternalTask(boolean bl, String string, boolean bl2, boolean bl3) {
            super(string, bl2);
            this.newLayer = bl;
            this.zoomAfterDownload = bl3;
        }

        public AbstractInternalTask(boolean bl, String string, ProgressMonitor progressMonitor, boolean bl2, boolean bl3) {
            super(string, progressMonitor, bl2);
            this.newLayer = bl;
            this.zoomAfterDownload = bl3;
        }

        protected OsmDataLayer getEditLayer() {
            if (!Main.isDisplayingMapView()) {
                return null;
            }
            return Main.getLayerManager().getEditLayer();
        }

        protected int getNumDataLayers() {
            return Main.getLayerManager().getLayersOfType(OsmDataLayer.class).size();
        }

        protected OsmDataLayer getFirstDataLayer() {
            return Utils.find(Main.getLayerManager().getLayers(), OsmDataLayer.class);
        }

        protected OsmDataLayer createNewLayer(String string) {
            if (string == null || string.isEmpty()) {
                string = OsmDataLayer.createNewName();
            }
            return new OsmDataLayer(this.dataSet, string, null);
        }

        protected OsmDataLayer createNewLayer() {
            return this.createNewLayer(null);
        }

        protected ProjectionBounds computeBbox(Bounds bounds) {
            BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
            if (bounds != null) {
                boundingXYVisitor.visit(bounds);
            } else {
                boundingXYVisitor.computeBoundingBox(this.dataSet.getNodes());
            }
            return boundingXYVisitor.getBounds();
        }

        protected OsmDataLayer addNewLayerIfRequired(String string) {
            int n = this.getNumDataLayers();
            if (this.newLayer || n == 0 || n > 1 && this.getEditLayer() == null) {
                OsmDataLayer osmDataLayer = this.createNewLayer(string);
                Main.getLayerManager().addLayer(osmDataLayer, this.zoomAfterDownload);
                return osmDataLayer;
            }
            return null;
        }

        protected void loadData(String string, Bounds bounds) {
            OsmDataLayer osmDataLayer = this.addNewLayerIfRequired(string);
            if (osmDataLayer == null) {
                osmDataLayer = Optional.ofNullable(this.getEditLayer()).orElseGet(this::getFirstDataLayer);
                Collection<OsmPrimitive> collection = this.searchPrimitivesToUpdate(bounds, osmDataLayer.data);
                osmDataLayer.mergeFrom(this.dataSet);
                if (Main.map != null && this.zoomAfterDownload) {
                    Main.map.mapView.zoomTo(new ViewportData(this.computeBbox(bounds)));
                }
                if (!collection.isEmpty()) {
                    Main.worker.submit(new UpdatePrimitivesTask(osmDataLayer, collection));
                }
                osmDataLayer.onPostDownloadFromServer();
            }
        }

        private Collection<OsmPrimitive> searchPrimitivesToUpdate(Bounds bounds, DataSet dataSet) {
            if (bounds == null) {
                return Collections.emptySet();
            }
            ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
            dataSet.searchNodes(bounds.toBBox()).stream().filter(node -> !node.isNew() && !this.dataSet.containsNode((Node)node)).forEachOrdered(arrayList::add);
            if (!arrayList.isEmpty()) {
                HashSet<Way> hashSet = new HashSet<Way>();
                HashSet<Relation> hashSet2 = new HashSet<Relation>();
                for (OsmPrimitive osmPrimitive : arrayList) {
                    for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                        if (osmPrimitive2.isNew()) continue;
                        if (osmPrimitive2 instanceof Way) {
                            hashSet.add((Way)osmPrimitive2);
                            continue;
                        }
                        if (!(osmPrimitive2 instanceof Relation)) continue;
                        hashSet2.add((Relation)osmPrimitive2);
                    }
                }
                hashSet.stream().filter(way -> !this.dataSet.containsWay((Way)way)).forEachOrdered(arrayList::add);
                hashSet2.stream().filter(relation -> !this.dataSet.containsRelation((Relation)relation)).forEachOrdered(arrayList::add);
            }
            return arrayList;
        }
    }
}

