/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;

public final class DynamicContext {
    @NotNull
    private final JsScope currentScope;
    @NotNull
    private final JsBlock currentBlock;
    @Nullable
    private JsVars vars;

    @NotNull
    public static DynamicContext rootContext(@NotNull JsScope rootScope2, @NotNull JsBlock globalBlock) {
        if (rootScope2 == null) {
            DynamicContext.$$$reportNull$$$0(0);
        }
        if (globalBlock == null) {
            DynamicContext.$$$reportNull$$$0(1);
        }
        DynamicContext dynamicContext = new DynamicContext(rootScope2, globalBlock);
        if (dynamicContext == null) {
            DynamicContext.$$$reportNull$$$0(2);
        }
        return dynamicContext;
    }

    @NotNull
    public static DynamicContext newContext(@NotNull JsScope scope, @NotNull JsBlock block) {
        if (scope == null) {
            DynamicContext.$$$reportNull$$$0(3);
        }
        if (block == null) {
            DynamicContext.$$$reportNull$$$0(4);
        }
        DynamicContext dynamicContext = new DynamicContext(scope, block);
        if (dynamicContext == null) {
            DynamicContext.$$$reportNull$$$0(5);
        }
        return dynamicContext;
    }

    private DynamicContext(@NotNull JsScope scope, @NotNull JsBlock block) {
        if (scope == null) {
            DynamicContext.$$$reportNull$$$0(6);
        }
        if (block == null) {
            DynamicContext.$$$reportNull$$$0(7);
        }
        this.currentScope = scope;
        this.currentBlock = block;
    }

    @NotNull
    public DynamicContext innerBlock(@NotNull JsBlock block) {
        if (block == null) {
            DynamicContext.$$$reportNull$$$0(8);
        }
        DynamicContext dynamicContext = new DynamicContext(this.currentScope, block);
        if (dynamicContext == null) {
            DynamicContext.$$$reportNull$$$0(9);
        }
        return dynamicContext;
    }

    @NotNull
    public TemporaryVariable declareTemporary(@Nullable JsExpression initExpression) {
        if (this.vars == null) {
            this.vars = new JsVars();
            MetadataProperties.setSynthetic(this.vars, true);
            this.currentBlock.getStatements().add(this.vars);
        }
        JsName temporaryName = this.currentScope.declareTemporary();
        JsVars.JsVar var = new JsVars.JsVar(temporaryName, null);
        MetadataProperties.setSynthetic(var, true);
        this.vars.add(var);
        TemporaryVariable temporaryVariable = TemporaryVariable.create(temporaryName, initExpression);
        if (temporaryVariable == null) {
            DynamicContext.$$$reportNull$$$0(10);
        }
        return temporaryVariable;
    }

    void moveVarsFrom(@NotNull DynamicContext dynamicContext) {
        if (dynamicContext == null) {
            DynamicContext.$$$reportNull$$$0(11);
        }
        if (dynamicContext.vars != null) {
            if (this.vars == null) {
                this.vars = dynamicContext.vars;
                this.currentBlock.getStatements().add(this.vars);
            } else {
                this.vars.addAll(dynamicContext.vars);
            }
            dynamicContext.currentBlock.getStatements().remove(dynamicContext.vars);
            dynamicContext.vars = null;
        }
    }

    @NotNull
    public JsScope getScope() {
        JsScope jsScope = this.currentScope;
        if (jsScope == null) {
            DynamicContext.$$$reportNull$$$0(12);
        }
        return jsScope;
    }

    @NotNull
    public JsBlock jsBlock() {
        JsBlock jsBlock = this.currentBlock;
        if (jsBlock == null) {
            DynamicContext.$$$reportNull$$$0(13);
        }
        return jsBlock;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootScope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalBlock";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/context/DynamicContext";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/context/DynamicContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "rootContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "newContext";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "innerBlock";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "declareTemporary";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "jsBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "rootContext";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "newContext";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "innerBlock";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "moveVarsFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

