#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: crypto-pubkey
version: 0.2.8
id: crypto-pubkey-0.2.8-DTIhE3PDwJfF3OGBMz2t2b
key: crypto-pubkey-0.2.8-DTIhE3PDwJfF3OGBMz2t2b
license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
homepage: https://github.com/vincenthz/hs-crypto-pubkey
synopsis: Public Key cryptography
description:
    Public Key cryptography
    .
    Supports RSA PKCS15, RSA OAEP, RSA PSS, DSA, ElGamal signature.
    .
    Also have primitive support for Diffie Hellman, and ElGamal encryption
category: Cryptography
author: Vincent Hanquez <vincent@snarc.org>
exposed: True
exposed-modules:
    Crypto.PubKey.RSA Crypto.PubKey.RSA.PKCS15 Crypto.PubKey.RSA.OAEP
    Crypto.PubKey.RSA.PSS Crypto.PubKey.RSA.Prim Crypto.PubKey.DSA
    Crypto.PubKey.DH Crypto.PubKey.HashDescr
    Crypto.PubKey.MaskGenFunction Crypto.PubKey.ECC.Generate
    Crypto.PubKey.ECC.Prim Crypto.PubKey.ECC.DH Crypto.PubKey.ECC.ECDSA
hidden-modules: Crypto.PubKey.ElGamal Crypto.PubKey.RSA.Types
                Crypto.PubKey.Internal
abi: 096b2a12483620d51b8b5432f3861e89
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/crypto-pubkey-0.2.8
library-dirs: /usr/lib/ghc-8.0.1/site-local/crypto-pubkey-0.2.8
data-dir: /usr/share/arm-linux-ghc-8.0.1/crypto-pubkey-0.2.8
hs-libraries: HScrypto-pubkey-0.2.8-DTIhE3PDwJfF3OGBMz2t2b
depends:
    base-4.9.0.0 byteable-0.1.1-15aIBCArSOBEnGxArzrDTM
    bytestring-0.10.8.1 crypto-numbers-0.2.7-8jbI9vZ2g8VFEPllUK8h2w
    crypto-pubkey-types-0.4.3-DIT5MXwnnE2ItoQ5f7cRUT
    crypto-random-0.0.9-DWV3dcrdJbJH1ghEKFtuv9
    cryptohash-0.11.9-KLIN16gW1mu17s2DuDaHoa
haddock-interfaces: /usr/share/doc/haskell-crypto-pubkey/html/crypto-pubkey.haddock
haddock-html: /usr/share/doc/haskell-crypto-pubkey/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
