// autogenerated from gen/MIPS64.rules: do not edit!
// generated with: cd gen; go run *.go

package ssa

import "math"

var _ = math.MinInt8 // in case not otherwise used
func rewriteValueMIPS64(v *Value, config *Config) bool {
	switch v.Op {
	case OpAdd16:
		return rewriteValueMIPS64_OpAdd16(v, config)
	case OpAdd32:
		return rewriteValueMIPS64_OpAdd32(v, config)
	case OpAdd32F:
		return rewriteValueMIPS64_OpAdd32F(v, config)
	case OpAdd64:
		return rewriteValueMIPS64_OpAdd64(v, config)
	case OpAdd64F:
		return rewriteValueMIPS64_OpAdd64F(v, config)
	case OpAdd8:
		return rewriteValueMIPS64_OpAdd8(v, config)
	case OpAddPtr:
		return rewriteValueMIPS64_OpAddPtr(v, config)
	case OpAddr:
		return rewriteValueMIPS64_OpAddr(v, config)
	case OpAnd16:
		return rewriteValueMIPS64_OpAnd16(v, config)
	case OpAnd32:
		return rewriteValueMIPS64_OpAnd32(v, config)
	case OpAnd64:
		return rewriteValueMIPS64_OpAnd64(v, config)
	case OpAnd8:
		return rewriteValueMIPS64_OpAnd8(v, config)
	case OpAndB:
		return rewriteValueMIPS64_OpAndB(v, config)
	case OpAvg64u:
		return rewriteValueMIPS64_OpAvg64u(v, config)
	case OpClosureCall:
		return rewriteValueMIPS64_OpClosureCall(v, config)
	case OpCom16:
		return rewriteValueMIPS64_OpCom16(v, config)
	case OpCom32:
		return rewriteValueMIPS64_OpCom32(v, config)
	case OpCom64:
		return rewriteValueMIPS64_OpCom64(v, config)
	case OpCom8:
		return rewriteValueMIPS64_OpCom8(v, config)
	case OpConst16:
		return rewriteValueMIPS64_OpConst16(v, config)
	case OpConst32:
		return rewriteValueMIPS64_OpConst32(v, config)
	case OpConst32F:
		return rewriteValueMIPS64_OpConst32F(v, config)
	case OpConst64:
		return rewriteValueMIPS64_OpConst64(v, config)
	case OpConst64F:
		return rewriteValueMIPS64_OpConst64F(v, config)
	case OpConst8:
		return rewriteValueMIPS64_OpConst8(v, config)
	case OpConstBool:
		return rewriteValueMIPS64_OpConstBool(v, config)
	case OpConstNil:
		return rewriteValueMIPS64_OpConstNil(v, config)
	case OpConvert:
		return rewriteValueMIPS64_OpConvert(v, config)
	case OpCvt32Fto32:
		return rewriteValueMIPS64_OpCvt32Fto32(v, config)
	case OpCvt32Fto64:
		return rewriteValueMIPS64_OpCvt32Fto64(v, config)
	case OpCvt32Fto64F:
		return rewriteValueMIPS64_OpCvt32Fto64F(v, config)
	case OpCvt32to32F:
		return rewriteValueMIPS64_OpCvt32to32F(v, config)
	case OpCvt32to64F:
		return rewriteValueMIPS64_OpCvt32to64F(v, config)
	case OpCvt64Fto32:
		return rewriteValueMIPS64_OpCvt64Fto32(v, config)
	case OpCvt64Fto32F:
		return rewriteValueMIPS64_OpCvt64Fto32F(v, config)
	case OpCvt64Fto64:
		return rewriteValueMIPS64_OpCvt64Fto64(v, config)
	case OpCvt64to32F:
		return rewriteValueMIPS64_OpCvt64to32F(v, config)
	case OpCvt64to64F:
		return rewriteValueMIPS64_OpCvt64to64F(v, config)
	case OpDeferCall:
		return rewriteValueMIPS64_OpDeferCall(v, config)
	case OpDiv16:
		return rewriteValueMIPS64_OpDiv16(v, config)
	case OpDiv16u:
		return rewriteValueMIPS64_OpDiv16u(v, config)
	case OpDiv32:
		return rewriteValueMIPS64_OpDiv32(v, config)
	case OpDiv32F:
		return rewriteValueMIPS64_OpDiv32F(v, config)
	case OpDiv32u:
		return rewriteValueMIPS64_OpDiv32u(v, config)
	case OpDiv64:
		return rewriteValueMIPS64_OpDiv64(v, config)
	case OpDiv64F:
		return rewriteValueMIPS64_OpDiv64F(v, config)
	case OpDiv64u:
		return rewriteValueMIPS64_OpDiv64u(v, config)
	case OpDiv8:
		return rewriteValueMIPS64_OpDiv8(v, config)
	case OpDiv8u:
		return rewriteValueMIPS64_OpDiv8u(v, config)
	case OpEq16:
		return rewriteValueMIPS64_OpEq16(v, config)
	case OpEq32:
		return rewriteValueMIPS64_OpEq32(v, config)
	case OpEq32F:
		return rewriteValueMIPS64_OpEq32F(v, config)
	case OpEq64:
		return rewriteValueMIPS64_OpEq64(v, config)
	case OpEq64F:
		return rewriteValueMIPS64_OpEq64F(v, config)
	case OpEq8:
		return rewriteValueMIPS64_OpEq8(v, config)
	case OpEqB:
		return rewriteValueMIPS64_OpEqB(v, config)
	case OpEqPtr:
		return rewriteValueMIPS64_OpEqPtr(v, config)
	case OpGeq16:
		return rewriteValueMIPS64_OpGeq16(v, config)
	case OpGeq16U:
		return rewriteValueMIPS64_OpGeq16U(v, config)
	case OpGeq32:
		return rewriteValueMIPS64_OpGeq32(v, config)
	case OpGeq32F:
		return rewriteValueMIPS64_OpGeq32F(v, config)
	case OpGeq32U:
		return rewriteValueMIPS64_OpGeq32U(v, config)
	case OpGeq64:
		return rewriteValueMIPS64_OpGeq64(v, config)
	case OpGeq64F:
		return rewriteValueMIPS64_OpGeq64F(v, config)
	case OpGeq64U:
		return rewriteValueMIPS64_OpGeq64U(v, config)
	case OpGeq8:
		return rewriteValueMIPS64_OpGeq8(v, config)
	case OpGeq8U:
		return rewriteValueMIPS64_OpGeq8U(v, config)
	case OpGetClosurePtr:
		return rewriteValueMIPS64_OpGetClosurePtr(v, config)
	case OpGoCall:
		return rewriteValueMIPS64_OpGoCall(v, config)
	case OpGreater16:
		return rewriteValueMIPS64_OpGreater16(v, config)
	case OpGreater16U:
		return rewriteValueMIPS64_OpGreater16U(v, config)
	case OpGreater32:
		return rewriteValueMIPS64_OpGreater32(v, config)
	case OpGreater32F:
		return rewriteValueMIPS64_OpGreater32F(v, config)
	case OpGreater32U:
		return rewriteValueMIPS64_OpGreater32U(v, config)
	case OpGreater64:
		return rewriteValueMIPS64_OpGreater64(v, config)
	case OpGreater64F:
		return rewriteValueMIPS64_OpGreater64F(v, config)
	case OpGreater64U:
		return rewriteValueMIPS64_OpGreater64U(v, config)
	case OpGreater8:
		return rewriteValueMIPS64_OpGreater8(v, config)
	case OpGreater8U:
		return rewriteValueMIPS64_OpGreater8U(v, config)
	case OpHmul16:
		return rewriteValueMIPS64_OpHmul16(v, config)
	case OpHmul16u:
		return rewriteValueMIPS64_OpHmul16u(v, config)
	case OpHmul32:
		return rewriteValueMIPS64_OpHmul32(v, config)
	case OpHmul32u:
		return rewriteValueMIPS64_OpHmul32u(v, config)
	case OpHmul64:
		return rewriteValueMIPS64_OpHmul64(v, config)
	case OpHmul64u:
		return rewriteValueMIPS64_OpHmul64u(v, config)
	case OpHmul8:
		return rewriteValueMIPS64_OpHmul8(v, config)
	case OpHmul8u:
		return rewriteValueMIPS64_OpHmul8u(v, config)
	case OpInterCall:
		return rewriteValueMIPS64_OpInterCall(v, config)
	case OpIsInBounds:
		return rewriteValueMIPS64_OpIsInBounds(v, config)
	case OpIsNonNil:
		return rewriteValueMIPS64_OpIsNonNil(v, config)
	case OpIsSliceInBounds:
		return rewriteValueMIPS64_OpIsSliceInBounds(v, config)
	case OpLeq16:
		return rewriteValueMIPS64_OpLeq16(v, config)
	case OpLeq16U:
		return rewriteValueMIPS64_OpLeq16U(v, config)
	case OpLeq32:
		return rewriteValueMIPS64_OpLeq32(v, config)
	case OpLeq32F:
		return rewriteValueMIPS64_OpLeq32F(v, config)
	case OpLeq32U:
		return rewriteValueMIPS64_OpLeq32U(v, config)
	case OpLeq64:
		return rewriteValueMIPS64_OpLeq64(v, config)
	case OpLeq64F:
		return rewriteValueMIPS64_OpLeq64F(v, config)
	case OpLeq64U:
		return rewriteValueMIPS64_OpLeq64U(v, config)
	case OpLeq8:
		return rewriteValueMIPS64_OpLeq8(v, config)
	case OpLeq8U:
		return rewriteValueMIPS64_OpLeq8U(v, config)
	case OpLess16:
		return rewriteValueMIPS64_OpLess16(v, config)
	case OpLess16U:
		return rewriteValueMIPS64_OpLess16U(v, config)
	case OpLess32:
		return rewriteValueMIPS64_OpLess32(v, config)
	case OpLess32F:
		return rewriteValueMIPS64_OpLess32F(v, config)
	case OpLess32U:
		return rewriteValueMIPS64_OpLess32U(v, config)
	case OpLess64:
		return rewriteValueMIPS64_OpLess64(v, config)
	case OpLess64F:
		return rewriteValueMIPS64_OpLess64F(v, config)
	case OpLess64U:
		return rewriteValueMIPS64_OpLess64U(v, config)
	case OpLess8:
		return rewriteValueMIPS64_OpLess8(v, config)
	case OpLess8U:
		return rewriteValueMIPS64_OpLess8U(v, config)
	case OpLoad:
		return rewriteValueMIPS64_OpLoad(v, config)
	case OpLsh16x16:
		return rewriteValueMIPS64_OpLsh16x16(v, config)
	case OpLsh16x32:
		return rewriteValueMIPS64_OpLsh16x32(v, config)
	case OpLsh16x64:
		return rewriteValueMIPS64_OpLsh16x64(v, config)
	case OpLsh16x8:
		return rewriteValueMIPS64_OpLsh16x8(v, config)
	case OpLsh32x16:
		return rewriteValueMIPS64_OpLsh32x16(v, config)
	case OpLsh32x32:
		return rewriteValueMIPS64_OpLsh32x32(v, config)
	case OpLsh32x64:
		return rewriteValueMIPS64_OpLsh32x64(v, config)
	case OpLsh32x8:
		return rewriteValueMIPS64_OpLsh32x8(v, config)
	case OpLsh64x16:
		return rewriteValueMIPS64_OpLsh64x16(v, config)
	case OpLsh64x32:
		return rewriteValueMIPS64_OpLsh64x32(v, config)
	case OpLsh64x64:
		return rewriteValueMIPS64_OpLsh64x64(v, config)
	case OpLsh64x8:
		return rewriteValueMIPS64_OpLsh64x8(v, config)
	case OpLsh8x16:
		return rewriteValueMIPS64_OpLsh8x16(v, config)
	case OpLsh8x32:
		return rewriteValueMIPS64_OpLsh8x32(v, config)
	case OpLsh8x64:
		return rewriteValueMIPS64_OpLsh8x64(v, config)
	case OpLsh8x8:
		return rewriteValueMIPS64_OpLsh8x8(v, config)
	case OpMIPS64ADDV:
		return rewriteValueMIPS64_OpMIPS64ADDV(v, config)
	case OpMIPS64ADDVconst:
		return rewriteValueMIPS64_OpMIPS64ADDVconst(v, config)
	case OpMIPS64AND:
		return rewriteValueMIPS64_OpMIPS64AND(v, config)
	case OpMIPS64ANDconst:
		return rewriteValueMIPS64_OpMIPS64ANDconst(v, config)
	case OpMIPS64MOVBUload:
		return rewriteValueMIPS64_OpMIPS64MOVBUload(v, config)
	case OpMIPS64MOVBUreg:
		return rewriteValueMIPS64_OpMIPS64MOVBUreg(v, config)
	case OpMIPS64MOVBload:
		return rewriteValueMIPS64_OpMIPS64MOVBload(v, config)
	case OpMIPS64MOVBreg:
		return rewriteValueMIPS64_OpMIPS64MOVBreg(v, config)
	case OpMIPS64MOVBstore:
		return rewriteValueMIPS64_OpMIPS64MOVBstore(v, config)
	case OpMIPS64MOVBstorezero:
		return rewriteValueMIPS64_OpMIPS64MOVBstorezero(v, config)
	case OpMIPS64MOVDload:
		return rewriteValueMIPS64_OpMIPS64MOVDload(v, config)
	case OpMIPS64MOVDstore:
		return rewriteValueMIPS64_OpMIPS64MOVDstore(v, config)
	case OpMIPS64MOVFload:
		return rewriteValueMIPS64_OpMIPS64MOVFload(v, config)
	case OpMIPS64MOVFstore:
		return rewriteValueMIPS64_OpMIPS64MOVFstore(v, config)
	case OpMIPS64MOVHUload:
		return rewriteValueMIPS64_OpMIPS64MOVHUload(v, config)
	case OpMIPS64MOVHUreg:
		return rewriteValueMIPS64_OpMIPS64MOVHUreg(v, config)
	case OpMIPS64MOVHload:
		return rewriteValueMIPS64_OpMIPS64MOVHload(v, config)
	case OpMIPS64MOVHreg:
		return rewriteValueMIPS64_OpMIPS64MOVHreg(v, config)
	case OpMIPS64MOVHstore:
		return rewriteValueMIPS64_OpMIPS64MOVHstore(v, config)
	case OpMIPS64MOVHstorezero:
		return rewriteValueMIPS64_OpMIPS64MOVHstorezero(v, config)
	case OpMIPS64MOVVload:
		return rewriteValueMIPS64_OpMIPS64MOVVload(v, config)
	case OpMIPS64MOVVreg:
		return rewriteValueMIPS64_OpMIPS64MOVVreg(v, config)
	case OpMIPS64MOVVstore:
		return rewriteValueMIPS64_OpMIPS64MOVVstore(v, config)
	case OpMIPS64MOVVstorezero:
		return rewriteValueMIPS64_OpMIPS64MOVVstorezero(v, config)
	case OpMIPS64MOVWUload:
		return rewriteValueMIPS64_OpMIPS64MOVWUload(v, config)
	case OpMIPS64MOVWUreg:
		return rewriteValueMIPS64_OpMIPS64MOVWUreg(v, config)
	case OpMIPS64MOVWload:
		return rewriteValueMIPS64_OpMIPS64MOVWload(v, config)
	case OpMIPS64MOVWreg:
		return rewriteValueMIPS64_OpMIPS64MOVWreg(v, config)
	case OpMIPS64MOVWstore:
		return rewriteValueMIPS64_OpMIPS64MOVWstore(v, config)
	case OpMIPS64MOVWstorezero:
		return rewriteValueMIPS64_OpMIPS64MOVWstorezero(v, config)
	case OpMIPS64NEGV:
		return rewriteValueMIPS64_OpMIPS64NEGV(v, config)
	case OpMIPS64NOR:
		return rewriteValueMIPS64_OpMIPS64NOR(v, config)
	case OpMIPS64NORconst:
		return rewriteValueMIPS64_OpMIPS64NORconst(v, config)
	case OpMIPS64OR:
		return rewriteValueMIPS64_OpMIPS64OR(v, config)
	case OpMIPS64ORconst:
		return rewriteValueMIPS64_OpMIPS64ORconst(v, config)
	case OpMIPS64SGT:
		return rewriteValueMIPS64_OpMIPS64SGT(v, config)
	case OpMIPS64SGTU:
		return rewriteValueMIPS64_OpMIPS64SGTU(v, config)
	case OpMIPS64SGTUconst:
		return rewriteValueMIPS64_OpMIPS64SGTUconst(v, config)
	case OpMIPS64SGTconst:
		return rewriteValueMIPS64_OpMIPS64SGTconst(v, config)
	case OpMIPS64SLLV:
		return rewriteValueMIPS64_OpMIPS64SLLV(v, config)
	case OpMIPS64SLLVconst:
		return rewriteValueMIPS64_OpMIPS64SLLVconst(v, config)
	case OpMIPS64SRAV:
		return rewriteValueMIPS64_OpMIPS64SRAV(v, config)
	case OpMIPS64SRAVconst:
		return rewriteValueMIPS64_OpMIPS64SRAVconst(v, config)
	case OpMIPS64SRLV:
		return rewriteValueMIPS64_OpMIPS64SRLV(v, config)
	case OpMIPS64SRLVconst:
		return rewriteValueMIPS64_OpMIPS64SRLVconst(v, config)
	case OpMIPS64SUBV:
		return rewriteValueMIPS64_OpMIPS64SUBV(v, config)
	case OpMIPS64SUBVconst:
		return rewriteValueMIPS64_OpMIPS64SUBVconst(v, config)
	case OpMIPS64XOR:
		return rewriteValueMIPS64_OpMIPS64XOR(v, config)
	case OpMIPS64XORconst:
		return rewriteValueMIPS64_OpMIPS64XORconst(v, config)
	case OpMod16:
		return rewriteValueMIPS64_OpMod16(v, config)
	case OpMod16u:
		return rewriteValueMIPS64_OpMod16u(v, config)
	case OpMod32:
		return rewriteValueMIPS64_OpMod32(v, config)
	case OpMod32u:
		return rewriteValueMIPS64_OpMod32u(v, config)
	case OpMod64:
		return rewriteValueMIPS64_OpMod64(v, config)
	case OpMod64u:
		return rewriteValueMIPS64_OpMod64u(v, config)
	case OpMod8:
		return rewriteValueMIPS64_OpMod8(v, config)
	case OpMod8u:
		return rewriteValueMIPS64_OpMod8u(v, config)
	case OpMove:
		return rewriteValueMIPS64_OpMove(v, config)
	case OpMul16:
		return rewriteValueMIPS64_OpMul16(v, config)
	case OpMul32:
		return rewriteValueMIPS64_OpMul32(v, config)
	case OpMul32F:
		return rewriteValueMIPS64_OpMul32F(v, config)
	case OpMul64:
		return rewriteValueMIPS64_OpMul64(v, config)
	case OpMul64F:
		return rewriteValueMIPS64_OpMul64F(v, config)
	case OpMul8:
		return rewriteValueMIPS64_OpMul8(v, config)
	case OpNeg16:
		return rewriteValueMIPS64_OpNeg16(v, config)
	case OpNeg32:
		return rewriteValueMIPS64_OpNeg32(v, config)
	case OpNeg32F:
		return rewriteValueMIPS64_OpNeg32F(v, config)
	case OpNeg64:
		return rewriteValueMIPS64_OpNeg64(v, config)
	case OpNeg64F:
		return rewriteValueMIPS64_OpNeg64F(v, config)
	case OpNeg8:
		return rewriteValueMIPS64_OpNeg8(v, config)
	case OpNeq16:
		return rewriteValueMIPS64_OpNeq16(v, config)
	case OpNeq32:
		return rewriteValueMIPS64_OpNeq32(v, config)
	case OpNeq32F:
		return rewriteValueMIPS64_OpNeq32F(v, config)
	case OpNeq64:
		return rewriteValueMIPS64_OpNeq64(v, config)
	case OpNeq64F:
		return rewriteValueMIPS64_OpNeq64F(v, config)
	case OpNeq8:
		return rewriteValueMIPS64_OpNeq8(v, config)
	case OpNeqB:
		return rewriteValueMIPS64_OpNeqB(v, config)
	case OpNeqPtr:
		return rewriteValueMIPS64_OpNeqPtr(v, config)
	case OpNilCheck:
		return rewriteValueMIPS64_OpNilCheck(v, config)
	case OpNot:
		return rewriteValueMIPS64_OpNot(v, config)
	case OpOffPtr:
		return rewriteValueMIPS64_OpOffPtr(v, config)
	case OpOr16:
		return rewriteValueMIPS64_OpOr16(v, config)
	case OpOr32:
		return rewriteValueMIPS64_OpOr32(v, config)
	case OpOr64:
		return rewriteValueMIPS64_OpOr64(v, config)
	case OpOr8:
		return rewriteValueMIPS64_OpOr8(v, config)
	case OpOrB:
		return rewriteValueMIPS64_OpOrB(v, config)
	case OpRsh16Ux16:
		return rewriteValueMIPS64_OpRsh16Ux16(v, config)
	case OpRsh16Ux32:
		return rewriteValueMIPS64_OpRsh16Ux32(v, config)
	case OpRsh16Ux64:
		return rewriteValueMIPS64_OpRsh16Ux64(v, config)
	case OpRsh16Ux8:
		return rewriteValueMIPS64_OpRsh16Ux8(v, config)
	case OpRsh16x16:
		return rewriteValueMIPS64_OpRsh16x16(v, config)
	case OpRsh16x32:
		return rewriteValueMIPS64_OpRsh16x32(v, config)
	case OpRsh16x64:
		return rewriteValueMIPS64_OpRsh16x64(v, config)
	case OpRsh16x8:
		return rewriteValueMIPS64_OpRsh16x8(v, config)
	case OpRsh32Ux16:
		return rewriteValueMIPS64_OpRsh32Ux16(v, config)
	case OpRsh32Ux32:
		return rewriteValueMIPS64_OpRsh32Ux32(v, config)
	case OpRsh32Ux64:
		return rewriteValueMIPS64_OpRsh32Ux64(v, config)
	case OpRsh32Ux8:
		return rewriteValueMIPS64_OpRsh32Ux8(v, config)
	case OpRsh32x16:
		return rewriteValueMIPS64_OpRsh32x16(v, config)
	case OpRsh32x32:
		return rewriteValueMIPS64_OpRsh32x32(v, config)
	case OpRsh32x64:
		return rewriteValueMIPS64_OpRsh32x64(v, config)
	case OpRsh32x8:
		return rewriteValueMIPS64_OpRsh32x8(v, config)
	case OpRsh64Ux16:
		return rewriteValueMIPS64_OpRsh64Ux16(v, config)
	case OpRsh64Ux32:
		return rewriteValueMIPS64_OpRsh64Ux32(v, config)
	case OpRsh64Ux64:
		return rewriteValueMIPS64_OpRsh64Ux64(v, config)
	case OpRsh64Ux8:
		return rewriteValueMIPS64_OpRsh64Ux8(v, config)
	case OpRsh64x16:
		return rewriteValueMIPS64_OpRsh64x16(v, config)
	case OpRsh64x32:
		return rewriteValueMIPS64_OpRsh64x32(v, config)
	case OpRsh64x64:
		return rewriteValueMIPS64_OpRsh64x64(v, config)
	case OpRsh64x8:
		return rewriteValueMIPS64_OpRsh64x8(v, config)
	case OpRsh8Ux16:
		return rewriteValueMIPS64_OpRsh8Ux16(v, config)
	case OpRsh8Ux32:
		return rewriteValueMIPS64_OpRsh8Ux32(v, config)
	case OpRsh8Ux64:
		return rewriteValueMIPS64_OpRsh8Ux64(v, config)
	case OpRsh8Ux8:
		return rewriteValueMIPS64_OpRsh8Ux8(v, config)
	case OpRsh8x16:
		return rewriteValueMIPS64_OpRsh8x16(v, config)
	case OpRsh8x32:
		return rewriteValueMIPS64_OpRsh8x32(v, config)
	case OpRsh8x64:
		return rewriteValueMIPS64_OpRsh8x64(v, config)
	case OpRsh8x8:
		return rewriteValueMIPS64_OpRsh8x8(v, config)
	case OpSelect0:
		return rewriteValueMIPS64_OpSelect0(v, config)
	case OpSelect1:
		return rewriteValueMIPS64_OpSelect1(v, config)
	case OpSignExt16to32:
		return rewriteValueMIPS64_OpSignExt16to32(v, config)
	case OpSignExt16to64:
		return rewriteValueMIPS64_OpSignExt16to64(v, config)
	case OpSignExt32to64:
		return rewriteValueMIPS64_OpSignExt32to64(v, config)
	case OpSignExt8to16:
		return rewriteValueMIPS64_OpSignExt8to16(v, config)
	case OpSignExt8to32:
		return rewriteValueMIPS64_OpSignExt8to32(v, config)
	case OpSignExt8to64:
		return rewriteValueMIPS64_OpSignExt8to64(v, config)
	case OpSlicemask:
		return rewriteValueMIPS64_OpSlicemask(v, config)
	case OpStaticCall:
		return rewriteValueMIPS64_OpStaticCall(v, config)
	case OpStore:
		return rewriteValueMIPS64_OpStore(v, config)
	case OpSub16:
		return rewriteValueMIPS64_OpSub16(v, config)
	case OpSub32:
		return rewriteValueMIPS64_OpSub32(v, config)
	case OpSub32F:
		return rewriteValueMIPS64_OpSub32F(v, config)
	case OpSub64:
		return rewriteValueMIPS64_OpSub64(v, config)
	case OpSub64F:
		return rewriteValueMIPS64_OpSub64F(v, config)
	case OpSub8:
		return rewriteValueMIPS64_OpSub8(v, config)
	case OpSubPtr:
		return rewriteValueMIPS64_OpSubPtr(v, config)
	case OpTrunc16to8:
		return rewriteValueMIPS64_OpTrunc16to8(v, config)
	case OpTrunc32to16:
		return rewriteValueMIPS64_OpTrunc32to16(v, config)
	case OpTrunc32to8:
		return rewriteValueMIPS64_OpTrunc32to8(v, config)
	case OpTrunc64to16:
		return rewriteValueMIPS64_OpTrunc64to16(v, config)
	case OpTrunc64to32:
		return rewriteValueMIPS64_OpTrunc64to32(v, config)
	case OpTrunc64to8:
		return rewriteValueMIPS64_OpTrunc64to8(v, config)
	case OpXor16:
		return rewriteValueMIPS64_OpXor16(v, config)
	case OpXor32:
		return rewriteValueMIPS64_OpXor32(v, config)
	case OpXor64:
		return rewriteValueMIPS64_OpXor64(v, config)
	case OpXor8:
		return rewriteValueMIPS64_OpXor8(v, config)
	case OpZero:
		return rewriteValueMIPS64_OpZero(v, config)
	case OpZeroExt16to32:
		return rewriteValueMIPS64_OpZeroExt16to32(v, config)
	case OpZeroExt16to64:
		return rewriteValueMIPS64_OpZeroExt16to64(v, config)
	case OpZeroExt32to64:
		return rewriteValueMIPS64_OpZeroExt32to64(v, config)
	case OpZeroExt8to16:
		return rewriteValueMIPS64_OpZeroExt8to16(v, config)
	case OpZeroExt8to32:
		return rewriteValueMIPS64_OpZeroExt8to32(v, config)
	case OpZeroExt8to64:
		return rewriteValueMIPS64_OpZeroExt8to64(v, config)
	}
	return false
}
func rewriteValueMIPS64_OpAdd16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Add16 x y)
	// cond:
	// result: (ADDV x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64ADDV)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpAdd32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Add32 x y)
	// cond:
	// result: (ADDV x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64ADDV)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpAdd32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Add32F x y)
	// cond:
	// result: (ADDF x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64ADDF)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpAdd64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Add64 x y)
	// cond:
	// result: (ADDV x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64ADDV)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpAdd64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Add64F x y)
	// cond:
	// result: (ADDD x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64ADDD)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpAdd8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Add8 x y)
	// cond:
	// result: (ADDV x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64ADDV)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpAddPtr(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (AddPtr x y)
	// cond:
	// result: (ADDV x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64ADDV)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpAddr(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Addr {sym} base)
	// cond:
	// result: (MOVVaddr {sym} base)
	for {
		sym := v.Aux
		base := v.Args[0]
		v.reset(OpMIPS64MOVVaddr)
		v.Aux = sym
		v.AddArg(base)
		return true
	}
}
func rewriteValueMIPS64_OpAnd16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (And16 x y)
	// cond:
	// result: (AND x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpAnd32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (And32 x y)
	// cond:
	// result: (AND x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpAnd64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (And64 x y)
	// cond:
	// result: (AND x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpAnd8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (And8 x y)
	// cond:
	// result: (AND x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpAndB(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (AndB x y)
	// cond:
	// result: (AND x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpAvg64u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Avg64u <t> x y)
	// cond:
	// result: (ADDV (ADDV <t> (SRLVconst <t> x [1]) (SRLVconst <t> y [1])) (AND <t> (AND <t> x y) (MOVVconst [1])))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64ADDV)
		v0 := b.NewValue0(v.Line, OpMIPS64ADDV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SRLVconst, t)
		v1.AuxInt = 1
		v1.AddArg(x)
		v0.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpMIPS64SRLVconst, t)
		v2.AuxInt = 1
		v2.AddArg(y)
		v0.AddArg(v2)
		v.AddArg(v0)
		v3 := b.NewValue0(v.Line, OpMIPS64AND, t)
		v4 := b.NewValue0(v.Line, OpMIPS64AND, t)
		v4.AddArg(x)
		v4.AddArg(y)
		v3.AddArg(v4)
		v5 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v5.AuxInt = 1
		v3.AddArg(v5)
		v.AddArg(v3)
		return true
	}
}
func rewriteValueMIPS64_OpClosureCall(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ClosureCall [argwid] entry closure mem)
	// cond:
	// result: (CALLclosure [argwid] entry closure mem)
	for {
		argwid := v.AuxInt
		entry := v.Args[0]
		closure := v.Args[1]
		mem := v.Args[2]
		v.reset(OpMIPS64CALLclosure)
		v.AuxInt = argwid
		v.AddArg(entry)
		v.AddArg(closure)
		v.AddArg(mem)
		return true
	}
}
func rewriteValueMIPS64_OpCom16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Com16 x)
	// cond:
	// result: (NOR (MOVVconst [0]) x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64NOR)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpCom32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Com32 x)
	// cond:
	// result: (NOR (MOVVconst [0]) x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64NOR)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpCom64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Com64 x)
	// cond:
	// result: (NOR (MOVVconst [0]) x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64NOR)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpCom8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Com8 x)
	// cond:
	// result: (NOR (MOVVconst [0]) x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64NOR)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpConst16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Const16 [val])
	// cond:
	// result: (MOVVconst [val])
	for {
		val := v.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = val
		return true
	}
}
func rewriteValueMIPS64_OpConst32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Const32 [val])
	// cond:
	// result: (MOVVconst [val])
	for {
		val := v.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = val
		return true
	}
}
func rewriteValueMIPS64_OpConst32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Const32F [val])
	// cond:
	// result: (MOVFconst [val])
	for {
		val := v.AuxInt
		v.reset(OpMIPS64MOVFconst)
		v.AuxInt = val
		return true
	}
}
func rewriteValueMIPS64_OpConst64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Const64 [val])
	// cond:
	// result: (MOVVconst [val])
	for {
		val := v.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = val
		return true
	}
}
func rewriteValueMIPS64_OpConst64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Const64F [val])
	// cond:
	// result: (MOVDconst [val])
	for {
		val := v.AuxInt
		v.reset(OpMIPS64MOVDconst)
		v.AuxInt = val
		return true
	}
}
func rewriteValueMIPS64_OpConst8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Const8 [val])
	// cond:
	// result: (MOVVconst [val])
	for {
		val := v.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = val
		return true
	}
}
func rewriteValueMIPS64_OpConstBool(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ConstBool [b])
	// cond:
	// result: (MOVVconst [b])
	for {
		b := v.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = b
		return true
	}
}
func rewriteValueMIPS64_OpConstNil(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ConstNil)
	// cond:
	// result: (MOVVconst [0])
	for {
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 0
		return true
	}
}
func rewriteValueMIPS64_OpConvert(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Convert x mem)
	// cond:
	// result: (MOVVconvert x mem)
	for {
		x := v.Args[0]
		mem := v.Args[1]
		v.reset(OpMIPS64MOVVconvert)
		v.AddArg(x)
		v.AddArg(mem)
		return true
	}
}
func rewriteValueMIPS64_OpCvt32Fto32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Cvt32Fto32 x)
	// cond:
	// result: (TRUNCFW x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64TRUNCFW)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpCvt32Fto64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Cvt32Fto64 x)
	// cond:
	// result: (TRUNCFV x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64TRUNCFV)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpCvt32Fto64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Cvt32Fto64F x)
	// cond:
	// result: (MOVFD x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64MOVFD)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpCvt32to32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Cvt32to32F x)
	// cond:
	// result: (MOVWF x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64MOVWF)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpCvt32to64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Cvt32to64F x)
	// cond:
	// result: (MOVWD x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64MOVWD)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpCvt64Fto32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Cvt64Fto32 x)
	// cond:
	// result: (TRUNCDW x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64TRUNCDW)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpCvt64Fto32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Cvt64Fto32F x)
	// cond:
	// result: (MOVDF x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64MOVDF)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpCvt64Fto64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Cvt64Fto64 x)
	// cond:
	// result: (TRUNCDV x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64TRUNCDV)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpCvt64to32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Cvt64to32F x)
	// cond:
	// result: (MOVVF x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64MOVVF)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpCvt64to64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Cvt64to64F x)
	// cond:
	// result: (MOVVD x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64MOVVD)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpDeferCall(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (DeferCall [argwid] mem)
	// cond:
	// result: (CALLdefer [argwid] mem)
	for {
		argwid := v.AuxInt
		mem := v.Args[0]
		v.reset(OpMIPS64CALLdefer)
		v.AuxInt = argwid
		v.AddArg(mem)
		return true
	}
}
func rewriteValueMIPS64_OpDiv16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div16 x y)
	// cond:
	// result: (Select1 (DIVV (SignExt16to64 x) (SignExt16to64 y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpSelect1)
		v0 := b.NewValue0(v.Line, OpMIPS64DIVV, MakeTuple(config.fe.TypeInt64(), config.fe.TypeInt64()))
		v1 := b.NewValue0(v.Line, OpSignExt16to64, config.fe.TypeInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpSignExt16to64, config.fe.TypeInt64())
		v2.AddArg(y)
		v0.AddArg(v2)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpDiv16u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div16u x y)
	// cond:
	// result: (Select1 (DIVVU (ZeroExt16to64 x) (ZeroExt16to64 y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpSelect1)
		v0 := b.NewValue0(v.Line, OpMIPS64DIVVU, MakeTuple(config.fe.TypeUInt64(), config.fe.TypeUInt64()))
		v1 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v2.AddArg(y)
		v0.AddArg(v2)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpDiv32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div32 x y)
	// cond:
	// result: (Select1 (DIVV (SignExt32to64 x) (SignExt32to64 y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpSelect1)
		v0 := b.NewValue0(v.Line, OpMIPS64DIVV, MakeTuple(config.fe.TypeInt64(), config.fe.TypeInt64()))
		v1 := b.NewValue0(v.Line, OpSignExt32to64, config.fe.TypeInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpSignExt32to64, config.fe.TypeInt64())
		v2.AddArg(y)
		v0.AddArg(v2)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpDiv32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div32F x y)
	// cond:
	// result: (DIVF x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64DIVF)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpDiv32u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div32u x y)
	// cond:
	// result: (Select1 (DIVVU (ZeroExt32to64 x) (ZeroExt32to64 y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpSelect1)
		v0 := b.NewValue0(v.Line, OpMIPS64DIVVU, MakeTuple(config.fe.TypeUInt64(), config.fe.TypeUInt64()))
		v1 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v2.AddArg(y)
		v0.AddArg(v2)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpDiv64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div64 x y)
	// cond:
	// result: (Select1 (DIVV x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpSelect1)
		v0 := b.NewValue0(v.Line, OpMIPS64DIVV, MakeTuple(config.fe.TypeInt64(), config.fe.TypeInt64()))
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpDiv64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div64F x y)
	// cond:
	// result: (DIVD x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64DIVD)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpDiv64u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div64u x y)
	// cond:
	// result: (Select1 (DIVVU x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpSelect1)
		v0 := b.NewValue0(v.Line, OpMIPS64DIVVU, MakeTuple(config.fe.TypeUInt64(), config.fe.TypeUInt64()))
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpDiv8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div8 x y)
	// cond:
	// result: (Select1 (DIVV (SignExt8to64 x) (SignExt8to64 y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpSelect1)
		v0 := b.NewValue0(v.Line, OpMIPS64DIVV, MakeTuple(config.fe.TypeInt64(), config.fe.TypeInt64()))
		v1 := b.NewValue0(v.Line, OpSignExt8to64, config.fe.TypeInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpSignExt8to64, config.fe.TypeInt64())
		v2.AddArg(y)
		v0.AddArg(v2)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpDiv8u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Div8u x y)
	// cond:
	// result: (Select1 (DIVVU (ZeroExt8to64 x) (ZeroExt8to64 y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpSelect1)
		v0 := b.NewValue0(v.Line, OpMIPS64DIVVU, MakeTuple(config.fe.TypeUInt64(), config.fe.TypeUInt64()))
		v1 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v2.AddArg(y)
		v0.AddArg(v2)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpEq16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Eq16 x y)
	// cond:
	// result: (SGTU (MOVVconst [1]) (XOR (ZeroExt16to64 x) (ZeroExt16to64 y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SGTU)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 1
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64XOR, config.fe.TypeUInt64())
		v2 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v2.AddArg(x)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpEq32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Eq32 x y)
	// cond:
	// result: (SGTU (MOVVconst [1]) (XOR (ZeroExt32to64 x) (ZeroExt32to64 y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SGTU)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 1
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64XOR, config.fe.TypeUInt64())
		v2 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v2.AddArg(x)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpEq32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Eq32F x y)
	// cond:
	// result: (FPFlagTrue (CMPEQF x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64FPFlagTrue)
		v0 := b.NewValue0(v.Line, OpMIPS64CMPEQF, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpEq64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Eq64 x y)
	// cond:
	// result: (SGTU (MOVVconst [1]) (XOR x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SGTU)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 1
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64XOR, config.fe.TypeUInt64())
		v1.AddArg(x)
		v1.AddArg(y)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpEq64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Eq64F x y)
	// cond:
	// result: (FPFlagTrue (CMPEQD x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64FPFlagTrue)
		v0 := b.NewValue0(v.Line, OpMIPS64CMPEQD, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpEq8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Eq8 x y)
	// cond:
	// result: (SGTU (MOVVconst [1]) (XOR (ZeroExt8to64 x) (ZeroExt8to64 y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SGTU)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 1
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64XOR, config.fe.TypeUInt64())
		v2 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v2.AddArg(x)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpEqB(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (EqB x y)
	// cond:
	// result: (XOR (MOVVconst [1]) (XOR <config.fe.TypeBool()> x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64XOR)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 1
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64XOR, config.fe.TypeBool())
		v1.AddArg(x)
		v1.AddArg(y)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpEqPtr(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (EqPtr x y)
	// cond:
	// result: (SGTU (MOVVconst [1]) (XOR x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SGTU)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 1
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64XOR, config.fe.TypeUInt64())
		v1.AddArg(x)
		v1.AddArg(y)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpGeq16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq16 x y)
	// cond:
	// result: (XOR (MOVVconst [1]) (SGT (SignExt16to64 y) (SignExt16to64 x)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64XOR)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 1
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64SGT, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpSignExt16to64, config.fe.TypeInt64())
		v2.AddArg(y)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpSignExt16to64, config.fe.TypeInt64())
		v3.AddArg(x)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpGeq16U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq16U x y)
	// cond:
	// result: (XOR (MOVVconst [1]) (SGTU (ZeroExt16to64 y) (ZeroExt16to64 x)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64XOR)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 1
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v2.AddArg(y)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v3.AddArg(x)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpGeq32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq32 x y)
	// cond:
	// result: (XOR (MOVVconst [1]) (SGT (SignExt32to64 y) (SignExt32to64 x)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64XOR)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 1
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64SGT, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpSignExt32to64, config.fe.TypeInt64())
		v2.AddArg(y)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpSignExt32to64, config.fe.TypeInt64())
		v3.AddArg(x)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpGeq32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq32F x y)
	// cond:
	// result: (FPFlagTrue (CMPGEF x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64FPFlagTrue)
		v0 := b.NewValue0(v.Line, OpMIPS64CMPGEF, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpGeq32U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq32U x y)
	// cond:
	// result: (XOR (MOVVconst [1]) (SGTU (ZeroExt32to64 y) (ZeroExt32to64 x)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64XOR)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 1
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v2.AddArg(y)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v3.AddArg(x)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpGeq64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq64 x y)
	// cond:
	// result: (XOR (MOVVconst [1]) (SGT y x))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64XOR)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 1
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64SGT, config.fe.TypeBool())
		v1.AddArg(y)
		v1.AddArg(x)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpGeq64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq64F x y)
	// cond:
	// result: (FPFlagTrue (CMPGED x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64FPFlagTrue)
		v0 := b.NewValue0(v.Line, OpMIPS64CMPGED, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpGeq64U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq64U x y)
	// cond:
	// result: (XOR (MOVVconst [1]) (SGTU y x))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64XOR)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 1
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v1.AddArg(y)
		v1.AddArg(x)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpGeq8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq8 x y)
	// cond:
	// result: (XOR (MOVVconst [1]) (SGT (SignExt8to64 y) (SignExt8to64 x)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64XOR)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 1
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64SGT, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpSignExt8to64, config.fe.TypeInt64())
		v2.AddArg(y)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpSignExt8to64, config.fe.TypeInt64())
		v3.AddArg(x)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpGeq8U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Geq8U x y)
	// cond:
	// result: (XOR (MOVVconst [1]) (SGTU (ZeroExt8to64 y) (ZeroExt8to64 x)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64XOR)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 1
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v2.AddArg(y)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v3.AddArg(x)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpGetClosurePtr(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (GetClosurePtr)
	// cond:
	// result: (LoweredGetClosurePtr)
	for {
		v.reset(OpMIPS64LoweredGetClosurePtr)
		return true
	}
}
func rewriteValueMIPS64_OpGoCall(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (GoCall [argwid] mem)
	// cond:
	// result: (CALLgo [argwid] mem)
	for {
		argwid := v.AuxInt
		mem := v.Args[0]
		v.reset(OpMIPS64CALLgo)
		v.AuxInt = argwid
		v.AddArg(mem)
		return true
	}
}
func rewriteValueMIPS64_OpGreater16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater16 x y)
	// cond:
	// result: (SGT (SignExt16to64 x) (SignExt16to64 y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SGT)
		v0 := b.NewValue0(v.Line, OpSignExt16to64, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpSignExt16to64, config.fe.TypeInt64())
		v1.AddArg(y)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpGreater16U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater16U x y)
	// cond:
	// result: (SGTU (ZeroExt16to64 x) (ZeroExt16to64 y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SGTU)
		v0 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v1.AddArg(y)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpGreater32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater32 x y)
	// cond:
	// result: (SGT (SignExt32to64 x) (SignExt32to64 y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SGT)
		v0 := b.NewValue0(v.Line, OpSignExt32to64, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpSignExt32to64, config.fe.TypeInt64())
		v1.AddArg(y)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpGreater32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater32F x y)
	// cond:
	// result: (FPFlagTrue (CMPGTF x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64FPFlagTrue)
		v0 := b.NewValue0(v.Line, OpMIPS64CMPGTF, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpGreater32U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater32U x y)
	// cond:
	// result: (SGTU (ZeroExt32to64 x) (ZeroExt32to64 y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SGTU)
		v0 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v1.AddArg(y)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpGreater64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater64 x y)
	// cond:
	// result: (SGT x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SGT)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpGreater64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater64F x y)
	// cond:
	// result: (FPFlagTrue (CMPGTD x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64FPFlagTrue)
		v0 := b.NewValue0(v.Line, OpMIPS64CMPGTD, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpGreater64U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater64U x y)
	// cond:
	// result: (SGTU x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SGTU)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpGreater8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater8 x y)
	// cond:
	// result: (SGT (SignExt8to64 x) (SignExt8to64 y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SGT)
		v0 := b.NewValue0(v.Line, OpSignExt8to64, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpSignExt8to64, config.fe.TypeInt64())
		v1.AddArg(y)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpGreater8U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Greater8U x y)
	// cond:
	// result: (SGTU (ZeroExt8to64 x) (ZeroExt8to64 y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SGTU)
		v0 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v1.AddArg(y)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpHmul16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Hmul16 x y)
	// cond:
	// result: (SRAVconst (Select1 <config.fe.TypeInt32()> (MULV (SignExt16to64 x) (SignExt16to64 y))) [16])
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SRAVconst)
		v.AuxInt = 16
		v0 := b.NewValue0(v.Line, OpSelect1, config.fe.TypeInt32())
		v1 := b.NewValue0(v.Line, OpMIPS64MULV, MakeTuple(config.fe.TypeInt64(), config.fe.TypeInt64()))
		v2 := b.NewValue0(v.Line, OpSignExt16to64, config.fe.TypeInt64())
		v2.AddArg(x)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpSignExt16to64, config.fe.TypeInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpHmul16u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Hmul16u x y)
	// cond:
	// result: (SRLVconst (Select1 <config.fe.TypeUInt32()> (MULVU (ZeroExt16to64 x) (ZeroExt16to64 y))) [16])
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SRLVconst)
		v.AuxInt = 16
		v0 := b.NewValue0(v.Line, OpSelect1, config.fe.TypeUInt32())
		v1 := b.NewValue0(v.Line, OpMIPS64MULVU, MakeTuple(config.fe.TypeUInt64(), config.fe.TypeUInt64()))
		v2 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v2.AddArg(x)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpHmul32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Hmul32 x y)
	// cond:
	// result: (SRAVconst (Select1 <config.fe.TypeInt64()> (MULV (SignExt32to64 x) (SignExt32to64 y))) [32])
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SRAVconst)
		v.AuxInt = 32
		v0 := b.NewValue0(v.Line, OpSelect1, config.fe.TypeInt64())
		v1 := b.NewValue0(v.Line, OpMIPS64MULV, MakeTuple(config.fe.TypeInt64(), config.fe.TypeInt64()))
		v2 := b.NewValue0(v.Line, OpSignExt32to64, config.fe.TypeInt64())
		v2.AddArg(x)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpSignExt32to64, config.fe.TypeInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpHmul32u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Hmul32u x y)
	// cond:
	// result: (SRLVconst (Select1 <config.fe.TypeUInt64()> (MULVU (ZeroExt32to64 x) (ZeroExt32to64 y))) [32])
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SRLVconst)
		v.AuxInt = 32
		v0 := b.NewValue0(v.Line, OpSelect1, config.fe.TypeUInt64())
		v1 := b.NewValue0(v.Line, OpMIPS64MULVU, MakeTuple(config.fe.TypeUInt64(), config.fe.TypeUInt64()))
		v2 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v2.AddArg(x)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpHmul64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Hmul64 x y)
	// cond:
	// result: (Select0 (MULV x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpSelect0)
		v0 := b.NewValue0(v.Line, OpMIPS64MULV, MakeTuple(config.fe.TypeInt64(), config.fe.TypeInt64()))
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpHmul64u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Hmul64u x y)
	// cond:
	// result: (Select0 (MULVU x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpSelect0)
		v0 := b.NewValue0(v.Line, OpMIPS64MULVU, MakeTuple(config.fe.TypeUInt64(), config.fe.TypeUInt64()))
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpHmul8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Hmul8 x y)
	// cond:
	// result: (SRAVconst (Select1 <config.fe.TypeInt16()> (MULV (SignExt8to64 x) (SignExt8to64 y))) [8])
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SRAVconst)
		v.AuxInt = 8
		v0 := b.NewValue0(v.Line, OpSelect1, config.fe.TypeInt16())
		v1 := b.NewValue0(v.Line, OpMIPS64MULV, MakeTuple(config.fe.TypeInt64(), config.fe.TypeInt64()))
		v2 := b.NewValue0(v.Line, OpSignExt8to64, config.fe.TypeInt64())
		v2.AddArg(x)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpSignExt8to64, config.fe.TypeInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpHmul8u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Hmul8u x y)
	// cond:
	// result: (SRLVconst (Select1 <config.fe.TypeUInt16()> (MULVU (ZeroExt8to64 x) (ZeroExt8to64 y))) [8])
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SRLVconst)
		v.AuxInt = 8
		v0 := b.NewValue0(v.Line, OpSelect1, config.fe.TypeUInt16())
		v1 := b.NewValue0(v.Line, OpMIPS64MULVU, MakeTuple(config.fe.TypeUInt64(), config.fe.TypeUInt64()))
		v2 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v2.AddArg(x)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpInterCall(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (InterCall [argwid] entry mem)
	// cond:
	// result: (CALLinter [argwid] entry mem)
	for {
		argwid := v.AuxInt
		entry := v.Args[0]
		mem := v.Args[1]
		v.reset(OpMIPS64CALLinter)
		v.AuxInt = argwid
		v.AddArg(entry)
		v.AddArg(mem)
		return true
	}
}
func rewriteValueMIPS64_OpIsInBounds(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (IsInBounds idx len)
	// cond:
	// result: (SGTU len idx)
	for {
		idx := v.Args[0]
		len := v.Args[1]
		v.reset(OpMIPS64SGTU)
		v.AddArg(len)
		v.AddArg(idx)
		return true
	}
}
func rewriteValueMIPS64_OpIsNonNil(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (IsNonNil ptr)
	// cond:
	// result: (SGTU ptr (MOVVconst [0]))
	for {
		ptr := v.Args[0]
		v.reset(OpMIPS64SGTU)
		v.AddArg(ptr)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpIsSliceInBounds(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (IsSliceInBounds idx len)
	// cond:
	// result: (XOR (MOVVconst [1]) (SGTU idx len))
	for {
		idx := v.Args[0]
		len := v.Args[1]
		v.reset(OpMIPS64XOR)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 1
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v1.AddArg(idx)
		v1.AddArg(len)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpLeq16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq16 x y)
	// cond:
	// result: (XOR (MOVVconst [1]) (SGT (SignExt16to64 x) (SignExt16to64 y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64XOR)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 1
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64SGT, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpSignExt16to64, config.fe.TypeInt64())
		v2.AddArg(x)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpSignExt16to64, config.fe.TypeInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpLeq16U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq16U x y)
	// cond:
	// result: (XOR (MOVVconst [1]) (SGTU (ZeroExt16to64 x) (ZeroExt16to64 y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64XOR)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 1
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v2.AddArg(x)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpLeq32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq32 x y)
	// cond:
	// result: (XOR (MOVVconst [1]) (SGT (SignExt32to64 x) (SignExt32to64 y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64XOR)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 1
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64SGT, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpSignExt32to64, config.fe.TypeInt64())
		v2.AddArg(x)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpSignExt32to64, config.fe.TypeInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpLeq32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq32F x y)
	// cond:
	// result: (FPFlagTrue (CMPGEF y x))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64FPFlagTrue)
		v0 := b.NewValue0(v.Line, OpMIPS64CMPGEF, TypeFlags)
		v0.AddArg(y)
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpLeq32U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq32U x y)
	// cond:
	// result: (XOR (MOVVconst [1]) (SGTU (ZeroExt32to64 x) (ZeroExt32to64 y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64XOR)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 1
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v2.AddArg(x)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpLeq64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq64 x y)
	// cond:
	// result: (XOR (MOVVconst [1]) (SGT x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64XOR)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 1
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64SGT, config.fe.TypeBool())
		v1.AddArg(x)
		v1.AddArg(y)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpLeq64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq64F x y)
	// cond:
	// result: (FPFlagTrue (CMPGED y x))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64FPFlagTrue)
		v0 := b.NewValue0(v.Line, OpMIPS64CMPGED, TypeFlags)
		v0.AddArg(y)
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpLeq64U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq64U x y)
	// cond:
	// result: (XOR (MOVVconst [1]) (SGTU x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64XOR)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 1
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v1.AddArg(x)
		v1.AddArg(y)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpLeq8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq8 x y)
	// cond:
	// result: (XOR (MOVVconst [1]) (SGT (SignExt8to64 x) (SignExt8to64 y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64XOR)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 1
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64SGT, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpSignExt8to64, config.fe.TypeInt64())
		v2.AddArg(x)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpSignExt8to64, config.fe.TypeInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpLeq8U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Leq8U x y)
	// cond:
	// result: (XOR (MOVVconst [1]) (SGTU (ZeroExt8to64 x) (ZeroExt8to64 y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64XOR)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 1
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v2.AddArg(x)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpLess16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less16 x y)
	// cond:
	// result: (SGT (SignExt16to64 y) (SignExt16to64 x))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SGT)
		v0 := b.NewValue0(v.Line, OpSignExt16to64, config.fe.TypeInt64())
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpSignExt16to64, config.fe.TypeInt64())
		v1.AddArg(x)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpLess16U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less16U x y)
	// cond:
	// result: (SGTU (ZeroExt16to64 y) (ZeroExt16to64 x))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SGTU)
		v0 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v1.AddArg(x)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpLess32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less32 x y)
	// cond:
	// result: (SGT (SignExt32to64 y) (SignExt32to64 x))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SGT)
		v0 := b.NewValue0(v.Line, OpSignExt32to64, config.fe.TypeInt64())
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpSignExt32to64, config.fe.TypeInt64())
		v1.AddArg(x)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpLess32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less32F x y)
	// cond:
	// result: (FPFlagTrue (CMPGTF y x))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64FPFlagTrue)
		v0 := b.NewValue0(v.Line, OpMIPS64CMPGTF, TypeFlags)
		v0.AddArg(y)
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpLess32U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less32U x y)
	// cond:
	// result: (SGTU (ZeroExt32to64 y) (ZeroExt32to64 x))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SGTU)
		v0 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v1.AddArg(x)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpLess64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less64 x y)
	// cond:
	// result: (SGT y x)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SGT)
		v.AddArg(y)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpLess64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less64F x y)
	// cond:
	// result: (FPFlagTrue (CMPGTD y x))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64FPFlagTrue)
		v0 := b.NewValue0(v.Line, OpMIPS64CMPGTD, TypeFlags)
		v0.AddArg(y)
		v0.AddArg(x)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpLess64U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less64U x y)
	// cond:
	// result: (SGTU y x)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SGTU)
		v.AddArg(y)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpLess8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less8 x y)
	// cond:
	// result: (SGT (SignExt8to64 y) (SignExt8to64 x))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SGT)
		v0 := b.NewValue0(v.Line, OpSignExt8to64, config.fe.TypeInt64())
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpSignExt8to64, config.fe.TypeInt64())
		v1.AddArg(x)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpLess8U(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Less8U x y)
	// cond:
	// result: (SGTU (ZeroExt8to64 y) (ZeroExt8to64 x))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SGTU)
		v0 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v1.AddArg(x)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpLoad(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Load <t> ptr mem)
	// cond: t.IsBoolean()
	// result: (MOVBUload ptr mem)
	for {
		t := v.Type
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(t.IsBoolean()) {
			break
		}
		v.reset(OpMIPS64MOVBUload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (Load <t> ptr mem)
	// cond: (is8BitInt(t) && isSigned(t))
	// result: (MOVBload ptr mem)
	for {
		t := v.Type
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(is8BitInt(t) && isSigned(t)) {
			break
		}
		v.reset(OpMIPS64MOVBload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (Load <t> ptr mem)
	// cond: (is8BitInt(t) && !isSigned(t))
	// result: (MOVBUload ptr mem)
	for {
		t := v.Type
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(is8BitInt(t) && !isSigned(t)) {
			break
		}
		v.reset(OpMIPS64MOVBUload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (Load <t> ptr mem)
	// cond: (is16BitInt(t) && isSigned(t))
	// result: (MOVHload ptr mem)
	for {
		t := v.Type
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(is16BitInt(t) && isSigned(t)) {
			break
		}
		v.reset(OpMIPS64MOVHload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (Load <t> ptr mem)
	// cond: (is16BitInt(t) && !isSigned(t))
	// result: (MOVHUload ptr mem)
	for {
		t := v.Type
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(is16BitInt(t) && !isSigned(t)) {
			break
		}
		v.reset(OpMIPS64MOVHUload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (Load <t> ptr mem)
	// cond: (is32BitInt(t) && isSigned(t))
	// result: (MOVWload ptr mem)
	for {
		t := v.Type
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(is32BitInt(t) && isSigned(t)) {
			break
		}
		v.reset(OpMIPS64MOVWload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (Load <t> ptr mem)
	// cond: (is32BitInt(t) && !isSigned(t))
	// result: (MOVWUload ptr mem)
	for {
		t := v.Type
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(is32BitInt(t) && !isSigned(t)) {
			break
		}
		v.reset(OpMIPS64MOVWUload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (Load <t> ptr mem)
	// cond: (is64BitInt(t) || isPtr(t))
	// result: (MOVVload ptr mem)
	for {
		t := v.Type
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(is64BitInt(t) || isPtr(t)) {
			break
		}
		v.reset(OpMIPS64MOVVload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (Load <t> ptr mem)
	// cond: is32BitFloat(t)
	// result: (MOVFload ptr mem)
	for {
		t := v.Type
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(is32BitFloat(t)) {
			break
		}
		v.reset(OpMIPS64MOVFload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (Load <t> ptr mem)
	// cond: is64BitFloat(t)
	// result: (MOVDload ptr mem)
	for {
		t := v.Type
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(is64BitFloat(t)) {
			break
		}
		v.reset(OpMIPS64MOVDload)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpLsh16x16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh16x16 <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) (ZeroExt16to64 y))) (SLLV <t> x (ZeroExt16to64 y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		v4 := b.NewValue0(v.Line, OpMIPS64SLLV, t)
		v4.AddArg(x)
		v5 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v5.AddArg(y)
		v4.AddArg(v5)
		v.AddArg(v4)
		return true
	}
}
func rewriteValueMIPS64_OpLsh16x32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh16x32 <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) (ZeroExt32to64 y))) (SLLV <t> x (ZeroExt32to64 y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		v4 := b.NewValue0(v.Line, OpMIPS64SLLV, t)
		v4.AddArg(x)
		v5 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v5.AddArg(y)
		v4.AddArg(v5)
		v.AddArg(v4)
		return true
	}
}
func rewriteValueMIPS64_OpLsh16x64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh16x64 <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) y)) (SLLV <t> x y))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v1.AddArg(y)
		v0.AddArg(v1)
		v.AddArg(v0)
		v3 := b.NewValue0(v.Line, OpMIPS64SLLV, t)
		v3.AddArg(x)
		v3.AddArg(y)
		v.AddArg(v3)
		return true
	}
}
func rewriteValueMIPS64_OpLsh16x8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh16x8  <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) (ZeroExt8to64  y))) (SLLV <t> x (ZeroExt8to64  y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		v4 := b.NewValue0(v.Line, OpMIPS64SLLV, t)
		v4.AddArg(x)
		v5 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v5.AddArg(y)
		v4.AddArg(v5)
		v.AddArg(v4)
		return true
	}
}
func rewriteValueMIPS64_OpLsh32x16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh32x16 <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) (ZeroExt16to64 y))) (SLLV <t> x (ZeroExt16to64 y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		v4 := b.NewValue0(v.Line, OpMIPS64SLLV, t)
		v4.AddArg(x)
		v5 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v5.AddArg(y)
		v4.AddArg(v5)
		v.AddArg(v4)
		return true
	}
}
func rewriteValueMIPS64_OpLsh32x32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh32x32 <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) (ZeroExt32to64 y))) (SLLV <t> x (ZeroExt32to64 y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		v4 := b.NewValue0(v.Line, OpMIPS64SLLV, t)
		v4.AddArg(x)
		v5 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v5.AddArg(y)
		v4.AddArg(v5)
		v.AddArg(v4)
		return true
	}
}
func rewriteValueMIPS64_OpLsh32x64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh32x64 <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) y)) (SLLV <t> x y))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v1.AddArg(y)
		v0.AddArg(v1)
		v.AddArg(v0)
		v3 := b.NewValue0(v.Line, OpMIPS64SLLV, t)
		v3.AddArg(x)
		v3.AddArg(y)
		v.AddArg(v3)
		return true
	}
}
func rewriteValueMIPS64_OpLsh32x8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh32x8  <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) (ZeroExt8to64  y))) (SLLV <t> x (ZeroExt8to64  y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		v4 := b.NewValue0(v.Line, OpMIPS64SLLV, t)
		v4.AddArg(x)
		v5 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v5.AddArg(y)
		v4.AddArg(v5)
		v.AddArg(v4)
		return true
	}
}
func rewriteValueMIPS64_OpLsh64x16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh64x16 <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) (ZeroExt16to64 y))) (SLLV <t> x (ZeroExt16to64 y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		v4 := b.NewValue0(v.Line, OpMIPS64SLLV, t)
		v4.AddArg(x)
		v5 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v5.AddArg(y)
		v4.AddArg(v5)
		v.AddArg(v4)
		return true
	}
}
func rewriteValueMIPS64_OpLsh64x32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh64x32 <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) (ZeroExt32to64 y))) (SLLV <t> x (ZeroExt32to64 y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		v4 := b.NewValue0(v.Line, OpMIPS64SLLV, t)
		v4.AddArg(x)
		v5 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v5.AddArg(y)
		v4.AddArg(v5)
		v.AddArg(v4)
		return true
	}
}
func rewriteValueMIPS64_OpLsh64x64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh64x64 <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) y)) (SLLV <t> x y))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v1.AddArg(y)
		v0.AddArg(v1)
		v.AddArg(v0)
		v3 := b.NewValue0(v.Line, OpMIPS64SLLV, t)
		v3.AddArg(x)
		v3.AddArg(y)
		v.AddArg(v3)
		return true
	}
}
func rewriteValueMIPS64_OpLsh64x8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh64x8  <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) (ZeroExt8to64  y))) (SLLV <t> x (ZeroExt8to64  y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		v4 := b.NewValue0(v.Line, OpMIPS64SLLV, t)
		v4.AddArg(x)
		v5 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v5.AddArg(y)
		v4.AddArg(v5)
		v.AddArg(v4)
		return true
	}
}
func rewriteValueMIPS64_OpLsh8x16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh8x16 <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) (ZeroExt16to64 y))) (SLLV <t> x (ZeroExt16to64 y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		v4 := b.NewValue0(v.Line, OpMIPS64SLLV, t)
		v4.AddArg(x)
		v5 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v5.AddArg(y)
		v4.AddArg(v5)
		v.AddArg(v4)
		return true
	}
}
func rewriteValueMIPS64_OpLsh8x32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh8x32 <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) (ZeroExt32to64 y))) (SLLV <t> x (ZeroExt32to64 y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		v4 := b.NewValue0(v.Line, OpMIPS64SLLV, t)
		v4.AddArg(x)
		v5 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v5.AddArg(y)
		v4.AddArg(v5)
		v.AddArg(v4)
		return true
	}
}
func rewriteValueMIPS64_OpLsh8x64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh8x64 <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) y)) (SLLV <t> x y))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v1.AddArg(y)
		v0.AddArg(v1)
		v.AddArg(v0)
		v3 := b.NewValue0(v.Line, OpMIPS64SLLV, t)
		v3.AddArg(x)
		v3.AddArg(y)
		v.AddArg(v3)
		return true
	}
}
func rewriteValueMIPS64_OpLsh8x8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Lsh8x8  <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) (ZeroExt8to64  y))) (SLLV <t> x (ZeroExt8to64  y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		v4 := b.NewValue0(v.Line, OpMIPS64SLLV, t)
		v4.AddArg(x)
		v5 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v5.AddArg(y)
		v4.AddArg(v5)
		v.AddArg(v4)
		return true
	}
}
func rewriteValueMIPS64_OpMIPS64ADDV(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ADDV (MOVVconst [c]) x)
	// cond: is32Bit(c)
	// result: (ADDVconst [c] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		if !(is32Bit(c)) {
			break
		}
		v.reset(OpMIPS64ADDVconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (ADDV x (MOVVconst [c]))
	// cond: is32Bit(c)
	// result: (ADDVconst [c] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_1.AuxInt
		if !(is32Bit(c)) {
			break
		}
		v.reset(OpMIPS64ADDVconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (ADDV x (NEGV y))
	// cond:
	// result: (SUBV x y)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64NEGV {
			break
		}
		y := v_1.Args[0]
		v.reset(OpMIPS64SUBV)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	// match: (ADDV (NEGV y) x)
	// cond:
	// result: (SUBV x y)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64NEGV {
			break
		}
		y := v_0.Args[0]
		x := v.Args[1]
		v.reset(OpMIPS64SUBV)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64ADDVconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ADDVconst [off1] (MOVVaddr [off2] {sym} ptr))
	// cond:
	// result: (MOVVaddr [off1+off2] {sym} ptr)
	for {
		off1 := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVaddr {
			break
		}
		off2 := v_0.AuxInt
		sym := v_0.Aux
		ptr := v_0.Args[0]
		v.reset(OpMIPS64MOVVaddr)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		return true
	}
	// match: (ADDVconst [0]  x)
	// cond:
	// result: x
	for {
		if v.AuxInt != 0 {
			break
		}
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (ADDVconst [c] (MOVVconst [d]))
	// cond:
	// result: (MOVVconst [c+d])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		d := v_0.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = c + d
		return true
	}
	// match: (ADDVconst [c] (ADDVconst [d] x))
	// cond: is32Bit(c+d)
	// result: (ADDVconst [c+d] x)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64ADDVconst {
			break
		}
		d := v_0.AuxInt
		x := v_0.Args[0]
		if !(is32Bit(c + d)) {
			break
		}
		v.reset(OpMIPS64ADDVconst)
		v.AuxInt = c + d
		v.AddArg(x)
		return true
	}
	// match: (ADDVconst [c] (SUBVconst [d] x))
	// cond: is32Bit(c-d)
	// result: (ADDVconst [c-d] x)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64SUBVconst {
			break
		}
		d := v_0.AuxInt
		x := v_0.Args[0]
		if !(is32Bit(c - d)) {
			break
		}
		v.reset(OpMIPS64ADDVconst)
		v.AuxInt = c - d
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64AND(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (AND (MOVVconst [c]) x)
	// cond: is32Bit(c)
	// result: (ANDconst [c] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		if !(is32Bit(c)) {
			break
		}
		v.reset(OpMIPS64ANDconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (AND x (MOVVconst [c]))
	// cond: is32Bit(c)
	// result: (ANDconst [c] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_1.AuxInt
		if !(is32Bit(c)) {
			break
		}
		v.reset(OpMIPS64ANDconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (AND x x)
	// cond:
	// result: x
	for {
		x := v.Args[0]
		if x != v.Args[1] {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64ANDconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ANDconst [0]  _)
	// cond:
	// result: (MOVVconst [0])
	for {
		if v.AuxInt != 0 {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 0
		return true
	}
	// match: (ANDconst [-1] x)
	// cond:
	// result: x
	for {
		if v.AuxInt != -1 {
			break
		}
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (ANDconst [c] (MOVVconst [d]))
	// cond:
	// result: (MOVVconst [c&d])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		d := v_0.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = c & d
		return true
	}
	// match: (ANDconst [c] (ANDconst [d] x))
	// cond:
	// result: (ANDconst [c&d] x)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64ANDconst {
			break
		}
		d := v_0.AuxInt
		x := v_0.Args[0]
		v.reset(OpMIPS64ANDconst)
		v.AuxInt = c & d
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64MOVBUload(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVBUload [off1] {sym} (ADDVconst [off2] ptr) mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVBUload [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64ADDVconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(OpMIPS64MOVBUload)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBUload [off1] {sym1} (MOVVaddr [off2] {sym2} ptr) mem)
	// cond: canMergeSym(sym1,sym2) && is32Bit(off1+off2)
	// result: (MOVBUload [off1+off2] {mergeSym(sym1,sym2)} ptr mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(canMergeSym(sym1, sym2) && is32Bit(off1+off2)) {
			break
		}
		v.reset(OpMIPS64MOVBUload)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64MOVBUreg(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVBUreg x:(MOVBUload _ _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVBUload {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVBUreg x:(MOVBUreg _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVBUreg {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVBUreg (MOVVconst [c]))
	// cond:
	// result: (MOVVconst [int64(uint8(c))])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_0.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = int64(uint8(c))
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64MOVBload(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVBload  [off1] {sym} (ADDVconst [off2] ptr) mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVBload  [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64ADDVconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(OpMIPS64MOVBload)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBload [off1] {sym1} (MOVVaddr [off2] {sym2} ptr) mem)
	// cond: canMergeSym(sym1,sym2) && is32Bit(off1+off2)
	// result: (MOVBload [off1+off2] {mergeSym(sym1,sym2)} ptr mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(canMergeSym(sym1, sym2) && is32Bit(off1+off2)) {
			break
		}
		v.reset(OpMIPS64MOVBload)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64MOVBreg(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVBreg x:(MOVBload _ _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVBload {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVBreg x:(MOVBreg _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVBreg {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVBreg  (MOVVconst [c]))
	// cond:
	// result: (MOVVconst [int64(int8(c))])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_0.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = int64(int8(c))
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64MOVBstore(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVBstore [off1] {sym} (ADDVconst [off2] ptr) val mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVBstore [off1+off2] {sym} ptr val mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64ADDVconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(OpMIPS64MOVBstore)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore [off1] {sym1} (MOVVaddr [off2] {sym2} ptr) val mem)
	// cond: canMergeSym(sym1,sym2) && is32Bit(off1+off2)
	// result: (MOVBstore [off1+off2] {mergeSym(sym1,sym2)} ptr val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(canMergeSym(sym1, sym2) && is32Bit(off1+off2)) {
			break
		}
		v.reset(OpMIPS64MOVBstore)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore [off] {sym} ptr (MOVVconst [0]) mem)
	// cond:
	// result: (MOVBstorezero [off] {sym} ptr mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVVconst {
			break
		}
		if v_1.AuxInt != 0 {
			break
		}
		mem := v.Args[2]
		v.reset(OpMIPS64MOVBstorezero)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore [off] {sym} ptr (MOVBreg x) mem)
	// cond:
	// result: (MOVBstore [off] {sym} ptr x mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVBreg {
			break
		}
		x := v_1.Args[0]
		mem := v.Args[2]
		v.reset(OpMIPS64MOVBstore)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(x)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore [off] {sym} ptr (MOVBUreg x) mem)
	// cond:
	// result: (MOVBstore [off] {sym} ptr x mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVBUreg {
			break
		}
		x := v_1.Args[0]
		mem := v.Args[2]
		v.reset(OpMIPS64MOVBstore)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(x)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore [off] {sym} ptr (MOVHreg x) mem)
	// cond:
	// result: (MOVBstore [off] {sym} ptr x mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVHreg {
			break
		}
		x := v_1.Args[0]
		mem := v.Args[2]
		v.reset(OpMIPS64MOVBstore)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(x)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore [off] {sym} ptr (MOVHUreg x) mem)
	// cond:
	// result: (MOVBstore [off] {sym} ptr x mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVHUreg {
			break
		}
		x := v_1.Args[0]
		mem := v.Args[2]
		v.reset(OpMIPS64MOVBstore)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(x)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore [off] {sym} ptr (MOVWreg x) mem)
	// cond:
	// result: (MOVBstore [off] {sym} ptr x mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVWreg {
			break
		}
		x := v_1.Args[0]
		mem := v.Args[2]
		v.reset(OpMIPS64MOVBstore)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(x)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstore [off] {sym} ptr (MOVWUreg x) mem)
	// cond:
	// result: (MOVBstore [off] {sym} ptr x mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVWUreg {
			break
		}
		x := v_1.Args[0]
		mem := v.Args[2]
		v.reset(OpMIPS64MOVBstore)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(x)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64MOVBstorezero(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVBstorezero [off1] {sym} (ADDVconst [off2] ptr) mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVBstorezero [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64ADDVconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(OpMIPS64MOVBstorezero)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVBstorezero [off1] {sym1} (MOVVaddr [off2] {sym2} ptr) mem)
	// cond: canMergeSym(sym1,sym2) && is32Bit(off1+off2)
	// result: (MOVBstorezero [off1+off2] {mergeSym(sym1,sym2)} ptr mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(canMergeSym(sym1, sym2) && is32Bit(off1+off2)) {
			break
		}
		v.reset(OpMIPS64MOVBstorezero)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64MOVDload(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVDload  [off1] {sym} (ADDVconst [off2] ptr) mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVDload  [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64ADDVconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(OpMIPS64MOVDload)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVDload [off1] {sym1} (MOVVaddr [off2] {sym2} ptr) mem)
	// cond: canMergeSym(sym1,sym2) && is32Bit(off1+off2)
	// result: (MOVDload [off1+off2] {mergeSym(sym1,sym2)} ptr mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(canMergeSym(sym1, sym2) && is32Bit(off1+off2)) {
			break
		}
		v.reset(OpMIPS64MOVDload)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64MOVDstore(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVDstore [off1] {sym} (ADDVconst [off2] ptr) val mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVDstore [off1+off2] {sym} ptr val mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64ADDVconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(OpMIPS64MOVDstore)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVDstore [off1] {sym1} (MOVVaddr [off2] {sym2} ptr) val mem)
	// cond: canMergeSym(sym1,sym2) && is32Bit(off1+off2)
	// result: (MOVDstore [off1+off2] {mergeSym(sym1,sym2)} ptr val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(canMergeSym(sym1, sym2) && is32Bit(off1+off2)) {
			break
		}
		v.reset(OpMIPS64MOVDstore)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64MOVFload(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVFload  [off1] {sym} (ADDVconst [off2] ptr) mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVFload  [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64ADDVconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(OpMIPS64MOVFload)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVFload [off1] {sym1} (MOVVaddr [off2] {sym2} ptr) mem)
	// cond: canMergeSym(sym1,sym2) && is32Bit(off1+off2)
	// result: (MOVFload [off1+off2] {mergeSym(sym1,sym2)} ptr mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(canMergeSym(sym1, sym2) && is32Bit(off1+off2)) {
			break
		}
		v.reset(OpMIPS64MOVFload)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64MOVFstore(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVFstore [off1] {sym} (ADDVconst [off2] ptr) val mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVFstore [off1+off2] {sym} ptr val mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64ADDVconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(OpMIPS64MOVFstore)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVFstore [off1] {sym1} (MOVVaddr [off2] {sym2} ptr) val mem)
	// cond: canMergeSym(sym1,sym2) && is32Bit(off1+off2)
	// result: (MOVFstore [off1+off2] {mergeSym(sym1,sym2)} ptr val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(canMergeSym(sym1, sym2) && is32Bit(off1+off2)) {
			break
		}
		v.reset(OpMIPS64MOVFstore)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64MOVHUload(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVHUload [off1] {sym} (ADDVconst [off2] ptr) mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVHUload [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64ADDVconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(OpMIPS64MOVHUload)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHUload [off1] {sym1} (MOVVaddr [off2] {sym2} ptr) mem)
	// cond: canMergeSym(sym1,sym2) && is32Bit(off1+off2)
	// result: (MOVHUload [off1+off2] {mergeSym(sym1,sym2)} ptr mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(canMergeSym(sym1, sym2) && is32Bit(off1+off2)) {
			break
		}
		v.reset(OpMIPS64MOVHUload)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64MOVHUreg(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVHUreg x:(MOVBUload _ _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVBUload {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVHUreg x:(MOVHUload _ _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVHUload {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVHUreg x:(MOVBUreg _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVBUreg {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVHUreg x:(MOVHUreg _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVHUreg {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVHUreg (MOVVconst [c]))
	// cond:
	// result: (MOVVconst [int64(uint16(c))])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_0.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = int64(uint16(c))
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64MOVHload(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVHload  [off1] {sym} (ADDVconst [off2] ptr) mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVHload  [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64ADDVconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(OpMIPS64MOVHload)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHload [off1] {sym1} (MOVVaddr [off2] {sym2} ptr) mem)
	// cond: canMergeSym(sym1,sym2) && is32Bit(off1+off2)
	// result: (MOVHload [off1+off2] {mergeSym(sym1,sym2)} ptr mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(canMergeSym(sym1, sym2) && is32Bit(off1+off2)) {
			break
		}
		v.reset(OpMIPS64MOVHload)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64MOVHreg(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVHreg x:(MOVBload _ _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVBload {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVHreg x:(MOVBUload _ _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVBUload {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVHreg x:(MOVHload _ _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVHload {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVHreg x:(MOVBreg _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVBreg {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVHreg x:(MOVBUreg _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVBUreg {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVHreg x:(MOVHreg _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVHreg {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVHreg  (MOVVconst [c]))
	// cond:
	// result: (MOVVconst [int64(int16(c))])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_0.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = int64(int16(c))
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64MOVHstore(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVHstore [off1] {sym} (ADDVconst [off2] ptr) val mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVHstore [off1+off2] {sym} ptr val mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64ADDVconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(OpMIPS64MOVHstore)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHstore [off1] {sym1} (MOVVaddr [off2] {sym2} ptr) val mem)
	// cond: canMergeSym(sym1,sym2) && is32Bit(off1+off2)
	// result: (MOVHstore [off1+off2] {mergeSym(sym1,sym2)} ptr val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(canMergeSym(sym1, sym2) && is32Bit(off1+off2)) {
			break
		}
		v.reset(OpMIPS64MOVHstore)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHstore [off] {sym} ptr (MOVVconst [0]) mem)
	// cond:
	// result: (MOVHstorezero [off] {sym} ptr mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVVconst {
			break
		}
		if v_1.AuxInt != 0 {
			break
		}
		mem := v.Args[2]
		v.reset(OpMIPS64MOVHstorezero)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHstore [off] {sym} ptr (MOVHreg x) mem)
	// cond:
	// result: (MOVHstore [off] {sym} ptr x mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVHreg {
			break
		}
		x := v_1.Args[0]
		mem := v.Args[2]
		v.reset(OpMIPS64MOVHstore)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(x)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHstore [off] {sym} ptr (MOVHUreg x) mem)
	// cond:
	// result: (MOVHstore [off] {sym} ptr x mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVHUreg {
			break
		}
		x := v_1.Args[0]
		mem := v.Args[2]
		v.reset(OpMIPS64MOVHstore)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(x)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHstore [off] {sym} ptr (MOVWreg x) mem)
	// cond:
	// result: (MOVHstore [off] {sym} ptr x mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVWreg {
			break
		}
		x := v_1.Args[0]
		mem := v.Args[2]
		v.reset(OpMIPS64MOVHstore)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(x)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHstore [off] {sym} ptr (MOVWUreg x) mem)
	// cond:
	// result: (MOVHstore [off] {sym} ptr x mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVWUreg {
			break
		}
		x := v_1.Args[0]
		mem := v.Args[2]
		v.reset(OpMIPS64MOVHstore)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(x)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64MOVHstorezero(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVHstorezero [off1] {sym} (ADDVconst [off2] ptr) mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVHstorezero [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64ADDVconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(OpMIPS64MOVHstorezero)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVHstorezero [off1] {sym1} (MOVVaddr [off2] {sym2} ptr) mem)
	// cond: canMergeSym(sym1,sym2) && is32Bit(off1+off2)
	// result: (MOVHstorezero [off1+off2] {mergeSym(sym1,sym2)} ptr mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(canMergeSym(sym1, sym2) && is32Bit(off1+off2)) {
			break
		}
		v.reset(OpMIPS64MOVHstorezero)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64MOVVload(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVVload  [off1] {sym} (ADDVconst [off2] ptr) mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVVload  [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64ADDVconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(OpMIPS64MOVVload)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVVload [off1] {sym1} (MOVVaddr [off2] {sym2} ptr) mem)
	// cond: canMergeSym(sym1,sym2) && is32Bit(off1+off2)
	// result: (MOVVload [off1+off2] {mergeSym(sym1,sym2)} ptr mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(canMergeSym(sym1, sym2) && is32Bit(off1+off2)) {
			break
		}
		v.reset(OpMIPS64MOVVload)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64MOVVreg(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVVreg x)
	// cond: x.Uses == 1
	// result: (MOVVnop x)
	for {
		x := v.Args[0]
		if !(x.Uses == 1) {
			break
		}
		v.reset(OpMIPS64MOVVnop)
		v.AddArg(x)
		return true
	}
	// match: (MOVVreg  (MOVVconst [c]))
	// cond:
	// result: (MOVVconst [c])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_0.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = c
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64MOVVstore(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVVstore [off1] {sym} (ADDVconst [off2] ptr) val mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVVstore [off1+off2] {sym} ptr val mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64ADDVconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(OpMIPS64MOVVstore)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVVstore [off1] {sym1} (MOVVaddr [off2] {sym2} ptr) val mem)
	// cond: canMergeSym(sym1,sym2) && is32Bit(off1+off2)
	// result: (MOVVstore [off1+off2] {mergeSym(sym1,sym2)} ptr val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(canMergeSym(sym1, sym2) && is32Bit(off1+off2)) {
			break
		}
		v.reset(OpMIPS64MOVVstore)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVVstore [off] {sym} ptr (MOVVconst [0]) mem)
	// cond:
	// result: (MOVVstorezero [off] {sym} ptr mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVVconst {
			break
		}
		if v_1.AuxInt != 0 {
			break
		}
		mem := v.Args[2]
		v.reset(OpMIPS64MOVVstorezero)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64MOVVstorezero(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVVstorezero [off1] {sym} (ADDVconst [off2] ptr) mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVVstorezero [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64ADDVconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(OpMIPS64MOVVstorezero)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVVstorezero [off1] {sym1} (MOVVaddr [off2] {sym2} ptr) mem)
	// cond: canMergeSym(sym1,sym2) && is32Bit(off1+off2)
	// result: (MOVVstorezero [off1+off2] {mergeSym(sym1,sym2)} ptr mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(canMergeSym(sym1, sym2) && is32Bit(off1+off2)) {
			break
		}
		v.reset(OpMIPS64MOVVstorezero)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64MOVWUload(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWUload [off1] {sym} (ADDVconst [off2] ptr) mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVWUload [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64ADDVconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(OpMIPS64MOVWUload)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWUload [off1] {sym1} (MOVVaddr [off2] {sym2} ptr) mem)
	// cond: canMergeSym(sym1,sym2) && is32Bit(off1+off2)
	// result: (MOVWUload [off1+off2] {mergeSym(sym1,sym2)} ptr mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(canMergeSym(sym1, sym2) && is32Bit(off1+off2)) {
			break
		}
		v.reset(OpMIPS64MOVWUload)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64MOVWUreg(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWUreg x:(MOVBUload _ _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVBUload {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWUreg x:(MOVHUload _ _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVHUload {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWUreg x:(MOVWUload _ _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVWUload {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWUreg x:(MOVBUreg _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVBUreg {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWUreg x:(MOVHUreg _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVHUreg {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWUreg x:(MOVWUreg _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVWUreg {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWUreg (MOVVconst [c]))
	// cond:
	// result: (MOVVconst [int64(uint32(c))])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_0.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = int64(uint32(c))
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64MOVWload(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWload  [off1] {sym} (ADDVconst [off2] ptr) mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVWload  [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64ADDVconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(OpMIPS64MOVWload)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWload [off1] {sym1} (MOVVaddr [off2] {sym2} ptr) mem)
	// cond: canMergeSym(sym1,sym2) && is32Bit(off1+off2)
	// result: (MOVWload [off1+off2] {mergeSym(sym1,sym2)} ptr mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(canMergeSym(sym1, sym2) && is32Bit(off1+off2)) {
			break
		}
		v.reset(OpMIPS64MOVWload)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64MOVWreg(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWreg x:(MOVBload _ _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVBload {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWreg x:(MOVBUload _ _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVBUload {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWreg x:(MOVHload _ _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVHload {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWreg x:(MOVHUload _ _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVHUload {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWreg x:(MOVWload _ _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVWload {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWreg x:(MOVBreg _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVBreg {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWreg x:(MOVBUreg _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVBUreg {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWreg x:(MOVHreg _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVHreg {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWreg x:(MOVHreg _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVHreg {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWreg x:(MOVWreg _))
	// cond:
	// result: (MOVVreg x)
	for {
		x := v.Args[0]
		if x.Op != OpMIPS64MOVWreg {
			break
		}
		v.reset(OpMIPS64MOVVreg)
		v.AddArg(x)
		return true
	}
	// match: (MOVWreg  (MOVVconst [c]))
	// cond:
	// result: (MOVVconst [int64(int32(c))])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_0.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = int64(int32(c))
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64MOVWstore(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWstore [off1] {sym} (ADDVconst [off2] ptr) val mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVWstore [off1+off2] {sym} ptr val mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64ADDVconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(OpMIPS64MOVWstore)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstore [off1] {sym1} (MOVVaddr [off2] {sym2} ptr) val mem)
	// cond: canMergeSym(sym1,sym2) && is32Bit(off1+off2)
	// result: (MOVWstore [off1+off2] {mergeSym(sym1,sym2)} ptr val mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(canMergeSym(sym1, sym2) && is32Bit(off1+off2)) {
			break
		}
		v.reset(OpMIPS64MOVWstore)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstore [off] {sym} ptr (MOVVconst [0]) mem)
	// cond:
	// result: (MOVWstorezero [off] {sym} ptr mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVVconst {
			break
		}
		if v_1.AuxInt != 0 {
			break
		}
		mem := v.Args[2]
		v.reset(OpMIPS64MOVWstorezero)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstore [off] {sym} ptr (MOVWreg x) mem)
	// cond:
	// result: (MOVWstore [off] {sym} ptr x mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVWreg {
			break
		}
		x := v_1.Args[0]
		mem := v.Args[2]
		v.reset(OpMIPS64MOVWstore)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(x)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstore [off] {sym} ptr (MOVWUreg x) mem)
	// cond:
	// result: (MOVWstore [off] {sym} ptr x mem)
	for {
		off := v.AuxInt
		sym := v.Aux
		ptr := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVWUreg {
			break
		}
		x := v_1.Args[0]
		mem := v.Args[2]
		v.reset(OpMIPS64MOVWstore)
		v.AuxInt = off
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(x)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64MOVWstorezero(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (MOVWstorezero [off1] {sym} (ADDVconst [off2] ptr) mem)
	// cond: is32Bit(off1+off2)
	// result: (MOVWstorezero [off1+off2] {sym} ptr mem)
	for {
		off1 := v.AuxInt
		sym := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64ADDVconst {
			break
		}
		off2 := v_0.AuxInt
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(is32Bit(off1 + off2)) {
			break
		}
		v.reset(OpMIPS64MOVWstorezero)
		v.AuxInt = off1 + off2
		v.Aux = sym
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (MOVWstorezero [off1] {sym1} (MOVVaddr [off2] {sym2} ptr) mem)
	// cond: canMergeSym(sym1,sym2) && is32Bit(off1+off2)
	// result: (MOVWstorezero [off1+off2] {mergeSym(sym1,sym2)} ptr mem)
	for {
		off1 := v.AuxInt
		sym1 := v.Aux
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVaddr {
			break
		}
		off2 := v_0.AuxInt
		sym2 := v_0.Aux
		ptr := v_0.Args[0]
		mem := v.Args[1]
		if !(canMergeSym(sym1, sym2) && is32Bit(off1+off2)) {
			break
		}
		v.reset(OpMIPS64MOVWstorezero)
		v.AuxInt = off1 + off2
		v.Aux = mergeSym(sym1, sym2)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64NEGV(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (NEGV (MOVVconst [c]))
	// cond:
	// result: (MOVVconst [-c])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_0.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = -c
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64NOR(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (NOR (MOVVconst [c]) x)
	// cond: is32Bit(c)
	// result: (NORconst [c] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		if !(is32Bit(c)) {
			break
		}
		v.reset(OpMIPS64NORconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (NOR x (MOVVconst [c]))
	// cond: is32Bit(c)
	// result: (NORconst [c] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_1.AuxInt
		if !(is32Bit(c)) {
			break
		}
		v.reset(OpMIPS64NORconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64NORconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (NORconst [c] (MOVVconst [d]))
	// cond:
	// result: (MOVVconst [^(c|d)])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		d := v_0.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = ^(c | d)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64OR(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (OR  (MOVVconst [c]) x)
	// cond: is32Bit(c)
	// result: (ORconst  [c] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		if !(is32Bit(c)) {
			break
		}
		v.reset(OpMIPS64ORconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (OR  x (MOVVconst [c]))
	// cond: is32Bit(c)
	// result: (ORconst  [c] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_1.AuxInt
		if !(is32Bit(c)) {
			break
		}
		v.reset(OpMIPS64ORconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (OR  x x)
	// cond:
	// result: x
	for {
		x := v.Args[0]
		if x != v.Args[1] {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64ORconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ORconst  [0]  x)
	// cond:
	// result: x
	for {
		if v.AuxInt != 0 {
			break
		}
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (ORconst  [-1] _)
	// cond:
	// result: (MOVVconst [-1])
	for {
		if v.AuxInt != -1 {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = -1
		return true
	}
	// match: (ORconst [c] (MOVVconst [d]))
	// cond:
	// result: (MOVVconst [c|d])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		d := v_0.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = c | d
		return true
	}
	// match: (ORconst [c] (ORconst [d] x))
	// cond: is32Bit(c|d)
	// result: (ORconst [c|d] x)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64ORconst {
			break
		}
		d := v_0.AuxInt
		x := v_0.Args[0]
		if !(is32Bit(c | d)) {
			break
		}
		v.reset(OpMIPS64ORconst)
		v.AuxInt = c | d
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64SGT(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SGT  (MOVVconst [c]) x)
	// cond: is32Bit(c)
	// result: (SGTconst  [c] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		if !(is32Bit(c)) {
			break
		}
		v.reset(OpMIPS64SGTconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64SGTU(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SGTU (MOVVconst [c]) x)
	// cond: is32Bit(c)
	// result: (SGTUconst [c] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		if !(is32Bit(c)) {
			break
		}
		v.reset(OpMIPS64SGTUconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64SGTUconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SGTUconst [c] (MOVVconst [d]))
	// cond: uint64(c)>uint64(d)
	// result: (MOVVconst [1])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		d := v_0.AuxInt
		if !(uint64(c) > uint64(d)) {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 1
		return true
	}
	// match: (SGTUconst [c] (MOVVconst [d]))
	// cond: uint64(c)<=uint64(d)
	// result: (MOVVconst [0])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		d := v_0.AuxInt
		if !(uint64(c) <= uint64(d)) {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 0
		return true
	}
	// match: (SGTUconst [c] (MOVBUreg _))
	// cond: 0xff < uint64(c)
	// result: (MOVVconst [1])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVBUreg {
			break
		}
		if !(0xff < uint64(c)) {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 1
		return true
	}
	// match: (SGTUconst [c] (MOVHUreg _))
	// cond: 0xffff < uint64(c)
	// result: (MOVVconst [1])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVHUreg {
			break
		}
		if !(0xffff < uint64(c)) {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 1
		return true
	}
	// match: (SGTUconst [c] (ANDconst [m] _))
	// cond: uint64(m) < uint64(c)
	// result: (MOVVconst [1])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64ANDconst {
			break
		}
		m := v_0.AuxInt
		if !(uint64(m) < uint64(c)) {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 1
		return true
	}
	// match: (SGTUconst [c] (SRLVconst _ [d]))
	// cond: 0 < d && d <= 63 && 1<<uint64(64-d) <= uint64(c)
	// result: (MOVVconst [1])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64SRLVconst {
			break
		}
		d := v_0.AuxInt
		if !(0 < d && d <= 63 && 1<<uint64(64-d) <= uint64(c)) {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 1
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64SGTconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SGTconst [c] (MOVVconst [d]))
	// cond: int64(c)>int64(d)
	// result: (MOVVconst [1])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		d := v_0.AuxInt
		if !(int64(c) > int64(d)) {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 1
		return true
	}
	// match: (SGTconst [c] (MOVVconst [d]))
	// cond: int64(c)<=int64(d)
	// result: (MOVVconst [0])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		d := v_0.AuxInt
		if !(int64(c) <= int64(d)) {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 0
		return true
	}
	// match: (SGTconst [c] (MOVBreg _))
	// cond: 0x7f < int64(c)
	// result: (MOVVconst [1])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVBreg {
			break
		}
		if !(0x7f < int64(c)) {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 1
		return true
	}
	// match: (SGTconst [c] (MOVBreg _))
	// cond: int64(c) <= -0x80
	// result: (MOVVconst [0])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVBreg {
			break
		}
		if !(int64(c) <= -0x80) {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 0
		return true
	}
	// match: (SGTconst [c] (MOVBUreg _))
	// cond: 0xff < int64(c)
	// result: (MOVVconst [1])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVBUreg {
			break
		}
		if !(0xff < int64(c)) {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 1
		return true
	}
	// match: (SGTconst [c] (MOVBUreg _))
	// cond: int64(c) < 0
	// result: (MOVVconst [0])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVBUreg {
			break
		}
		if !(int64(c) < 0) {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 0
		return true
	}
	// match: (SGTconst [c] (MOVHreg _))
	// cond: 0x7fff < int64(c)
	// result: (MOVVconst [1])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVHreg {
			break
		}
		if !(0x7fff < int64(c)) {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 1
		return true
	}
	// match: (SGTconst [c] (MOVHreg _))
	// cond: int64(c) <= -0x8000
	// result: (MOVVconst [0])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVHreg {
			break
		}
		if !(int64(c) <= -0x8000) {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 0
		return true
	}
	// match: (SGTconst [c] (MOVHUreg _))
	// cond: 0xffff < int64(c)
	// result: (MOVVconst [1])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVHUreg {
			break
		}
		if !(0xffff < int64(c)) {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 1
		return true
	}
	// match: (SGTconst [c] (MOVHUreg _))
	// cond: int64(c) < 0
	// result: (MOVVconst [0])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVHUreg {
			break
		}
		if !(int64(c) < 0) {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 0
		return true
	}
	// match: (SGTconst [c] (MOVWUreg _))
	// cond: int64(c) < 0
	// result: (MOVVconst [0])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVWUreg {
			break
		}
		if !(int64(c) < 0) {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 0
		return true
	}
	// match: (SGTconst [c] (ANDconst [m] _))
	// cond: 0 <= m && m < c
	// result: (MOVVconst [1])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64ANDconst {
			break
		}
		m := v_0.AuxInt
		if !(0 <= m && m < c) {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 1
		return true
	}
	// match: (SGTconst [c] (SRLVconst _ [d]))
	// cond: 0 <= c && 0 < d && d <= 63 && 1<<uint64(64-d) <= c
	// result: (MOVVconst [1])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64SRLVconst {
			break
		}
		d := v_0.AuxInt
		if !(0 <= c && 0 < d && d <= 63 && 1<<uint64(64-d) <= c) {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 1
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64SLLV(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SLLV _ (MOVVconst [c]))
	// cond: uint64(c)>=64
	// result: (MOVVconst [0])
	for {
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_1.AuxInt
		if !(uint64(c) >= 64) {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 0
		return true
	}
	// match: (SLLV x (MOVVconst [c]))
	// cond:
	// result: (SLLVconst x [c])
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_1.AuxInt
		v.reset(OpMIPS64SLLVconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64SLLVconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SLLVconst [c] (MOVVconst [d]))
	// cond:
	// result: (MOVVconst [int64(d)<<uint64(c)])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		d := v_0.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = int64(d) << uint64(c)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64SRAV(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SRAV x (MOVVconst [c]))
	// cond: uint64(c)>=64
	// result: (SRAVconst x [63])
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_1.AuxInt
		if !(uint64(c) >= 64) {
			break
		}
		v.reset(OpMIPS64SRAVconst)
		v.AuxInt = 63
		v.AddArg(x)
		return true
	}
	// match: (SRAV x (MOVVconst [c]))
	// cond:
	// result: (SRAVconst x [c])
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_1.AuxInt
		v.reset(OpMIPS64SRAVconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64SRAVconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SRAVconst [c] (MOVVconst [d]))
	// cond:
	// result: (MOVVconst [int64(d)>>uint64(c)])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		d := v_0.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = int64(d) >> uint64(c)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64SRLV(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SRLV _ (MOVVconst [c]))
	// cond: uint64(c)>=64
	// result: (MOVVconst [0])
	for {
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_1.AuxInt
		if !(uint64(c) >= 64) {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 0
		return true
	}
	// match: (SRLV x (MOVVconst [c]))
	// cond:
	// result: (SRLVconst x [c])
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_1.AuxInt
		v.reset(OpMIPS64SRLVconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64SRLVconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SRLVconst [c] (MOVVconst [d]))
	// cond:
	// result: (MOVVconst [int64(uint64(d)>>uint64(c))])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		d := v_0.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = int64(uint64(d) >> uint64(c))
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64SUBV(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SUBV x (MOVVconst [c]))
	// cond: is32Bit(c)
	// result: (SUBVconst [c] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_1.AuxInt
		if !(is32Bit(c)) {
			break
		}
		v.reset(OpMIPS64SUBVconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (SUBV x x)
	// cond:
	// result: (MOVVconst [0])
	for {
		x := v.Args[0]
		if x != v.Args[1] {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 0
		return true
	}
	// match: (SUBV (MOVVconst [0]) x)
	// cond:
	// result: (NEGV x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		if v_0.AuxInt != 0 {
			break
		}
		x := v.Args[1]
		v.reset(OpMIPS64NEGV)
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64SUBVconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SUBVconst [0]  x)
	// cond:
	// result: x
	for {
		if v.AuxInt != 0 {
			break
		}
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (SUBVconst [c] (MOVVconst [d]))
	// cond:
	// result: (MOVVconst [d-c])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		d := v_0.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = d - c
		return true
	}
	// match: (SUBVconst [c] (SUBVconst [d] x))
	// cond: is32Bit(-c-d)
	// result: (ADDVconst [-c-d] x)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64SUBVconst {
			break
		}
		d := v_0.AuxInt
		x := v_0.Args[0]
		if !(is32Bit(-c - d)) {
			break
		}
		v.reset(OpMIPS64ADDVconst)
		v.AuxInt = -c - d
		v.AddArg(x)
		return true
	}
	// match: (SUBVconst [c] (ADDVconst [d] x))
	// cond: is32Bit(-c+d)
	// result: (ADDVconst [-c+d] x)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64ADDVconst {
			break
		}
		d := v_0.AuxInt
		x := v_0.Args[0]
		if !(is32Bit(-c + d)) {
			break
		}
		v.reset(OpMIPS64ADDVconst)
		v.AuxInt = -c + d
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64XOR(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (XOR (MOVVconst [c]) x)
	// cond: is32Bit(c)
	// result: (XORconst [c] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_0.AuxInt
		x := v.Args[1]
		if !(is32Bit(c)) {
			break
		}
		v.reset(OpMIPS64XORconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (XOR x (MOVVconst [c]))
	// cond: is32Bit(c)
	// result: (XORconst [c] x)
	for {
		x := v.Args[0]
		v_1 := v.Args[1]
		if v_1.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_1.AuxInt
		if !(is32Bit(c)) {
			break
		}
		v.reset(OpMIPS64XORconst)
		v.AuxInt = c
		v.AddArg(x)
		return true
	}
	// match: (XOR x x)
	// cond:
	// result: (MOVVconst [0])
	for {
		x := v.Args[0]
		if x != v.Args[1] {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 0
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMIPS64XORconst(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (XORconst [0]  x)
	// cond:
	// result: x
	for {
		if v.AuxInt != 0 {
			break
		}
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (XORconst [-1] x)
	// cond:
	// result: (NORconst [0] x)
	for {
		if v.AuxInt != -1 {
			break
		}
		x := v.Args[0]
		v.reset(OpMIPS64NORconst)
		v.AuxInt = 0
		v.AddArg(x)
		return true
	}
	// match: (XORconst [c] (MOVVconst [d]))
	// cond:
	// result: (MOVVconst [c^d])
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MOVVconst {
			break
		}
		d := v_0.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = c ^ d
		return true
	}
	// match: (XORconst [c] (XORconst [d] x))
	// cond: is32Bit(c^d)
	// result: (XORconst [c^d] x)
	for {
		c := v.AuxInt
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64XORconst {
			break
		}
		d := v_0.AuxInt
		x := v_0.Args[0]
		if !(is32Bit(c ^ d)) {
			break
		}
		v.reset(OpMIPS64XORconst)
		v.AuxInt = c ^ d
		v.AddArg(x)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMod16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mod16 x y)
	// cond:
	// result: (Select0 (DIVV (SignExt16to64 x) (SignExt16to64 y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpSelect0)
		v0 := b.NewValue0(v.Line, OpMIPS64DIVV, MakeTuple(config.fe.TypeInt64(), config.fe.TypeInt64()))
		v1 := b.NewValue0(v.Line, OpSignExt16to64, config.fe.TypeInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpSignExt16to64, config.fe.TypeInt64())
		v2.AddArg(y)
		v0.AddArg(v2)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpMod16u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mod16u x y)
	// cond:
	// result: (Select0 (DIVVU (ZeroExt16to64 x) (ZeroExt16to64 y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpSelect0)
		v0 := b.NewValue0(v.Line, OpMIPS64DIVVU, MakeTuple(config.fe.TypeUInt64(), config.fe.TypeUInt64()))
		v1 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v2.AddArg(y)
		v0.AddArg(v2)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpMod32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mod32 x y)
	// cond:
	// result: (Select0 (DIVV (SignExt32to64 x) (SignExt32to64 y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpSelect0)
		v0 := b.NewValue0(v.Line, OpMIPS64DIVV, MakeTuple(config.fe.TypeInt64(), config.fe.TypeInt64()))
		v1 := b.NewValue0(v.Line, OpSignExt32to64, config.fe.TypeInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpSignExt32to64, config.fe.TypeInt64())
		v2.AddArg(y)
		v0.AddArg(v2)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpMod32u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mod32u x y)
	// cond:
	// result: (Select0 (DIVVU (ZeroExt32to64 x) (ZeroExt32to64 y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpSelect0)
		v0 := b.NewValue0(v.Line, OpMIPS64DIVVU, MakeTuple(config.fe.TypeUInt64(), config.fe.TypeUInt64()))
		v1 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v2.AddArg(y)
		v0.AddArg(v2)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpMod64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mod64 x y)
	// cond:
	// result: (Select0 (DIVV x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpSelect0)
		v0 := b.NewValue0(v.Line, OpMIPS64DIVV, MakeTuple(config.fe.TypeInt64(), config.fe.TypeInt64()))
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpMod64u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mod64u x y)
	// cond:
	// result: (Select0 (DIVVU x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpSelect0)
		v0 := b.NewValue0(v.Line, OpMIPS64DIVVU, MakeTuple(config.fe.TypeUInt64(), config.fe.TypeUInt64()))
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpMod8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mod8 x y)
	// cond:
	// result: (Select0 (DIVV (SignExt8to64 x) (SignExt8to64 y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpSelect0)
		v0 := b.NewValue0(v.Line, OpMIPS64DIVV, MakeTuple(config.fe.TypeInt64(), config.fe.TypeInt64()))
		v1 := b.NewValue0(v.Line, OpSignExt8to64, config.fe.TypeInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpSignExt8to64, config.fe.TypeInt64())
		v2.AddArg(y)
		v0.AddArg(v2)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpMod8u(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mod8u x y)
	// cond:
	// result: (Select0 (DIVVU (ZeroExt8to64 x) (ZeroExt8to64 y)))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpSelect0)
		v0 := b.NewValue0(v.Line, OpMIPS64DIVVU, MakeTuple(config.fe.TypeUInt64(), config.fe.TypeUInt64()))
		v1 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v2.AddArg(y)
		v0.AddArg(v2)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpMove(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Move [s] _ _ mem)
	// cond: SizeAndAlign(s).Size() == 0
	// result: mem
	for {
		s := v.AuxInt
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 0) {
			break
		}
		v.reset(OpCopy)
		v.Type = mem.Type
		v.AddArg(mem)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 1
	// result: (MOVBstore dst (MOVBload src mem) mem)
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 1) {
			break
		}
		v.reset(OpMIPS64MOVBstore)
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVBload, config.fe.TypeInt8())
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v.AddArg(mem)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 2 && SizeAndAlign(s).Align()%2 == 0
	// result: (MOVHstore dst (MOVHload src mem) mem)
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 2 && SizeAndAlign(s).Align()%2 == 0) {
			break
		}
		v.reset(OpMIPS64MOVHstore)
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVHload, config.fe.TypeInt16())
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v.AddArg(mem)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 2
	// result: (MOVBstore [1] dst (MOVBload [1] src mem) 		(MOVBstore dst (MOVBload src mem) mem))
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 2) {
			break
		}
		v.reset(OpMIPS64MOVBstore)
		v.AuxInt = 1
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVBload, config.fe.TypeInt8())
		v0.AuxInt = 1
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64MOVBstore, TypeMem)
		v1.AddArg(dst)
		v2 := b.NewValue0(v.Line, OpMIPS64MOVBload, config.fe.TypeInt8())
		v2.AddArg(src)
		v2.AddArg(mem)
		v1.AddArg(v2)
		v1.AddArg(mem)
		v.AddArg(v1)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 4 && SizeAndAlign(s).Align()%4 == 0
	// result: (MOVWstore dst (MOVWload src mem) mem)
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 4 && SizeAndAlign(s).Align()%4 == 0) {
			break
		}
		v.reset(OpMIPS64MOVWstore)
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVWload, config.fe.TypeInt32())
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v.AddArg(mem)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 4 && SizeAndAlign(s).Align()%2 == 0
	// result: (MOVHstore [2] dst (MOVHload [2] src mem) 		(MOVHstore dst (MOVHload src mem) mem))
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 4 && SizeAndAlign(s).Align()%2 == 0) {
			break
		}
		v.reset(OpMIPS64MOVHstore)
		v.AuxInt = 2
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVHload, config.fe.TypeInt16())
		v0.AuxInt = 2
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64MOVHstore, TypeMem)
		v1.AddArg(dst)
		v2 := b.NewValue0(v.Line, OpMIPS64MOVHload, config.fe.TypeInt16())
		v2.AddArg(src)
		v2.AddArg(mem)
		v1.AddArg(v2)
		v1.AddArg(mem)
		v.AddArg(v1)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 4
	// result: (MOVBstore [3] dst (MOVBload [3] src mem) 		(MOVBstore [2] dst (MOVBload [2] src mem) 			(MOVBstore [1] dst (MOVBload [1] src mem) 				(MOVBstore dst (MOVBload src mem) mem))))
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 4) {
			break
		}
		v.reset(OpMIPS64MOVBstore)
		v.AuxInt = 3
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVBload, config.fe.TypeInt8())
		v0.AuxInt = 3
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64MOVBstore, TypeMem)
		v1.AuxInt = 2
		v1.AddArg(dst)
		v2 := b.NewValue0(v.Line, OpMIPS64MOVBload, config.fe.TypeInt8())
		v2.AuxInt = 2
		v2.AddArg(src)
		v2.AddArg(mem)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpMIPS64MOVBstore, TypeMem)
		v3.AuxInt = 1
		v3.AddArg(dst)
		v4 := b.NewValue0(v.Line, OpMIPS64MOVBload, config.fe.TypeInt8())
		v4.AuxInt = 1
		v4.AddArg(src)
		v4.AddArg(mem)
		v3.AddArg(v4)
		v5 := b.NewValue0(v.Line, OpMIPS64MOVBstore, TypeMem)
		v5.AddArg(dst)
		v6 := b.NewValue0(v.Line, OpMIPS64MOVBload, config.fe.TypeInt8())
		v6.AddArg(src)
		v6.AddArg(mem)
		v5.AddArg(v6)
		v5.AddArg(mem)
		v3.AddArg(v5)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 8 && SizeAndAlign(s).Align()%8 == 0
	// result: (MOVVstore dst (MOVVload src mem) mem)
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 8 && SizeAndAlign(s).Align()%8 == 0) {
			break
		}
		v.reset(OpMIPS64MOVVstore)
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVload, config.fe.TypeUInt64())
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v.AddArg(mem)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 8 && SizeAndAlign(s).Align()%4 == 0
	// result: (MOVWstore [4] dst (MOVWload [4] src mem) 		(MOVWstore dst (MOVWload src mem) mem))
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 8 && SizeAndAlign(s).Align()%4 == 0) {
			break
		}
		v.reset(OpMIPS64MOVWstore)
		v.AuxInt = 4
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVWload, config.fe.TypeInt32())
		v0.AuxInt = 4
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64MOVWstore, TypeMem)
		v1.AddArg(dst)
		v2 := b.NewValue0(v.Line, OpMIPS64MOVWload, config.fe.TypeInt32())
		v2.AddArg(src)
		v2.AddArg(mem)
		v1.AddArg(v2)
		v1.AddArg(mem)
		v.AddArg(v1)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 8 && SizeAndAlign(s).Align()%2 == 0
	// result: (MOVHstore [6] dst (MOVHload [6] src mem) 		(MOVHstore [4] dst (MOVHload [4] src mem) 			(MOVHstore [2] dst (MOVHload [2] src mem) 				(MOVHstore dst (MOVHload src mem) mem))))
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 8 && SizeAndAlign(s).Align()%2 == 0) {
			break
		}
		v.reset(OpMIPS64MOVHstore)
		v.AuxInt = 6
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVHload, config.fe.TypeInt16())
		v0.AuxInt = 6
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64MOVHstore, TypeMem)
		v1.AuxInt = 4
		v1.AddArg(dst)
		v2 := b.NewValue0(v.Line, OpMIPS64MOVHload, config.fe.TypeInt16())
		v2.AuxInt = 4
		v2.AddArg(src)
		v2.AddArg(mem)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpMIPS64MOVHstore, TypeMem)
		v3.AuxInt = 2
		v3.AddArg(dst)
		v4 := b.NewValue0(v.Line, OpMIPS64MOVHload, config.fe.TypeInt16())
		v4.AuxInt = 2
		v4.AddArg(src)
		v4.AddArg(mem)
		v3.AddArg(v4)
		v5 := b.NewValue0(v.Line, OpMIPS64MOVHstore, TypeMem)
		v5.AddArg(dst)
		v6 := b.NewValue0(v.Line, OpMIPS64MOVHload, config.fe.TypeInt16())
		v6.AddArg(src)
		v6.AddArg(mem)
		v5.AddArg(v6)
		v5.AddArg(mem)
		v3.AddArg(v5)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 3
	// result: (MOVBstore [2] dst (MOVBload [2] src mem) 		(MOVBstore [1] dst (MOVBload [1] src mem) 			(MOVBstore dst (MOVBload src mem) mem)))
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 3) {
			break
		}
		v.reset(OpMIPS64MOVBstore)
		v.AuxInt = 2
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVBload, config.fe.TypeInt8())
		v0.AuxInt = 2
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64MOVBstore, TypeMem)
		v1.AuxInt = 1
		v1.AddArg(dst)
		v2 := b.NewValue0(v.Line, OpMIPS64MOVBload, config.fe.TypeInt8())
		v2.AuxInt = 1
		v2.AddArg(src)
		v2.AddArg(mem)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpMIPS64MOVBstore, TypeMem)
		v3.AddArg(dst)
		v4 := b.NewValue0(v.Line, OpMIPS64MOVBload, config.fe.TypeInt8())
		v4.AddArg(src)
		v4.AddArg(mem)
		v3.AddArg(v4)
		v3.AddArg(mem)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 6 && SizeAndAlign(s).Align()%2 == 0
	// result: (MOVHstore [4] dst (MOVHload [4] src mem) 		(MOVHstore [2] dst (MOVHload [2] src mem) 			(MOVHstore dst (MOVHload src mem) mem)))
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 6 && SizeAndAlign(s).Align()%2 == 0) {
			break
		}
		v.reset(OpMIPS64MOVHstore)
		v.AuxInt = 4
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVHload, config.fe.TypeInt16())
		v0.AuxInt = 4
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64MOVHstore, TypeMem)
		v1.AuxInt = 2
		v1.AddArg(dst)
		v2 := b.NewValue0(v.Line, OpMIPS64MOVHload, config.fe.TypeInt16())
		v2.AuxInt = 2
		v2.AddArg(src)
		v2.AddArg(mem)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpMIPS64MOVHstore, TypeMem)
		v3.AddArg(dst)
		v4 := b.NewValue0(v.Line, OpMIPS64MOVHload, config.fe.TypeInt16())
		v4.AddArg(src)
		v4.AddArg(mem)
		v3.AddArg(v4)
		v3.AddArg(mem)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 12 && SizeAndAlign(s).Align()%4 == 0
	// result: (MOVWstore [8] dst (MOVWload [8] src mem) 		(MOVWstore [4] dst (MOVWload [4] src mem) 			(MOVWstore dst (MOVWload src mem) mem)))
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 12 && SizeAndAlign(s).Align()%4 == 0) {
			break
		}
		v.reset(OpMIPS64MOVWstore)
		v.AuxInt = 8
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVWload, config.fe.TypeInt32())
		v0.AuxInt = 8
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64MOVWstore, TypeMem)
		v1.AuxInt = 4
		v1.AddArg(dst)
		v2 := b.NewValue0(v.Line, OpMIPS64MOVWload, config.fe.TypeInt32())
		v2.AuxInt = 4
		v2.AddArg(src)
		v2.AddArg(mem)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpMIPS64MOVWstore, TypeMem)
		v3.AddArg(dst)
		v4 := b.NewValue0(v.Line, OpMIPS64MOVWload, config.fe.TypeInt32())
		v4.AddArg(src)
		v4.AddArg(mem)
		v3.AddArg(v4)
		v3.AddArg(mem)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 16 && SizeAndAlign(s).Align()%8 == 0
	// result: (MOVVstore [8] dst (MOVVload [8] src mem) 		(MOVVstore dst (MOVVload src mem) mem))
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 16 && SizeAndAlign(s).Align()%8 == 0) {
			break
		}
		v.reset(OpMIPS64MOVVstore)
		v.AuxInt = 8
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVload, config.fe.TypeUInt64())
		v0.AuxInt = 8
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64MOVVstore, TypeMem)
		v1.AddArg(dst)
		v2 := b.NewValue0(v.Line, OpMIPS64MOVVload, config.fe.TypeUInt64())
		v2.AddArg(src)
		v2.AddArg(mem)
		v1.AddArg(v2)
		v1.AddArg(mem)
		v.AddArg(v1)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() == 24 && SizeAndAlign(s).Align()%8 == 0
	// result: (MOVVstore [16] dst (MOVVload [16] src mem) 		(MOVVstore [8] dst (MOVVload [8] src mem) 			(MOVVstore dst (MOVVload src mem) mem)))
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() == 24 && SizeAndAlign(s).Align()%8 == 0) {
			break
		}
		v.reset(OpMIPS64MOVVstore)
		v.AuxInt = 16
		v.AddArg(dst)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVload, config.fe.TypeUInt64())
		v0.AuxInt = 16
		v0.AddArg(src)
		v0.AddArg(mem)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64MOVVstore, TypeMem)
		v1.AuxInt = 8
		v1.AddArg(dst)
		v2 := b.NewValue0(v.Line, OpMIPS64MOVVload, config.fe.TypeUInt64())
		v2.AuxInt = 8
		v2.AddArg(src)
		v2.AddArg(mem)
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpMIPS64MOVVstore, TypeMem)
		v3.AddArg(dst)
		v4 := b.NewValue0(v.Line, OpMIPS64MOVVload, config.fe.TypeUInt64())
		v4.AddArg(src)
		v4.AddArg(mem)
		v3.AddArg(v4)
		v3.AddArg(mem)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
	// match: (Move [s] dst src mem)
	// cond: SizeAndAlign(s).Size() > 24 || SizeAndAlign(s).Align()%8 != 0
	// result: (LoweredMove [SizeAndAlign(s).Align()] 		dst 		src 		(ADDVconst <src.Type> src [SizeAndAlign(s).Size()-moveSize(SizeAndAlign(s).Align(), config)]) 		mem)
	for {
		s := v.AuxInt
		dst := v.Args[0]
		src := v.Args[1]
		mem := v.Args[2]
		if !(SizeAndAlign(s).Size() > 24 || SizeAndAlign(s).Align()%8 != 0) {
			break
		}
		v.reset(OpMIPS64LoweredMove)
		v.AuxInt = SizeAndAlign(s).Align()
		v.AddArg(dst)
		v.AddArg(src)
		v0 := b.NewValue0(v.Line, OpMIPS64ADDVconst, src.Type)
		v0.AuxInt = SizeAndAlign(s).Size() - moveSize(SizeAndAlign(s).Align(), config)
		v0.AddArg(src)
		v.AddArg(v0)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpMul16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mul16 x y)
	// cond:
	// result: (Select1 (MULVU x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpSelect1)
		v0 := b.NewValue0(v.Line, OpMIPS64MULVU, MakeTuple(config.fe.TypeUInt64(), config.fe.TypeUInt64()))
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpMul32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mul32 x y)
	// cond:
	// result: (Select1 (MULVU x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpSelect1)
		v0 := b.NewValue0(v.Line, OpMIPS64MULVU, MakeTuple(config.fe.TypeUInt64(), config.fe.TypeUInt64()))
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpMul32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mul32F x y)
	// cond:
	// result: (MULF x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64MULF)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpMul64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mul64 x y)
	// cond:
	// result: (Select1 (MULVU x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpSelect1)
		v0 := b.NewValue0(v.Line, OpMIPS64MULVU, MakeTuple(config.fe.TypeUInt64(), config.fe.TypeUInt64()))
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpMul64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mul64F x y)
	// cond:
	// result: (MULD x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64MULD)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpMul8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Mul8 x y)
	// cond:
	// result: (Select1 (MULVU x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpSelect1)
		v0 := b.NewValue0(v.Line, OpMIPS64MULVU, MakeTuple(config.fe.TypeUInt64(), config.fe.TypeUInt64()))
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpNeg16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neg16 x)
	// cond:
	// result: (NEGV x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64NEGV)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpNeg32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neg32 x)
	// cond:
	// result: (NEGV x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64NEGV)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpNeg32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neg32F x)
	// cond:
	// result: (NEGF x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64NEGF)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpNeg64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neg64 x)
	// cond:
	// result: (NEGV x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64NEGV)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpNeg64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neg64F x)
	// cond:
	// result: (NEGD x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64NEGD)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpNeg8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neg8 x)
	// cond:
	// result: (NEGV x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64NEGV)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpNeq16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neq16 x y)
	// cond:
	// result: (SGTU (XOR (ZeroExt16to32 x) (ZeroExt16to64 y)) (MOVVconst [0]))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SGTU)
		v0 := b.NewValue0(v.Line, OpMIPS64XOR, config.fe.TypeUInt64())
		v1 := b.NewValue0(v.Line, OpZeroExt16to32, config.fe.TypeUInt32())
		v1.AddArg(x)
		v0.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v2.AddArg(y)
		v0.AddArg(v2)
		v.AddArg(v0)
		v3 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v3.AuxInt = 0
		v.AddArg(v3)
		return true
	}
}
func rewriteValueMIPS64_OpNeq32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neq32 x y)
	// cond:
	// result: (SGTU (XOR (ZeroExt32to64 x) (ZeroExt32to64 y)) (MOVVconst [0]))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SGTU)
		v0 := b.NewValue0(v.Line, OpMIPS64XOR, config.fe.TypeUInt64())
		v1 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v2.AddArg(y)
		v0.AddArg(v2)
		v.AddArg(v0)
		v3 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v3.AuxInt = 0
		v.AddArg(v3)
		return true
	}
}
func rewriteValueMIPS64_OpNeq32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neq32F x y)
	// cond:
	// result: (FPFlagFalse (CMPEQF x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64FPFlagFalse)
		v0 := b.NewValue0(v.Line, OpMIPS64CMPEQF, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpNeq64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neq64 x y)
	// cond:
	// result: (SGTU (XOR x y) (MOVVconst [0]))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SGTU)
		v0 := b.NewValue0(v.Line, OpMIPS64XOR, config.fe.TypeUInt64())
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v1.AuxInt = 0
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpNeq64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neq64F x y)
	// cond:
	// result: (FPFlagFalse (CMPEQD x y))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64FPFlagFalse)
		v0 := b.NewValue0(v.Line, OpMIPS64CMPEQD, TypeFlags)
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpNeq8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Neq8 x y)
	// cond:
	// result: (SGTU (XOR (ZeroExt8to64 x) (ZeroExt8to64 y)) (MOVVconst [0]))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SGTU)
		v0 := b.NewValue0(v.Line, OpMIPS64XOR, config.fe.TypeUInt64())
		v1 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v1.AddArg(x)
		v0.AddArg(v1)
		v2 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v2.AddArg(y)
		v0.AddArg(v2)
		v.AddArg(v0)
		v3 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v3.AuxInt = 0
		v.AddArg(v3)
		return true
	}
}
func rewriteValueMIPS64_OpNeqB(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (NeqB x y)
	// cond:
	// result: (XOR x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64XOR)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpNeqPtr(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (NeqPtr x y)
	// cond:
	// result: (SGTU (XOR x y) (MOVVconst [0]))
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SGTU)
		v0 := b.NewValue0(v.Line, OpMIPS64XOR, config.fe.TypeUInt64())
		v0.AddArg(x)
		v0.AddArg(y)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v1.AuxInt = 0
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpNilCheck(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (NilCheck ptr mem)
	// cond:
	// result: (LoweredNilCheck ptr mem)
	for {
		ptr := v.Args[0]
		mem := v.Args[1]
		v.reset(OpMIPS64LoweredNilCheck)
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
}
func rewriteValueMIPS64_OpNot(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Not x)
	// cond:
	// result: (XORconst [1] x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64XORconst)
		v.AuxInt = 1
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpOffPtr(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (OffPtr [off] ptr:(SP))
	// cond:
	// result: (MOVVaddr [off] ptr)
	for {
		off := v.AuxInt
		ptr := v.Args[0]
		if ptr.Op != OpSP {
			break
		}
		v.reset(OpMIPS64MOVVaddr)
		v.AuxInt = off
		v.AddArg(ptr)
		return true
	}
	// match: (OffPtr [off] ptr)
	// cond:
	// result: (ADDVconst [off] ptr)
	for {
		off := v.AuxInt
		ptr := v.Args[0]
		v.reset(OpMIPS64ADDVconst)
		v.AuxInt = off
		v.AddArg(ptr)
		return true
	}
}
func rewriteValueMIPS64_OpOr16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Or16 x y)
	// cond:
	// result: (OR x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64OR)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpOr32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Or32 x y)
	// cond:
	// result: (OR x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64OR)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpOr64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Or64 x y)
	// cond:
	// result: (OR x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64OR)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpOr8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Or8 x y)
	// cond:
	// result: (OR x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64OR)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpOrB(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (OrB x y)
	// cond:
	// result: (OR x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64OR)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpRsh16Ux16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh16Ux16 <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) (ZeroExt16to64 y))) (SRLV <t> (ZeroExt16to64 x) (ZeroExt16to64 y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		v4 := b.NewValue0(v.Line, OpMIPS64SRLV, t)
		v5 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v5.AddArg(x)
		v4.AddArg(v5)
		v6 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v6.AddArg(y)
		v4.AddArg(v6)
		v.AddArg(v4)
		return true
	}
}
func rewriteValueMIPS64_OpRsh16Ux32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh16Ux32 <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) (ZeroExt32to64 y))) (SRLV <t> (ZeroExt16to64 x) (ZeroExt32to64 y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		v4 := b.NewValue0(v.Line, OpMIPS64SRLV, t)
		v5 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v5.AddArg(x)
		v4.AddArg(v5)
		v6 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v6.AddArg(y)
		v4.AddArg(v6)
		v.AddArg(v4)
		return true
	}
}
func rewriteValueMIPS64_OpRsh16Ux64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh16Ux64 <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) y)) (SRLV <t> (ZeroExt16to64 x) y))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v1.AddArg(y)
		v0.AddArg(v1)
		v.AddArg(v0)
		v3 := b.NewValue0(v.Line, OpMIPS64SRLV, t)
		v4 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v4.AddArg(x)
		v3.AddArg(v4)
		v3.AddArg(y)
		v.AddArg(v3)
		return true
	}
}
func rewriteValueMIPS64_OpRsh16Ux8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh16Ux8  <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) (ZeroExt8to64  y))) (SRLV <t> (ZeroExt16to64 x) (ZeroExt8to64  y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		v4 := b.NewValue0(v.Line, OpMIPS64SRLV, t)
		v5 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v5.AddArg(x)
		v4.AddArg(v5)
		v6 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v6.AddArg(y)
		v4.AddArg(v6)
		v.AddArg(v4)
		return true
	}
}
func rewriteValueMIPS64_OpRsh16x16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh16x16 <t> x y)
	// cond:
	// result: (SRAV (SignExt16to64 x) (OR <t> (NEGV <t> (SGTU (ZeroExt16to64 y) (Const64 <config.fe.TypeUInt64()> [63]))) (ZeroExt16to64 y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SRAV)
		v0 := b.NewValue0(v.Line, OpSignExt16to64, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64OR, t)
		v2 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v3 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v4 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v4.AddArg(y)
		v3.AddArg(v4)
		v5 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v5.AuxInt = 63
		v3.AddArg(v5)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v6 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v6.AddArg(y)
		v1.AddArg(v6)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpRsh16x32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh16x32 <t> x y)
	// cond:
	// result: (SRAV (SignExt16to64 x) (OR <t> (NEGV <t> (SGTU (ZeroExt32to64 y) (Const64 <config.fe.TypeUInt64()> [63]))) (ZeroExt32to64 y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SRAV)
		v0 := b.NewValue0(v.Line, OpSignExt16to64, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64OR, t)
		v2 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v3 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v4 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v4.AddArg(y)
		v3.AddArg(v4)
		v5 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v5.AuxInt = 63
		v3.AddArg(v5)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v6 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v6.AddArg(y)
		v1.AddArg(v6)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpRsh16x64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh16x64 <t> x y)
	// cond:
	// result: (SRAV (SignExt16to64 x) (OR <t> (NEGV <t> (SGTU y (Const64 <config.fe.TypeUInt64()> [63]))) y))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SRAV)
		v0 := b.NewValue0(v.Line, OpSignExt16to64, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64OR, t)
		v2 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v3 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v3.AddArg(y)
		v4 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v4.AuxInt = 63
		v3.AddArg(v4)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v1.AddArg(y)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpRsh16x8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh16x8  <t> x y)
	// cond:
	// result: (SRAV (SignExt16to64 x) (OR <t> (NEGV <t> (SGTU (ZeroExt8to64  y) (Const64 <config.fe.TypeUInt64()> [63]))) (ZeroExt8to64  y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SRAV)
		v0 := b.NewValue0(v.Line, OpSignExt16to64, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64OR, t)
		v2 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v3 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v4 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v4.AddArg(y)
		v3.AddArg(v4)
		v5 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v5.AuxInt = 63
		v3.AddArg(v5)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v6 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v6.AddArg(y)
		v1.AddArg(v6)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpRsh32Ux16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh32Ux16 <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) (ZeroExt16to64 y))) (SRLV <t> (ZeroExt32to64 x) (ZeroExt16to64 y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		v4 := b.NewValue0(v.Line, OpMIPS64SRLV, t)
		v5 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v5.AddArg(x)
		v4.AddArg(v5)
		v6 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v6.AddArg(y)
		v4.AddArg(v6)
		v.AddArg(v4)
		return true
	}
}
func rewriteValueMIPS64_OpRsh32Ux32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh32Ux32 <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) (ZeroExt32to64 y))) (SRLV <t> (ZeroExt32to64 x) (ZeroExt32to64 y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		v4 := b.NewValue0(v.Line, OpMIPS64SRLV, t)
		v5 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v5.AddArg(x)
		v4.AddArg(v5)
		v6 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v6.AddArg(y)
		v4.AddArg(v6)
		v.AddArg(v4)
		return true
	}
}
func rewriteValueMIPS64_OpRsh32Ux64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh32Ux64 <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) y)) (SRLV <t> (ZeroExt32to64 x) y))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v1.AddArg(y)
		v0.AddArg(v1)
		v.AddArg(v0)
		v3 := b.NewValue0(v.Line, OpMIPS64SRLV, t)
		v4 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v4.AddArg(x)
		v3.AddArg(v4)
		v3.AddArg(y)
		v.AddArg(v3)
		return true
	}
}
func rewriteValueMIPS64_OpRsh32Ux8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh32Ux8  <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) (ZeroExt8to64  y))) (SRLV <t> (ZeroExt32to64 x) (ZeroExt8to64  y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		v4 := b.NewValue0(v.Line, OpMIPS64SRLV, t)
		v5 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v5.AddArg(x)
		v4.AddArg(v5)
		v6 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v6.AddArg(y)
		v4.AddArg(v6)
		v.AddArg(v4)
		return true
	}
}
func rewriteValueMIPS64_OpRsh32x16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh32x16 <t> x y)
	// cond:
	// result: (SRAV (SignExt32to64 x) (OR <t> (NEGV <t> (SGTU (ZeroExt16to64 y) (Const64 <config.fe.TypeUInt64()> [63]))) (ZeroExt16to64 y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SRAV)
		v0 := b.NewValue0(v.Line, OpSignExt32to64, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64OR, t)
		v2 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v3 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v4 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v4.AddArg(y)
		v3.AddArg(v4)
		v5 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v5.AuxInt = 63
		v3.AddArg(v5)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v6 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v6.AddArg(y)
		v1.AddArg(v6)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpRsh32x32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh32x32 <t> x y)
	// cond:
	// result: (SRAV (SignExt32to64 x) (OR <t> (NEGV <t> (SGTU (ZeroExt32to64 y) (Const64 <config.fe.TypeUInt64()> [63]))) (ZeroExt32to64 y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SRAV)
		v0 := b.NewValue0(v.Line, OpSignExt32to64, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64OR, t)
		v2 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v3 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v4 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v4.AddArg(y)
		v3.AddArg(v4)
		v5 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v5.AuxInt = 63
		v3.AddArg(v5)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v6 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v6.AddArg(y)
		v1.AddArg(v6)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpRsh32x64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh32x64 <t> x y)
	// cond:
	// result: (SRAV (SignExt32to64 x) (OR <t> (NEGV <t> (SGTU y (Const64 <config.fe.TypeUInt64()> [63]))) y))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SRAV)
		v0 := b.NewValue0(v.Line, OpSignExt32to64, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64OR, t)
		v2 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v3 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v3.AddArg(y)
		v4 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v4.AuxInt = 63
		v3.AddArg(v4)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v1.AddArg(y)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpRsh32x8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh32x8  <t> x y)
	// cond:
	// result: (SRAV (SignExt32to64 x) (OR <t> (NEGV <t> (SGTU (ZeroExt8to64  y) (Const64 <config.fe.TypeUInt64()> [63]))) (ZeroExt8to64  y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SRAV)
		v0 := b.NewValue0(v.Line, OpSignExt32to64, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64OR, t)
		v2 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v3 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v4 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v4.AddArg(y)
		v3.AddArg(v4)
		v5 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v5.AuxInt = 63
		v3.AddArg(v5)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v6 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v6.AddArg(y)
		v1.AddArg(v6)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpRsh64Ux16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh64Ux16 <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) (ZeroExt16to64 y))) (SRLV <t> x (ZeroExt16to64 y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		v4 := b.NewValue0(v.Line, OpMIPS64SRLV, t)
		v4.AddArg(x)
		v5 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v5.AddArg(y)
		v4.AddArg(v5)
		v.AddArg(v4)
		return true
	}
}
func rewriteValueMIPS64_OpRsh64Ux32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh64Ux32 <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) (ZeroExt32to64 y))) (SRLV <t> x (ZeroExt32to64 y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		v4 := b.NewValue0(v.Line, OpMIPS64SRLV, t)
		v4.AddArg(x)
		v5 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v5.AddArg(y)
		v4.AddArg(v5)
		v.AddArg(v4)
		return true
	}
}
func rewriteValueMIPS64_OpRsh64Ux64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh64Ux64 <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) y)) (SRLV <t> x y))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v1.AddArg(y)
		v0.AddArg(v1)
		v.AddArg(v0)
		v3 := b.NewValue0(v.Line, OpMIPS64SRLV, t)
		v3.AddArg(x)
		v3.AddArg(y)
		v.AddArg(v3)
		return true
	}
}
func rewriteValueMIPS64_OpRsh64Ux8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh64Ux8  <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) (ZeroExt8to64  y))) (SRLV <t> x (ZeroExt8to64  y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		v4 := b.NewValue0(v.Line, OpMIPS64SRLV, t)
		v4.AddArg(x)
		v5 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v5.AddArg(y)
		v4.AddArg(v5)
		v.AddArg(v4)
		return true
	}
}
func rewriteValueMIPS64_OpRsh64x16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh64x16 <t> x y)
	// cond:
	// result: (SRAV x (OR <t> (NEGV <t> (SGTU (ZeroExt16to64 y) (Const64 <config.fe.TypeUInt64()> [63]))) (ZeroExt16to64 y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SRAV)
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, OpMIPS64OR, t)
		v1 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v2 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v3 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v2.AddArg(v3)
		v4 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v4.AuxInt = 63
		v2.AddArg(v4)
		v1.AddArg(v2)
		v0.AddArg(v1)
		v5 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v5.AddArg(y)
		v0.AddArg(v5)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpRsh64x32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh64x32 <t> x y)
	// cond:
	// result: (SRAV x (OR <t> (NEGV <t> (SGTU (ZeroExt32to64 y) (Const64 <config.fe.TypeUInt64()> [63]))) (ZeroExt32to64 y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SRAV)
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, OpMIPS64OR, t)
		v1 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v2 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v3 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v2.AddArg(v3)
		v4 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v4.AuxInt = 63
		v2.AddArg(v4)
		v1.AddArg(v2)
		v0.AddArg(v1)
		v5 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v5.AddArg(y)
		v0.AddArg(v5)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpRsh64x64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh64x64 <t> x y)
	// cond:
	// result: (SRAV x (OR <t> (NEGV <t> (SGTU y (Const64 <config.fe.TypeUInt64()> [63]))) y))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SRAV)
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, OpMIPS64OR, t)
		v1 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v2 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2.AddArg(y)
		v3 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v3.AuxInt = 63
		v2.AddArg(v3)
		v1.AddArg(v2)
		v0.AddArg(v1)
		v0.AddArg(y)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpRsh64x8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh64x8  <t> x y)
	// cond:
	// result: (SRAV x (OR <t> (NEGV <t> (SGTU (ZeroExt8to64  y) (Const64 <config.fe.TypeUInt64()> [63]))) (ZeroExt8to64  y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SRAV)
		v.AddArg(x)
		v0 := b.NewValue0(v.Line, OpMIPS64OR, t)
		v1 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v2 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v3 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v2.AddArg(v3)
		v4 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v4.AuxInt = 63
		v2.AddArg(v4)
		v1.AddArg(v2)
		v0.AddArg(v1)
		v5 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v5.AddArg(y)
		v0.AddArg(v5)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpRsh8Ux16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh8Ux16 <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) (ZeroExt16to64 y))) (SRLV <t> (ZeroExt8to64 x) (ZeroExt16to64 y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		v4 := b.NewValue0(v.Line, OpMIPS64SRLV, t)
		v5 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v5.AddArg(x)
		v4.AddArg(v5)
		v6 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v6.AddArg(y)
		v4.AddArg(v6)
		v.AddArg(v4)
		return true
	}
}
func rewriteValueMIPS64_OpRsh8Ux32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh8Ux32 <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) (ZeroExt32to64 y))) (SRLV <t> (ZeroExt8to64 x) (ZeroExt32to64 y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		v4 := b.NewValue0(v.Line, OpMIPS64SRLV, t)
		v5 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v5.AddArg(x)
		v4.AddArg(v5)
		v6 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v6.AddArg(y)
		v4.AddArg(v6)
		v.AddArg(v4)
		return true
	}
}
func rewriteValueMIPS64_OpRsh8Ux64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh8Ux64 <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) y)) (SRLV <t> (ZeroExt8to64 x) y))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v1.AddArg(y)
		v0.AddArg(v1)
		v.AddArg(v0)
		v3 := b.NewValue0(v.Line, OpMIPS64SRLV, t)
		v4 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v4.AddArg(x)
		v3.AddArg(v4)
		v3.AddArg(y)
		v.AddArg(v3)
		return true
	}
}
func rewriteValueMIPS64_OpRsh8Ux8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh8Ux8  <t> x y)
	// cond:
	// result: (AND (NEGV <t> (SGTU (Const64 <config.fe.TypeUInt64()> [64]) (ZeroExt8to64  y))) (SRLV <t> (ZeroExt8to64 x) (ZeroExt8to64  y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64AND)
		v0 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v1 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v2 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v2.AuxInt = 64
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v3.AddArg(y)
		v1.AddArg(v3)
		v0.AddArg(v1)
		v.AddArg(v0)
		v4 := b.NewValue0(v.Line, OpMIPS64SRLV, t)
		v5 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v5.AddArg(x)
		v4.AddArg(v5)
		v6 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v6.AddArg(y)
		v4.AddArg(v6)
		v.AddArg(v4)
		return true
	}
}
func rewriteValueMIPS64_OpRsh8x16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh8x16 <t> x y)
	// cond:
	// result: (SRAV (SignExt8to64 x) (OR <t> (NEGV <t> (SGTU (ZeroExt16to64 y) (Const64 <config.fe.TypeUInt64()> [63]))) (ZeroExt16to64 y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SRAV)
		v0 := b.NewValue0(v.Line, OpSignExt8to64, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64OR, t)
		v2 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v3 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v4 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v4.AddArg(y)
		v3.AddArg(v4)
		v5 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v5.AuxInt = 63
		v3.AddArg(v5)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v6 := b.NewValue0(v.Line, OpZeroExt16to64, config.fe.TypeUInt64())
		v6.AddArg(y)
		v1.AddArg(v6)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpRsh8x32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh8x32 <t> x y)
	// cond:
	// result: (SRAV (SignExt8to64 x) (OR <t> (NEGV <t> (SGTU (ZeroExt32to64 y) (Const64 <config.fe.TypeUInt64()> [63]))) (ZeroExt32to64 y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SRAV)
		v0 := b.NewValue0(v.Line, OpSignExt8to64, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64OR, t)
		v2 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v3 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v4 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v4.AddArg(y)
		v3.AddArg(v4)
		v5 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v5.AuxInt = 63
		v3.AddArg(v5)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v6 := b.NewValue0(v.Line, OpZeroExt32to64, config.fe.TypeUInt64())
		v6.AddArg(y)
		v1.AddArg(v6)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpRsh8x64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh8x64 <t> x y)
	// cond:
	// result: (SRAV (SignExt8to64 x) (OR <t> (NEGV <t> (SGTU y (Const64 <config.fe.TypeUInt64()> [63]))) y))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SRAV)
		v0 := b.NewValue0(v.Line, OpSignExt8to64, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64OR, t)
		v2 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v3 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v3.AddArg(y)
		v4 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v4.AuxInt = 63
		v3.AddArg(v4)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v1.AddArg(y)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpRsh8x8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Rsh8x8  <t> x y)
	// cond:
	// result: (SRAV (SignExt8to64 x) (OR <t> (NEGV <t> (SGTU (ZeroExt8to64  y) (Const64 <config.fe.TypeUInt64()> [63]))) (ZeroExt8to64  y)))
	for {
		t := v.Type
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SRAV)
		v0 := b.NewValue0(v.Line, OpSignExt8to64, config.fe.TypeInt64())
		v0.AddArg(x)
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64OR, t)
		v2 := b.NewValue0(v.Line, OpMIPS64NEGV, t)
		v3 := b.NewValue0(v.Line, OpMIPS64SGTU, config.fe.TypeBool())
		v4 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v4.AddArg(y)
		v3.AddArg(v4)
		v5 := b.NewValue0(v.Line, OpConst64, config.fe.TypeUInt64())
		v5.AuxInt = 63
		v3.AddArg(v5)
		v2.AddArg(v3)
		v1.AddArg(v2)
		v6 := b.NewValue0(v.Line, OpZeroExt8to64, config.fe.TypeUInt64())
		v6.AddArg(y)
		v1.AddArg(v6)
		v.AddArg(v1)
		return true
	}
}
func rewriteValueMIPS64_OpSelect0(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Select0 (DIVVU _ (MOVVconst [1])))
	// cond:
	// result: (MOVVconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64DIVVU {
			break
		}
		v_0_1 := v_0.Args[1]
		if v_0_1.Op != OpMIPS64MOVVconst {
			break
		}
		if v_0_1.AuxInt != 1 {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 0
		return true
	}
	// match: (Select0 (DIVVU x (MOVVconst [c])))
	// cond: isPowerOfTwo(c)
	// result: (ANDconst [c-1] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64DIVVU {
			break
		}
		x := v_0.Args[0]
		v_0_1 := v_0.Args[1]
		if v_0_1.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_0_1.AuxInt
		if !(isPowerOfTwo(c)) {
			break
		}
		v.reset(OpMIPS64ANDconst)
		v.AuxInt = c - 1
		v.AddArg(x)
		return true
	}
	// match: (Select0 (DIVV  (MOVVconst [c]) (MOVVconst [d])))
	// cond:
	// result: (MOVVconst [int64(c)%int64(d)])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64DIVV {
			break
		}
		v_0_0 := v_0.Args[0]
		if v_0_0.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_0_0.AuxInt
		v_0_1 := v_0.Args[1]
		if v_0_1.Op != OpMIPS64MOVVconst {
			break
		}
		d := v_0_1.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = int64(c) % int64(d)
		return true
	}
	// match: (Select0 (DIVVU (MOVVconst [c]) (MOVVconst [d])))
	// cond:
	// result: (MOVVconst [int64(uint64(c)%uint64(d))])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64DIVVU {
			break
		}
		v_0_0 := v_0.Args[0]
		if v_0_0.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_0_0.AuxInt
		v_0_1 := v_0.Args[1]
		if v_0_1.Op != OpMIPS64MOVVconst {
			break
		}
		d := v_0_1.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = int64(uint64(c) % uint64(d))
		return true
	}
	return false
}
func rewriteValueMIPS64_OpSelect1(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Select1 (MULVU x (MOVVconst [-1])))
	// cond:
	// result: (NEGV x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MULVU {
			break
		}
		x := v_0.Args[0]
		v_0_1 := v_0.Args[1]
		if v_0_1.Op != OpMIPS64MOVVconst {
			break
		}
		if v_0_1.AuxInt != -1 {
			break
		}
		v.reset(OpMIPS64NEGV)
		v.AddArg(x)
		return true
	}
	// match: (Select1 (MULVU _ (MOVVconst [0])))
	// cond:
	// result: (MOVVconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MULVU {
			break
		}
		v_0_1 := v_0.Args[1]
		if v_0_1.Op != OpMIPS64MOVVconst {
			break
		}
		if v_0_1.AuxInt != 0 {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 0
		return true
	}
	// match: (Select1 (MULVU x (MOVVconst [1])))
	// cond:
	// result: x
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MULVU {
			break
		}
		x := v_0.Args[0]
		v_0_1 := v_0.Args[1]
		if v_0_1.Op != OpMIPS64MOVVconst {
			break
		}
		if v_0_1.AuxInt != 1 {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (Select1 (MULVU x (MOVVconst [c])))
	// cond: isPowerOfTwo(c)
	// result: (SLLVconst [log2(c)] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MULVU {
			break
		}
		x := v_0.Args[0]
		v_0_1 := v_0.Args[1]
		if v_0_1.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_0_1.AuxInt
		if !(isPowerOfTwo(c)) {
			break
		}
		v.reset(OpMIPS64SLLVconst)
		v.AuxInt = log2(c)
		v.AddArg(x)
		return true
	}
	// match: (Select1 (MULVU (MOVVconst [-1]) x))
	// cond:
	// result: (NEGV x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MULVU {
			break
		}
		v_0_0 := v_0.Args[0]
		if v_0_0.Op != OpMIPS64MOVVconst {
			break
		}
		if v_0_0.AuxInt != -1 {
			break
		}
		x := v_0.Args[1]
		v.reset(OpMIPS64NEGV)
		v.AddArg(x)
		return true
	}
	// match: (Select1 (MULVU (MOVVconst [0]) _))
	// cond:
	// result: (MOVVconst [0])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MULVU {
			break
		}
		v_0_0 := v_0.Args[0]
		if v_0_0.Op != OpMIPS64MOVVconst {
			break
		}
		if v_0_0.AuxInt != 0 {
			break
		}
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = 0
		return true
	}
	// match: (Select1 (MULVU (MOVVconst [1]) x))
	// cond:
	// result: x
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MULVU {
			break
		}
		v_0_0 := v_0.Args[0]
		if v_0_0.Op != OpMIPS64MOVVconst {
			break
		}
		if v_0_0.AuxInt != 1 {
			break
		}
		x := v_0.Args[1]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (Select1 (MULVU (MOVVconst [c]) x))
	// cond: isPowerOfTwo(c)
	// result: (SLLVconst [log2(c)] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MULVU {
			break
		}
		v_0_0 := v_0.Args[0]
		if v_0_0.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_0_0.AuxInt
		x := v_0.Args[1]
		if !(isPowerOfTwo(c)) {
			break
		}
		v.reset(OpMIPS64SLLVconst)
		v.AuxInt = log2(c)
		v.AddArg(x)
		return true
	}
	// match: (Select1 (DIVVU x (MOVVconst [1])))
	// cond:
	// result: x
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64DIVVU {
			break
		}
		x := v_0.Args[0]
		v_0_1 := v_0.Args[1]
		if v_0_1.Op != OpMIPS64MOVVconst {
			break
		}
		if v_0_1.AuxInt != 1 {
			break
		}
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
	// match: (Select1 (DIVVU x (MOVVconst [c])))
	// cond: isPowerOfTwo(c)
	// result: (SRLVconst [log2(c)] x)
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64DIVVU {
			break
		}
		x := v_0.Args[0]
		v_0_1 := v_0.Args[1]
		if v_0_1.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_0_1.AuxInt
		if !(isPowerOfTwo(c)) {
			break
		}
		v.reset(OpMIPS64SRLVconst)
		v.AuxInt = log2(c)
		v.AddArg(x)
		return true
	}
	// match: (Select1 (MULVU (MOVVconst [c]) (MOVVconst [d])))
	// cond:
	// result: (MOVVconst [c*d])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64MULVU {
			break
		}
		v_0_0 := v_0.Args[0]
		if v_0_0.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_0_0.AuxInt
		v_0_1 := v_0.Args[1]
		if v_0_1.Op != OpMIPS64MOVVconst {
			break
		}
		d := v_0_1.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = c * d
		return true
	}
	// match: (Select1 (DIVV  (MOVVconst [c]) (MOVVconst [d])))
	// cond:
	// result: (MOVVconst [int64(c)/int64(d)])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64DIVV {
			break
		}
		v_0_0 := v_0.Args[0]
		if v_0_0.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_0_0.AuxInt
		v_0_1 := v_0.Args[1]
		if v_0_1.Op != OpMIPS64MOVVconst {
			break
		}
		d := v_0_1.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = int64(c) / int64(d)
		return true
	}
	// match: (Select1 (DIVVU (MOVVconst [c]) (MOVVconst [d])))
	// cond:
	// result: (MOVVconst [int64(uint64(c)/uint64(d))])
	for {
		v_0 := v.Args[0]
		if v_0.Op != OpMIPS64DIVVU {
			break
		}
		v_0_0 := v_0.Args[0]
		if v_0_0.Op != OpMIPS64MOVVconst {
			break
		}
		c := v_0_0.AuxInt
		v_0_1 := v_0.Args[1]
		if v_0_1.Op != OpMIPS64MOVVconst {
			break
		}
		d := v_0_1.AuxInt
		v.reset(OpMIPS64MOVVconst)
		v.AuxInt = int64(uint64(c) / uint64(d))
		return true
	}
	return false
}
func rewriteValueMIPS64_OpSignExt16to32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SignExt16to32 x)
	// cond:
	// result: (MOVHreg x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64MOVHreg)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpSignExt16to64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SignExt16to64 x)
	// cond:
	// result: (MOVHreg x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64MOVHreg)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpSignExt32to64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SignExt32to64 x)
	// cond:
	// result: (MOVWreg x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64MOVWreg)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpSignExt8to16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SignExt8to16 x)
	// cond:
	// result: (MOVBreg x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64MOVBreg)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpSignExt8to32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SignExt8to32 x)
	// cond:
	// result: (MOVBreg x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64MOVBreg)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpSignExt8to64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SignExt8to64 x)
	// cond:
	// result: (MOVBreg x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64MOVBreg)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpSlicemask(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Slicemask <t> x)
	// cond:
	// result: (NORconst [0] (SRAVconst <t> (SUBVconst <t> x [1]) [63]))
	for {
		t := v.Type
		x := v.Args[0]
		v.reset(OpMIPS64NORconst)
		v.AuxInt = 0
		v0 := b.NewValue0(v.Line, OpMIPS64SRAVconst, t)
		v0.AuxInt = 63
		v1 := b.NewValue0(v.Line, OpMIPS64SUBVconst, t)
		v1.AuxInt = 1
		v1.AddArg(x)
		v0.AddArg(v1)
		v.AddArg(v0)
		return true
	}
}
func rewriteValueMIPS64_OpStaticCall(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (StaticCall [argwid] {target} mem)
	// cond:
	// result: (CALLstatic [argwid] {target} mem)
	for {
		argwid := v.AuxInt
		target := v.Aux
		mem := v.Args[0]
		v.reset(OpMIPS64CALLstatic)
		v.AuxInt = argwid
		v.Aux = target
		v.AddArg(mem)
		return true
	}
}
func rewriteValueMIPS64_OpStore(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Store [1] ptr val mem)
	// cond:
	// result: (MOVBstore ptr val mem)
	for {
		if v.AuxInt != 1 {
			break
		}
		ptr := v.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		v.reset(OpMIPS64MOVBstore)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (Store [2] ptr val mem)
	// cond:
	// result: (MOVHstore ptr val mem)
	for {
		if v.AuxInt != 2 {
			break
		}
		ptr := v.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		v.reset(OpMIPS64MOVHstore)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (Store [4] ptr val mem)
	// cond: !is32BitFloat(val.Type)
	// result: (MOVWstore ptr val mem)
	for {
		if v.AuxInt != 4 {
			break
		}
		ptr := v.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(!is32BitFloat(val.Type)) {
			break
		}
		v.reset(OpMIPS64MOVWstore)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (Store [8] ptr val mem)
	// cond: !is64BitFloat(val.Type)
	// result: (MOVVstore ptr val mem)
	for {
		if v.AuxInt != 8 {
			break
		}
		ptr := v.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(!is64BitFloat(val.Type)) {
			break
		}
		v.reset(OpMIPS64MOVVstore)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (Store [4] ptr val mem)
	// cond: is32BitFloat(val.Type)
	// result: (MOVFstore ptr val mem)
	for {
		if v.AuxInt != 4 {
			break
		}
		ptr := v.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is32BitFloat(val.Type)) {
			break
		}
		v.reset(OpMIPS64MOVFstore)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	// match: (Store [8] ptr val mem)
	// cond: is64BitFloat(val.Type)
	// result: (MOVDstore ptr val mem)
	for {
		if v.AuxInt != 8 {
			break
		}
		ptr := v.Args[0]
		val := v.Args[1]
		mem := v.Args[2]
		if !(is64BitFloat(val.Type)) {
			break
		}
		v.reset(OpMIPS64MOVDstore)
		v.AddArg(ptr)
		v.AddArg(val)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpSub16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Sub16 x y)
	// cond:
	// result: (SUBV x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SUBV)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpSub32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Sub32 x y)
	// cond:
	// result: (SUBV x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SUBV)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpSub32F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Sub32F x y)
	// cond:
	// result: (SUBF x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SUBF)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpSub64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Sub64 x y)
	// cond:
	// result: (SUBV x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SUBV)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpSub64F(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Sub64F x y)
	// cond:
	// result: (SUBD x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SUBD)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpSub8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Sub8 x y)
	// cond:
	// result: (SUBV x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SUBV)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpSubPtr(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (SubPtr x y)
	// cond:
	// result: (SUBV x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64SUBV)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpTrunc16to8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Trunc16to8 x)
	// cond:
	// result: x
	for {
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpTrunc32to16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Trunc32to16 x)
	// cond:
	// result: x
	for {
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpTrunc32to8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Trunc32to8 x)
	// cond:
	// result: x
	for {
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpTrunc64to16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Trunc64to16 x)
	// cond:
	// result: x
	for {
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpTrunc64to32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Trunc64to32 x)
	// cond:
	// result: x
	for {
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpTrunc64to8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Trunc64to8 x)
	// cond:
	// result: x
	for {
		x := v.Args[0]
		v.reset(OpCopy)
		v.Type = x.Type
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpXor16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Xor16 x y)
	// cond:
	// result: (XOR x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64XOR)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpXor32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Xor32 x y)
	// cond:
	// result: (XOR x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64XOR)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpXor64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Xor64 x y)
	// cond:
	// result: (XOR x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64XOR)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpXor8(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Xor8 x y)
	// cond:
	// result: (XOR x y)
	for {
		x := v.Args[0]
		y := v.Args[1]
		v.reset(OpMIPS64XOR)
		v.AddArg(x)
		v.AddArg(y)
		return true
	}
}
func rewriteValueMIPS64_OpZero(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (Zero [s] _ mem)
	// cond: SizeAndAlign(s).Size() == 0
	// result: mem
	for {
		s := v.AuxInt
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 0) {
			break
		}
		v.reset(OpCopy)
		v.Type = mem.Type
		v.AddArg(mem)
		return true
	}
	// match: (Zero [s] ptr mem)
	// cond: SizeAndAlign(s).Size() == 1
	// result: (MOVBstore ptr (MOVVconst [0]) mem)
	for {
		s := v.AuxInt
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 1) {
			break
		}
		v.reset(OpMIPS64MOVBstore)
		v.AddArg(ptr)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v.AddArg(mem)
		return true
	}
	// match: (Zero [s] ptr mem)
	// cond: SizeAndAlign(s).Size() == 2 && SizeAndAlign(s).Align()%2 == 0
	// result: (MOVHstore ptr (MOVVconst [0]) mem)
	for {
		s := v.AuxInt
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 2 && SizeAndAlign(s).Align()%2 == 0) {
			break
		}
		v.reset(OpMIPS64MOVHstore)
		v.AddArg(ptr)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v.AddArg(mem)
		return true
	}
	// match: (Zero [s] ptr mem)
	// cond: SizeAndAlign(s).Size() == 2
	// result: (MOVBstore [1] ptr (MOVVconst [0]) 		(MOVBstore [0] ptr (MOVVconst [0]) mem))
	for {
		s := v.AuxInt
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 2) {
			break
		}
		v.reset(OpMIPS64MOVBstore)
		v.AuxInt = 1
		v.AddArg(ptr)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64MOVBstore, TypeMem)
		v1.AuxInt = 0
		v1.AddArg(ptr)
		v2 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v2.AuxInt = 0
		v1.AddArg(v2)
		v1.AddArg(mem)
		v.AddArg(v1)
		return true
	}
	// match: (Zero [s] ptr mem)
	// cond: SizeAndAlign(s).Size() == 4 && SizeAndAlign(s).Align()%4 == 0
	// result: (MOVWstore ptr (MOVVconst [0]) mem)
	for {
		s := v.AuxInt
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 4 && SizeAndAlign(s).Align()%4 == 0) {
			break
		}
		v.reset(OpMIPS64MOVWstore)
		v.AddArg(ptr)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v.AddArg(mem)
		return true
	}
	// match: (Zero [s] ptr mem)
	// cond: SizeAndAlign(s).Size() == 4 && SizeAndAlign(s).Align()%2 == 0
	// result: (MOVHstore [2] ptr (MOVVconst [0]) 		(MOVHstore [0] ptr (MOVVconst [0]) mem))
	for {
		s := v.AuxInt
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 4 && SizeAndAlign(s).Align()%2 == 0) {
			break
		}
		v.reset(OpMIPS64MOVHstore)
		v.AuxInt = 2
		v.AddArg(ptr)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64MOVHstore, TypeMem)
		v1.AuxInt = 0
		v1.AddArg(ptr)
		v2 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v2.AuxInt = 0
		v1.AddArg(v2)
		v1.AddArg(mem)
		v.AddArg(v1)
		return true
	}
	// match: (Zero [s] ptr mem)
	// cond: SizeAndAlign(s).Size() == 4
	// result: (MOVBstore [3] ptr (MOVVconst [0]) 		(MOVBstore [2] ptr (MOVVconst [0]) 			(MOVBstore [1] ptr (MOVVconst [0]) 				(MOVBstore [0] ptr (MOVVconst [0]) mem))))
	for {
		s := v.AuxInt
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 4) {
			break
		}
		v.reset(OpMIPS64MOVBstore)
		v.AuxInt = 3
		v.AddArg(ptr)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64MOVBstore, TypeMem)
		v1.AuxInt = 2
		v1.AddArg(ptr)
		v2 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v2.AuxInt = 0
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpMIPS64MOVBstore, TypeMem)
		v3.AuxInt = 1
		v3.AddArg(ptr)
		v4 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v4.AuxInt = 0
		v3.AddArg(v4)
		v5 := b.NewValue0(v.Line, OpMIPS64MOVBstore, TypeMem)
		v5.AuxInt = 0
		v5.AddArg(ptr)
		v6 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v6.AuxInt = 0
		v5.AddArg(v6)
		v5.AddArg(mem)
		v3.AddArg(v5)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
	// match: (Zero [s] ptr mem)
	// cond: SizeAndAlign(s).Size() == 8 && SizeAndAlign(s).Align()%8 == 0
	// result: (MOVVstore ptr (MOVVconst [0]) mem)
	for {
		s := v.AuxInt
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 8 && SizeAndAlign(s).Align()%8 == 0) {
			break
		}
		v.reset(OpMIPS64MOVVstore)
		v.AddArg(ptr)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v.AddArg(mem)
		return true
	}
	// match: (Zero [s] ptr mem)
	// cond: SizeAndAlign(s).Size() == 8 && SizeAndAlign(s).Align()%4 == 0
	// result: (MOVWstore [4] ptr (MOVVconst [0]) 		(MOVWstore [0] ptr (MOVVconst [0]) mem))
	for {
		s := v.AuxInt
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 8 && SizeAndAlign(s).Align()%4 == 0) {
			break
		}
		v.reset(OpMIPS64MOVWstore)
		v.AuxInt = 4
		v.AddArg(ptr)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64MOVWstore, TypeMem)
		v1.AuxInt = 0
		v1.AddArg(ptr)
		v2 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v2.AuxInt = 0
		v1.AddArg(v2)
		v1.AddArg(mem)
		v.AddArg(v1)
		return true
	}
	// match: (Zero [s] ptr mem)
	// cond: SizeAndAlign(s).Size() == 4
	// result: (MOVHstore [6] ptr (MOVVconst [0]) 		(MOVHstore [4] ptr (MOVVconst [0]) 			(MOVHstore [2] ptr (MOVVconst [0]) 				(MOVHstore [0] ptr (MOVVconst [0]) mem))))
	for {
		s := v.AuxInt
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 4) {
			break
		}
		v.reset(OpMIPS64MOVHstore)
		v.AuxInt = 6
		v.AddArg(ptr)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64MOVHstore, TypeMem)
		v1.AuxInt = 4
		v1.AddArg(ptr)
		v2 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v2.AuxInt = 0
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpMIPS64MOVHstore, TypeMem)
		v3.AuxInt = 2
		v3.AddArg(ptr)
		v4 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v4.AuxInt = 0
		v3.AddArg(v4)
		v5 := b.NewValue0(v.Line, OpMIPS64MOVHstore, TypeMem)
		v5.AuxInt = 0
		v5.AddArg(ptr)
		v6 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v6.AuxInt = 0
		v5.AddArg(v6)
		v5.AddArg(mem)
		v3.AddArg(v5)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
	// match: (Zero [s] ptr mem)
	// cond: SizeAndAlign(s).Size() == 3
	// result: (MOVBstore [2] ptr (MOVVconst [0]) 		(MOVBstore [1] ptr (MOVVconst [0]) 			(MOVBstore [0] ptr (MOVVconst [0]) mem)))
	for {
		s := v.AuxInt
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 3) {
			break
		}
		v.reset(OpMIPS64MOVBstore)
		v.AuxInt = 2
		v.AddArg(ptr)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64MOVBstore, TypeMem)
		v1.AuxInt = 1
		v1.AddArg(ptr)
		v2 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v2.AuxInt = 0
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpMIPS64MOVBstore, TypeMem)
		v3.AuxInt = 0
		v3.AddArg(ptr)
		v4 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v4.AuxInt = 0
		v3.AddArg(v4)
		v3.AddArg(mem)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
	// match: (Zero [s] ptr mem)
	// cond: SizeAndAlign(s).Size() == 6 && SizeAndAlign(s).Align()%2 == 0
	// result: (MOVHstore [4] ptr (MOVVconst [0]) 		(MOVHstore [2] ptr (MOVVconst [0]) 			(MOVHstore [0] ptr (MOVVconst [0]) mem)))
	for {
		s := v.AuxInt
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 6 && SizeAndAlign(s).Align()%2 == 0) {
			break
		}
		v.reset(OpMIPS64MOVHstore)
		v.AuxInt = 4
		v.AddArg(ptr)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64MOVHstore, TypeMem)
		v1.AuxInt = 2
		v1.AddArg(ptr)
		v2 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v2.AuxInt = 0
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpMIPS64MOVHstore, TypeMem)
		v3.AuxInt = 0
		v3.AddArg(ptr)
		v4 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v4.AuxInt = 0
		v3.AddArg(v4)
		v3.AddArg(mem)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
	// match: (Zero [s] ptr mem)
	// cond: SizeAndAlign(s).Size() == 12 && SizeAndAlign(s).Align()%4 == 0
	// result: (MOVWstore [8] ptr (MOVVconst [0]) 		(MOVWstore [4] ptr (MOVVconst [0]) 			(MOVWstore [0] ptr (MOVVconst [0]) mem)))
	for {
		s := v.AuxInt
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 12 && SizeAndAlign(s).Align()%4 == 0) {
			break
		}
		v.reset(OpMIPS64MOVWstore)
		v.AuxInt = 8
		v.AddArg(ptr)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64MOVWstore, TypeMem)
		v1.AuxInt = 4
		v1.AddArg(ptr)
		v2 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v2.AuxInt = 0
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpMIPS64MOVWstore, TypeMem)
		v3.AuxInt = 0
		v3.AddArg(ptr)
		v4 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v4.AuxInt = 0
		v3.AddArg(v4)
		v3.AddArg(mem)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
	// match: (Zero [s] ptr mem)
	// cond: SizeAndAlign(s).Size() == 16 && SizeAndAlign(s).Align()%8 == 0
	// result: (MOVVstore [8] ptr (MOVVconst [0]) 		(MOVVstore [0] ptr (MOVVconst [0]) mem))
	for {
		s := v.AuxInt
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 16 && SizeAndAlign(s).Align()%8 == 0) {
			break
		}
		v.reset(OpMIPS64MOVVstore)
		v.AuxInt = 8
		v.AddArg(ptr)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64MOVVstore, TypeMem)
		v1.AuxInt = 0
		v1.AddArg(ptr)
		v2 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v2.AuxInt = 0
		v1.AddArg(v2)
		v1.AddArg(mem)
		v.AddArg(v1)
		return true
	}
	// match: (Zero [s] ptr mem)
	// cond: SizeAndAlign(s).Size() == 24 && SizeAndAlign(s).Align()%8 == 0
	// result: (MOVVstore [16] ptr (MOVVconst [0]) 		(MOVVstore [8] ptr (MOVVconst [0]) 			(MOVVstore [0] ptr (MOVVconst [0]) mem)))
	for {
		s := v.AuxInt
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size() == 24 && SizeAndAlign(s).Align()%8 == 0) {
			break
		}
		v.reset(OpMIPS64MOVVstore)
		v.AuxInt = 16
		v.AddArg(ptr)
		v0 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v0.AuxInt = 0
		v.AddArg(v0)
		v1 := b.NewValue0(v.Line, OpMIPS64MOVVstore, TypeMem)
		v1.AuxInt = 8
		v1.AddArg(ptr)
		v2 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v2.AuxInt = 0
		v1.AddArg(v2)
		v3 := b.NewValue0(v.Line, OpMIPS64MOVVstore, TypeMem)
		v3.AuxInt = 0
		v3.AddArg(ptr)
		v4 := b.NewValue0(v.Line, OpMIPS64MOVVconst, config.fe.TypeUInt64())
		v4.AuxInt = 0
		v3.AddArg(v4)
		v3.AddArg(mem)
		v1.AddArg(v3)
		v.AddArg(v1)
		return true
	}
	// match: (Zero [s] ptr mem)
	// cond: SizeAndAlign(s).Size()%8 == 0 && SizeAndAlign(s).Size() > 24 && SizeAndAlign(s).Size() <= 8*128 	&& SizeAndAlign(s).Align()%8 == 0 && !config.noDuffDevice
	// result: (DUFFZERO [8 * (128 - int64(SizeAndAlign(s).Size()/8))] ptr mem)
	for {
		s := v.AuxInt
		ptr := v.Args[0]
		mem := v.Args[1]
		if !(SizeAndAlign(s).Size()%8 == 0 && SizeAndAlign(s).Size() > 24 && SizeAndAlign(s).Size() <= 8*128 && SizeAndAlign(s).Align()%8 == 0 && !config.noDuffDevice) {
			break
		}
		v.reset(OpMIPS64DUFFZERO)
		v.AuxInt = 8 * (128 - int64(SizeAndAlign(s).Size()/8))
		v.AddArg(ptr)
		v.AddArg(mem)
		return true
	}
	// match: (Zero [s] ptr mem)
	// cond: (SizeAndAlign(s).Size() > 8*128 || config.noDuffDevice) || SizeAndAlign(s).Align()%8 != 0
	// result: (LoweredZero [SizeAndAlign(s).Align()] 		ptr 		(ADDVconst <ptr.Type> ptr [SizeAndAlign(s).Size()-moveSize(SizeAndAlign(s).Align(), config)]) 		mem)
	for {
		s := v.AuxInt
		ptr := v.Args[0]
		mem := v.Args[1]
		if !((SizeAndAlign(s).Size() > 8*128 || config.noDuffDevice) || SizeAndAlign(s).Align()%8 != 0) {
			break
		}
		v.reset(OpMIPS64LoweredZero)
		v.AuxInt = SizeAndAlign(s).Align()
		v.AddArg(ptr)
		v0 := b.NewValue0(v.Line, OpMIPS64ADDVconst, ptr.Type)
		v0.AuxInt = SizeAndAlign(s).Size() - moveSize(SizeAndAlign(s).Align(), config)
		v0.AddArg(ptr)
		v.AddArg(v0)
		v.AddArg(mem)
		return true
	}
	return false
}
func rewriteValueMIPS64_OpZeroExt16to32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ZeroExt16to32 x)
	// cond:
	// result: (MOVHUreg x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64MOVHUreg)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpZeroExt16to64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ZeroExt16to64 x)
	// cond:
	// result: (MOVHUreg x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64MOVHUreg)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpZeroExt32to64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ZeroExt32to64 x)
	// cond:
	// result: (MOVWUreg x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64MOVWUreg)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpZeroExt8to16(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ZeroExt8to16 x)
	// cond:
	// result: (MOVBUreg x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64MOVBUreg)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpZeroExt8to32(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ZeroExt8to32 x)
	// cond:
	// result: (MOVBUreg x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64MOVBUreg)
		v.AddArg(x)
		return true
	}
}
func rewriteValueMIPS64_OpZeroExt8to64(v *Value, config *Config) bool {
	b := v.Block
	_ = b
	// match: (ZeroExt8to64 x)
	// cond:
	// result: (MOVBUreg x)
	for {
		x := v.Args[0]
		v.reset(OpMIPS64MOVBUreg)
		v.AddArg(x)
		return true
	}
}
func rewriteBlockMIPS64(b *Block, config *Config) bool {
	switch b.Kind {
	case BlockMIPS64EQ:
		// match: (EQ (FPFlagTrue cmp) yes no)
		// cond:
		// result: (FPF cmp yes no)
		for {
			v := b.Control
			if v.Op != OpMIPS64FPFlagTrue {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockMIPS64FPF
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (EQ (FPFlagFalse cmp) yes no)
		// cond:
		// result: (FPT cmp yes no)
		for {
			v := b.Control
			if v.Op != OpMIPS64FPFlagFalse {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockMIPS64FPT
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (EQ (XORconst [1] cmp:(SGT _ _)) yes no)
		// cond:
		// result: (NE cmp yes no)
		for {
			v := b.Control
			if v.Op != OpMIPS64XORconst {
				break
			}
			if v.AuxInt != 1 {
				break
			}
			cmp := v.Args[0]
			if cmp.Op != OpMIPS64SGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockMIPS64NE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (EQ (XORconst [1] cmp:(SGTU _ _)) yes no)
		// cond:
		// result: (NE cmp yes no)
		for {
			v := b.Control
			if v.Op != OpMIPS64XORconst {
				break
			}
			if v.AuxInt != 1 {
				break
			}
			cmp := v.Args[0]
			if cmp.Op != OpMIPS64SGTU {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockMIPS64NE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (EQ (XORconst [1] cmp:(SGTconst _)) yes no)
		// cond:
		// result: (NE cmp yes no)
		for {
			v := b.Control
			if v.Op != OpMIPS64XORconst {
				break
			}
			if v.AuxInt != 1 {
				break
			}
			cmp := v.Args[0]
			if cmp.Op != OpMIPS64SGTconst {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockMIPS64NE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (EQ (XORconst [1] cmp:(SGTUconst _)) yes no)
		// cond:
		// result: (NE cmp yes no)
		for {
			v := b.Control
			if v.Op != OpMIPS64XORconst {
				break
			}
			if v.AuxInt != 1 {
				break
			}
			cmp := v.Args[0]
			if cmp.Op != OpMIPS64SGTUconst {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockMIPS64NE
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (EQ (SGTUconst [1] x) yes no)
		// cond:
		// result: (NE x yes no)
		for {
			v := b.Control
			if v.Op != OpMIPS64SGTUconst {
				break
			}
			if v.AuxInt != 1 {
				break
			}
			x := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockMIPS64NE
			b.SetControl(x)
			_ = yes
			_ = no
			return true
		}
		// match: (EQ (SGTU x (MOVVconst [0])) yes no)
		// cond:
		// result: (EQ x yes no)
		for {
			v := b.Control
			if v.Op != OpMIPS64SGTU {
				break
			}
			x := v.Args[0]
			v_1 := v.Args[1]
			if v_1.Op != OpMIPS64MOVVconst {
				break
			}
			if v_1.AuxInt != 0 {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockMIPS64EQ
			b.SetControl(x)
			_ = yes
			_ = no
			return true
		}
		// match: (EQ (SGTconst [0] x) yes no)
		// cond:
		// result: (GEZ x yes no)
		for {
			v := b.Control
			if v.Op != OpMIPS64SGTconst {
				break
			}
			if v.AuxInt != 0 {
				break
			}
			x := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockMIPS64GEZ
			b.SetControl(x)
			_ = yes
			_ = no
			return true
		}
		// match: (EQ (SGT x (MOVVconst [0])) yes no)
		// cond:
		// result: (LEZ x yes no)
		for {
			v := b.Control
			if v.Op != OpMIPS64SGT {
				break
			}
			x := v.Args[0]
			v_1 := v.Args[1]
			if v_1.Op != OpMIPS64MOVVconst {
				break
			}
			if v_1.AuxInt != 0 {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockMIPS64LEZ
			b.SetControl(x)
			_ = yes
			_ = no
			return true
		}
		// match: (EQ  (MOVVconst [0]) yes no)
		// cond:
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != OpMIPS64MOVVconst {
				break
			}
			if v.AuxInt != 0 {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (EQ  (MOVVconst [c]) yes no)
		// cond: c != 0
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != OpMIPS64MOVVconst {
				break
			}
			c := v.AuxInt
			yes := b.Succs[0]
			no := b.Succs[1]
			if !(c != 0) {
				break
			}
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
	case BlockMIPS64GEZ:
		// match: (GEZ (MOVVconst [c]) yes no)
		// cond: c >= 0
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != OpMIPS64MOVVconst {
				break
			}
			c := v.AuxInt
			yes := b.Succs[0]
			no := b.Succs[1]
			if !(c >= 0) {
				break
			}
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (GEZ (MOVVconst [c]) yes no)
		// cond: c <  0
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != OpMIPS64MOVVconst {
				break
			}
			c := v.AuxInt
			yes := b.Succs[0]
			no := b.Succs[1]
			if !(c < 0) {
				break
			}
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
	case BlockMIPS64GTZ:
		// match: (GTZ (MOVVconst [c]) yes no)
		// cond: c >  0
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != OpMIPS64MOVVconst {
				break
			}
			c := v.AuxInt
			yes := b.Succs[0]
			no := b.Succs[1]
			if !(c > 0) {
				break
			}
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (GTZ (MOVVconst [c]) yes no)
		// cond: c <= 0
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != OpMIPS64MOVVconst {
				break
			}
			c := v.AuxInt
			yes := b.Succs[0]
			no := b.Succs[1]
			if !(c <= 0) {
				break
			}
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
	case BlockIf:
		// match: (If cond yes no)
		// cond:
		// result: (NE cond yes no)
		for {
			v := b.Control
			_ = v
			cond := b.Control
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockMIPS64NE
			b.SetControl(cond)
			_ = yes
			_ = no
			return true
		}
	case BlockMIPS64LEZ:
		// match: (LEZ (MOVVconst [c]) yes no)
		// cond: c <= 0
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != OpMIPS64MOVVconst {
				break
			}
			c := v.AuxInt
			yes := b.Succs[0]
			no := b.Succs[1]
			if !(c <= 0) {
				break
			}
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (LEZ (MOVVconst [c]) yes no)
		// cond: c >  0
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != OpMIPS64MOVVconst {
				break
			}
			c := v.AuxInt
			yes := b.Succs[0]
			no := b.Succs[1]
			if !(c > 0) {
				break
			}
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
	case BlockMIPS64LTZ:
		// match: (LTZ (MOVVconst [c]) yes no)
		// cond: c <  0
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != OpMIPS64MOVVconst {
				break
			}
			c := v.AuxInt
			yes := b.Succs[0]
			no := b.Succs[1]
			if !(c < 0) {
				break
			}
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
		// match: (LTZ (MOVVconst [c]) yes no)
		// cond: c >= 0
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != OpMIPS64MOVVconst {
				break
			}
			c := v.AuxInt
			yes := b.Succs[0]
			no := b.Succs[1]
			if !(c >= 0) {
				break
			}
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
	case BlockMIPS64NE:
		// match: (NE (FPFlagTrue cmp) yes no)
		// cond:
		// result: (FPT cmp yes no)
		for {
			v := b.Control
			if v.Op != OpMIPS64FPFlagTrue {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockMIPS64FPT
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (FPFlagFalse cmp) yes no)
		// cond:
		// result: (FPF cmp yes no)
		for {
			v := b.Control
			if v.Op != OpMIPS64FPFlagFalse {
				break
			}
			cmp := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockMIPS64FPF
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (XORconst [1] cmp:(SGT _ _)) yes no)
		// cond:
		// result: (EQ cmp yes no)
		for {
			v := b.Control
			if v.Op != OpMIPS64XORconst {
				break
			}
			if v.AuxInt != 1 {
				break
			}
			cmp := v.Args[0]
			if cmp.Op != OpMIPS64SGT {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockMIPS64EQ
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (XORconst [1] cmp:(SGTU _ _)) yes no)
		// cond:
		// result: (EQ cmp yes no)
		for {
			v := b.Control
			if v.Op != OpMIPS64XORconst {
				break
			}
			if v.AuxInt != 1 {
				break
			}
			cmp := v.Args[0]
			if cmp.Op != OpMIPS64SGTU {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockMIPS64EQ
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (XORconst [1] cmp:(SGTconst _)) yes no)
		// cond:
		// result: (EQ cmp yes no)
		for {
			v := b.Control
			if v.Op != OpMIPS64XORconst {
				break
			}
			if v.AuxInt != 1 {
				break
			}
			cmp := v.Args[0]
			if cmp.Op != OpMIPS64SGTconst {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockMIPS64EQ
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (XORconst [1] cmp:(SGTUconst _)) yes no)
		// cond:
		// result: (EQ cmp yes no)
		for {
			v := b.Control
			if v.Op != OpMIPS64XORconst {
				break
			}
			if v.AuxInt != 1 {
				break
			}
			cmp := v.Args[0]
			if cmp.Op != OpMIPS64SGTUconst {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockMIPS64EQ
			b.SetControl(cmp)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (SGTUconst [1] x) yes no)
		// cond:
		// result: (EQ x yes no)
		for {
			v := b.Control
			if v.Op != OpMIPS64SGTUconst {
				break
			}
			if v.AuxInt != 1 {
				break
			}
			x := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockMIPS64EQ
			b.SetControl(x)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (SGTU x (MOVVconst [0])) yes no)
		// cond:
		// result: (NE x yes no)
		for {
			v := b.Control
			if v.Op != OpMIPS64SGTU {
				break
			}
			x := v.Args[0]
			v_1 := v.Args[1]
			if v_1.Op != OpMIPS64MOVVconst {
				break
			}
			if v_1.AuxInt != 0 {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockMIPS64NE
			b.SetControl(x)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (SGTconst [0] x) yes no)
		// cond:
		// result: (LTZ x yes no)
		for {
			v := b.Control
			if v.Op != OpMIPS64SGTconst {
				break
			}
			if v.AuxInt != 0 {
				break
			}
			x := v.Args[0]
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockMIPS64LTZ
			b.SetControl(x)
			_ = yes
			_ = no
			return true
		}
		// match: (NE (SGT x (MOVVconst [0])) yes no)
		// cond:
		// result: (GTZ x yes no)
		for {
			v := b.Control
			if v.Op != OpMIPS64SGT {
				break
			}
			x := v.Args[0]
			v_1 := v.Args[1]
			if v_1.Op != OpMIPS64MOVVconst {
				break
			}
			if v_1.AuxInt != 0 {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockMIPS64GTZ
			b.SetControl(x)
			_ = yes
			_ = no
			return true
		}
		// match: (NE  (MOVVconst [0]) yes no)
		// cond:
		// result: (First nil no yes)
		for {
			v := b.Control
			if v.Op != OpMIPS64MOVVconst {
				break
			}
			if v.AuxInt != 0 {
				break
			}
			yes := b.Succs[0]
			no := b.Succs[1]
			b.Kind = BlockFirst
			b.SetControl(nil)
			b.swapSuccessors()
			_ = no
			_ = yes
			return true
		}
		// match: (NE  (MOVVconst [c]) yes no)
		// cond: c != 0
		// result: (First nil yes no)
		for {
			v := b.Control
			if v.Op != OpMIPS64MOVVconst {
				break
			}
			c := v.AuxInt
			yes := b.Succs[0]
			no := b.Succs[1]
			if !(c != 0) {
				break
			}
			b.Kind = BlockFirst
			b.SetControl(nil)
			_ = yes
			_ = no
			return true
		}
	}
	return false
}
