# - Find the lxqt-globalkeys-ui include and library dirs and define a some macros
#
# The module defines the following variables
#  LXQT_GLOBALKEYS_UI_FOUND         - Set to TRUE if all of the above has been found
#
# Typical usage:
#    find_package(lxqt-globalkeys-ui)
#    add_executable(use-lxqt-globalkeys-ui main.cpp)
#    target_link_libraries(use-lxqt-globalkeys-ui lxqt-globalkeys-ui)


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was lxqt_globalkeys_ui-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include(CMakeFindDependencyMacro)

set(LXQT_GLOBALKEYS_UI_MAJOR_VERSION 0)
set(LXQT_GLOBALKEYS_UI_MINOR_VERSION 11)
set(LXQT_GLOBALKEYS_UI_PATCH_VERSION 1)
set(LXQT_GLOBALKEYS_UI_VERSION 0.11.1)

find_dependency(Qt5Widgets)
find_dependency(Qt5DBus)
find_dependency(lxqt-globalkeys)

if (CMAKE_VERSION VERSION_GREATER 2.8.12)
    cmake_policy(SET CMP0024 OLD)
endif()
include("${CMAKE_CURRENT_LIST_DIR}/lxqt-globalkeys-ui-targets.cmake")
