/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.view.tree;

import ch.softenvironment.view.tree.TreeNodeUtility;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class NavigationTreeModel
implements TreeModel,
PropertyChangeListener {
    private TreeNodeUtility utility = null;
    public static final int SORT_AS_IS = 10;
    public static final int SORT_BY_NAME = 11;
    public static final int SORT_BY_KIND_NAME = 12;
    private int order = 10;
    private Vector treeModelListeners = new Vector();
    private boolean showOnlyPackages = true;

    public NavigationTreeModel(boolean showOnlyPackages, TreeNodeUtility utility) {
        this.showOnlyPackages = showOnlyPackages;
        this.utility = utility;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        if (!this.treeModelListeners.contains(l)) {
            this.treeModelListeners.addElement(l);
        }
    }

    protected void fireTreeNodesChanged(Object node) {
        int len = this.treeModelListeners.size();
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getTreePath(node));
        for (int i = 0; i < len; ++i) {
            if (e.getPath()[0] == null) continue;
            ((TreeModelListener)this.treeModelListeners.elementAt(i)).treeNodesChanged(e);
        }
    }

    protected void fireTreeNodesInserted(Object node) {
        int len = this.treeModelListeners.size();
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getTreePath(node));
        for (int i = 0; i < len; ++i) {
            if (e.getPath()[0] == null) continue;
            ((TreeModelListener)this.treeModelListeners.elementAt(i)).treeNodesInserted(e);
        }
    }

    protected void fireTreeNodesRemoved(Object node) {
        int len = this.treeModelListeners.size();
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getTreePath(node));
        for (int i = 0; i < len; ++i) {
            if (e.getPath()[0] == null) continue;
            ((TreeModelListener)this.treeModelListeners.elementAt(i)).treeNodesRemoved(e);
        }
    }

    protected void fireTreeStructureChanged(Object node) {
        int len = this.treeModelListeners.size();
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getTreePath(node));
        for (int i = 0; i < len; ++i) {
            ((TreeModelListener)this.treeModelListeners.elementAt(i)).treeStructureChanged(e);
        }
    }

    @Override
    public Object getChild(Object parent, int index) {
        List children = this.getChildren(parent);
        return children.get(index);
    }

    @Override
    public int getChildCount(Object parent) {
        List children = this.getChildren(parent);
        return children.size();
    }

    private List getChildren(Object parent) {
        ArrayList ret = new ArrayList();
        Iterator iterator = this.utility.iteratorChildren(parent);
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (this.showOnlyPackages) {
                if (this.utility.isLeaf(next)) continue;
                ret.add(next);
                continue;
            }
            ret.add(next);
        }
        Collections.sort(ret, new Compare(this.getOrder()));
        return ret;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        List children = this.getChildren(parent);
        return children.indexOf(child);
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public Object getRoot() {
        return this.utility.getRoot();
    }

    public TreePath getTreePath(Object node) {
        ArrayList<Object> path = new ArrayList<Object>();
        path.add(node);
        Object current = node;
        Object next = null;
        while ((next = this.utility.findParent(current)) != null) {
            path.add(0, next);
            current = next;
        }
        return new TreePath(path.toArray());
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.utility.isLeaf(node);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (this.utility.isNodeStructureChanged(event)) {
            this.fireTreeStructureChanged(event.getSource());
        } else if (this.utility.isNodeChanged(event)) {
            this.fireTreeNodesChanged(event.getSource());
        }
    }

    public void refresh() {
        this.fireTreeStructureChanged(this.utility.getRoot());
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        if (this.treeModelListeners.contains(l)) {
            this.treeModelListeners.removeElement(l);
        }
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        Object node = path.getLastPathComponent();
        this.utility.setName(node, (String)newValue);
    }

    public TreeNodeUtility getUtility() {
        return this.utility;
    }

    class Compare
    implements Comparator {
        private int order;

        public Compare(int order) {
            this.order = order;
        }

        public int compare(Object o1, Object o2) {
            if (this.order == 12) {
                int def = NavigationTreeModel.this.utility.compareDefinition(o1.getClass(), o2.getClass());
                if (def != 0) {
                    return def;
                }
            } else if (this.order == 11) {
                String name2;
                String name1 = NavigationTreeModel.this.utility.getName(o1);
                if (name1 == null) {
                    name1 = "";
                }
                if ((name2 = NavigationTreeModel.this.utility.getName(o2)) == null) {
                    name2 = "";
                }
                return name1.compareToIgnoreCase(name2);
            }
            return 0;
        }
    }
}

