/*
 * Decompiled with CFR 0.152.
 */
package esmska.data;

import esmska.data.Config;
import esmska.data.CountryPrefix;
import esmska.data.Gateway;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.Collator;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Contact
implements Comparable<Contact> {
    private String name;
    private String number;
    private String gateway;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public Contact(Contact c) {
        this(c.getName(), c.getNumber(), c.getGateway());
    }

    public Contact(String name, String number, String gateway) {
        this.setName(name);
        this.setNumber(number);
        this.setGateway(gateway);
    }

    public void copyFrom(Contact c) {
        this.setName(c.getName());
        this.setNumber(c.getNumber());
        this.setGateway(c.getGateway());
    }

    public String getName() {
        return this.name;
    }

    public String getNumber() {
        return this.number;
    }

    public String getGateway() {
        return this.gateway;
    }

    public void setName(String name) {
        if (name == null) {
            name = "";
        }
        String oldName = this.name;
        this.name = name;
        this.changeSupport.firePropertyChange("name", oldName, name);
    }

    public void setNumber(String number) {
        if (number == null) {
            number = "";
        }
        if (number.length() > 0 && !Contact.isValidNumber(number)) {
            throw new IllegalArgumentException("Number is not valid: " + number);
        }
        String oldNumber = this.number;
        this.number = number;
        this.changeSupport.firePropertyChange("number", oldNumber, number);
    }

    public void setGateway(String gateway) {
        if (gateway == null) {
            gateway = Gateway.UNKNOWN;
        }
        String oldGateway = this.gateway;
        this.gateway = gateway;
        this.changeSupport.firePropertyChange("gateway", oldGateway, gateway);
    }

    public static boolean isValidNumber(String number) {
        if (number == null) {
            return false;
        }
        String prefix = CountryPrefix.extractCountryPrefix(number);
        if (prefix == null) {
            return false;
        }
        if ((number = number.substring(prefix.length())).length() < 1 || number.length() + prefix.length() > 16) {
            return false;
        }
        char[] arr$ = number.toCharArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character c = Character.valueOf(arr$[i$]);
            if (Character.isDigit(c.charValue())) continue;
            return false;
        }
        return true;
    }

    public static String anonymizeNumber(String number) {
        if (number == null) {
            return number;
        }
        return number.replaceAll("\\d", "N");
    }

    public static String parseNumber(String number) {
        if (StringUtils.isEmpty(number)) {
            return null;
        }
        boolean international = number.startsWith("+");
        number = number.replaceAll("[^0-9]", "");
        number = !international && StringUtils.isNotEmpty(Config.getInstance().getCountryPrefix()) ? Config.getInstance().getCountryPrefix() + number : "+" + number;
        if (Contact.isValidNumber(number)) {
            return number;
        }
        return null;
    }

    @Override
    public int compareTo(Contact c) {
        Collator collator = Collator.getInstance();
        return new CompareToBuilder().append(this.name, c.name, (Comparator)collator).append(this.number, c.number, (Comparator)collator).append(this.gateway, c.gateway, (Comparator)collator).toComparison();
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Contact)) {
            return false;
        }
        Contact c = (Contact)obj;
        return new EqualsBuilder().append(this.name, c.name).append(this.number, c.number).append(this.gateway, c.gateway).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(337, 139).append(this.name).append(this.number).append(this.gateway).toHashCode();
    }
}

