/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.classfile;

import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.classfile.ConstantPool;

final class TypeInfo {
    static final int TOP = 0;
    static final int INTEGER = 1;
    static final int FLOAT = 2;
    static final int DOUBLE = 3;
    static final int LONG = 4;
    static final int NULL = 5;
    static final int UNINITIALIZED_THIS = 6;
    static final int OBJECT_TAG = 7;
    static final int UNINITIALIZED_VAR_TAG = 8;

    private TypeInfo() {
    }

    static final int OBJECT(int n) {
        return (n & 0xFFFF) << 8 | 7;
    }

    static final int OBJECT(String string, ConstantPool constantPool) {
        return TypeInfo.OBJECT(constantPool.addClass(string));
    }

    static final int UNINITIALIZED_VARIABLE(int n) {
        return (n & 0xFFFF) << 8 | 8;
    }

    static final int getTag(int n) {
        return n & 0xFF;
    }

    static final int getPayload(int n) {
        return n >>> 8;
    }

    static final String getPayloadAsType(int n, ConstantPool constantPool) {
        if (TypeInfo.getTag(n) == 7) {
            return (String)constantPool.getConstantData(TypeInfo.getPayload(n));
        }
        throw new IllegalArgumentException("expecting object type");
    }

    static final int fromType(String string, ConstantPool constantPool) {
        if (string.length() == 1) {
            switch (string.charAt(0)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    return 1;
                }
                case 'D': {
                    return 3;
                }
                case 'F': {
                    return 2;
                }
                case 'J': {
                    return 4;
                }
            }
            throw new IllegalArgumentException("bad type");
        }
        return TypeInfo.OBJECT(string, constantPool);
    }

    static boolean isTwoWords(int n) {
        return n == 3 || n == 4;
    }

    static int merge(int n, int n2, ConstantPool constantPool) {
        boolean bl;
        int n3 = TypeInfo.getTag(n);
        int n4 = TypeInfo.getTag(n2);
        boolean bl2 = n3 == 7;
        boolean bl3 = bl = n4 == 7;
        if (n == n2 || bl2 && n2 == 5) {
            return n;
        }
        if (n3 == 0 || n4 == 0) {
            return 0;
        }
        if (n == 5 && bl) {
            return n2;
        }
        if (bl2 && bl) {
            Class<?> clazz;
            Class<?> clazz2;
            String string = TypeInfo.getPayloadAsType(n, constantPool);
            String string2 = TypeInfo.getPayloadAsType(n2, constantPool);
            String string3 = (String)constantPool.getConstantData(2);
            String string4 = (String)constantPool.getConstantData(4);
            if (string.equals(string3)) {
                string = string4;
            }
            if (string2.equals(string3)) {
                string2 = string4;
            }
            if ((clazz2 = TypeInfo.getClassFromInternalName(string)).isAssignableFrom(clazz = TypeInfo.getClassFromInternalName(string2))) {
                return n;
            }
            if (clazz.isAssignableFrom(clazz2)) {
                return n2;
            }
            if (clazz.isInterface() || clazz2.isInterface()) {
                return TypeInfo.OBJECT("java/lang/Object", constantPool);
            }
            for (Class<?> clazz3 = clazz.getSuperclass(); clazz3 != null; clazz3 = clazz3.getSuperclass()) {
                if (!clazz3.isAssignableFrom(clazz2)) continue;
                String string5 = clazz3.getName();
                string5 = ClassFileWriter.getSlashedForm(string5);
                return TypeInfo.OBJECT(string5, constantPool);
            }
        }
        throw new IllegalArgumentException("bad merge attempt between " + TypeInfo.toString(n, constantPool) + " and " + TypeInfo.toString(n2, constantPool));
    }

    static String toString(int n, ConstantPool constantPool) {
        int n2 = TypeInfo.getTag(n);
        switch (n2) {
            case 0: {
                return "top";
            }
            case 1: {
                return "int";
            }
            case 2: {
                return "float";
            }
            case 3: {
                return "double";
            }
            case 4: {
                return "long";
            }
            case 5: {
                return "null";
            }
            case 6: {
                return "uninitialized_this";
            }
        }
        if (n2 == 7) {
            return TypeInfo.getPayloadAsType(n, constantPool);
        }
        if (n2 == 8) {
            return "uninitialized";
        }
        throw new IllegalArgumentException("bad type");
    }

    static Class<?> getClassFromInternalName(String string) {
        try {
            return Class.forName(string.replace('/', '.'));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    static String toString(int[] nArray, ConstantPool constantPool) {
        return TypeInfo.toString(nArray, nArray.length, constantPool);
    }

    static String toString(int[] nArray, int n, ConstantPool constantPool) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(TypeInfo.toString(nArray[i], constantPool));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    static void print(int[] nArray, int[] nArray2, ConstantPool constantPool) {
        TypeInfo.print(nArray, nArray.length, nArray2, nArray2.length, constantPool);
    }

    static void print(int[] nArray, int n, int[] nArray2, int n2, ConstantPool constantPool) {
        System.out.print("locals: ");
        System.out.println(TypeInfo.toString(nArray, n, constantPool));
        System.out.print("stack: ");
        System.out.println(TypeInfo.toString(nArray2, n2, constantPool));
        System.out.println();
    }
}

