/*
 * Decompiled with CFR 0.152.
 */
package de.tuberlin.polymake.polytope;

import de.tuberlin.polymake.common.PolymakeControl;
import de.tuberlin.polymake.common.PolymakeFrame;
import de.tuberlin.polymake.common.SelectorThread;
import de.tuberlin.polymake.common.geometry.EmbeddedGeometries;
import de.tuberlin.polymake.common.geometry.PointSet;
import de.tuberlin.polymake.common.io.SimpleGeometryParser;
import de.tuberlin.polymake.common.ui.ParameterPanel;
import de.tuberlin.polymake.common.ui.PolymakeSlider;
import de.tuberlin.polymake.common.ui.SliderEvent;
import de.tuberlin.polymake.common.ui.SliderListener;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;

public abstract class PolymakeSchlegelFrame
extends PolymakeFrame
implements SliderListener {
    private static final long serialVersionUID = -4524691460396933711L;
    protected boolean vertexDragged = false;
    protected Vector facet = null;

    public PolymakeSchlegelFrame(EmbeddedGeometries embeddedGeometries, String string, Properties properties, Properties properties2, PolymakeControl polymakeControl) {
        super(embeddedGeometries, string, properties, properties2, polymakeControl);
        this.geometry = (EmbeddedGeometries)embeddedGeometries.clone();
        this.paramPanel = new ParameterPanel(properties, properties2, this);
    }

    public void update(PointSet pointSet, Properties properties, boolean bl) {
        if (!properties.getProperty("zoom").equals("null")) {
            this.parameters.setProperty("zoom", properties.getProperty("zoom"));
            if (this.vertexDragged) {
                this.paramPanel.setParameter("zoom", "" + 100.0 * Double.parseDouble(this.parameters.getProperty("zoom")));
                this.vertexDragged = false;
            }
        }
        this.geometry.update(pointSet, false);
    }

    @Override
    public void update(PointSet pointSet, Properties properties) {
        this.update(pointSet, properties, false);
    }

    @Override
    public String getName() {
        return "SchlegelFramePicker";
    }

    protected void setupSchlegelGUI() {
        this.vertexDragged = true;
        JButton jButton = new JButton("New Projection Facet");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Vector vector = PolymakeSchlegelFrame.this.geometry.getMarkedVertices();
                    if (vector.isEmpty()) {
                        PolymakeSchlegelFrame.this.statusBar.setText("no points selected");
                    } else {
                        PolymakeSchlegelFrame.this.parentControl.putMessage(SimpleGeometryParser.writeFacet("" + PolymakeSchlegelFrame.this.number, vector), 'P', false);
                        PolymakeSchlegelFrame.this.statusBar.setText(" ");
                    }
                }
                catch (IOException iOException) {
                    SelectorThread.newErr.println("SchlegelFrame: error writing to polymake server");
                    iOException.printStackTrace(SelectorThread.newErr);
                }
            }
        });
        JButton jButton2 = new JButton("Save View");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PolymakeSchlegelFrame.this.parentControl.putMessage("n " + PolymakeSchlegelFrame.this.number + "\nS\n" + PolymakeSchlegelFrame.this.writeTransformation() + "x\n", 'P', false);
                }
                catch (IOException iOException) {
                    SelectorThread.newErr.println("SchlegelFrame: error writing to polymake server");
                    iOException.printStackTrace(SelectorThread.newErr);
                }
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.southBox.add(this.paramPanel);
        this.southBox.add(jPanel);
        this.setupFrame();
    }

    protected String writeTransformation() {
        return "";
    }

    @Override
    public void sliderValueChanged(SliderEvent sliderEvent) {
        double d;
        PolymakeSlider polymakeSlider = (PolymakeSlider)sliderEvent.getSource();
        double d2 = polymakeSlider.getDoubleValue() / 100.0;
        if (Math.abs(d2 - (d = Double.parseDouble(this.parameters.getProperty("zoom")))) <= 0.01) {
            return;
        }
        if (d2 == 0.0) {
            d2 = 0.01;
        }
        String string = "n " + this.getGeomTitle() + "\n" + "s zoom " + d2 + "\nx\n";
        this.statusBar.setText(" ");
        try {
            this.parentControl.putMessage(string, 'C', true);
        }
        catch (Exception exception) {
            SelectorThread.newErr.println("JavaviewSchlegelFrame: communication error");
            exception.printStackTrace(SelectorThread.newErr);
        }
    }
}

