#ifndef _ELM_SCROLLER_EO_LEGACY_H_
#define _ELM_SCROLLER_EO_LEGACY_H_

#ifndef _ELM_SCROLLER_EO_CLASS_TYPE
#define _ELM_SCROLLER_EO_CLASS_TYPE

typedef Eo Elm_Scroller;

#endif

#ifndef _ELM_SCROLLER_EO_TYPES
#define _ELM_SCROLLER_EO_TYPES


#endif

/**
 * @brief Set event propagation on a scroller
 *
 * This enables or disables event propagation from the scroller content to the
 * scroller and its parent. By default event propagation is enabled.
 *
 * @param[in] propagation The propagation state
 *
 * @ingroup Elm_Scroller
 */
EAPI void elm_scroller_propagate_events_set(Elm_Scroller *obj, Eina_Bool propagation);

/**
 * @brief Get event propagation for a scroller
 *
 * This gets the event propagation for a scroller.
 *
 * @return The propagation state
 *
 * @ingroup Elm_Scroller
 */
EAPI Eina_Bool elm_scroller_propagate_events_get(const Elm_Scroller *obj);

/**
 * @brief Set custom theme elements for the scroller
 *
 * @param[in] klass
 * @param[in] group
 *
 * @ingroup Elm_Scroller
 */
EAPI void elm_scroller_custom_widget_base_theme_set(Elm_Scroller *obj, const char *klass, const char *group);

/**
 * @brief Set the maximum of the movable page at a flicking.
 *
 * The value of maximum movable page should be more than 1.
 *
 * @param[in] page_limit_h The maximum of the movable horizontal page
 * @param[in] page_limit_v The maximum of the movable vertical page
 *
 * @since 1.8
 *
 * @ingroup Elm_Scroller
 */
EAPI void elm_scroller_page_scroll_limit_set(const Elm_Scroller *obj, int page_limit_h, int page_limit_v);

/**
 * @brief Get the maximum of the movable page at a flicking.
 *
 * @param[in] page_limit_h The maximum of the movable horizontal page
 * @param[in] page_limit_v The maximum of the movable vertical page
 *
 * @since 1.8
 *
 * @ingroup Elm_Scroller
 */
EAPI void elm_scroller_page_scroll_limit_get(const Elm_Scroller *obj, int *page_limit_h, int *page_limit_v);

#endif
