/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngHelperInternal;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunk;
import jogamp.opengl.util.pngj.chunks.PngChunkSingle;

public class PngChunkOFFS
extends PngChunkSingle {
    public static final String ID = "oFFs";
    private long posX;
    private long posY;
    private int units;

    public PngChunkOFFS(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_IDAT;
    }

    @Override
    public ChunkRaw createRawChunk() {
        ChunkRaw chunkRaw = this.createEmptyChunk(9, true);
        PngHelperInternal.writeInt4tobytes((int)this.posX, chunkRaw.data, 0);
        PngHelperInternal.writeInt4tobytes((int)this.posY, chunkRaw.data, 4);
        chunkRaw.data[8] = (byte)this.units;
        return chunkRaw;
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        if (chunkRaw.len != 9) {
            throw new PngjException("bad chunk length " + chunkRaw);
        }
        this.posX = PngHelperInternal.readInt4fromBytes(chunkRaw.data, 0);
        if (this.posX < 0L) {
            this.posX += 0x100000000L;
        }
        this.posY = PngHelperInternal.readInt4fromBytes(chunkRaw.data, 4);
        if (this.posY < 0L) {
            this.posY += 0x100000000L;
        }
        this.units = PngHelperInternal.readInt1fromByte(chunkRaw.data, 8);
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkOFFS pngChunkOFFS = (PngChunkOFFS)pngChunk;
        this.posX = pngChunkOFFS.posX;
        this.posY = pngChunkOFFS.posY;
        this.units = pngChunkOFFS.units;
    }

    public int getUnits() {
        return this.units;
    }

    public void setUnits(int n) {
        this.units = n;
    }

    public long getPosX() {
        return this.posX;
    }

    public void setPosX(long l) {
        this.posX = l;
    }

    public long getPosY() {
        return this.posY;
    }

    public void setPosY(long l) {
        this.posY = l;
    }
}

