/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.converters;

import org.gradle.api.Action;
import org.gradle.tooling.internal.adapter.ViewBuilder;
import org.gradle.tooling.internal.consumer.converters.EclipseProjectDependencyTargetMixin;
import org.gradle.tooling.internal.consumer.converters.EclipseProjectIdentifierMixin;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.model.eclipse.EclipseProjectDependency;
import org.gradle.tooling.model.eclipse.HierarchicalEclipseProject;
import org.gradle.util.GradleVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseModelCompatibilityMapping
implements Action<ViewBuilder<?>> {
    private final boolean versionSupportsEclipseProjectIdentifier;

    public EclipseModelCompatibilityMapping(VersionDetails versionDetails) {
        GradleVersion targetGradleVersion = GradleVersion.version(versionDetails.getVersion());
        this.versionSupportsEclipseProjectIdentifier = this.supportsEclipseProjectIdentifier(targetGradleVersion);
    }

    @Override
    public void execute(ViewBuilder<?> viewBuilder) {
        if (!this.versionSupportsEclipseProjectIdentifier) {
            viewBuilder.mixInTo(EclipseProjectDependency.class, EclipseProjectDependencyTargetMixin.class);
            viewBuilder.mixInTo(HierarchicalEclipseProject.class, EclipseProjectIdentifierMixin.class);
        }
    }

    private boolean supportsEclipseProjectIdentifier(GradleVersion targetGradleVersion) {
        return targetGradleVersion.getBaseVersion().compareTo(GradleVersion.version("2.14")) >= 0;
    }
}

