/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.AbstractPlainSocketImpl;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.FileChannel;
import sun.misc.IoTrace;
import sun.net.ConnectionResetException;

class SocketOutputStream
extends FileOutputStream {
    private AbstractPlainSocketImpl impl = null;
    private byte[] temp = new byte[1];
    private Socket socket = null;
    private boolean closing = false;

    SocketOutputStream(AbstractPlainSocketImpl impl) throws IOException {
        super(impl.getFileDescriptor());
        this.impl = impl;
        this.socket = impl.getSocket();
    }

    @Override
    public final FileChannel getChannel() {
        return null;
    }

    private native void socketWrite0(FileDescriptor var1, byte[] var2, int var3, int var4) throws IOException;

    private void socketWrite(byte[] b, int off, int len) throws IOException {
        if (len <= 0 || off < 0 || len > b.length - off) {
            if (len == 0) {
                return;
            }
            throw new ArrayIndexOutOfBoundsException("len == " + len + " off == " + off + " buffer length == " + b.length);
        }
        Object traceContext = IoTrace.socketWriteBegin();
        int bytesWritten = 0;
        FileDescriptor fd = this.impl.acquireFD();
        try {
            this.socketWrite0(fd, b, off, len);
            bytesWritten = len;
        }
        catch (SocketException se) {
            if (se instanceof ConnectionResetException) {
                this.impl.setConnectionResetPending();
                se = new SocketException("Connection reset");
            }
            if (this.impl.isClosedOrPending()) {
                throw new SocketException("Socket closed");
            }
            throw se;
        }
        finally {
            this.impl.releaseFD();
            IoTrace.socketWriteEnd(traceContext, this.impl.address, this.impl.port, bytesWritten);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.temp[0] = (byte)b;
        this.socketWrite(this.temp, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.socketWrite(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.socketWrite(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.closing) {
            return;
        }
        this.closing = true;
        if (this.socket != null) {
            if (!this.socket.isClosed()) {
                this.socket.close();
            }
        } else {
            this.impl.close();
        }
        this.closing = false;
    }

    @Override
    protected void finalize() {
    }

    private static native void init();

    static {
        SocketOutputStream.init();
    }
}

