/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Color;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.swing.outline.CheckRenderDataProvider;
import org.netbeans.swing.outline.Outline;
import org.openide.explorer.view.CheckableNode;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;

class NodeRenderDataProvider
implements CheckRenderDataProvider {
    private Outline table;

    public NodeRenderDataProvider(Outline outline) {
        this.table = outline;
    }

    public Color getBackground(Object object) {
        return null;
    }

    public String getDisplayName(Object object) {
        Node node = Visualizer.findNode(object);
        if (node == null) {
            throw new IllegalStateException("TreeNode must be VisualizerNode but was: " + object + " of class " + object.getClass().getName());
        }
        String string = node.getHtmlDisplayName();
        if (null == string) {
            string = node.getDisplayName();
        }
        return string;
    }

    public Color getForeground(Object object) {
        return null;
    }

    public Icon getIcon(Object object) {
        Object object2;
        Node node = Visualizer.findNode(object);
        if (node == null) {
            throw new IllegalStateException("TreeNode must be VisualizerNode but was: " + object + " of class " + object.getClass().getName());
        }
        boolean bl = false;
        if (object instanceof TreeNode) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (object2 = (TreeNode)object; object2 != null; object2 = object2.getParent()) {
                arrayList.add(object2);
            }
            Collections.reverse(arrayList);
            TreePath treePath = new TreePath(arrayList.toArray());
            AbstractLayoutCache abstractLayoutCache = this.table.getLayoutCache();
            bl = abstractLayoutCache.isExpanded(treePath);
        }
        object2 = null;
        object2 = bl ? node.getOpenedIcon(1) : node.getIcon(1);
        return new ImageIcon((Image)object2);
    }

    public String getTooltipText(Object object) {
        Node node = Visualizer.findNode(object);
        if (node == null) {
            throw new IllegalStateException("TreeNode must be VisualizerNode but was: " + object + " of class " + object.getClass().getName());
        }
        return node.getShortDescription();
    }

    public boolean isHtmlDisplayName(Object object) {
        Node node = Visualizer.findNode(object);
        if (node == null) {
            throw new IllegalStateException("TreeNode must be VisualizerNode but was: " + object + " of class " + object.getClass().getName());
        }
        return null != node.getHtmlDisplayName();
    }

    private CheckableNode getCheckCookie(Object object) {
        Node node = Visualizer.findNode(object);
        if (node == null) {
            throw new IllegalStateException("TreeNode must be VisualizerNode but was: " + object + " of class " + object.getClass().getName());
        }
        return (CheckableNode)node.getLookup().lookup(CheckableNode.class);
    }

    public boolean isCheckable(Object object) {
        CheckableNode checkableNode = this.getCheckCookie(object);
        return checkableNode != null && checkableNode.isCheckable();
    }

    public boolean isCheckEnabled(Object object) {
        CheckableNode checkableNode = this.getCheckCookie(object);
        return checkableNode != null && checkableNode.isCheckEnabled();
    }

    public Boolean isSelected(Object object) {
        CheckableNode checkableNode = this.getCheckCookie(object);
        if (checkableNode != null) {
            return checkableNode.isSelected();
        }
        return null;
    }

    public void setSelected(Object object, Boolean bl) {
        CheckableNode checkableNode = this.getCheckCookie(object);
        if (checkableNode != null) {
            checkableNode.setSelected(bl);
        }
    }
}

