-- EFL LuaJIT bindings: elm_naviframe.eo (class Elm.Naviframe)
-- For use with Elua; automatically generated, do not modify

local cutil = require("cutil")
local util  = require("util")
local ffi   = require("ffi")
local eo    = require("eo")

local M, __lib = ...

local __class
local __body

local init = function()
    __class = __lib.elm_naviframe_class_get()
    eo.class_register("Elm_Naviframe", {"Elm_Layout"}, {"Elm_Interface_Atspi_Widget_Action"}, __body, __class)
end

cutil.init_module(init, function() end)

ffi.cdef [[
    const Eo_Class *elm_naviframe_class_get(void);
    void elm_obj_naviframe_event_enabled_set(Eina_Bool enabled);
    Eina_Bool elm_obj_naviframe_event_enabled_get(void);
    void elm_obj_naviframe_content_preserve_on_pop_set(Eina_Bool preserve);
    Eina_Bool elm_obj_naviframe_content_preserve_on_pop_get(void);
    void elm_obj_naviframe_prev_btn_auto_pushed_set(Eina_Bool auto_pushed);
    Eina_Bool elm_obj_naviframe_prev_btn_auto_pushed_get(void);
    Eina_List *elm_obj_naviframe_items_get(void);
    Elm_Widget_Item *elm_obj_naviframe_top_item_get(void);
    Elm_Widget_Item *elm_obj_naviframe_bottom_item_get(void);
    Efl_Canvas_Object *elm_obj_naviframe_item_pop(void);
    Elm_Widget_Item *elm_obj_naviframe_item_insert_before(Elm_Widget_Item * before, const char * title_label, Efl_Canvas_Object * prev_btn, Efl_Canvas_Object * next_btn, Efl_Canvas_Object * content, const char * item_style);
    Elm_Widget_Item *elm_obj_naviframe_item_push(const char * title_label, Efl_Canvas_Object * prev_btn, Efl_Canvas_Object * next_btn, Efl_Canvas_Object * content, const char * item_style);
    void elm_obj_naviframe_item_simple_promote(Efl_Canvas_Object * content);
    Elm_Widget_Item *elm_obj_naviframe_item_insert_after(Elm_Widget_Item * after, const char * title_label, Efl_Canvas_Object * prev_btn, Efl_Canvas_Object * next_btn, Efl_Canvas_Object * content, const char * item_style);
    extern const Eo_Event_Description _ELM_NAVIFRAME_EVENT_TRANSITION_FINISHED;
    extern const Eo_Event_Description _ELM_NAVIFRAME_EVENT_TITLE_TRANSITION_FINISHED;
    extern const Eo_Event_Description _ELM_NAVIFRAME_EVENT_TITLE_CLICKED;
]]

__body = {
    __eo_ctor = function(self, __func)
        if __func then __func() end
    end,

    event_enabled_set = function(self, enabled)
        eo.__do_start(self, __class)
        __lib.elm_obj_naviframe_event_enabled_set(enabled)
        eo.__do_end()
    end,

    event_enabled_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_naviframe_event_enabled_get()
        eo.__do_end()
        return ((v) ~= 0)
    end,

    content_preserve_on_pop_set = function(self, preserve)
        eo.__do_start(self, __class)
        __lib.elm_obj_naviframe_content_preserve_on_pop_set(preserve)
        eo.__do_end()
    end,

    content_preserve_on_pop_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_naviframe_content_preserve_on_pop_get()
        eo.__do_end()
        return ((v) ~= 0)
    end,

    prev_btn_auto_pushed_set = function(self, auto_pushed)
        eo.__do_start(self, __class)
        __lib.elm_obj_naviframe_prev_btn_auto_pushed_set(auto_pushed)
        eo.__do_end()
    end,

    prev_btn_auto_pushed_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_naviframe_prev_btn_auto_pushed_get()
        eo.__do_end()
        return ((v) ~= 0)
    end,

    items_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_naviframe_items_get()
        eo.__do_end()
    end,

    top_item_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_naviframe_top_item_get()
        eo.__do_end()
    end,

    bottom_item_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_naviframe_bottom_item_get()
        eo.__do_end()
    end,

    item_pop = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_naviframe_item_pop()
        eo.__do_end()
        return v
    end,

    item_insert_before = function(self, before, title_label, prev_btn, next_btn, content, item_style)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_naviframe_item_insert_before(before, title_label, prev_btn, next_btn, content, item_style)
        eo.__do_end()
        return v
    end,

    item_push = function(self, title_label, prev_btn, next_btn, content, item_style)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_naviframe_item_push(title_label, prev_btn, next_btn, content, item_style)
        eo.__do_end()
        return v
    end,

    item_simple_promote = function(self, content)
        eo.__do_start(self, __class)
        __lib.elm_obj_naviframe_item_simple_promote(content)
        eo.__do_end()
    end,

    item_insert_after = function(self, after, title_label, prev_btn, next_btn, content, item_style)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_naviframe_item_insert_after(after, title_label, prev_btn, next_btn, content, item_style)
        eo.__do_end()
        return v
    end,

    __events = {
        ["transition,finished"] = __lib._ELM_NAVIFRAME_EVENT_TRANSITION_FINISHED,
        ["title,transition,finished"] = __lib._ELM_NAVIFRAME_EVENT_TITLE_TRANSITION_FINISHED,
        ["title,clicked"] = __lib._ELM_NAVIFRAME_EVENT_TITLE_CLICKED
    },

    __properties = {
        ["prev_btn_auto_pushed"] = { 0, 0, 1, 1, true, true },
        ["event_enabled"] = { 0, 0, 1, 1, true, true },
        ["bottom_item"] = { 0, 0, 1, 0, true, false },
        ["top_item"] = { 0, 0, 1, 0, true, false },
        ["content_preserve_on_pop"] = { 0, 0, 1, 1, true, true },
        ["items"] = { 0, 0, 1, 0, true, false }
    }
}

M.Naviframe = function(parent, ...)
    return eo.__ctor_common(__class, parent, eo.class_get("Elm_Naviframe").__eo_ctor,
                            1, ...)
end

return M
