/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStoreable;

final class PSubMapShortcut
extends AStoreable {
    private final Definition.Struct struct;
    private AExpression index;
    private Definition.Method getter;
    private Definition.Method setter;

    PSubMapShortcut(Location location, Definition.Struct struct, AExpression index) {
        super(location);
        this.struct = Objects.requireNonNull(struct);
        this.index = Objects.requireNonNull(index);
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw this.createError(new IllegalStateException("Illegal tree structure."));
    }

    @Override
    void analyze(Locals locals) {
        this.getter = this.struct.methods.get(new Definition.MethodKey("get", 1));
        this.setter = this.struct.methods.get(new Definition.MethodKey("put", 2));
        if (this.getter != null && (this.getter.rtn.sort == Definition.Sort.VOID || this.getter.arguments.size() != 1)) {
            throw this.createError(new IllegalArgumentException("Illegal map get shortcut for type [" + this.struct.name + "]."));
        }
        if (this.setter != null && this.setter.arguments.size() != 2) {
            throw this.createError(new IllegalArgumentException("Illegal map set shortcut for type [" + this.struct.name + "]."));
        }
        if (!(this.getter == null || this.setter == null || this.getter.arguments.get(0).equals(this.setter.arguments.get(0)) && this.getter.rtn.equals(this.setter.arguments.get(1)))) {
            throw this.createError(new IllegalArgumentException("Shortcut argument types must match."));
        }
        if (!this.read && !this.write || this.read && this.getter == null || this.write && this.setter == null) {
            throw this.createError(new IllegalArgumentException("Illegal map shortcut for type [" + this.struct.name + "]."));
        }
        this.index.expected = this.setter != null ? this.setter.arguments.get(0) : this.getter.arguments.get(0);
        this.index.analyze(locals);
        this.index = this.index.cast(locals);
        this.actual = this.setter != null ? this.setter.arguments.get(1) : this.getter.rtn;
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        this.index.write(writer, globals);
        writer.writeDebugInfo(this.location);
        this.getter.write(writer);
        if (!this.getter.rtn.clazz.equals(this.getter.handle.type().returnType())) {
            writer.checkCast(this.getter.rtn.type);
        }
    }

    @Override
    int accessElementCount() {
        return 2;
    }

    @Override
    boolean isDefOptimized() {
        return false;
    }

    @Override
    void updateActual(Definition.Type actual) {
        throw new IllegalArgumentException("Illegal tree structure.");
    }

    @Override
    void setup(MethodWriter writer, Globals globals) {
        this.index.write(writer, globals);
    }

    @Override
    void load(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        this.getter.write(writer);
        if (!this.getter.rtn.clazz.equals(this.getter.handle.type().returnType())) {
            writer.checkCast(this.getter.rtn.type);
        }
    }

    @Override
    void store(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        this.setter.write(writer);
        writer.writePop(this.setter.rtn.sort.size);
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.prefix, this.index);
    }
}

