/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.cli.Command;
import org.elasticsearch.cli.MultiCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.plugins.InstallPluginCommand;
import org.elasticsearch.plugins.ListPluginsCommand;
import org.elasticsearch.plugins.RemovePluginCommand;

public class PluginCli
extends MultiCommand {
    private final Collection<Command> commands;

    private PluginCli() {
        super("A tool for managing installed elasticsearch plugins");
        this.subcommands.put("list", new ListPluginsCommand());
        this.subcommands.put("install", new InstallPluginCommand());
        this.subcommands.put("remove", new RemovePluginCommand());
        this.commands = Collections.unmodifiableCollection(this.subcommands.values());
    }

    public static void main(String[] args) throws Exception {
        PluginCli.exit(new PluginCli().main(args, Terminal.DEFAULT));
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.commands);
    }
}

